/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Gate;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.AutoInstanceParam;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.creole.metadata.HiddenCreoleParameter;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.util.Err;
import gate.util.GateException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreoleAnnotationHandler {
    private URL creoleFileUrl;

    public CreoleAnnotationHandler(URL uRL) {
        this.creoleFileUrl = uRL;
    }

    public void addJarsToClassLoader(Document document) throws MalformedURLException {
        this.addJarsToClassLoader(document.getRootElement());
    }

    private void addJarsToClassLoader(Element element) throws MalformedURLException {
        if ("JAR".equals(element.getName())) {
            URL uRL = new URL(this.creoleFileUrl, element.getTextTrim());
            try {
                InputStream inputStream = uRL.openStream();
                inputStream.close();
                Gate.getClassLoader().addURL(uRL);
            }
            catch (IOException iOException) {
                Err.println("Error opening JAR " + uRL + " specified in creole file " + this.creoleFileUrl + ": " + iOException);
            }
        } else {
            for (Element element2 : element.getChildren()) {
                this.addJarsToClassLoader(element2);
            }
        }
    }

    public void createResourceElementsForDirInfo(Document document) throws MalformedURLException {
        Element element = document.getRootElement();
        URL uRL = new URL(this.creoleFileUrl, ".");
        Gate.DirectoryInfo directoryInfo = Gate.getDirectoryInfo(uRL);
        if (directoryInfo != null) {
            HashMap<String, Element> hashMap = new HashMap<String, Element>();
            this.findResourceElements(hashMap, element);
            for (Gate.ResourceInfo resourceInfo : directoryInfo.getResourceInfoList()) {
                if (hashMap.containsKey(resourceInfo.getResourceClassName())) continue;
                element.addContent((Content)new Element("RESOURCE").addContent((Content)new Element("CLASS").setText(resourceInfo.getResourceClassName())));
            }
        }
    }

    private void findResourceElements(Map<String, Element> map, Element element) {
        if (element.getName().equals("RESOURCE")) {
            String string = element.getChildTextTrim("CLASS");
            if (string != null) {
                map.put(string, element);
            }
        } else {
            for (Element element2 : element.getChildren()) {
                this.findResourceElements(map, element2);
            }
        }
    }

    public void processAnnotations(Document document) throws GateException {
        this.processAnnotations(document.getRootElement());
    }

    private void processAnnotations(Element element) throws GateException {
        if ("RESOURCE".equals(element.getName())) {
            this.processAnnotationsForResource(element);
        } else {
            for (Element element2 : element.getChildren()) {
                this.processAnnotations(element2);
            }
        }
    }

    private void processAnnotationsForResource(Element element) throws GateException {
        String string = element.getChildTextTrim("CLASS");
        if (string == null) {
            throw new GateException("\"CLASS\" element not found for resource in " + this.creoleFileUrl);
        }
        Class<?> clazz = null;
        try {
            clazz = Gate.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new GateException("Couldn't load class " + string + " for resource in " + this.creoleFileUrl);
        }
        this.processCreoleResourceAnnotations(element, clazz);
    }

    public void processCreoleResourceAnnotations(Element element, Class<?> clazz) throws GateException {
        CreoleResource creoleResource = clazz.getAnnotation(CreoleResource.class);
        if (creoleResource != null) {
            this.processResourceData(clazz, element);
            HashMap<String, Element> hashMap = new HashMap<String, Element>();
            HashMap<String, Element> hashMap2 = new HashMap<String, Element>();
            for (Element element2 : element.getChildren("PARAMETER")) {
                hashMap.put(element2.getAttributeValue("NAME"), element2);
            }
            for (Element element2 : element.getChildren("OR")) {
                String string = element2.getAttributeValue("ID");
                if (string != null) {
                    hashMap2.put(string, element2);
                }
                for (Element element3 : element2.getChildren("PARAMETER")) {
                    hashMap.put(element3.getAttributeValue("NAME"), element3);
                }
            }
            this.processParameters(clazz, element, hashMap, hashMap2);
        }
    }

    private void processResourceData(Class<?> clazz, Element element) {
        CreoleResource creoleResource = clazz.getAnnotation(CreoleResource.class);
        if (creoleResource.isPrivate() && element.getChild("PRIVATE") == null) {
            element.addContent((Content)new Element("PRIVATE"));
        }
        if (creoleResource.mainViewer() && element.getChild("MAIN_VIEWER") == null) {
            element.addContent((Content)new Element("MAIN_VIEWER"));
        }
        if (creoleResource.tool() && element.getChild("TOOL") == null) {
            element.addContent((Content)new Element("TOOL"));
        }
        this.addElement(element, "".equals(creoleResource.name()) ? clazz.getSimpleName() : creoleResource.name(), "NAME");
        this.processInheritableResourceData(clazz, element);
        this.processAutoInstances(creoleResource, element);
    }

    private void processInheritableResourceData(Class<?> clazz, Element element) {
        Element element2;
        CreoleResource creoleResource = clazz.getAnnotation(CreoleResource.class);
        if (creoleResource != null) {
            this.addElement(element, creoleResource.comment(), "COMMENT");
            this.addElement(element, creoleResource.helpURL(), "HELPURL");
            this.addElement(element, creoleResource.interfaceName(), "INTERFACE");
            this.addElement(element, creoleResource.icon(), "ICON");
            if (creoleResource.guiType() != GuiType.NONE && element.getChild("GUI") == null) {
                element2 = new Element("GUI").setAttribute("TYPE", creoleResource.guiType().toString());
                element.addContent((Content)element2);
                this.addElement(element2, creoleResource.resourceDisplayed(), "RESOURCE_DISPLAYED");
            }
            this.addElement(element, creoleResource.annotationTypeDisplayed(), "ANNOTATION_TYPE_DISPLAYED");
        }
        if ((element2 = clazz.getSuperclass()) != null) {
            this.processInheritableResourceData((Class<?>)element2, element);
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.processInheritableResourceData(clazz2, element);
        }
    }

    private void addElement(Element element, String string, String string2) {
        if (!"".equals(string) && element.getChild(string2) == null) {
            element.addContent((Content)new Element(string2).setText(string));
        }
    }

    private void processAutoInstances(CreoleResource creoleResource, Element element) {
        for (AutoInstance autoInstance : creoleResource.autoinstances()) {
            Element element2 = null;
            element2 = autoInstance.hidden() ? new Element("HIDDEN-AUTOINSTANCE") : new Element("AUTOINSTANCE");
            element.addContent((Content)element2);
            for (AutoInstanceParam autoInstanceParam : autoInstance.parameters()) {
                element2.addContent((Content)new Element("PARAM").setAttribute("NAME", autoInstanceParam.name()).setAttribute("VALUE", autoInstanceParam.value()));
            }
        }
    }

    private void processParameters(Class<?> clazz, Element element, Map<String, Element> map, Map<String, Element> map2) throws GateException {
        for (Method method : clazz.getDeclaredMethods()) {
            Object object;
            CreoleParameter creoleParameter = method.getAnnotation(CreoleParameter.class);
            HiddenCreoleParameter hiddenCreoleParameter = method.getAnnotation(HiddenCreoleParameter.class);
            if (creoleParameter == null && hiddenCreoleParameter == null) continue;
            if (!method.getName().startsWith("set") || method.getName().length() < 4 || method.getParameterTypes().length != 1) {
                throw new GateException("Creole parameter annotation found on " + method + ", but only setter methods may have this annotation.");
            }
            String string = Character.toLowerCase(method.getName().charAt(3)) + method.getName().substring(4);
            if (hiddenCreoleParameter != null && !map.containsKey(string)) {
                map.put(string, null);
            }
            if (creoleParameter == null) continue;
            Element element2 = null;
            if (map.containsKey(string)) {
                element2 = map.get(string);
            } else {
                element2 = new Element("PARAMETER").setAttribute("NAME", string);
                if (!"".equals(creoleParameter.disjunction())) {
                    object = map2.get(creoleParameter.disjunction());
                    if (object == null) {
                        object = new Element("OR");
                        element.addContent((Content)object);
                        map2.put(creoleParameter.disjunction(), (Element)object);
                    }
                    object.addContent((Content)element2);
                } else {
                    element.addContent((Content)element2);
                }
                map.put(string, element2);
            }
            if (element2 == null) continue;
            if (element2.getTextTrim().length() == 0) {
                element2.setText(method.getParameterTypes()[0].getName());
                if (Collection.class.isAssignableFrom(method.getParameterTypes()[0])) {
                    this.determineCollectionElementType(method, element2);
                }
            }
            this.addAttribute(element2, creoleParameter.comment(), "", "COMMENT");
            this.addAttribute(element2, creoleParameter.suffixes(), "", "SUFFIXES");
            this.addAttribute(element2, creoleParameter.defaultValue(), "____NO_DEFAULT____", "DEFAULT");
            this.addAttribute(element2, String.valueOf(creoleParameter.priority()), String.valueOf(Integer.MAX_VALUE), "PRIORITY");
            object = "";
            if (method.isAnnotationPresent(RunTime.class)) {
                object = String.valueOf(method.getAnnotation(RunTime.class).value());
            }
            this.addAttribute(element2, object, "", "RUNTIME");
            String string2 = "";
            if (method.isAnnotationPresent(Optional.class)) {
                string2 = String.valueOf(method.getAnnotation(Optional.class).value());
            }
            this.addAttribute(element2, string2, "", "OPTIONAL");
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            this.processParameters(clazz2, element, map, map2);
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            this.processParameters(clazz3, element, map, map2);
        }
    }

    private void determineCollectionElementType(Method method, Element element) {
        if (element.getAttributeValue("ITEM_CLASS_NAME") == null) {
            Class<?> clazz;
            CreoleParameter creoleParameter = method.getAnnotation(CreoleParameter.class);
            if (creoleParameter != null && creoleParameter.collectionElementType() != CreoleParameter.NoElementType.class) {
                clazz = creoleParameter.collectionElementType();
            } else {
                Type type = method.getGenericParameterTypes()[0];
                clazz = this.findCollectionElementType(type);
            }
            if (clazz != null) {
                element.setAttribute("ITEM_CLASS_NAME", clazz.getName());
            }
        }
    }

    private Class<?> findCollectionElementType(Type type) {
        return this.findCollectionElementType(type, new HashMap());
    }

    private Class<?> findCollectionElementType(Type type, Map<TypeVariable<?>, Class<?>> map) {
        Type type2;
        Class clazz = null;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            type2 = ((ParameterizedType)type).getRawType();
            if (type2 == Collection.class) {
                Type type3 = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (type3 instanceof Class) {
                    return (Class)type3;
                }
                if (type3 instanceof TypeVariable) {
                    return map.get(type3);
                }
                return null;
            }
            if (type2 instanceof Class) {
                clazz = (Class)type2;
                Type[] object = ((ParameterizedType)type).getActualTypeArguments();
                TypeVariable<Class<T>>[] typeVariableArray = ((Class)type2).getTypeParameters();
                for (int i = 0; i < object.length; ++i) {
                    if (object[i] instanceof Class) {
                        map.put(typeVariableArray[i], (Class)object[i]);
                        continue;
                    }
                    if (!(object[i] instanceof TypeVariable)) continue;
                    map.put(typeVariableArray[i], map.get(object[i]));
                }
            }
        }
        if (clazz != null) {
            Class<?> clazz2;
            type2 = clazz.getGenericSuperclass();
            if (type != null && (clazz2 = this.findCollectionElementType(type2, map)) != null) {
                return clazz2;
            }
            for (Type type3 : clazz.getGenericInterfaces()) {
                Class<?> clazz3 = this.findCollectionElementType(type3, map);
                if (clazz3 == null) continue;
                return clazz3;
            }
        }
        return null;
    }

    private void addAttribute(Element element, Object object, Object object2, String string) {
        if (!object2.equals(object) && element.getAttribute(string) == null) {
            element.setAttribute(string, object.toString());
        }
    }
}

