/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.Parameter;
import gate.creole.ParameterException;
import gate.creole.ParameterList;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.util.AbstractFeatureBearer;
import gate.util.Err;
import gate.util.GateException;
import gate.util.LuckyException;
import gate.util.Strings;
import gate.util.Tools;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractResource
extends AbstractFeatureBearer
implements Resource,
Serializable {
    static final long serialVersionUID = -9196293927841163321L;
    protected String name;
    private static int beanCount = 0;
    private static Hashtable beanInfoCache = new Hashtable();

    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void cleanup() {
    }

    public static Object getParameterValue(Resource resource, String string) throws ResourceInstantiationException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = AbstractResource.getBeanInfo(resource.getClass());
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + resource.getClass().getName() + Strings.getNl() + "Introspector exception was: " + exception);
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            throw new ResourceInstantiationException("Couldn't get properties info for resource " + resource.getClass().getName());
        }
        boolean bl = false;
        Object object = null;
        for (int i = 0; !bl && i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (!propertyDescriptor.getName().equals(string)) continue;
            Method method = propertyDescriptor.getReadMethod();
            if (method == null) {
                throw new ResourceInstantiationException("Couldn't get read accessor method for parameter " + string + " in " + resource.getClass().getName());
            }
            Object[] objectArray = new Object[]{};
            try {
                object = method.invoke((Object)resource, objectArray);
            }
            catch (Exception exception) {
                throw new ResourceInstantiationException("couldn't invoke get method: " + exception);
            }
            bl = true;
        }
        if (bl) {
            return object;
        }
        throw new ResourceInstantiationException("Couldn't find parameter named " + string + " in " + resource.getClass().getName());
    }

    public static void setParameterValue(Resource resource, BeanInfo beanInfo, String string, Object object) throws ResourceInstantiationException {
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            throw new ResourceInstantiationException("Couldn't get properties info for resource " + resource.getClass().getName());
        }
        boolean bl = false;
        for (int i = 0; !bl && i < propertyDescriptorArray.length; ++i) {
            Object[] objectArray;
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (!propertyDescriptor.getName().equals(string)) continue;
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                throw new ResourceInstantiationException("Couldn't get write accessor method for parameter " + string + " in " + resource.getClass().getName());
            }
            if (object != null) {
                Class<?> clazz;
                Object object2 = objectArray = propertyDescriptor.getPropertyType();
                if (Parameter.substituteClasses.containsKey(objectArray)) {
                    object2 = Parameter.substituteClasses.get(objectArray);
                }
                if (!objectArray.isAssignableFrom(clazz = object.getClass())) {
                    try {
                        Constructor constructor = Tools.getMostSpecificConstructor((Class)object2, clazz);
                        object = constructor.newInstance(object);
                    }
                    catch (Exception exception) {
                        if (String.class.isAssignableFrom(clazz)) {
                            Parameter parameter;
                            Iterator<Parameter> iterator;
                            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(resource.getClass().getName());
                            ParameterList parameterList = resourceData.getParameterList();
                            Parameter parameter2 = null;
                            Iterator<List<Parameter>> iterator2 = parameterList.getInitimeParameters().iterator();
                            while (parameter2 == null && iterator2.hasNext()) {
                                iterator = iterator2.next().iterator();
                                while (parameter2 == null && iterator.hasNext()) {
                                    parameter = iterator.next();
                                    if (!parameter.getName().equals(string)) continue;
                                    parameter2 = parameter;
                                }
                            }
                            iterator2 = parameterList.getRuntimeParameters().iterator();
                            while (parameter2 == null && iterator2.hasNext()) {
                                iterator = iterator2.next().iterator();
                                while (parameter2 == null && iterator.hasNext()) {
                                    parameter = iterator.next();
                                    if (!parameter.getName().equals(string)) continue;
                                    parameter2 = parameter;
                                }
                            }
                            if (parameter2 != null) {
                                try {
                                    object = parameter2.calculateValueFromString((String)object);
                                }
                                catch (ParameterException parameterException) {
                                    throw new ResourceInstantiationException(parameterException);
                                }
                            }
                            throw new LuckyException("Unknown parameter " + string + " for resource " + resource.getClass().getName() + "!");
                        }
                        throw new ResourceInstantiationException("Error converting " + object.getClass() + " to " + objectArray + ": " + exception.toString());
                    }
                }
            }
            objectArray = new Object[]{object};
            try {
                method.invoke((Object)resource, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace(Err.getPrintWriter());
                throw new ResourceInstantiationException("couldn't invoke set method for " + string + " on " + resource.getClass().getName() + ": " + exception);
            }
            bl = true;
        }
        if (!bl) {
            throw new ResourceInstantiationException("Couldn't find parameter named " + string + " in " + resource.getClass().getName());
        }
    }

    public static void setParameterValues(Resource resource, FeatureMap featureMap) throws ResourceInstantiationException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = AbstractResource.getBeanInfo(resource.getClass());
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + resource.getClass().getName() + Strings.getNl() + "Introspector exception was: " + exception);
        }
        for (String string : featureMap.keySet()) {
            AbstractResource.setParameterValue(resource, beanInfo, string, featureMap.get(string));
        }
    }

    public static void setResourceListeners(Resource resource, Map map) throws IntrospectionException, InvocationTargetException, IllegalAccessException, GateException {
        BeanInfo beanInfo = AbstractResource.getBeanInfo(resource.getClass());
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        if (eventSetDescriptorArray != null) {
            for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
                EventSetDescriptor eventSetDescriptor = eventSetDescriptorArray[i];
                Object v = map.get(eventSetDescriptor.getListenerType().getName());
                if (v == null) continue;
                Method method = eventSetDescriptor.getAddListenerMethod();
                Object[] objectArray = new Object[]{v};
                method.invoke((Object)resource, objectArray);
            }
        }
    }

    public static void removeResourceListeners(Resource resource, Map map) throws IntrospectionException, InvocationTargetException, IllegalAccessException, GateException {
        BeanInfo beanInfo = AbstractResource.getBeanInfo(resource.getClass());
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        if (eventSetDescriptorArray != null) {
            for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
                EventSetDescriptor eventSetDescriptor = eventSetDescriptorArray[i];
                Object v = map.get(eventSetDescriptor.getListenerType().getName());
                if (v == null) continue;
                Method method = eventSetDescriptor.getRemoveListenerMethod();
                Object[] objectArray = new Object[]{v};
                method.invoke((Object)resource, objectArray);
            }
        }
    }

    public static boolean checkParameterValues(Resource resource, List list) throws ResourceInstantiationException {
        for (List list2 : list) {
            boolean bl = !((Parameter)list2.get(0)).isOptional();
            if (!bl) continue;
            boolean bl2 = false;
            Iterator iterator = list2.iterator();
            while (!bl2 && iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                bl2 = resource.getParameterValue(parameter.getName()) != null;
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    public Object getParameterValue(String string) throws ResourceInstantiationException {
        return AbstractResource.getParameterValue(this, string);
    }

    public void setParameterValue(String string, Object object) throws ResourceInstantiationException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = AbstractResource.getBeanInfo(this.getClass());
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + this.getClass().getName() + Strings.getNl() + "Introspector exception was: " + exception);
        }
        AbstractResource.setParameterValue(this, beanInfo, string, object);
    }

    public void setParameterValues(FeatureMap featureMap) throws ResourceInstantiationException {
        AbstractResource.setParameterValues(this, featureMap);
    }

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        ++beanCount;
        BeanInfo beanInfo = (BeanInfo)beanInfoCache.get(clazz);
        if (beanInfo == null) {
            beanInfo = Introspector.getBeanInfo(clazz, Object.class);
            beanInfoCache.put(clazz, beanInfo);
        }
        return beanInfo;
    }
}

