/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Corpus;
import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.corpora.CorpusImpl;
import gate.corpora.DocType;
import gate.corpora.DocumentData;
import gate.creole.AbstractLanguageResource;
import gate.creole.CustomDuplication;
import gate.creole.ResourceInstantiationException;
import gate.creole.ir.IREngine;
import gate.creole.ir.IndexDefinition;
import gate.creole.ir.IndexException;
import gate.creole.ir.IndexManager;
import gate.creole.ir.IndexStatistics;
import gate.creole.ir.IndexedCorpus;
import gate.creole.metadata.CreoleResource;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.persist.PersistenceException;
import gate.security.SecurityException;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.MethodNotImplementedException;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CreoleResource(name="GATE Serial Corpus", isPrivate=true, comment="GATE persistent corpus (serialisation)", icon="corpus", helpURL="http://gate.ac.uk/userguide/sec:developer:datastores")
public class SerialCorpusImpl
extends AbstractLanguageResource
implements Corpus,
CreoleListener,
DatastoreListener,
IndexedCorpus,
CustomDuplication {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 3632609241787241616L;
    protected transient Vector corpusListeners;
    protected List docDataList = null;
    protected transient List documents = null;
    protected transient IndexManager indexManager = null;
    protected transient List addedDocs = null;
    protected transient List removedDocIDs = null;
    protected transient List changedDocs = null;

    public SerialCorpusImpl() {
    }

    protected SerialCorpusImpl(Corpus corpus) {
        this.setName(corpus.getName());
        this.setFeatures(corpus.getFeatures());
        this.docDataList = new ArrayList();
        List<String> list = corpus.getDocumentNames();
        for (int i = 0; i < list.size(); ++i) {
            Document document = (Document)corpus.get(i);
            this.docDataList.add(new DocumentData(list.get(i), null, document.getClass().getName()));
        }
        this.documents = new ArrayList();
        this.documents.addAll(corpus);
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    @Override
    public List<String> getDocumentNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.docDataList == null) {
            return arrayList;
        }
        for (Object e : this.docDataList) {
            DocumentData documentData = (DocumentData)e;
            arrayList.add(documentData.getDocumentName());
        }
        return arrayList;
    }

    public List getDocumentPersistentIDs() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.docDataList == null) {
            return arrayList;
        }
        for (DocumentData documentData : this.docDataList) {
            arrayList.add(documentData.getPersistentID());
        }
        return arrayList;
    }

    public List getDocumentClassTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.docDataList == null) {
            return arrayList;
        }
        for (DocumentData documentData : this.docDataList) {
            arrayList.add(documentData.getClassType());
        }
        return arrayList;
    }

    public void setDocumentPersistentID(int n, Object object) {
        if (n >= this.docDataList.size()) {
            return;
        }
        ((DocumentData)this.docDataList.get(n)).setPersistentID(object);
    }

    @Override
    public String getDocumentName(int n) {
        if (n >= this.docDataList.size()) {
            return "No such document";
        }
        return ((DocumentData)this.docDataList.get(n)).getDocumentName();
    }

    public Object getDocumentPersistentID(int n) {
        if (n >= this.docDataList.size()) {
            return null;
        }
        return ((DocumentData)this.docDataList.get(n)).getPersistentID();
    }

    public String getDocumentClassType(int n) {
        if (n >= this.docDataList.size()) {
            return null;
        }
        return ((DocumentData)this.docDataList.get(n)).getClassType();
    }

    public void unloadDocument(int n, boolean bl) {
        if (!this.isDocumentLoaded(n) && this.isPersistentDocument(n)) {
            return;
        }
        if (bl) {
            Document document = (Document)this.documents.get(n);
            try {
                if (document.getLRPersistenceId() == null) {
                    document = (Document)this.getDataStore().adopt(document, null);
                    this.getDataStore().sync(document);
                    this.setDocumentPersistentID(n, document.getLRPersistenceId());
                } else {
                    this.getDataStore().sync(document);
                }
            }
            catch (PersistenceException persistenceException) {
                throw new GateRuntimeException("Error unloading document from corpusbecause document sync failed: " + persistenceException.getMessage());
            }
            catch (SecurityException securityException) {
                throw new GateRuntimeException("Error unloading document from corpusbecause of document access error: " + securityException.getMessage());
            }
        }
        this.documents.set(n, null);
    }

    public void unloadDocument(Document document, boolean bl) {
        int n = this.findDocument(document);
        if (n == -1) {
            return;
        }
        this.unloadDocument(n, bl);
    }

    @Override
    public void unloadDocument(Document document) {
        this.unloadDocument(document, true);
    }

    public void unloadDocument(int n) {
        this.unloadDocument(n, true);
    }

    @Override
    public boolean isDocumentLoaded(int n) {
        if (this.documents == null || this.documents.isEmpty()) {
            return false;
        }
        return this.documents.get(n) != null;
    }

    public boolean isPersistentDocument(int n) {
        if (this.documents == null || this.documents.isEmpty()) {
            return false;
        }
        return ((DocumentData)this.docDataList.get(n)).getPersistentID() != null;
    }

    @Override
    public void cleanup() {
        if (this.corpusListeners != null) {
            this.corpusListeners = null;
        }
        if (this.documents != null) {
            this.documents.clear();
        }
        this.docDataList.clear();
        Gate.getCreoleRegister().removeCreoleListener(this);
        if (this.dataStore != null) {
            this.dataStore.removeDatastoreListener(this);
        }
    }

    @Override
    public void populate(URL uRL, FileFilter fileFilter, String string, boolean bl) throws IOException, ResourceInstantiationException {
        CorpusImpl.populate(this, uRL, fileFilter, string, bl);
    }

    @Override
    public void populate(URL uRL, FileFilter fileFilter, String string, String string2, boolean bl) throws IOException, ResourceInstantiationException {
        CorpusImpl.populate(this, uRL, fileFilter, string, string2, bl);
    }

    @Override
    public long populate(URL uRL, String string, String string2, int n, String string3, DocType docType) throws IOException, ResourceInstantiationException {
        return CorpusImpl.populate(this, uRL, string, string2, n, string3, docType);
    }

    @Override
    public synchronized void removeCorpusListener(CorpusListener corpusListener) {
        if (this.corpusListeners != null && this.corpusListeners.contains(corpusListener)) {
            Vector vector = (Vector)this.corpusListeners.clone();
            vector.removeElement(corpusListener);
            this.corpusListeners = vector;
        }
    }

    @Override
    public synchronized void addCorpusListener(CorpusListener corpusListener) {
        Vector vector;
        Vector vector2 = vector = this.corpusListeners == null ? new Vector(2) : (Vector)this.corpusListeners.clone();
        if (!vector.contains(corpusListener)) {
            vector.addElement(corpusListener);
            this.corpusListeners = vector;
        }
    }

    protected void fireDocumentAdded(CorpusEvent corpusEvent) {
        if (this.corpusListeners != null) {
            Vector vector = this.corpusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CorpusListener)vector.elementAt(i)).documentAdded(corpusEvent);
            }
        }
    }

    protected void fireDocumentRemoved(CorpusEvent corpusEvent) {
        if (this.corpusListeners != null) {
            Vector vector = this.corpusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CorpusListener)vector.elementAt(i)).documentRemoved(corpusEvent);
            }
        }
    }

    @Override
    public void resourceLoaded(CreoleEvent creoleEvent) {
    }

    @Override
    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    @Override
    public void resourceUnloaded(CreoleEvent creoleEvent) {
        Resource resource = creoleEvent.getResource();
        if (resource instanceof Document) {
            Document document = (Document)resource;
            if (document.getDataStore() != this.getDataStore()) {
                this.remove(document);
            } else {
                int n = this.indexOf(resource);
                if (n < 0) {
                    return;
                }
                this.documents.set(n, null);
            }
        }
    }

    @Override
    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreClosed(CreoleEvent creoleEvent) {
        if (!creoleEvent.getDatastore().equals(this.getDataStore())) {
            return;
        }
        if (this.getDataStore() != null) {
            this.getDataStore().removeDatastoreListener(this);
        }
        Factory.deleteResource(this);
    }

    @Override
    public void resourceAdopted(DatastoreEvent datastoreEvent) {
    }

    @Override
    public void resourceDeleted(DatastoreEvent datastoreEvent) {
        DataStore dataStore = (DataStore)datastoreEvent.getSource();
        if (!dataStore.equals(this.dataStore)) {
            return;
        }
        Object object = datastoreEvent.getResourceID();
        if (object == null) {
            return;
        }
        if (object.equals(this.getLRPersistenceId())) {
            Factory.deleteResource(this);
            return;
        }
        boolean bl = false;
        for (int i = 0; i < this.docDataList.size(); ++i) {
            DocumentData documentData = (DocumentData)this.docDataList.get(i);
            if (!object.equals(documentData.getPersistentID())) continue;
            if (datastoreEvent.getResource() == null) {
                this.documentRemoved(((DocumentData)this.docDataList.get((int)i)).persistentID.toString());
                this.docDataList.remove(i);
                this.documents.remove(i);
                bl = true;
                --i;
                continue;
            }
            this.remove(i);
            bl = true;
        }
        if (bl) {
            try {
                this.dataStore.sync(this);
            }
            catch (PersistenceException persistenceException) {
                throw new GateRuntimeException("SerialCorpusImpl: " + persistenceException.getMessage());
            }
            catch (SecurityException securityException) {
                throw new GateRuntimeException("SerialCorpusImpl: " + securityException.getMessage());
            }
        }
    }

    @Override
    public void resourceWritten(DatastoreEvent datastoreEvent) {
        if (datastoreEvent.getResourceID().equals(this.getLRPersistenceId())) {
            this.thisResourceWritten();
        }
    }

    @Override
    public int size() {
        return this.docDataList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.docDataList.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof Document)) {
            return false;
        }
        int n = this.findDocument((Document)object);
        return n >= 0;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            Iterator docDataIter;
            {
                this.docDataIter = SerialCorpusImpl.this.docDataList.iterator();
            }

            public boolean hasNext() {
                return this.docDataIter.hasNext();
            }

            public Object next() {
                DocumentData documentData = (DocumentData)this.docDataIter.next();
                int n = SerialCorpusImpl.this.docDataList.indexOf(documentData);
                return SerialCorpusImpl.this.get(n);
            }

            public void remove() {
                throw new UnsupportedOperationException("SerialCorpusImpl does not support remove in the iterators");
            }
        };
    }

    public String toString() {
        return "document data " + this.docDataList.toString() + " documents " + this.documents;
    }

    @Override
    public Object[] toArray() {
        throw new MethodNotImplementedException("toArray() is not implemented for SerialCorpusImpl");
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        throw new MethodNotImplementedException("toArray(Object[] a) is not implemented for SerialCorpusImpl");
    }

    @Override
    public boolean add(Object object) {
        if (!(object instanceof Document) || object == null) {
            return false;
        }
        Document document = (Document)object;
        if (document.getDataStore() != null && !this.dataStore.equals(document.getDataStore())) {
            Err.prln("Error: Persistent corpus can only accept documents from its own datastore!");
            return false;
        }
        DocumentData documentData = new DocumentData(document.getName(), document.getLRPersistenceId(), document.getClass().getName());
        boolean bl = this.docDataList.add(documentData);
        this.documents.add(document);
        this.documentAdded(document);
        this.fireDocumentAdded(new CorpusEvent(this, document, this.docDataList.size() - 1, document.getLRPersistenceId(), 401));
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof Document)) {
            return false;
        }
        Document document = (Document)object;
        int n = this.findDocument(document);
        if (n == -1) {
            return false;
        }
        if (n < this.docDataList.size()) {
            String string = ((DocumentData)this.docDataList.get(n)).getDocumentName();
            Object object2 = this.getDocumentPersistentID(n);
            this.docDataList.remove(n);
            this.documents.remove(n);
            if (object2 != null) {
                this.documentRemoved(object2.toString());
            }
            this.fireDocumentRemoved(new CorpusEvent(this, (Document)object, n, object2, 402));
        }
        return true;
    }

    public int findDocument(Document document) {
        boolean bl = false;
        DocumentData documentData = null;
        int n = this.documents.indexOf(document);
        if (n > -1 && n < this.docDataList.size()) {
            return n;
        }
        Iterator iterator = this.docDataList.iterator();
        n = 0;
        while (iterator.hasNext()) {
            documentData = (DocumentData)iterator.next();
            if (documentData.getDocumentName().equals(document.getName()) && documentData.getPersistentID().equals(document.getLRPersistenceId()) && documentData.getClassType().equals(document.getClass().getName())) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl && n < this.docDataList.size()) {
            return n;
        }
        return -1;
    }

    @Override
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.add(iterator.next())) continue;
            bl = false;
        }
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.remove(iterator.next())) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.documents.clear();
        this.docDataList.clear();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SerialCorpusImpl)) {
            return false;
        }
        SerialCorpusImpl serialCorpusImpl = (SerialCorpusImpl)object;
        if (serialCorpusImpl == null) {
            return false;
        }
        if (serialCorpusImpl == this) {
            return true;
        }
        return (serialCorpusImpl.lrPersistentId == this.lrPersistentId || this.lrPersistentId != null && this.lrPersistentId.equals(serialCorpusImpl.lrPersistentId)) && serialCorpusImpl.name.equals(this.name) && (serialCorpusImpl.dataStore == this.dataStore || serialCorpusImpl.dataStore.equals(this.dataStore)) && ((Object)serialCorpusImpl.docDataList).equals(this.docDataList);
    }

    @Override
    public int hashCode() {
        return ((Object)this.docDataList).hashCode();
    }

    public Object get(int n) {
        if (n >= this.docDataList.size()) {
            return null;
        }
        Object object = this.documents.get(n);
        if (object == null) {
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("DataStore", this.dataStore);
            try {
                featureMap.put("LRPersistenceId", ((DocumentData)this.docDataList.get(n)).getPersistentID());
                Resource resource = Factory.createResource(((DocumentData)this.docDataList.get(n)).getClassType(), featureMap);
                object = resource;
                this.documents.set(n, resource);
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                Err.prln("Error reading document inside a serialised corpus.");
                throw new GateRuntimeException(resourceInstantiationException);
            }
        }
        return object;
    }

    public Object set(int n, Object object) {
        throw new MethodNotImplementedException();
    }

    public void add(int n, Object object) {
        if (!(object instanceof Document) || object == null) {
            return;
        }
        Document document = (Document)object;
        DocumentData documentData = new DocumentData(document.getName(), document.getLRPersistenceId(), document.getClass().getName());
        this.docDataList.add(n, documentData);
        this.documents.add(n, document);
        this.documentAdded(document);
        this.fireDocumentAdded(new CorpusEvent(this, document, n, document.getLRPersistenceId(), 401));
    }

    public Object remove(int n) {
        Document document = this.isDocumentLoaded(n) ? (Document)this.get(n) : null;
        Object object = ((DocumentData)this.docDataList.get((int)n)).persistentID;
        if (object != null) {
            this.documentRemoved(object.toString());
        }
        this.docDataList.remove(n);
        this.documents.remove(n);
        this.fireDocumentRemoved(new CorpusEvent(this, document, n, object, 402));
        return document;
    }

    @Override
    public int indexOf(Object object) {
        if (object instanceof Document) {
            return this.findDocument((Document)object);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        throw new MethodNotImplementedException();
    }

    public ListIterator listIterator() {
        throw new MethodNotImplementedException();
    }

    public ListIterator listIterator(int n) {
        throw new MethodNotImplementedException();
    }

    public List subList(int n, int n2) {
        throw new MethodNotImplementedException();
    }

    @Override
    public void setDataStore(DataStore dataStore) throws PersistenceException {
        super.setDataStore(dataStore);
        if (this.dataStore != null) {
            this.dataStore.addDatastoreListener(this);
        }
    }

    public void setTransientSource(Object object) {
        if (!(object instanceof Corpus)) {
            return;
        }
        if (this.dataStore != null && this.lrPersistentId != null) {
            return;
        }
        Corpus corpus = (Corpus)object;
        this.setName(corpus.getName());
        this.setFeatures(corpus.getFeatures());
        this.docDataList = new ArrayList();
        List<String> list = corpus.getDocumentNames();
        for (int i = 0; i < list.size(); ++i) {
            Document document = (Document)corpus.get(i);
            this.docDataList.add(new DocumentData(list.get(i), null, document.getClass().getName()));
        }
        this.documents = new ArrayList();
        this.documents.addAll(corpus);
        this.addedDocs = new Vector();
        this.removedDocIDs = new Vector();
        this.changedDocs = new Vector();
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    public Object getTransientSource() {
        return null;
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        super.init();
        return this;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IndexDefinition indexDefinition;
        objectInputStream.defaultReadObject();
        this.documents = new ArrayList(this.docDataList.size());
        for (int i = 0; i < this.docDataList.size(); ++i) {
            this.documents.add(null);
        }
        this.corpusListeners = new Vector();
        Gate.getCreoleRegister().addCreoleListener(this);
        if (this.dataStore != null) {
            this.dataStore.addDatastoreListener(this);
        }
        if ((indexDefinition = (IndexDefinition)this.getFeatures().get("Index_definition_feature_key")) != null) {
            String string = indexDefinition.getIrEngineClassName();
            try {
                Class<?> clazz = Class.forName(string, true, Gate.getClassLoader());
                IREngine iREngine = (IREngine)clazz.newInstance();
                this.indexManager = iREngine.getIndexmanager();
                this.indexManager.setIndexDefinition(indexDefinition);
                this.indexManager.setCorpus(this);
            }
            catch (Exception exception) {
                exception.printStackTrace(Err.getPrintWriter());
            }
            this.addedDocs = new Vector();
            this.removedDocIDs = new Vector();
            this.changedDocs = new Vector();
        }
    }

    @Override
    public void setIndexDefinition(IndexDefinition indexDefinition) {
        if (indexDefinition != null) {
            this.getFeatures().put("Index_definition_feature_key", indexDefinition);
            String string = indexDefinition.getIrEngineClassName();
            try {
                Class<?> clazz = Class.forName(string, true, Gate.getClassLoader());
                IREngine iREngine = (IREngine)clazz.newInstance();
                this.indexManager = iREngine.getIndexmanager();
                this.indexManager.setIndexDefinition(indexDefinition);
                this.indexManager.setCorpus(this);
            }
            catch (Exception exception) {
                exception.printStackTrace(Err.getPrintWriter());
            }
            this.addedDocs = new Vector();
            this.removedDocIDs = new Vector();
            this.changedDocs = new Vector();
        }
    }

    @Override
    public IndexDefinition getIndexDefinition() {
        return (IndexDefinition)this.getFeatures().get("Index_definition_feature_key");
    }

    @Override
    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    @Override
    public IndexStatistics getIndexStatistics() {
        return (IndexStatistics)this.getFeatures().get("Index_statistics_feature_key");
    }

    private void documentAdded(Document document) {
        if (this.indexManager != null) {
            this.addedDocs.add(document);
        }
    }

    private void documentRemoved(String string) {
        if (this.indexManager != null) {
            this.removedDocIDs.add(string);
        }
    }

    private void thisResourceWritten() {
        if (this.indexManager != null) {
            try {
                for (int i = 0; i < this.documents.size(); ++i) {
                    Document document;
                    if (this.documents.get(i) == null || this.addedDocs.contains(document = (Document)this.documents.get(i)) || !document.isModified()) continue;
                    this.changedDocs.add(document);
                }
                this.indexManager.sync(this.addedDocs, this.removedDocIDs, this.changedDocs);
            }
            catch (IndexException indexException) {
                indexException.printStackTrace();
            }
        }
    }

    @Override
    public Resource duplicate(Factory.DuplicationContext duplicationContext) throws ResourceInstantiationException {
        throw new ResourceInstantiationException("Duplication of " + this.getClass().getName() + " not permitted");
    }
}

