/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Resource;
import gate.corpora.MimeType;
import gate.corpora.TextualDocumentFormat;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.email.EmailDocumentHandler;
import gate.event.StatusListener;
import gate.util.DocumentFormatException;
import gate.util.InvalidOffsetException;
import java.io.IOException;

@CreoleResource(name="GATE EMAIL Document Format", isPrivate=true, autoinstances={@AutoInstance(hidden=true)})
public class EmailDocumentFormat
extends TextualDocumentFormat {
    private static final boolean DEBUG = false;

    public void unpackMarkup(Document document) throws DocumentFormatException {
        if (document == null || document.getSourceUrl() == null && document.getContent() == null) {
            throw new DocumentFormatException("GATE document is null or no content found. Nothing to parse!");
        }
        this.setNewLineProperty(document);
        EmailDocumentHandler emailDocumentHandler = null;
        emailDocumentHandler = new EmailDocumentHandler(document, this.markupElementsMap, this.element2StringMap);
        StatusListener statusListener = new StatusListener(){

            public void statusChanged(String string) {
                EmailDocumentFormat.this.fireStatusChanged(string);
            }
        };
        emailDocumentHandler.addStatusListener(statusListener);
        try {
            try {
                emailDocumentHandler.annotateMessages();
                AnnotationSet annotationSet = document.getAnnotations("Original markups").get("body");
                if (annotationSet != null && !annotationSet.isEmpty()) {
                    for (Annotation annotation : annotationSet) {
                        this.annotateParagraphs(document, annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue(), "Original markups");
                    }
                }
                Object var8_9 = null;
                emailDocumentHandler.removeStatusListener(statusListener);
            }
            catch (IOException iOException) {
                throw new DocumentFormatException("Couldn't create a buffered reader ", iOException);
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new DocumentFormatException(invalidOffsetException);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            emailDocumentHandler.removeStatusListener(statusListener);
            throw throwable;
        }
    }

    public Resource init() throws ResourceInstantiationException {
        MimeType mimeType = new MimeType("text", "email");
        mimeString2ClassHandlerMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), this);
        mimeString2mimeTypeMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), mimeType);
        suffixes2mimeTypeMap.put("eml", mimeType);
        suffixes2mimeTypeMap.put("email", mimeType);
        suffixes2mimeTypeMap.put("mail", mimeType);
        magic2mimeTypeMap.put("Subject:", mimeType);
        this.setMimeType(mimeType);
        return this;
    }
}

