/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.corpora.DocType;
import gate.corpora.DocumentImpl;
import gate.creole.AbstractLanguageResource;
import gate.creole.CustomDuplication;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.StatusListener;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Err;
import gate.util.Files;
import gate.util.Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CreoleResource(name="GATE Corpus", comment="GATE transient corpus.", interfaceName="gate.Corpus", icon="corpus-trans", helpURL="http://gate.ac.uk/userguide/sec:developer:loadlr")
public class CorpusImpl
extends AbstractLanguageResource
implements Corpus,
CreoleListener,
CustomDuplication {
    private static final boolean DEBUG = false;
    protected List supportList = Collections.synchronizedList(new VerboseList());
    static final long serialVersionUID = -1113142759053898456L;
    private transient Vector corpusListeners;
    protected transient List documentsList;

    public CorpusImpl() {
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    @Override
    public List<String> getDocumentNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.supportList.size());
        for (Object e : this.supportList) {
            arrayList.add(((Document)e).getName());
        }
        return arrayList;
    }

    @Override
    public String getDocumentName(int n) {
        return ((Document)this.supportList.get(n)).getName();
    }

    @Override
    public void unloadDocument(Document document) {
    }

    @Override
    public boolean isDocumentLoaded(int n) {
        return true;
    }

    protected void clearDocList() {
        if (this.supportList == null) {
            return;
        }
        this.supportList.clear();
    }

    @Override
    public int size() {
        return this.supportList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.supportList.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.supportList.contains(object);
    }

    @Override
    public Iterator iterator() {
        return this.supportList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.supportList.toArray();
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.supportList.toArray(objectArray);
    }

    @Override
    public boolean add(Object object) {
        return this.supportList.add(object);
    }

    @Override
    public boolean remove(Object object) {
        return this.supportList.remove(object);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.supportList.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.supportList.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.supportList.addAll(n, collection);
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.supportList.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.supportList.retainAll(collection);
    }

    @Override
    public void clear() {
        this.supportList.clear();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CorpusImpl)) {
            return false;
        }
        return ((Object)this.supportList).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.supportList).hashCode();
    }

    public Object get(int n) {
        return this.supportList.get(n);
    }

    public Object set(int n, Object object) {
        return this.supportList.set(n, object);
    }

    public void add(int n, Object object) {
        this.supportList.add(n, object);
    }

    public Object remove(int n) {
        return this.supportList.remove(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.supportList.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.supportList.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.supportList.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.supportList.listIterator(n);
    }

    public List subList(int n, int n2) {
        return this.supportList.subList(n, n2);
    }

    @Override
    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
    }

    @Override
    public Resource init() {
        if (this.documentsList != null && !this.documentsList.isEmpty()) {
            this.addAll((Collection)this.documentsList);
        }
        return this;
    }

    public static void populate(Corpus corpus, URL uRL, FileFilter fileFilter, String string, boolean bl) throws IOException {
        CorpusImpl.populate(corpus, uRL, fileFilter, string, null, bl);
    }

    public static void populate(Corpus corpus, URL uRL, FileFilter fileFilter, String string, String string2, boolean bl) throws IOException {
        if (!uRL.getProtocol().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("The URL provided is not of type \"file:\"!");
        }
        File file = Files.fileFromURL(uRL);
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory!");
        }
        File[] fileArray = bl ? Files.listFilesRecursively(file, fileFilter) : file.listFiles(fileFilter);
        if (fileArray == null) {
            return;
        }
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareTo(file2.getName());
            }
        });
        for (File file2 : fileArray) {
            if (file2.isDirectory()) continue;
            StatusListener statusListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
            if (statusListener != null) {
                statusListener.statusChanged("Reading: " + file2.getName());
            }
            String string3 = file2.getName() + "_" + Gate.genSym();
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("sourceUrl", file2.toURI().toURL());
            if (string != null) {
                featureMap.put("encoding", string);
            }
            if (string2 != null) {
                featureMap.put("mimeType", string2);
            }
            try {
                Document document = (Document)Factory.createResource(DocumentImpl.class.getName(), featureMap, null, string3);
                corpus.add(document);
                if (corpus.getLRPersistenceId() != null) {
                    corpus.unloadDocument(document);
                    Factory.deleteResource(document);
                }
            }
            catch (Throwable throwable) {
                String string4 = Strings.getNl();
                Err.prln("WARNING: Corpus.populate could not instantiate document" + string4 + "  Document name was: " + string3 + string4 + "  Exception was: " + throwable + string4 + string4);
                throwable.printStackTrace();
            }
            if (statusListener == null) continue;
            statusListener.statusChanged(file2.getName() + " read");
        }
    }

    @Override
    public void populate(URL uRL, FileFilter fileFilter, String string, boolean bl) throws IOException, ResourceInstantiationException {
        CorpusImpl.populate(this, uRL, fileFilter, string, null, bl);
    }

    @Override
    public void populate(URL uRL, FileFilter fileFilter, String string, String string2, boolean bl) throws IOException, ResourceInstantiationException {
        CorpusImpl.populate(this, uRL, fileFilter, string, string2, bl);
    }

    private static String replaceAmpChars(String string) {
        string = string.replaceAll("&", "&amp;");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long populate(Corpus corpus, URL uRL, String string, String string2, int n, String string3, DocType docType) throws IOException {
        long l;
        string = string.toLowerCase();
        string3 = string3 == null ? "" : string3.trim() + "_";
        File file = null;
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException.getMessage());
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is a directory!");
        }
        BufferedReader bufferedReader = null;
        try {
            String string4 = "";
            if (string2 != null && string2.trim().length() != 0) {
                bufferedReader = new BomStrippingInputStreamReader((InputStream)new FileInputStream(file), string2, 0xA00000);
                if (docType == DocType.XML) {
                    string4 = "<?xml version=\"1.0\" encoding=\"" + string2 + "\" ?>";
                }
            } else {
                bufferedReader = new BomStrippingInputStreamReader((InputStream)new FileInputStream(file), 0xA00000);
                if (docType == DocType.XML) {
                    string4 = "<?xml version=\"1.0\" ?>";
                }
            }
            String string5 = bufferedReader.readLine();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            int n2 = 1;
            long l2 = 0L;
            while (string5 != null && (n == -1 || n2 - 1 != n)) {
                String string6;
                StatusListener statusListener;
                int n3;
                block38: {
                    Object var29_30;
                    String string7;
                    BufferedWriter bufferedWriter;
                    File file2;
                    FeatureMap featureMap;
                    block36: {
                        Object var27_29;
                        String string8 = string5.toLowerCase();
                        if (bl) {
                            n3 = string8.indexOf("<" + string + " ");
                            if (n3 < 0) {
                                n3 = string8.indexOf("<" + string + ">");
                            }
                            if (n3 < 0) {
                                string5 = bufferedReader.readLine();
                                continue;
                            }
                            stringBuilder.append(string4 + "\n" + string5.substring(n3) + "\n");
                            bl = false;
                            string5 = bufferedReader.readLine();
                            continue;
                        }
                        n3 = string8.indexOf("</" + string + ">");
                        if (n3 < 0) {
                            stringBuilder.append(string5 + "\n");
                            string5 = bufferedReader.readLine();
                            continue;
                        }
                        stringBuilder.append(string5.substring(0, n3 + string.length() + 3));
                        bl = true;
                        statusListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
                        if (statusListener != null) {
                            statusListener.statusChanged("Reading File Number :" + n2);
                        }
                        string6 = string3 + n2 + "_" + Gate.genSym();
                        featureMap = Factory.newFeatureMap();
                        file2 = null;
                        String string9 = "";
                        if (docType == DocType.XML) {
                            string9 = ".xml";
                        } else if (docType == DocType.HTML) {
                            string9 = ".html";
                        }
                        file2 = File.createTempFile(string6, string9);
                        if (statusListener != null) {
                            statusListener.statusChanged("Writing it on disk :" + file2.getAbsolutePath());
                        }
                        bufferedWriter = null;
                        try {
                            try {
                                bufferedWriter = string2 != null && string2.trim().length() > 0 ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string2)) : new BufferedWriter(new FileWriter(file2));
                                if (docType == DocType.XML) {
                                    bufferedWriter.write(CorpusImpl.replaceAmpChars(stringBuilder.toString()));
                                } else {
                                    bufferedWriter.write(stringBuilder.toString());
                                }
                            }
                            catch (IOException iOException) {
                                string7 = Strings.getNl();
                                Err.prln("WARNING: Corpus.populate could not instantiate document" + string7 + "  Document name was: " + string6 + string7 + "  Exception was: " + iOException + string7 + string7);
                                iOException.printStackTrace();
                                var27_29 = null;
                                if (bufferedWriter != null) {
                                    bufferedWriter.close();
                                }
                                break block36;
                            }
                            var27_29 = null;
                            if (bufferedWriter == null) break block36;
                        }
                        catch (Throwable throwable) {
                            var27_29 = null;
                            if (bufferedWriter == null) throw throwable;
                            bufferedWriter.close();
                            throw throwable;
                        }
                        bufferedWriter.close();
                    }
                    if (statusListener != null) {
                        statusListener.statusChanged("Creating GATE document for :" + file2.getAbsolutePath());
                    }
                    featureMap.put("sourceUrl", file2.toURI().toURL());
                    l2 += (long)stringBuilder.toString().getBytes().length;
                    if (string2 != null && string2.trim().length() > 0) {
                        featureMap.put("encoding", string2);
                    }
                    try {
                        block37: {
                            try {
                                Document document = (Document)Factory.createResource(DocumentImpl.class.getName(), featureMap, null, string6);
                                ++n2;
                                corpus.add(document);
                                if (corpus.getLRPersistenceId() == null) break block37;
                                corpus.unloadDocument(document);
                                Factory.deleteResource(document);
                            }
                            catch (Throwable throwable) {
                                string7 = Strings.getNl();
                                Err.prln("WARNING: Corpus.populate could not instantiate document" + string7 + "  Document name was: " + string6 + string7 + "  Exception was: " + throwable + string7 + string7);
                                throwable.printStackTrace();
                                var29_30 = null;
                                bufferedWriter = null;
                                file2.delete();
                                break block38;
                            }
                        }
                        var29_30 = null;
                        bufferedWriter = null;
                        file2.delete();
                    }
                    catch (Throwable throwable) {
                        var29_30 = null;
                        bufferedWriter = null;
                        file2.delete();
                        throw throwable;
                    }
                }
                stringBuilder = new StringBuilder();
                if (statusListener != null) {
                    statusListener.statusChanged(string6 + " created!");
                }
                if (string5.length() > n3 + 7) {
                    string5 = string5.substring(n3 + 6);
                    continue;
                }
                string5 = bufferedReader.readLine();
            }
            l = l2;
            Object var31_33 = null;
            if (bufferedReader == null) return l;
        }
        catch (Throwable throwable) {
            Object var31_34 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return l;
    }

    @Override
    public long populate(URL uRL, String string, String string2, int n, String string3, DocType docType) throws IOException, ResourceInstantiationException {
        return CorpusImpl.populate(this, uRL, string, string2, n, string3, docType);
    }

    @Override
    public synchronized void removeCorpusListener(CorpusListener corpusListener) {
        if (this.corpusListeners != null && this.corpusListeners.contains(corpusListener)) {
            Vector vector = (Vector)this.corpusListeners.clone();
            vector.removeElement(corpusListener);
            this.corpusListeners = vector;
        }
    }

    @Override
    public synchronized void addCorpusListener(CorpusListener corpusListener) {
        Vector vector;
        Vector vector2 = vector = this.corpusListeners == null ? new Vector(2) : (Vector)this.corpusListeners.clone();
        if (!vector.contains(corpusListener)) {
            vector.addElement(corpusListener);
            this.corpusListeners = vector;
        }
    }

    @Override
    public Resource duplicate(Factory.DuplicationContext duplicationContext) throws ResourceInstantiationException {
        Corpus corpus = (Corpus)Factory.defaultDuplicate(this, duplicationContext);
        for (Document document : this) {
            corpus.add((Document)Factory.duplicate(document, duplicationContext));
        }
        return corpus;
    }

    protected void fireDocumentAdded(CorpusEvent corpusEvent) {
        if (this.corpusListeners != null) {
            Vector vector = this.corpusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CorpusListener)vector.elementAt(i)).documentAdded(corpusEvent);
            }
        }
    }

    protected void fireDocumentRemoved(CorpusEvent corpusEvent) {
        if (this.corpusListeners != null) {
            Vector vector = this.corpusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CorpusListener)vector.elementAt(i)).documentRemoved(corpusEvent);
            }
        }
    }

    @Optional
    @CreoleParameter(collectionElementType=Document.class, comment="A list of GATE documents")
    public void setDocumentsList(List list) {
        this.documentsList = list;
    }

    public List getDocumentsList() {
        return this.documentsList;
    }

    @Override
    public void resourceLoaded(CreoleEvent creoleEvent) {
    }

    @Override
    public void resourceUnloaded(CreoleEvent creoleEvent) {
        Resource resource = creoleEvent.getResource();
        if (resource instanceof Document) {
            while (this.contains(resource)) {
                this.remove(resource);
            }
        }
    }

    @Override
    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    @Override
    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreClosed(CreoleEvent creoleEvent) {
    }

    protected class VerboseList
    extends AbstractList
    implements Serializable {
        ArrayList data = new ArrayList();

        VerboseList() {
        }

        public Object get(int n) {
            return this.data.get(n);
        }

        public int size() {
            return this.data.size();
        }

        public Object set(int n, Object object) {
            if (object instanceof Document) {
                Document document = (Document)this.data.set(n, object);
                Document document2 = (Document)object;
                CorpusImpl.this.fireDocumentRemoved(new CorpusEvent(CorpusImpl.this, document, n, 402));
                CorpusImpl.this.fireDocumentAdded(new CorpusEvent(CorpusImpl.this, document2, n, 401));
                return document;
            }
            throw new UnsupportedOperationException(this.getClass().getName() + " only accepts gate.Document values as members!\n" + object.getClass().getName() + " is not a gate.Document");
        }

        public void add(int n, Object object) {
            if (!(object instanceof Document)) {
                throw new UnsupportedOperationException(this.getClass().getName() + " only accepts gate.Document values as members!\n" + object.getClass().getName() + " is not a gate.Document");
            }
            this.data.add(n, object);
            CorpusImpl.this.fireDocumentAdded(new CorpusEvent(CorpusImpl.this, (Document)object, n, 401));
        }

        public Object remove(int n) {
            Document document = (Document)this.data.remove(n);
            CorpusImpl.this.fireDocumentRemoved(new CorpusEvent(CorpusImpl.this, document, n, 402));
            return document;
        }
    }
}

