/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.CreoleRegister;
import gate.DataStoreRegister;
import gate.Executable;
import gate.Factory;
import gate.FeatureMap;
import gate.GateConstants;
import gate.Resource;
import gate.config.ConfigDataProcessor;
import gate.creole.CreoleRegisterImpl;
import gate.creole.ir.IREngine;
import gate.creole.metadata.CreoleResource;
import gate.event.CreoleListener;
import gate.util.Benchmark;
import gate.util.Files;
import gate.util.GateClassLoader;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.LuckyException;
import gate.util.OptionsMap;
import gate.util.Strings;
import gate.util.asm.AnnotationVisitor;
import gate.util.asm.ClassReader;
import gate.util.asm.ClassVisitor;
import gate.util.asm.Type;
import gate.util.asm.commons.EmptyVisitor;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gate
implements GateConstants {
    protected static final Logger log = Logger.getLogger(Gate.class);
    public static final int STRINGBUFFER_SIZE = 1024;
    public static final int HASH_STH_SIZE = 4;
    public static final String DB_OWNER = "gateadmin";
    private static String[] builtinCreoleDirectoryUrls = new String[0];
    public static final String URI = "http://www.gate.ac.uk";
    protected static final String MIN_JDK_VERSION = "1.5";
    protected static final String ENABLE_BENCHMARKING_FEATURE_NAME = "gate.enable.benchmark";
    private static boolean sandboxed = false;
    protected static boolean initFinished = false;
    private static boolean netConnected = false;
    private static int lastSym;
    private static Set<String> registeredIREngines;
    private static boolean localWebServer;
    private static URL urlBase;
    private static GateClassLoader classLoader;
    private static CreoleRegister creoleRegister;
    private static DataStoreRegister dataStoreRegister;
    private static Executable currentExecutable;
    private static OptionsMap userConfig;
    private static OptionsMap originalUserConfig;
    private static String userConfigElement;
    private static String nl;
    private static String emptyConfigFile;
    protected static File gateHome;
    private static File siteConfigFile;
    private static File userConfigFile;
    protected static File pluginsHome;
    protected static URL builtinCreoleDir;
    protected static File userSessionFile;
    protected static List<URL> knownPlugins;
    protected static List<URL> autoloadPlugins;
    protected static Map<URL, DirectoryInfo> pluginData;
    private static boolean slugGui;
    private static boolean useXMLSerialization;
    @Deprecated
    public static Map<String, EventListener> listeners;

    public static boolean isSandboxed() {
        return sandboxed;
    }

    public static void runInSandbox(boolean bl) {
        if (initFinished) {
            throw new IllegalStateException("Sandbox status cannot be changed after GATE has been initialised!");
        }
        sandboxed = bl;
    }

    public static String getMinJdkVersion() {
        return MIN_JDK_VERSION;
    }

    public static void init() throws GateException {
        if (!sandboxed) {
            Gate.initLocalPaths();
        }
        if (System.getProperty(ENABLE_BENCHMARKING_FEATURE_NAME) != null && System.getProperty(ENABLE_BENCHMARKING_FEATURE_NAME).equalsIgnoreCase("true")) {
            Benchmark.setBenchmarkingEnabled(true);
        }
        if (builtinCreoleDir == null) {
            String string = System.getProperty("gate.builtin.creole.dir");
            if (string == null) {
                builtinCreoleDir = Files.getGateResource("/creole/");
            } else {
                String string2 = string;
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                try {
                    builtinCreoleDir = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new GateRuntimeException("gate.builtin.creole.dir value \"" + string + "\" could" + " not be parsed as either a URL or a file path.");
                }
                log.info((Object)("Using " + builtinCreoleDir + " as built-in CREOLE" + " directory URL"));
            }
        }
        System.setProperty("java.protocol.handler.pkgs", System.getProperty("java.protocol.handler.pkgs") + "|" + "gate.util.protocols");
        lastSym = 0;
        if (classLoader == null) {
            classLoader = new GateClassLoader(Gate.class.getClassLoader());
        }
        if (creoleRegister == null) {
            creoleRegister = new CreoleRegisterImpl();
        }
        if (knownPlugins == null) {
            knownPlugins = new ArrayList<URL>();
        }
        if (autoloadPlugins == null) {
            autoloadPlugins = new ArrayList<URL>();
        }
        if (pluginData == null) {
            pluginData = new HashMap<URL, DirectoryInfo>();
        }
        Gate.initCreoleRegister();
        Gate.initDataStoreRegister();
        if (!sandboxed) {
            Gate.initConfigData();
        }
        if (!sandboxed) {
            Gate.initCreoleRepositories();
        }
        dataStoreRegister.addCreoleListener(creoleRegister);
        Factory.addCreoleListener(creoleRegister);
        if (System.getProperty("java.version").compareTo(MIN_JDK_VERSION) < 0) {
            throw new GateException("GATE requires JDK 1.5 or newer");
        }
        try {
            Gate.registerIREngine("gate.creole.ir.lucene.LuceneIREngine");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GateRuntimeException(classNotFoundException);
        }
        initFinished = true;
    }

    public static boolean isInitialised() {
        return initFinished;
    }

    protected static void initLocalPaths() {
        Serializable serializable;
        String string;
        if (gateHome == null) {
            string = System.getProperty("gate.home");
            if (string != null && string.length() > 0) {
                gateHome = new File(string);
            }
            if (gateHome == null || !gateHome.exists()) {
                log.warn((Object)"GATE home system property (\"gate.home\") not set.\nAttempting to guess...");
                serializable = Thread.currentThread().getContextClassLoader().getResource("gate/Gate.class");
                try {
                    if (((URL)serializable).getProtocol().equals("jar")) {
                        String string2 = ((URL)serializable).getFile();
                        File file = new File(new URI(string2.substring(0, string2.indexOf(33))));
                        gateHome = file.getParentFile().getParentFile();
                    } else if (((URL)serializable).getProtocol().equals("file")) {
                        File file = Files.fileFromURL((URL)serializable);
                        gateHome = file.getParentFile().getParentFile().getParentFile();
                    }
                    log.warn((Object)("Using \"" + gateHome.getCanonicalPath() + "\" as GATE Home.\nIf this is not correct please set it manually" + " using the -D" + "gate.home" + " option in your start-up script"));
                }
                catch (Throwable throwable) {
                    throw new GateRuntimeException("Cannot guess GATE Home. Pease set it manually!", throwable);
                }
            }
        }
        log.info((Object)("Using " + gateHome.toString() + " as GATE home"));
        if (pluginsHome == null) {
            string = System.getProperty("gate.plugins.home");
            if (string != null && string.length() > 0 && ((File)(serializable = new File(string))).exists() && ((File)serializable).isDirectory()) {
                pluginsHome = serializable;
            }
            if (pluginsHome == null && ((File)(serializable = new File(gateHome, "plugins"))).exists() && ((File)serializable).isDirectory()) {
                pluginsHome = serializable;
            }
            if (pluginsHome == null) {
                throw new GateRuntimeException("Could not infer installed plug-ins home!\nPlease set it manually using the -Dgate.plugins.home option in your start-up script.");
            }
        }
        log.info((Object)("Using " + pluginsHome.toString() + " as installed plug-ins directory."));
        if (siteConfigFile == null) {
            string = System.getProperty("gate.site.config");
            if (string != null && string.length() > 0 && ((File)(serializable = new File(string))).exists()) {
                siteConfigFile = serializable;
            }
            if (siteConfigFile == null && ((File)(serializable = new File(gateHome, "gate.xml"))).exists()) {
                siteConfigFile = serializable;
            }
            if (siteConfigFile == null) {
                throw new GateRuntimeException("Could not locate the site configuration file!\nPlease create it at " + new File(gateHome, "gate.xml").toString() + " or point to an existing one using the -D" + "gate.site.config" + " option in your start-up script!");
            }
        }
        log.info((Object)("Using " + siteConfigFile.toString() + " as site configuration file."));
        if (userConfigFile == null) {
            string = System.getProperty("gate.user.config");
            userConfigFile = string != null && string.length() > 0 ? new File(string) : new File(Gate.getDefaultUserConfigFileName());
        }
        log.info((Object)("Using " + userConfigFile + " as user configuration file"));
        if (userSessionFile == null) {
            string = System.getProperty("gate.user.session");
            userSessionFile = string != null && string.length() > 0 ? new File(string) : new File(Gate.getDefaultUserSessionFileName());
        }
        log.info((Object)("Using " + userSessionFile + " as user session file"));
    }

    protected static void initCreoleRepositories() {
        Object object;
        Object object2;
        Object object3;
        String string = (String)Gate.getUserConfig().get("Known_plugin_path");
        if (string != null && string.length() > 0) {
            object3 = new StringTokenizer(string, ";", false);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object3).nextToken();
                try {
                    object2 = new URL(string2);
                    Gate.addKnownPlugin((URL)object2);
                }
                catch (MalformedURLException malformedURLException) {
                    log.error((Object)("Plugin error: " + string2 + " is an invalid URL!"));
                }
            }
        }
        object3 = pluginsHome.listFiles();
        for (int i = 0; i < ((File[])object3).length; ++i) {
            object2 = new File((File)object3[i], "creole.xml");
            if (!((File)object2).exists()) continue;
            try {
                object = ((File)object3[i]).toURI().toURL();
                Gate.addKnownPlugin((URL)object);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new GateRuntimeException(malformedURLException);
            }
        }
        Object object4 = Gate.getUserConfig().getString("Load_plugin_path");
        object2 = System.getProperty("load.plugin.path");
        if (object2 != null && ((String)object2).length() > 0) {
            object4 = object2;
        }
        if (object4 == null || ((String)object4).length() == 0) {
            return;
        }
        object = new StringTokenizer((String)object4, ";", false);
        while (((StringTokenizer)object).hasMoreTokens()) {
            Object object5;
            String string3 = ((StringTokenizer)object).nextToken();
            try {
                object5 = new URL(string3);
                Gate.addAutoloadPlugin((URL)object5);
            }
            catch (MalformedURLException malformedURLException) {
                log.error((Object)("Cannot load " + string3 + " CREOLE repository."), (Throwable)malformedURLException);
            }
            try {
                object5 = Gate.getAutoloadPlugins().iterator();
                while (object5.hasNext()) {
                    Gate.getCreoleRegister().registerDirectories((URL)object5.next());
                }
            }
            catch (GateException gateException) {
                log.error((Object)("Cannot load " + string3 + " CREOLE repository."), (Throwable)gateException);
            }
        }
    }

    public static void initCreoleRegister() throws GateException {
        for (int i = 0; i < builtinCreoleDirectoryUrls.length; ++i) {
            try {
                creoleRegister.addDirectory(new URL(builtinCreoleDirectoryUrls[i]));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new GateException(malformedURLException);
            }
        }
        creoleRegister.registerBuiltins();
    }

    public static void initDataStoreRegister() {
        dataStoreRegister = new DataStoreRegister();
    }

    public static void initConfigData() throws GateException {
        FileInputStream fileInputStream;
        URL uRL;
        ConfigDataProcessor configDataProcessor = new ConfigDataProcessor();
        try {
            uRL = siteConfigFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new GateRuntimeException(malformedURLException);
        }
        try {
            fileInputStream = new FileInputStream(siteConfigFile);
            configDataProcessor.parseConfigFile(fileInputStream, uRL);
        }
        catch (IOException iOException) {
            throw new GateException("Couldn't open site configuration file: " + uRL + " " + iOException);
        }
        if (userConfigFile != null && userConfigFile.exists()) {
            try {
                uRL = userConfigFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new GateRuntimeException(malformedURLException);
            }
            try {
                fileInputStream = new FileInputStream(userConfigFile);
                configDataProcessor.parseConfigFile(fileInputStream, uRL);
            }
            catch (IOException iOException) {
                throw new GateException("Couldn't open user configuration file: " + uRL + " " + iOException);
            }
        }
        originalUserConfig.putAll(userConfig);
        log.debug((Object)("user config loaded; DBCONFIG=" + DataStoreRegister.getConfigData()));
    }

    public static String guessUnicodeFont() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("Arial Unicode MS")) {
                string = stringArray[i];
                break;
            }
            if (stringArray[i].toLowerCase().indexOf("unicode") == -1) continue;
            string = stringArray[i];
        }
        return string;
    }

    public static URL getUrl() throws GateException {
        if (urlBase != null) {
            return urlBase;
        }
        try {
            if (Gate.isNetConnected() && Gate.tryNetServer("gate.ac.uk", 80, "/")) {
                log.debug((Object)("getUrl() returned " + urlBase));
                return urlBase;
            }
            if (Gate.isLocalWebServer() && Gate.tryNetServer(InetAddress.getLocalHost().getHostName(), 80, "/gate.ac.uk/")) {
                log.debug((Object)("getUrlBase() returned " + urlBase));
                return urlBase;
            }
            Gate.tryFileSystem();
        }
        catch (MalformedURLException malformedURLException) {
            throw new GateException("Bad URL, getUrlBase(): " + urlBase + ": " + malformedURLException);
        }
        catch (UnknownHostException unknownHostException) {
            throw new GateException("No host, getUrlBase(): " + urlBase + ": " + unknownHostException);
        }
        log.debug((Object)("getUrlBase() returned " + urlBase));
        return urlBase;
    }

    public static URL getUrl(String string) throws GateException {
        Gate.getUrl();
        if (urlBase == null) {
            return null;
        }
        URL uRL = null;
        try {
            uRL = new URL(urlBase, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new GateException("Bad URL, getUrl( " + string + "): " + malformedURLException);
        }
        log.debug((Object)("getUrl(" + string + ") returned " + uRL));
        return uRL;
    }

    public static void registerIREngine(String string) throws GateException, ClassNotFoundException {
        Class<?> clazz = Class.forName(string, true, Gate.getClassLoader());
        if (!IREngine.class.isAssignableFrom(clazz)) {
            throw new GateException(string + " does not implement the " + IREngine.class.getName() + " interface!");
        }
        registeredIREngines.add(string);
    }

    public static boolean unregisterIREngine(String string) {
        return registeredIREngines.remove(string);
    }

    public static Set<String> getRegisteredIREngines() {
        return Collections.unmodifiableSet(registeredIREngines);
    }

    public static File getGateHome() {
        return gateHome;
    }

    public static boolean isNetConnected() {
        return netConnected;
    }

    public static void setNetConnected(boolean bl) {
        netConnected = bl;
    }

    public static boolean isLocalWebServer() {
        return localWebServer;
    }

    public static void setLocalWebServer(boolean bl) {
        localWebServer = bl;
    }

    public static boolean tryNetServer(String string, int n, String string2) throws MalformedURLException {
        log.debug((Object)("tryNetServer(hostName=" + string + ", serverPort=" + n + ", path=" + string2 + ")"));
        try {
            URL uRL = new URL("http://" + string + ":" + n + "/");
            URLConnection uRLConnection = uRL.openConnection();
            HttpURLConnection httpURLConnection = null;
            if (uRLConnection instanceof HttpURLConnection) {
                httpURLConnection = (HttpURLConnection)uRLConnection;
            }
            if (httpURLConnection.getResponseCode() == -1) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        urlBase = new URL("http", string, n, string2);
        return true;
    }

    protected static boolean tryFileSystem() throws MalformedURLException {
        String string = Gate.locateGateFiles();
        log.debug((Object)("tryFileSystem: " + string));
        urlBase = new URL(string + "gate/resources/gate.ac.uk/");
        return urlBase == null;
    }

    public static String locateGateFiles() {
        String string = "gate/resources/creole/creole.xml";
        URL uRL = Gate.getClassLoader().getResource(string);
        StringBuffer stringBuffer = new StringBuffer(uRL.toExternalForm());
        String string2 = stringBuffer.substring(0, stringBuffer.length() - string.length());
        return string2;
    }

    public static boolean isGateType(String string) {
        boolean bl = Gate.getCreoleRegister().containsKey(string);
        if (!bl) {
            try {
                Class<?> clazz = Class.forName(string, true, Gate.getClassLoader());
                bl = Resource.class.isAssignableFrom(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        return bl;
    }

    public static boolean getHiddenAttribute(FeatureMap featureMap) {
        if (featureMap == null) {
            return false;
        }
        Object v = featureMap.get("gate.HIDDEN");
        return v != null && v instanceof String && ((String)v).equals("true");
    }

    public static void setHiddenAttribute(FeatureMap featureMap, boolean bl) {
        if (bl) {
            featureMap.put("gate.HIDDEN", "true");
        } else {
            featureMap.remove("gate.HIDDEN");
        }
    }

    public static synchronized void addCreoleListener(CreoleListener creoleListener) {
        creoleRegister.addCreoleListener(creoleListener);
    }

    public static void setUrlBase(URL uRL) {
        urlBase = uRL;
    }

    public static GateClassLoader getClassLoader() {
        return classLoader;
    }

    public static CreoleRegister getCreoleRegister() {
        return creoleRegister;
    }

    public static DataStoreRegister getDataStoreRegister() {
        return dataStoreRegister;
    }

    public static synchronized void setExecutable(Executable executable) {
        if (executable == null) {
            currentExecutable = executable;
        } else {
            while (Gate.getExecutable() != null) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    throw new LuckyException(interruptedException.toString());
                }
            }
            currentExecutable = executable;
        }
    }

    public static synchronized Executable getExecutable() {
        return currentExecutable;
    }

    public static synchronized String genSym() {
        StringBuffer stringBuffer = new StringBuffer(Integer.toHexString(lastSym++).toUpperCase());
        for (int i = stringBuffer.length(); i <= 4; ++i) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public static String getUserConfigElement() {
        return userConfigElement;
    }

    public static File getSiteConfigFile() {
        String string;
        if (siteConfigFile == null && (string = System.getProperty("gate.config")) != null) {
            siteConfigFile = new File(string);
        }
        return siteConfigFile;
    }

    public static void setSiteConfigFile(File file) {
        siteConfigFile = file;
    }

    public static String getEmptyConfigFile() {
        return emptyConfigFile;
    }

    public static OptionsMap getUserConfig() {
        return userConfig;
    }

    public static OptionsMap getOriginalUserConfig() {
        return originalUserConfig;
    }

    /*
     * WARNING - void declaration
     */
    public static void writeUserConfig() throws GateException {
        void var3_6;
        String string;
        if (sandboxed) {
            return;
        }
        try {
            string = pluginsHome.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new GateRuntimeException("Problem while locating the plug-ins home!", iOException);
        }
        String string2 = "";
        for (URL object2 : Gate.getKnownPlugins()) {
            if (object2.getProtocol().equals("file")) {
                File file = Files.fileFromURL(object2);
                try {
                    if (file.getCanonicalPath().startsWith(string)) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    throw new GateRuntimeException("Problem while locating the plug-in" + object2.toString(), iOException);
                }
            }
            if (string2.length() > 0) {
                string2 = string2 + ";";
            }
            string2 = string2 + object2.toExternalForm();
        }
        Gate.getUserConfig().put((Object)"Known_plugin_path", string2);
        String string3 = "";
        for (URL uRL : Gate.getAutoloadPlugins()) {
            void var3_8;
            if (var3_6.length() > 0) {
                String string4 = (String)var3_6 + ";";
            }
            String string5 = (String)var3_8 + uRL.toExternalForm();
        }
        Gate.getUserConfig().put((Object)"Load_plugin_path", (Object)var3_6);
        File file = Gate.getUserConfigFile();
        try {
            if (!file.exists()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                outputStreamWriter.write(emptyConfigFile);
                outputStreamWriter.close();
            }
            Files.updateXmlElement(file, userConfigElement, (Map)userConfig);
        }
        catch (IOException iOException) {
            throw new GateException("problem writing user gate.xml: " + nl + iOException.toString());
        }
    }

    public static String getUserConfigFileName() {
        return Gate.getDefaultUserConfigFileName();
    }

    public static String getDefaultUserConfigFileName() {
        String string = "";
        if (Gate.runningOnUnix()) {
            string = ".";
        }
        String string2 = System.getProperty("user.home") + Strings.getFileSep() + string + "gate.xml";
        return string2;
    }

    public static String getDefaultUserSessionFileName() {
        String string = "";
        if (Gate.runningOnUnix()) {
            string = ".";
        }
        String string2 = System.getProperty("user.home") + Strings.getFileSep() + string + "gate.session";
        return string2;
    }

    public static boolean runningOnUnix() {
        return Strings.getFileSep().equals("/");
    }

    public static boolean runningOnMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static List<URL> getKnownPlugins() {
        return knownPlugins;
    }

    public static void addKnownPlugin(URL uRL) {
        if (knownPlugins.contains(uRL = Gate.normaliseCreoleUrl(uRL))) {
            return;
        }
        knownPlugins.add(uRL);
    }

    private static URL normaliseCreoleUrl(URL uRL) {
        String string;
        String string2 = uRL.toExternalForm();
        if (string2.endsWith(string = "/")) {
            return uRL;
        }
        string2 = string2 + string;
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new GateRuntimeException(malformedURLException);
        }
    }

    public static List<URL> getAutoloadPlugins() {
        return autoloadPlugins;
    }

    public static void addAutoloadPlugin(URL uRL) {
        if (autoloadPlugins.contains(uRL = Gate.normaliseCreoleUrl(uRL))) {
            return;
        }
        Gate.addKnownPlugin(uRL);
        autoloadPlugins.add(uRL);
    }

    public static DirectoryInfo getDirectoryInfo(URL uRL) {
        if (!knownPlugins.contains(uRL = Gate.normaliseCreoleUrl(uRL))) {
            return null;
        }
        DirectoryInfo directoryInfo = pluginData.get(uRL);
        if (directoryInfo == null) {
            directoryInfo = new DirectoryInfo(uRL);
            pluginData.put(uRL, directoryInfo);
        }
        return directoryInfo;
    }

    public static void removeKnownPlugin(URL uRL) {
        uRL = Gate.normaliseCreoleUrl(uRL);
        knownPlugins.remove(uRL);
        autoloadPlugins.remove(uRL);
        creoleRegister.removeDirectory(uRL);
        pluginData.remove(uRL);
    }

    public static void removeAutoloadPlugin(URL uRL) {
        uRL = Gate.normaliseCreoleUrl(uRL);
        autoloadPlugins.remove(uRL);
    }

    public static void setGateHome(File file) {
        if (gateHome != null) {
            throw new IllegalStateException("gateHome has already been set");
        }
        gateHome = file;
    }

    public static void setPluginsHome(File file) {
        if (pluginsHome != null) {
            throw new IllegalStateException("pluginsHome has already been set");
        }
        pluginsHome = file;
    }

    public static File getPluginsHome() {
        return pluginsHome;
    }

    public static void setUserConfigFile(File file) {
        if (userConfigFile != null) {
            throw new IllegalStateException("userConfigFile has already been set");
        }
        userConfigFile = file;
    }

    public static File getUserConfigFile() {
        return userConfigFile;
    }

    public static void setBuiltinCreoleDir(URL uRL) {
        if (builtinCreoleDir != null) {
            throw new IllegalStateException("builtinCreoleDir has already been set");
        }
        builtinCreoleDir = uRL;
    }

    public static URL getBuiltinCreoleDir() {
        return builtinCreoleDir;
    }

    public static void setUserSessionFile(File file) {
        if (userSessionFile != null) {
            throw new IllegalStateException("userSessionFile has already been set");
        }
        userSessionFile = file;
    }

    public static File getUserSessionFile() {
        return userSessionFile;
    }

    public static boolean isSlugGui() {
        return slugGui;
    }

    public static void setSlugGui(boolean bl) {
        slugGui = bl;
    }

    public static void setUseXMLSerialization(boolean bl) {
        useXMLSerialization = bl;
    }

    public static boolean getUseXMLSerialization() {
        return useXMLSerialization;
    }

    public static Map<String, EventListener> getListeners() {
        return listeners;
    }

    static {
        registeredIREngines = new HashSet<String>();
        localWebServer = false;
        urlBase = null;
        classLoader = null;
        creoleRegister = null;
        dataStoreRegister = null;
        userConfig = new OptionsMap();
        originalUserConfig = new OptionsMap();
        userConfigElement = "GATECONFIG";
        nl = Strings.getNl();
        emptyConfigFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + nl + "<!-- " + "gate.xml" + ": GATE configuration data -->" + nl + "<GATE>" + nl + "" + nl + "<!-- NOTE: the next element may be overwritten by the GUI!!! -->" + nl + "<" + userConfigElement + "/>" + nl + "" + nl + "</GATE>" + nl;
        slugGui = false;
        useXMLSerialization = true;
        listeners = new HashMap<String, EventListener>();
    }

    private static class ResourceInfoVisitor
    extends EmptyVisitor {
        private ResourceInfo resInfo;
        private boolean foundCreoleResource = false;
        private boolean isAbstract = false;
        private static final String CREOLE_RESOURCE_DESC = Type.getDescriptor(CreoleResource.class);

        public ResourceInfoVisitor(ResourceInfo resourceInfo) {
            this.resInfo = resourceInfo;
        }

        public boolean isCreoleResource() {
            return this.foundCreoleResource && !this.isAbstract;
        }

        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            this.isAbstract = (n2 & 0x600) != 0;
        }

        public AnnotationVisitor visitAnnotation(String string, boolean bl) {
            if (string.equals(CREOLE_RESOURCE_DESC)) {
                this.foundCreoleResource = true;
                return new EmptyVisitor(){

                    public void visit(String string, Object object) {
                        if (string.equals("name") && ((ResourceInfoVisitor)ResourceInfoVisitor.this).resInfo.resourceName == null) {
                            ((ResourceInfoVisitor)ResourceInfoVisitor.this).resInfo.resourceName = (String)object;
                        } else if (string.equals("comment") && ((ResourceInfoVisitor)ResourceInfoVisitor.this).resInfo.resourceComment == null) {
                            ((ResourceInfoVisitor)ResourceInfoVisitor.this).resInfo.resourceComment = (String)object;
                        }
                    }

                    public AnnotationVisitor visitAnnotation(String string, String string2) {
                        return new EmptyVisitor();
                    }
                };
            }
            return super.visitAnnotation(string, bl);
        }
    }

    public static class ResourceInfo {
        protected String resourceClassName;
        protected String resourceName;
        protected String resourceComment;

        public ResourceInfo(String string, String string2, String string3) {
            this.resourceClassName = string2;
            this.resourceName = string;
            this.resourceComment = string3;
        }

        public String getResourceClassName() {
            return this.resourceClassName;
        }

        public String getResourceComment() {
            return this.resourceComment;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DirectoryInfo {
        protected URL url;
        protected boolean valid;
        protected List<ResourceInfo> resourceInfoList;

        public DirectoryInfo(URL uRL) {
            this.url = Gate.normaliseCreoleUrl(uRL);
            this.valid = true;
            this.resourceInfoList = new ArrayList<ResourceInfo>();
            this.parseCreole();
        }

        protected void parseCreole() {
            SAXBuilder sAXBuilder = new SAXBuilder(false);
            try {
                Object object5;
                Object object3;
                URL uRL = new URL(this.url, "creole.xml");
                Document document = sAXBuilder.build(uRL);
                LinkedHashMap<String, ResourceInfo> linkedHashMap = new LinkedHashMap<String, ResourceInfo>();
                ArrayList<Element> object4 = new ArrayList<Element>();
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                object4.add(document.getRootElement());
                while (!object4.isEmpty()) {
                    object3 = (Element)object4.remove(0);
                    if (object3.getName().equalsIgnoreCase("JAR")) {
                        List list = object3.getAttributes();
                        for (Object object2 : list) {
                            if (!object2.getName().equalsIgnoreCase("SCAN") || !object2.getBooleanValue()) continue;
                            arrayList.add(object3.getTextTrim());
                            break;
                        }
                        arrayList2.add(object3.getTextTrim());
                        continue;
                    }
                    if (object3.getName().equalsIgnoreCase("RESOURCE")) {
                        Object object2;
                        String string = object3.getChildTextTrim("NAME");
                        object5 = object3.getChildTextTrim("CLASS");
                        object2 = object3.getChildTextTrim("COMMENT");
                        if (linkedHashMap.containsKey(object5)) continue;
                        ResourceInfo resourceInfo = new ResourceInfo(string, (String)object5, (String)object2);
                        linkedHashMap.put((String)object5, resourceInfo);
                        continue;
                    }
                    ArrayList<Element> arrayList3 = new ArrayList<Element>(object3.getChildren());
                    arrayList3.addAll(object4);
                    object4 = arrayList3;
                }
                for (String string : arrayList) {
                    object5 = new URL(this.url, string);
                    this.scanJar((URL)object5, linkedHashMap);
                }
                object3 = new ArrayList();
                for (Object object5 : linkedHashMap.values()) {
                    if (((ResourceInfo)object5).getResourceName() != null) continue;
                    object3.add(object5);
                }
                if (!object3.isEmpty()) {
                    this.fillInResInfos((List<ResourceInfo>)object3, arrayList2);
                }
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object5 = (ResourceInfo)iterator.next();
                    if (((ResourceInfo)object5).getResourceName() != null) continue;
                    ((ResourceInfo)object5).resourceName = ((ResourceInfo)object5).resourceClassName.substring(((ResourceInfo)object5).resourceClassName.lastIndexOf(46) + 1);
                }
                this.resourceInfoList.addAll(linkedHashMap.values());
            }
            catch (IOException iOException) {
                this.valid = false;
                log.error((Object)("Problem while parsing plugin " + this.url.toExternalForm() + "!\n" + iOException.toString() + "\nPlugin not available!"));
            }
            catch (JDOMException jDOMException) {
                this.valid = false;
                log.error((Object)("Problem while parsing plugin " + this.url.toExternalForm() + "!\n" + jDOMException.toString() + "\nPlugin not available!"));
            }
        }

        protected void scanJar(URL uRL, Map<String, ResourceInfo> map) throws IOException {
            JarInputStream jarInputStream = new JarInputStream(uRL.openStream(), false);
            JarEntry jarEntry = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String string;
                String string2 = jarEntry.getName();
                if (string2 == null || !string2.endsWith(".class") || map.containsKey(string = string2.substring(0, string2.length() - 6).replace('/', '.'))) continue;
                ClassReader classReader = new ClassReader((InputStream)jarInputStream);
                ResourceInfo resourceInfo = new ResourceInfo(null, string, null);
                ResourceInfoVisitor resourceInfoVisitor = new ResourceInfoVisitor(resourceInfo);
                classReader.accept((ClassVisitor)resourceInfoVisitor, 7);
                if (!resourceInfoVisitor.isCreoleResource()) continue;
                map.put(string, resourceInfo);
            }
            jarInputStream.close();
        }

        protected void fillInResInfos(List<ResourceInfo> list, List<String> list2) throws IOException {
            URL[] uRLArray = new URL[list2.size()];
            for (int i = 0; i < uRLArray.length; ++i) {
                uRLArray[i] = new URL(this.url, list2.get(i));
            }
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, Gate.class.getClassLoader());
            for (ResourceInfo resourceInfo : list) {
                String string = resourceInfo.getResourceClassName().replace('.', '/') + ".class";
                InputStream inputStream = ((ClassLoader)uRLClassLoader).getResourceAsStream(string);
                if (inputStream == null) continue;
                ClassReader classReader = new ClassReader(inputStream);
                ResourceInfoVisitor resourceInfoVisitor = new ResourceInfoVisitor(resourceInfo);
                classReader.accept((ClassVisitor)resourceInfoVisitor, 7);
                inputStream.close();
            }
        }

        public List<ResourceInfo> getResourceInfoList() {
            return this.resourceInfoList;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

