/*
 * Decompiled with CFR 0.152.
 */
package gate.util.spring;

import gate.Gate;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Init {
    private List<Resource> plugins;

    public void setGateHome(Resource resource) throws IOException {
        if (!Gate.isInitialised()) {
            Gate.setGateHome(resource.getFile());
        }
    }

    public void setPluginsHome(Resource resource) throws IOException {
        if (!Gate.isInitialised()) {
            Gate.setPluginsHome(resource.getFile());
        }
    }

    public void setSiteConfigFile(Resource resource) throws IOException {
        if (!Gate.isInitialised()) {
            Gate.setSiteConfigFile(resource.getFile());
        }
    }

    public void setUserConfigFile(Resource resource) throws IOException {
        if (!Gate.isInitialised()) {
            Gate.setUserConfigFile(resource.getFile());
        }
    }

    public void setBuiltinCreoleDir(Resource resource) throws IOException {
        if (!Gate.isInitialised()) {
            Gate.setBuiltinCreoleDir(resource.getURL());
        }
    }

    public void setPreloadPlugins(List<Resource> list) {
        this.plugins = list;
    }

    public void init() throws Exception {
        if (!Gate.isInitialised()) {
            Gate.init();
            if (this.plugins != null && !this.plugins.isEmpty()) {
                for (Resource resource : this.plugins) {
                    File file = null;
                    try {
                        file = resource.getFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (file == null) {
                        Gate.getCreoleRegister().registerDirectories(resource.getURL());
                        continue;
                    }
                    Gate.getCreoleRegister().registerDirectories(file.toURI().toURL());
                }
            }
        }
    }
}

