/*
 * Decompiled with CFR 0.152.
 */
package gate.util.spring;

import gate.Controller;
import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.LanguageAnalyser;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.ConditionalController;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.ontology.Ontology;
import gate.util.GateException;
import gate.util.spring.GateAwareObject;
import gate.util.spring.ResourceCustomiser;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateResourceFactoryBean
extends GateAwareObject
implements FactoryBean,
DisposableBean {
    private Resource templateResource;
    private boolean returnTemplate = false;
    private List<ResourceCustomiser> customisers;
    private List<WeakReference<Resource>> resourcesReturned = Collections.synchronizedList(new ArrayList());
    private Class<?> typeClass = null;

    public void setTemplate(Resource resource) {
        this.templateResource = resource;
    }

    public void setReturnTemplate(boolean bl) {
        this.returnTemplate = bl;
    }

    public void setCustomisers(List<ResourceCustomiser> list) {
        this.customisers = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws Exception {
        this.ensureGateInit();
        Resource resource = null;
        if (this.returnTemplate) {
            List<WeakReference<Resource>> list = this.resourcesReturned;
            synchronized (list) {
                if (this.resourcesReturned.isEmpty()) {
                    this.resourcesReturned.add(new WeakReference<Resource>(this.templateResource));
                    resource = this.templateResource;
                }
            }
        }
        if (resource == null) {
            resource = Factory.duplicate(this.templateResource);
        }
        if (this.customisers != null) {
            for (ResourceCustomiser resourceCustomiser : this.customisers) {
                try {
                    resourceCustomiser.customiseResource(resource);
                }
                catch (GateException gateException) {
                    throw gateException;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new ResourceInstantiationException("Exception in resource customiser", exception);
                }
            }
        }
        if (resource != this.templateResource) {
            this.resourcesReturned.add(new WeakReference<Resource>(resource));
        }
        return resource;
    }

    public Class<?> getObjectType() {
        if (this.templateResource != null && this.typeClass == null) {
            ArrayList<Class<Corpus>> arrayList = new ArrayList<Class<Corpus>>();
            arrayList.add(Resource.class);
            if (this.templateResource instanceof ProcessingResource) {
                arrayList.add(ProcessingResource.class);
            }
            if (this.templateResource instanceof LanguageAnalyser) {
                arrayList.add(LanguageAnalyser.class);
            }
            if (this.templateResource instanceof Gazetteer) {
                arrayList.add(Gazetteer.class);
            }
            if (this.templateResource instanceof Controller) {
                arrayList.add(Controller.class);
            }
            if (this.templateResource instanceof CorpusController) {
                arrayList.add(CorpusController.class);
            }
            if (this.templateResource instanceof ConditionalController) {
                arrayList.add(ConditionalController.class);
            }
            if (this.templateResource instanceof LanguageResource) {
                arrayList.add(LanguageResource.class);
            }
            if (this.templateResource instanceof Ontology) {
                arrayList.add(Ontology.class);
            }
            if (this.templateResource instanceof Document) {
                arrayList.add(Document.class);
            }
            if (this.templateResource instanceof Corpus) {
                arrayList.add(Corpus.class);
            }
            this.typeClass = Proxy.getProxyClass(Gate.getClassLoader(), arrayList.toArray(new Class[arrayList.size()]));
        }
        return this.typeClass;
    }

    public boolean isSingleton() {
        return false;
    }

    public void destroy() {
        for (WeakReference<Resource> weakReference : this.resourcesReturned) {
            Resource resource = (Resource)weakReference.get();
            if (resource == null) continue;
            Factory.deleteResource(resource);
        }
    }
}

