/*
 * Decompiled with CFR 0.152.
 */
package gate.util.reporting;

import gate.util.reporting.BenchmarkReportable;
import gate.util.reporting.FileWatcher;
import gate.util.reporting.ValueComparator;
import gate.util.reporting.exceptions.BenchmarkReportExecutionException;
import gate.util.reporting.exceptions.BenchmarkReportFileAccessException;
import gate.util.reporting.exceptions.BenchmarkReportInputFileFormatException;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocTimeReporter
implements BenchmarkReportable {
    private File benchmarkFile = new File("benchmark.txt");
    private String printMedia = "html";
    private int maxDocumentInReport = 10;
    private String PRMatchingRegex = "all_prs";
    private String logicalStart = null;
    private File reportFile;
    private HashSet<String> allDocs = new HashSet();
    private HashSet<String> matchingPRs = new HashSet();
    private float globalTotal = 0.0f;
    private LinkedHashMap<String, Object> docContainer = new LinkedHashMap();
    private File temporaryDirectory;
    private String pipelineName = "";
    private static final int STATUS_NORMAL = 0;
    private static final int STATUS_ERROR = 1;
    private static final int FILE_CHUNK_SIZE = 2000;
    private static final String NL = System.getProperty("line.separator");
    public int validEntries = 0;
    public static final String MEDIA_TEXT = "text";
    public static final String MEDIA_HTML = "html";
    public static final int ALL_DOCS = -1;
    public static final String MATCH_ALL_PR_REGEX = "all_prs";

    public DocTimeReporter() {
        try {
            this.temporaryDirectory = File.createTempFile("benchmark-reports", "", null);
            if (!this.temporaryDirectory.delete() || !this.temporaryDirectory.mkdir()) {
                throw new IOException("Unable to create temporary directory.\n" + this.temporaryDirectory.getCanonicalPath());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    DocTimeReporter(String[] stringArray) {
        this.parseArguments(stringArray);
    }

    @Override
    public Object calculate(Object object) {
        return this.sortHashMapByValues(this.doTotal((LinkedHashMap)object));
    }

    private LinkedHashMap sortHashMapByValues(LinkedHashMap linkedHashMap) {
        ArrayList arrayList = new ArrayList(linkedHashMap.keySet());
        ArrayList arrayList2 = new ArrayList(linkedHashMap.values());
        Collections.sort(arrayList2, new ValueComparator());
        Collections.sort(arrayList);
        Collections.reverse(arrayList2);
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        block0: for (Object e : arrayList2) {
            for (Object e2 : arrayList) {
                String string;
                String string2 = linkedHashMap.get(e2).toString();
                if (!string2.equals(string = e.toString())) continue;
                linkedHashMap.remove(e2);
                arrayList.remove(e2);
                linkedHashMap2.put(e2, e);
                continue block0;
            }
        }
        return linkedHashMap2;
    }

    private LinkedHashMap<String, Object> doTotal(LinkedHashMap<String, Object> linkedHashMap) {
        LinkedHashMap<String, Object> linkedHashMap2 = linkedHashMap;
        for (String string : linkedHashMap2.keySet()) {
            if (linkedHashMap2.get(string) instanceof LinkedHashMap) {
                this.docContainer = this.doTotal((LinkedHashMap)linkedHashMap2.get(string));
                continue;
            }
            if (this.docContainer.get(string) == null) {
                this.docContainer.put(string, linkedHashMap2.get(string));
                continue;
            }
            int n = Integer.parseInt((String)this.docContainer.get(string)) + Integer.parseInt((String)linkedHashMap2.get(string));
            this.docContainer.put(string, Integer.toString(n));
        }
        return this.docContainer;
    }

    @Override
    public void printReport(Object object, File file) {
        if (this.printMedia.equalsIgnoreCase(MEDIA_TEXT)) {
            this.printToText(object, file);
        } else if (this.printMedia.equalsIgnoreCase(MEDIA_HTML)) {
            this.printToHTML((LinkedHashMap)object, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void printToText(Object object, File file) {
        block24: {
            Object object2;
            ArrayList<String> arrayList = new ArrayList<String>();
            LinkedHashMap linkedHashMap = (LinkedHashMap)object;
            String string = "";
            string = this.maxDocumentInReport != -1 ? (this.allDocs.size() < this.maxDocumentInReport ? Integer.toString(this.allDocs.size()) : Integer.toString(this.maxDocumentInReport)) : "All";
            arrayList.add("=============================================================" + NL);
            if (this.PRMatchingRegex.equals(MATCH_ALL_PR_REGEX)) {
                arrayList.add("Top " + string + " expensive documents matching All PRs in " + this.pipelineName + NL);
            } else if (this.matchingPRs.size() > 0) {
                arrayList.add("Top " + string + " expensive documents matching following PRs in " + this.pipelineName + NL);
                for (String string2 : this.matchingPRs) {
                    arrayList.add("\t" + string2 + NL);
                }
            } else {
                arrayList.add("No PRs matched to search string \"" + this.getPRMatchingRegex() + "\"" + " in " + this.pipelineName);
                arrayList.add(NL);
                arrayList.add("=============================================================" + NL);
            }
            if (this.allDocs.size() > 0) {
                arrayList.add("=============================================================" + NL);
                arrayList.add("Document Name\tTime (in seconds)\t%" + NL);
                arrayList.add("-------------------------------------------------------------" + NL);
            }
            Iterator<String> iterator = linkedHashMap.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (!((String)object2).equals("total")) {
                    int n2 = Integer.parseInt((String)linkedHashMap.get(object2));
                    if (this.maxDocumentInReport == -1) {
                        arrayList.add(object2 + "\t" + (double)n2 / 1000.0 + "\t" + (double)Math.round((float)n2 / this.globalTotal * 100.0f * 10.0f) / 10.0 + NL);
                    } else if (n < this.maxDocumentInReport) {
                        arrayList.add(object2 + "\t" + (double)n2 / 1000.0 + "\t" + (double)Math.round((float)n2 / this.globalTotal * 100.0f * 10.0f) / 10.0 + NL);
                    }
                }
                ++n;
            }
            if (this.allDocs.size() > 0) {
                arrayList.add("-------------------------------------------------------------" + NL);
                arrayList.add("Pipeline Total\t" + (double)this.globalTotal / 1000.0 + "\t" + 100 + NL + NL + NL);
            }
            object2 = null;
            object2 = new BufferedWriter(new FileWriter(file, true));
            for (String string3 : arrayList) {
                ((Writer)object2).write(string3);
            }
            Object var12_14 = null;
            try {
                if (object2 != null) {
                    ((BufferedWriter)object2).close();
                }
                break block24;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block24;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var12_15 = null;
                    try {
                        if (object2 != null) {
                            ((BufferedWriter)object2).close();
                        }
                        break block24;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                try {
                    if (object2 != null) {
                        ((BufferedWriter)object2).close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object store(File file) throws BenchmarkReportInputFileFormatException {
        LinkedHashMap<String, Object> linkedHashMap;
        block21: {
            String string;
            String[] stringArray = file.getAbsolutePath().split("\\" + File.separator);
            this.pipelineName = stringArray[stringArray.length - 1].replace("_benchmark.txt", "");
            linkedHashMap = new LinkedHashMap<String, Object>();
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            String string3 = null;
            String string4 = null;
            Pattern pattern = Pattern.compile("(\\d+) (\\d+) (.*) (.*) \\{(.*)\\}");
            Pattern pattern2 = Pattern.compile(".*documentName=(.*?)[,|}].*");
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                if (string.matches(".*START.*")) {
                    object = string.split("\\s");
                    if (((String[])object).length > 2) {
                        string4 = object[2];
                    } else {
                        throw new BenchmarkReportInputFileFormatException(this.getBenchmarkFile() + " is invalid.");
                    }
                }
                object = pattern.matcher(string);
                Matcher matcher = pattern2.matcher(string);
                Pattern pattern3 = Pattern.compile("(\\d+) (\\d+) " + Pattern.quote(string4) + " (.*) \\{(.*)\\}.*");
                Matcher matcher2 = pattern3.matcher(string);
                if (matcher != null && matcher.matches()) {
                    string2 = matcher.group(1);
                }
                if (matcher2 != null && matcher2.matches()) {
                    this.globalTotal += (float)Integer.parseInt(matcher2.group(2));
                }
                if (object == null || !((Matcher)object).matches()) continue;
                String string5 = ((Matcher)object).group(3).replaceFirst(Pattern.quote(string4) + ".", "").replaceFirst("doc_" + Pattern.quote(string2) + ".", "");
                String[] stringArray2 = string5.split("\\.");
                if (this.PRMatchingRegex.equals(MATCH_ALL_PR_REGEX)) {
                    if (stringArray2.length > 0) {
                        string3 = stringArray2[0];
                    }
                    if (string3.equalsIgnoreCase(string4)) continue;
                    this.organizeEntries(linkedHashMap, string3, ((Matcher)object).group(2), string2);
                    continue;
                }
                if (!this.isPRMatched(string5, this.PRMatchingRegex)) continue;
                if (stringArray2.length > 0) {
                    string3 = stringArray2[0];
                }
                if (string3 != null) {
                    this.matchingPRs.add(string3);
                }
                this.organizeEntries(linkedHashMap, string3, ((Matcher)object).group(2), string2);
            }
            Object var18_18 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block21;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                linkedHashMap = null;
            }
            break block21;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    linkedHashMap = null;
                    Object var18_19 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block21;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                        linkedHashMap = null;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    linkedHashMap = null;
                }
                throw throwable;
            }
        }
        return linkedHashMap;
    }

    private void organizeEntries(LinkedHashMap<String, Object> linkedHashMap, String string, String string2, String string3) {
        this.allDocs.add(string3);
        if (linkedHashMap.containsKey(string)) {
            ((LinkedHashMap)linkedHashMap.get(string)).put(string3, string2);
        } else {
            LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
            linkedHashMap2.put(string3, string2);
            linkedHashMap.put(string, linkedHashMap2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void printToHTML(LinkedHashMap<String, Object> linkedHashMap, File file) {
        block23: {
            Object object;
            String string;
            String string2 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"" + NL + "\"http://www.w3.org/TR/html4/loose.dtd\">" + NL + "<html><head><title>Benchmarking Report</title>" + NL + "<meta http-equiv=\"Content-Type\"" + " content=\"text/html; charset=utf-8\">" + NL + "<style type=\"text/css\">" + NL + "div { font-size:12px; margin-top: 4; }" + NL + "</style>" + NL + "</head>" + NL + "<body style=\"font-family:Verdana; color:navy;\">" + NL;
            String string3 = string = "<div style=\"right: 0pt; border-top:1px solid #C9D7F1; font-size:1px;\" ></div>" + NL;
            String string4 = "";
            string4 = this.maxDocumentInReport != -1 ? (this.allDocs.size() < this.maxDocumentInReport ? Integer.toString(this.allDocs.size()) : Integer.toString(this.maxDocumentInReport)) : "All";
            if (this.PRMatchingRegex.equals(MATCH_ALL_PR_REGEX)) {
                string3 = string3 + "<div style=\"font-size:15px;font-family:Verdana; color:navy;\">Top " + string4 + " expensive documents matching All PRs in <b>" + this.pipelineName + "</b></div>" + NL;
            } else if (this.matchingPRs.size() > 0) {
                string3 = string3 + "<div style=\"font-size:15px;font-family:Verdana; color:navy;\">Top " + string4 + " expensive documents matching following PRs in <b>" + this.pipelineName + "</b> <ul>" + NL;
                for (String string5 : this.matchingPRs) {
                    string3 = string3 + "<li>" + string5 + "</li>";
                }
                string3 = string3 + "</ul></div>";
            } else {
                string3 = string3 + "<div style=\"font-size:15px;font-family:Verdana; color:navy;\">No PRs matched to search string \"" + this.getPRMatchingRegex() + " \" in " + this.pipelineName + "</div>";
            }
            string3 = string3 + string;
            if (this.allDocs.size() > 0) {
                String string5;
                object = string3 + "<table><tr bgcolor=\"#eeeeff\">" + "<td><b>Document Name</b></td>" + "<td><b>Time in seconds</b></td>" + "<td><b>% Time taken</b></td>" + "</tr><tr>" + NL;
                string5 = "<td rowspan = '112' width = '550'>";
                String string6 = "<td width = '100'>";
                String string7 = "<td width = '100'>";
                LinkedHashMap<String, Object> linkedHashMap2 = linkedHashMap;
                linkedHashMap2.remove("total");
                Iterator<String> iterator = linkedHashMap2.keySet().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String string8 = iterator.next();
                    if (!string8.equals("total")) {
                        int n2 = Integer.parseInt((String)linkedHashMap2.get(string8));
                        if (this.maxDocumentInReport == -1) {
                            string5 = string5 + "<div>" + string8 + "</div>";
                            string6 = string6 + "<div>" + (double)n2 / 1000.0 + "</div>";
                            string7 = string7 + "<div>" + (double)Math.round((float)n2 / this.globalTotal * 100.0f * 10.0f) / 10.0 + "</div>" + NL;
                        } else if (n < this.maxDocumentInReport) {
                            string5 = string5 + "<div>" + string8 + "</div>";
                            string6 = string6 + "<div>" + (double)n2 / 1000.0 + "</div>";
                            string7 = string7 + "<div>" + (double)Math.round((float)n2 / this.globalTotal * 100.0f * 10.0f) / 10.0 + "</div>" + NL;
                        }
                    }
                    ++n;
                }
                string5 = string5 + "<div bgcolor=\"#eeeeff\" style = \"font-size:15px;margin-left:400px;\"><b>Total</b></div></td>" + NL;
                string6 = string6 + "<div bgcolor=\"#eeeeff\" style = \"font-size:15px;\"><b>" + (double)this.globalTotal / 1000.0 + "</b></div></td>" + NL;
                string7 = string7 + "<div bgcolor=\"#eeeeff\" style = \"font-size:15px;\"><b>100</b></div></td>" + NL;
                string2 = !file.exists() ? string2 + (String)object + string5 + string6 + string7 + "</tr></table>" : "<br/><br/>" + (String)object + string5 + string6 + string7 + "</tr></table></body></html>";
            } else {
                string2 = string2 + string3 + "</body></html>";
            }
            object = null;
            object = new BufferedWriter(new FileWriter(file));
            ((Writer)object).write(string2);
            Object var17_17 = null;
            try {
                if (object != null) {
                    ((BufferedWriter)object).close();
                }
                break block23;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block23;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var17_18 = null;
                    try {
                        if (object != null) {
                            ((BufferedWriter)object).close();
                        }
                        break block23;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                try {
                    if (object != null) {
                        ((BufferedWriter)object).close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private boolean validateLogEntry(String string, ArrayList<String> arrayList) {
        String string2 = "(";
        for (int i = 0; i < arrayList.size(); ++i) {
            if (string.split("\\.").length == 1 && string.equals(arrayList.get(i))) {
                ++this.validEntries;
                return true;
            }
            string2 = string2 + arrayList.get(i) + "|";
        }
        if (string2.length() > 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string.matches((string2 = string2 + ")") + "\\.doc_.*?\\.pr_.*")) {
            ++this.validEntries;
            return true;
        }
        return false;
    }

    @Override
    public void parseArguments(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("gate.util.reporting.DocTimeReporter", stringArray, "i:m:d:p:o:l:h");
        String string = null;
        block11: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 105: {
                    String string2 = getopt.getOptarg();
                    if (string2 == null) continue block11;
                    this.setBenchmarkFile(new File(string2));
                    continue block11;
                }
                case 109: {
                    String string3 = getopt.getOptarg();
                    if (string3 == null) continue block11;
                    this.setPrintMedia(string3);
                    continue block11;
                }
                case 100: {
                    string = getopt.getOptarg();
                    if (string != null) continue block11;
                    this.setMaxDocumentInReport(this.maxDocumentInReport);
                    continue block11;
                }
                case 112: {
                    String string4 = getopt.getOptarg();
                    if (string4 != null) {
                        this.setPRMatchingRegex(string4);
                        continue block11;
                    }
                    this.setPRMatchingRegex(this.PRMatchingRegex);
                    continue block11;
                }
                case 111: {
                    String string5 = getopt.getOptarg();
                    if (string5 == null) continue block11;
                    this.setReportFile(new File(string5));
                    continue block11;
                }
                case 108: {
                    String string6 = getopt.getOptarg();
                    if (string6 == null) continue block11;
                    this.setLogicalStart(string6);
                    continue block11;
                }
                case 63: 
                case 104: {
                    DocTimeReporter.usage();
                    System.exit(0);
                    continue block11;
                }
            }
            DocTimeReporter.usage();
            System.exit(1);
        }
        if (string != null) {
            try {
                this.setMaxDocumentInReport(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                DocTimeReporter.usage();
                System.exit(1);
            }
        }
    }

    public String getPrintMedia() {
        return this.printMedia;
    }

    public void setPrintMedia(String string) {
        if (!string.equals(MEDIA_HTML) && !string.equals(MEDIA_TEXT)) {
            throw new IllegalArgumentException("Illegal argument: " + string);
        }
        this.printMedia = string.trim();
    }

    private boolean isPRMatched(String string, String string2) {
        String string3 = string.split("\\.")[0];
        string2 = string2.trim();
        string2 = string2.replaceAll("^(pr|pr_)", "");
        string2 = string2.replaceAll("_", " ");
        string2 = string2.replaceAll("\\s+", " ");
        string2 = string2.trim();
        String string4 = string3.replaceAll("^pr_", "");
        string4 = string4.replaceAll("_", " ");
        if (string3.startsWith("pr_")) {
            return string4.matches("(?i).*" + string2 + ".*");
        }
        return false;
    }

    private void deleteFile(File file) throws BenchmarkReportFileAccessException {
        if (file.isFile() && !file.delete()) {
            throw new BenchmarkReportFileAccessException("Could not delete " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void splitBenchmarkFile(File file, File file2) throws BenchmarkReportFileAccessException, BenchmarkReportInputFileFormatException {
        block31: {
            Object object;
            File file3 = this.temporaryDirectory;
            if (file3.isDirectory()) {
                object = file3.listFiles();
                for (int i = 0; i < ((File[])object).length; ++i) {
                    if (object[i].delete()) continue;
                    throw new BenchmarkReportFileAccessException("Could not delete files in the folder \"" + this.temporaryDirectory + "\"");
                }
            } else if (!file3.mkdir()) {
                throw new BenchmarkReportFileAccessException("Could not create  temporary folder \"" + this.temporaryDirectory + "\"");
            }
            if (this.getPrintMedia().equalsIgnoreCase(MEDIA_TEXT)) {
                this.deleteFile(new File(file2.getAbsolutePath() + ".txt"));
            } else if (this.getPrintMedia().equalsIgnoreCase(MEDIA_HTML)) {
                this.deleteFile(new File(file2.getAbsolutePath() + ".html"));
            }
            object = null;
            BufferedWriter bufferedWriter = null;
            String string = "";
            long l = 0L;
            if (this.getLogicalStart() != null) {
                l = this.tail(file, 2000);
            }
            object = new RandomAccessFile(file, "r");
            if (this.getLogicalStart() != null) {
                ((RandomAccessFile)object).seek(l);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = "";
            Pattern pattern = Pattern.compile("(\\d+) (\\d+) (.*) (.*) \\{(.*)\\}");
            Matcher matcher = null;
            File file4 = null;
            while ((string = ((RandomAccessFile)object).readLine()) != null) {
                matcher = pattern.matcher(string);
                String string3 = "";
                if (string.matches(".*START.*")) {
                    String[] stringArray = string.split("\\s");
                    if (stringArray.length <= 2) {
                        throw new BenchmarkReportInputFileFormatException(this.getBenchmarkFile() + " is invalid.");
                    }
                    string3 = stringArray[2];
                    if (string3.endsWith("Start")) continue;
                    if (!arrayList.contains(string3)) {
                        arrayList.add(string3);
                        file4 = new File(this.temporaryDirectory, string3 + "_benchmark.txt");
                        if (!file4.createNewFile()) {
                            throw new BenchmarkReportFileAccessException("Could not create \"" + string3 + "_benchmark.txt" + "\" in directory named \"" + this.temporaryDirectory + "\"");
                        }
                        bufferedWriter = new BufferedWriter(new FileWriter(file4));
                        bufferedWriter.write(string);
                        bufferedWriter.newLine();
                    }
                }
                if (matcher == null || !matcher.matches() || !this.validateLogEntry(matcher.group(3), arrayList) && !string.matches(".*documentLoaded.*")) continue;
                string3 = matcher.group(3).split("\\.")[0];
                if (!string2.equals(string3)) {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    file4 = new File(this.temporaryDirectory, string3 + "_benchmark.txt");
                    bufferedWriter = new BufferedWriter(new FileWriter(file4, true));
                }
                if (bufferedWriter != null) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                string2 = string3;
            }
            Object var17_17 = null;
            try {
                if (object != null) {
                    ((RandomAccessFile)object).close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                break block31;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block31;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var17_18 = null;
                    try {
                        if (object != null) {
                            ((RandomAccessFile)object).close();
                        }
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        break block31;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                try {
                    if (object != null) {
                        ((RandomAccessFile)object).close();
                    }
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private long tail(File file, int n) throws BenchmarkReportInputFileFormatException {
        try {
            long l;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            long l2 = 0L;
            l2 = randomAccessFile.length() - 1L;
            while (true) {
                byte[] byArray;
                if ((l = l2 - (long)n) <= 0L) {
                    randomAccessFile.seek(0L);
                    byArray = new byte[(int)l2];
                    randomAccessFile.readFully(byArray);
                    if (!this.parseLinesFromLast(byArray, vector, l) || l >= 0L) break;
                    l = 0L;
                    break;
                }
                randomAccessFile.seek(l);
                byArray = new byte[n];
                randomAccessFile.readFully(byArray);
                if (this.parseLinesFromLast(byArray, vector, l)) break;
                n2 = vector.get(vector.size() - 1).length();
                vector.remove(vector.size() - 1);
                l2 = l + (long)n2;
            }
            if (l < 0L) {
                throw new BenchmarkReportInputFileFormatException(this.getBenchmarkFile() + " does not contain a marker named " + this.getLogicalStart() + " indicating logical start of a run.");
            }
            return l;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1L;
        }
    }

    private boolean parseLinesFromLast(byte[] byArray, Vector<String> vector, long l) {
        String string = new String(byArray);
        StringBuffer stringBuffer = new StringBuffer(string);
        string = stringBuffer.reverse().toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, NL);
        while (stringTokenizer.hasMoreTokens()) {
            StringBuffer stringBuffer2 = new StringBuffer(stringTokenizer.nextToken());
            vector.add(stringBuffer2.reverse().toString());
            if (!vector.get(vector.size() - 1).trim().endsWith(this.getLogicalStart())) continue;
            return true;
        }
        return false;
    }

    public static void usage() {
        System.out.println("Usage: java gate.util.reporting.DocTimeReporter [Options]" + NL + "\t Options:" + NL + "\t -i input file path (default: benchmark.txt in the execution directory)" + NL + "\t -m print media - html/text (default: html)" + NL + "\t -d number of docs, use -1 for all docs (default: 10 docs)" + NL + "\t -p processing resource name to be matched (default: all_prs)" + NL + "\t -o output file path (default: report.html/txt in the system temporary directory)" + NL + "\t -l logical start (not set by default)" + NL + "\t -h show help" + NL);
    }

    public static void main(String[] stringArray) throws BenchmarkReportInputFileFormatException, BenchmarkReportFileAccessException {
        DocTimeReporter docTimeReporter = new DocTimeReporter(stringArray);
        docTimeReporter.generateReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReport() throws BenchmarkReportInputFileFormatException, BenchmarkReportFileAccessException {
        Timer timer = null;
        try {
            FileWatcher fileWatcher = new FileWatcher(this.getBenchmarkFile()){

                protected void onChange(File file) {
                    throw new BenchmarkReportExecutionException(DocTimeReporter.this.getBenchmarkFile() + " file has been modified while generating the report.");
                }
            };
            timer = new Timer();
            timer.schedule((TimerTask)fileWatcher, new Date(), 1000L);
            if (this.reportFile == null) {
                this.reportFile = new File(System.getProperty("java.io.tmpdir"), "report." + (this.printMedia.equals(MEDIA_HTML) ? MEDIA_HTML : "txt"));
            }
            this.splitBenchmarkFile(this.getBenchmarkFile(), this.reportFile);
            if (this.validEntries == 0) {
                if (this.logicalStart != null) {
                    throw new BenchmarkReportInputFileFormatException("No valid log entries present in " + this.getBenchmarkFile() + " does not contain a marker named " + this.logicalStart + ".");
                }
                throw new BenchmarkReportInputFileFormatException("No valid log entries present in " + this.getBenchmarkFile().getAbsolutePath());
            }
            File file = this.temporaryDirectory;
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    Object object = this.store(file2);
                    Object object2 = this.calculate(object);
                    this.printReport(object2, this.reportFile);
                }
                if (fileArray.length > 0 && fileArray[0].exists() && !fileArray[0].delete()) {
                    System.err.println(fileArray[0] + " was not possible to delete.");
                }
            }
            Object var10_9 = null;
            if (timer != null) {
                timer.cancel();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (timer != null) {
                timer.cancel();
            }
            throw throwable;
        }
    }

    @Override
    public void executeReport() throws BenchmarkReportInputFileFormatException, BenchmarkReportFileAccessException {
        this.generateReport();
    }

    public String getLogicalStart() {
        return this.logicalStart;
    }

    public void setLogicalStart(String string) {
        this.logicalStart = string;
    }

    public File getBenchmarkFile() {
        return this.benchmarkFile;
    }

    public void setBenchmarkFile(File file) {
        this.benchmarkFile = file;
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(File file) {
        this.reportFile = file;
    }

    public int getMaxDocumentInReport() {
        return this.maxDocumentInReport;
    }

    public void setMaxDocumentInReport(int n) {
        if (n <= 0 && n != -1) {
            throw new IllegalArgumentException("Illegal argument: " + n);
        }
        this.maxDocumentInReport = n;
    }

    public String getPRMatchingRegex() {
        return this.PRMatchingRegex;
    }

    public void setPRMatchingRegex(String string) {
        this.PRMatchingRegex = string;
    }
}

