/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.Parameter;
import gate.creole.ParameterList;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.persistence.PersistenceManager;
import gate.util.persistence.ResourcePersistence;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PRPersistence
extends ResourcePersistence {
    protected Object runtimeParams;
    static final long serialVersionUID = 2031381604712340552L;

    public void extractDataFromSource(Object object) throws PersistenceException {
        if (!(object instanceof ProcessingResource)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + ProcessingResource.class.getName() + " objects!\n" + object.getClass().getName() + " is not a " + ProcessingResource.class.getName());
        }
        super.extractDataFromSource(object);
        Resource resource = (Resource)object;
        ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(resource.getClass().getName());
        if (resourceData == null) {
            throw new PersistenceException("Could not find CREOLE data for " + resource.getClass().getName());
        }
        ParameterList parameterList = resourceData.getParameterList();
        try {
            this.runtimeParams = Factory.newFeatureMap();
            Iterator<List<Parameter>> iterator = parameterList.getRuntimeParameters().iterator();
            while (iterator.hasNext()) {
                for (Parameter parameter : iterator.next()) {
                    String string = parameter.getName();
                    Object object2 = resource.getParameterValue(string);
                    ((Map)this.runtimeParams).put(string, object2);
                }
            }
            this.runtimeParams = PersistenceManager.getPersistentRepresentation(this.runtimeParams);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new PersistenceException(resourceInstantiationException);
        }
    }

    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        Object object = super.createObject();
        if (this.runtimeParams != null) {
            this.runtimeParams = PersistenceManager.getTransientRepresentation(this.runtimeParams);
            ((Resource)object).setParameterValues((FeatureMap)this.runtimeParams);
        }
        return object;
    }
}

