/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Gate;
import gate.corpora.DocumentXmlUtils;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Err;
import gate.util.GateClassLoader;
import gate.util.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Files {
    private static final boolean DEBUG = false;
    static long resourceIndex = 0L;
    protected static String resourcePath = "/gate/resources";

    public static String getResourcePath() {
        return resourcePath;
    }

    public static String getLastPathComponent(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getString(String string) throws IOException {
        return Files.getString(new File(string));
    }

    public static String getString(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray, 0, n);
        fileInputStream.close();
        return new String(byArray);
    }

    public static byte[] getByteArray(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray, 0, n);
        fileInputStream.close();
        return byArray;
    }

    public static String getResourceAsString(String string) throws IOException {
        return Files.getResourceAsString(string, null);
    }

    public static String getResourceAsString(String string, String string2) throws IOException {
        int n;
        InputStream inputStream = Files.getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        BomStrippingInputStreamReader bomStrippingInputStreamReader = string2 == null ? new BomStrippingInputStreamReader(inputStream) : new BomStrippingInputStreamReader(inputStream, string2);
        if (bomStrippingInputStreamReader == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        char[] cArray = new char[1024];
        while ((n2 = ((BufferedReader)bomStrippingInputStreamReader).read(cArray, 0, 1024)) != -1) {
            stringBuffer.append(cArray, 0, n2);
        }
        while ((n = ((BufferedReader)bomStrippingInputStreamReader).read()) != -1) {
            stringBuffer.append((char)n);
        }
        ((BufferedReader)bomStrippingInputStreamReader).close();
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGateResourceAsString(String string) throws IOException {
        String string2;
        InputStream inputStream = Files.getGateResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("No such resource on classpath: " + string);
        }
        try {
            string2 = IOUtils.toString((InputStream)inputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return string2;
    }

    public static File writeTempFile(InputStream inputStream) throws IOException {
        File file = null;
        FileOutputStream fileOutputStream = null;
        file = File.createTempFile("gateResource", ".tmp");
        fileOutputStream = new FileOutputStream(file);
        file.deleteOnExit();
        if (inputStream == null) {
            return file;
        }
        int n = 0;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
        inputStream.close();
        return file;
    }

    public static File writeTempFile(String string, String string2) throws UnsupportedEncodingException, IOException {
        File file = null;
        OutputStreamWriter outputStreamWriter = null;
        file = File.createTempFile("gateResource", ".tmp");
        file.deleteOnExit();
        if (string == null) {
            return file;
        }
        outputStreamWriter = string2 == null ? new OutputStreamWriter(new FileOutputStream(file)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2);
        outputStreamWriter.write(string);
        outputStreamWriter.flush();
        outputStreamWriter.close();
        return file;
    }

    public static File writeTempFile(String string) throws IOException {
        return Files.writeTempFile(string, null);
    }

    public static byte[] getResourceAsByteArray(String string) throws IOException, IndexOutOfBoundsException, ArrayStoreException {
        byte[] byArray;
        byte by;
        InputStream inputStream = Files.getResourceAsStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] byArray2 = new byte[1024];
        int n = 0;
        while ((by = (byte)bufferedInputStream.read()) != -1) {
            if (n == byArray2.length) {
                byArray = new byte[byArray2.length * 2];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            byArray2[n++] = by;
        }
        bufferedInputStream.close();
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    public static byte[] getGateResourceAsByteArray(String string) throws IOException, IndexOutOfBoundsException, ArrayStoreException {
        byte[] byArray;
        byte by;
        InputStream inputStream = Files.getGateResourceAsStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] byArray2 = new byte[1024];
        int n = 0;
        while ((by = (byte)bufferedInputStream.read()) != -1) {
            if (n == byArray2.length) {
                byArray = new byte[byArray2.length * 2];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            byArray2[n++] = by;
        }
        bufferedInputStream.close();
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    public static InputStream getResourceAsStream(String string) throws IOException {
        GateClassLoader gateClassLoader;
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if ((gateClassLoader = Gate.getClassLoader()) == null) {
            return Files.class.getClassLoader().getResourceAsStream(string);
        }
        return ((ClassLoader)gateClassLoader).getResourceAsStream(string);
    }

    public static InputStream getGateResourceAsStream(String string) throws IOException {
        if (string.startsWith("/") || string.startsWith("\\")) {
            return Files.getResourceAsStream(resourcePath + string);
        }
        return Files.getResourceAsStream(resourcePath + "/" + string);
    }

    public static URL getResource(String string) {
        GateClassLoader gateClassLoader;
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if ((gateClassLoader = Gate.getClassLoader()) == null) {
            return Files.class.getClassLoader().getResource(string);
        }
        return gateClassLoader.getResource(string);
    }

    public static URL getGateResource(String string) {
        if (string.startsWith("/") || string.startsWith("\\")) {
            return Files.getResource(resourcePath + string);
        }
        return Files.getResource(resourcePath + "/" + string);
    }

    public static Set<String> Find(String string, String string2) {
        Matcher matcher;
        HashSet<String> hashSet = new HashSet<String>();
        File file = null;
        try {
            file = new File(string2);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(Err.getPrintWriter());
        }
        Pattern pattern = Pattern.compile("^" + string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i <= stringArray.length - 1; ++i) {
                String string3 = string2 + "/" + stringArray[i];
                Matcher matcher2 = pattern.matcher(string3);
                if (!matcher2.matches()) continue;
                hashSet.add(string3);
            }
        } else if (file.isFile() && (matcher = pattern.matcher(string2)).matches()) {
            hashSet.add(string2);
        }
        return hashSet;
    }

    public static boolean rmdir(File file) {
        if (file == null || !file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isFile()) {
                if (file2.delete()) continue;
                bl = false;
                continue;
            }
            if (Files.rmdir(file2)) continue;
            bl = false;
        }
        file.delete();
        return bl;
    }

    public static String updateXmlElement(BufferedReader bufferedReader, String string, Map map) throws IOException {
        String string2 = null;
        String string3 = Strings.getNl();
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string3);
        }
        int n = stringBuffer.toString().indexOf("<" + string);
        if (n == -1) {
            return stringBuffer.toString();
        }
        int n2 = stringBuffer.toString().indexOf(">", n);
        if (n2 == -1) {
            return stringBuffer.toString();
        }
        boolean bl = false;
        if (stringBuffer.toString().charAt(n2 - 1) == '/') {
            bl = true;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("<");
        stringBuffer2.append(string);
        for (Map.Entry entry : map.entrySet()) {
            String string4 = (String)entry.getKey();
            String string5 = (String)entry.getValue();
            stringBuffer2.append(" ");
            stringBuffer2.append(DocumentXmlUtils.combinedNormalisation(string4));
            stringBuffer2.append("=\"");
            stringBuffer2.append(DocumentXmlUtils.combinedNormalisation(string5));
            stringBuffer2.append("\"" + string3);
        }
        if (bl) {
            stringBuffer2.append("/");
        }
        stringBuffer2.append(">");
        stringBuffer.replace(n, n2 + 1, stringBuffer2.toString());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String updateXmlElement(File file, String string, Map map) throws IOException {
        Object object;
        Closeable closeable;
        Charset charset;
        String string2;
        block10: {
            BufferedReader bufferedReader;
            block11: {
                string2 = null;
                BufferedReader bufferedReader2 = null;
                bufferedReader = null;
                charset = Charset.forName("UTF-8");
                try {
                    try {
                        closeable = new FileInputStream(file);
                        object = charset.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
                        bufferedReader2 = new BomStrippingInputStreamReader((InputStream)closeable, (CharsetDecoder)object);
                        string2 = Files.updateXmlElement(bufferedReader2, string, map);
                    }
                    catch (CharacterCodingException characterCodingException) {
                        if (bufferedReader2 != null) {
                            bufferedReader2.close();
                            bufferedReader2 = null;
                        }
                        bufferedReader = new BufferedReader(new FileReader(file));
                        string2 = Files.updateXmlElement(bufferedReader, string, map);
                        Object var10_11 = null;
                        if (bufferedReader2 != null) {
                            bufferedReader2.close();
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block10;
                    }
                    Object var10_10 = null;
                    if (bufferedReader2 == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (bufferedReader2 != null) {
                        bufferedReader2.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    throw throwable;
                }
                bufferedReader2.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        string2 = string2.replaceFirst("\\A<\\?xml (.*)encoding=(?:\"[^\"]*\"|'[^']*')", "<?xml $1encoding=\"UTF-8\"");
        closeable = new FileOutputStream(file);
        object = new OutputStreamWriter((OutputStream)closeable, charset);
        ((Writer)object).write(string2);
        ((OutputStreamWriter)object).close();
        return string2;
    }

    public static File fileFromURL(URL uRL) throws IllegalArgumentException {
        try {
            URI uRI = new URI(uRL.toExternalForm());
            return new File(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                URI uRI = new URI(uRL.getProtocol(), null, uRL.getPath(), null, null);
                return new File(uRI);
            }
            catch (URISyntaxException uRISyntaxException2) {
                throw new IllegalArgumentException("Cannot convert " + uRL + " to a file path");
            }
        }
    }

    public static File[] listFilesRecursively(File file, FileFilter fileFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray == null) {
            return null;
        }
        for (File file2 : fileArray) {
            arrayList.add(file2);
            if (!file2.isDirectory()) continue;
            File[] fileArray2 = Files.listFilesRecursively(file2, fileFilter);
            if (fileArray2 == null) {
                return null;
            }
            arrayList.addAll(Arrays.asList(fileArray2));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }
}

