/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPopupMenu;

public class MenuLayout
implements LayoutManager {
    private int[] columnForComponentIndex;
    private ArrayList<Integer> preferredWidthForColumn;

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = container.getComponentCount();
        Dimension[] dimensionArray = new Dimension[n];
        for (int i = 0; i < n; ++i) {
            dimensionArray[i] = container.getComponent(i).getPreferredSize();
        }
        return this.getCompositeSize(container, dimensionArray);
    }

    protected Dimension getCompositeSize(Container container, Dimension[] dimensionArray) {
        Object object;
        Point point = new Point(0, 0);
        if (container.isShowing()) {
            point = container.getLocationOnScreen();
        } else if (container instanceof JPopupMenu && (object = ((JPopupMenu)container).getInvoker()) != null) {
            point = ((Component)object).getLocationOnScreen();
        }
        object = Toolkit.getDefaultToolkit();
        Rectangle rectangle = new Rectangle(((Toolkit)object).getScreenSize());
        Insets insets = new Insets(0, 0, 0, 0);
        GraphicsConfiguration graphicsConfiguration = this.findGraphicsConfiguration(container);
        if (graphicsConfiguration != null) {
            rectangle = graphicsConfiguration.getBounds();
            insets = ((Toolkit)object).getScreenInsets(graphicsConfiguration);
        }
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        rectangle.height = Math.max(point.y, rectangle.height - point.y);
        Insets insets2 = container.getInsets();
        rectangle.width -= insets2.left + insets2.right;
        rectangle.height -= insets2.top + insets2.bottom;
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        this.columnForComponentIndex = new int[dimensionArray.length];
        this.preferredWidthForColumn = new ArrayList();
        for (int i = 0; i < dimensionArray.length; ++i) {
            if (dimension.height + dimensionArray[i].height <= rectangle.height) {
                dimension.height += dimensionArray[i].height;
                dimension.width = Math.max(dimension.width, dimensionArray[i].width);
                continue;
            }
            Arrays.fill(this.columnForComponentIndex, n4, i, n3);
            this.preferredWidthForColumn.add(dimension.width);
            n4 = i;
            ++n3;
            n += dimension.width;
            n2 = Math.max(n2, dimension.height);
            dimension.height = dimensionArray[i].height;
            dimension.width = dimensionArray[i].width;
        }
        Arrays.fill(this.columnForComponentIndex, n4, this.columnForComponentIndex.length, n3);
        this.preferredWidthForColumn.add(dimension.width);
        dimension.height = Math.max(n2, dimension.height);
        dimension.width += n;
        dimension.width += insets2.left + insets2.right;
        dimension.height += insets2.top + insets2.bottom;
        return dimension;
    }

    protected GraphicsConfiguration findGraphicsConfiguration(Component serializable) {
        Serializable serializable2;
        GraphicsConfiguration graphicsConfiguration = null;
        if (!serializable.isShowing() && serializable instanceof JPopupMenu && (serializable2 = ((JPopupMenu)serializable).getInvoker()) != null) {
            serializable = serializable2;
        }
        if (serializable.isShowing()) {
            serializable2 = serializable.getLocationOnScreen();
            graphicsConfiguration = serializable.getGraphicsConfiguration();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
                GraphicsConfiguration graphicsConfiguration2;
                if (graphicsDevice.getType() != 0 || !(graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration()).getBounds().contains((Point)serializable2)) continue;
                graphicsConfiguration = graphicsConfiguration2;
                break;
            }
        }
        return graphicsConfiguration;
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = container.getComponentCount();
        Dimension[] dimensionArray = new Dimension[n];
        for (int i = 0; i < n; ++i) {
            dimensionArray[i] = container.getComponent(i).getMinimumSize();
        }
        return this.getCompositeSize(container, dimensionArray);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Rectangle rectangle = container.getBounds();
        int n = rectangle.height - insets.bottom;
        int n2 = container.getComponentCount();
        int n3 = insets.top;
        int n4 = insets.left;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            component.setSize(dimension);
            if (n3 + dimension.height <= n) {
                component.setLocation(n4, n3);
                n3 += dimension.height;
                n5 = Math.max(n5, dimension.width);
                continue;
            }
            n4 += n5;
            n5 = 0;
            n3 = insets.top;
            component.setLocation(n4, n3);
            n3 += dimension.height;
            n5 = Math.max(n5, dimension.width);
        }
    }

    public int getColumnForComponentIndex(int n) {
        return this.columnForComponentIndex[n];
    }

    public int getPreferredWidthForColumn(int n) {
        return this.preferredWidthForColumn.get(n - 1);
    }
}

