/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.Corpus;
import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.corpora.SerialCorpusImpl;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.persist.GateAwareObjectInputStream;
import gate.persist.PersistenceException;
import gate.security.SecurityException;
import gate.security.SecurityInfo;
import gate.security.Session;
import gate.util.AbstractFeatureBearer;
import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SerialDataStore
extends AbstractFeatureBearer
implements DataStore {
    private static final boolean DEBUG = false;
    protected String name;
    protected File storageDir;
    protected static String versionFileName = "__GATE_SerialDataStore__";
    protected static String currentProtocolVersion = null;
    protected String versionNumber = "1.1";
    protected String[] protocolVersionNumbers = new String[]{"1.0", "1.1"};
    protected boolean autoSaving = false;
    protected static Random randomiser = new Random();
    private transient Vector datastoreListeners;

    public SerialDataStore(String string) throws PersistenceException {
        this.setStorageUrl(string);
    }

    public SerialDataStore() {
    }

    public void setStorageDir(File file) {
        this.storageDir = file;
    }

    public File getStorageDir() {
        return this.storageDir;
    }

    public void setStorageUrl(String string) throws PersistenceException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new PersistenceException("The URL passed is not correct: " + string);
        }
        if (!uRL.getProtocol().equalsIgnoreCase("file")) {
            throw new PersistenceException("A serial data store needs a file URL, not " + uRL);
        }
        try {
            this.storageDir = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.storageDir = Files.fileFromURL(uRL);
        }
    }

    public String getStorageUrl() {
        if (this.storageDir == null) {
            return null;
        }
        URL uRL = null;
        try {
            uRL = this.storageDir.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL.toString();
    }

    public void create() throws PersistenceException {
        Object object;
        if (this.storageDir == null) {
            throw new PersistenceException("null storage directory: cannot create");
        }
        if (!this.storageDir.exists()) {
            if (!this.storageDir.mkdir()) {
                throw new PersistenceException("cannot create directory " + this.storageDir);
            }
        } else {
            object = this.filterIgnoredFileNames(this.storageDir.list());
            if (object != null && ((String[])object).length != 0) {
                throw new PersistenceException("directory " + this.storageDir + " is not empty: cannot use for data store");
            }
        }
        try {
            object = this.getVersionFile();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream((File)object));
            outputStreamWriter.write(this.versionNumber + Strings.getNl());
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new PersistenceException("couldn't write version file: " + iOException);
        }
    }

    protected File getVersionFile() throws IOException {
        return new File(this.storageDir, versionFileName);
    }

    protected boolean isValidProtocolVersion(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < this.protocolVersionNumbers.length; ++i) {
            if (!this.protocolVersionNumbers[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void delete() throws PersistenceException {
        if (this.storageDir == null || !Files.rmdir(this.storageDir)) {
            throw new PersistenceException("couldn't delete " + this.storageDir);
        }
        Gate.getDataStoreRegister().remove(this);
    }

    public void delete(String string, Object object) throws PersistenceException {
        File file = new File(this.storageDir, string);
        if (!file.exists() || !file.isDirectory()) {
            throw new PersistenceException("Can't find " + file);
        }
        File file2 = new File(file, (String)object);
        if (!file2.exists() || !file2.isFile()) {
            throw new PersistenceException("Can't find file " + file2);
        }
        if (!file2.delete()) {
            throw new PersistenceException("Can't delete file " + file2);
        }
        if (this.filterIgnoredFileNames(file.list()).length == 0 && !file.delete()) {
            throw new PersistenceException("Can't delete " + file);
        }
        this.fireResourceDeleted(new DatastoreEvent(this, 302, null, (String)object));
    }

    public LanguageResource adopt(LanguageResource languageResource, SecurityInfo securityInfo) throws PersistenceException, SecurityException {
        DataStore dataStore = languageResource.getDataStore();
        if (dataStore == null) {
            LanguageResource languageResource2 = languageResource;
            if (languageResource instanceof Corpus) {
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("transientSource", languageResource);
                try {
                    languageResource2 = (LanguageResource)Factory.createResource("gate.corpora.SerialCorpusImpl", featureMap);
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    throw new GateRuntimeException(resourceInstantiationException.getMessage());
                }
            }
            languageResource2.setDataStore(this);
            this.fireResourceAdopted(new DatastoreEvent(this, 301, languageResource, null));
            return languageResource2;
        }
        if (dataStore.equals(this)) {
            return languageResource;
        }
        throw new PersistenceException("Can't adopt a resource which is already in a different datastore");
    }

    public void open() throws PersistenceException {
        if (this.storageDir == null) {
            throw new PersistenceException("Can't open: storage dir is null");
        }
        if (!this.storageDir.canRead()) {
            throw new PersistenceException("Can't read " + this.storageDir);
        }
        try {
            FileReader fileReader = new FileReader(this.getVersionFile());
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            currentProtocolVersion = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PersistenceException("Invalid storage directory: " + iOException);
        }
        if (!this.isValidProtocolVersion(currentProtocolVersion)) {
            throw new PersistenceException("Invalid protocol version number: " + currentProtocolVersion);
        }
    }

    public void close() throws PersistenceException {
        Gate.getDataStoreRegister().remove(this);
    }

    public void sync(LanguageResource languageResource) throws PersistenceException {
        Object object;
        Serializable serializable;
        if (languageResource.getDataStore() == null || !languageResource.getDataStore().equals(this)) {
            throw new PersistenceException("LR " + languageResource.getName() + " has not been adopted by this DataStore");
        }
        ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(languageResource.getClass().getName());
        File file = new File(this.storageDir, resourceData.getClassName());
        if (!(file.exists() && file.isDirectory() || file.mkdir() || file.exists())) {
            throw new PersistenceException("Can't write " + file);
        }
        String string = null;
        Object object2 = null;
        string = languageResource.getName();
        object2 = languageResource.getLRPersistenceId();
        if (string == null) {
            string = resourceData.getName();
        }
        if (object2 == null) {
            object2 = this.constructPersistenceId(string);
            languageResource.setLRPersistenceId(object2);
        }
        if (languageResource instanceof Corpus) {
            if (!(languageResource instanceof SerialCorpusImpl)) {
                throw new PersistenceException("Can't save a corpus which is not of type SerialCorpusImpl!");
            }
            serializable = (SerialCorpusImpl)languageResource;
            for (int i = 0; i < ((SerialCorpusImpl)serializable).size(); ++i) {
                if (!((SerialCorpusImpl)serializable).isDocumentLoaded(i) && ((SerialCorpusImpl)serializable).isPersistentDocument(i)) continue;
                object = (Document)((SerialCorpusImpl)serializable).get(i);
                try {
                    if (object.getLRPersistenceId() == null) {
                        object = (Document)this.adopt((LanguageResource)object, null);
                        this.sync((LanguageResource)object);
                        ((SerialCorpusImpl)serializable).setDocumentPersistentID(i, object.getLRPersistenceId());
                    } else {
                        this.sync((LanguageResource)object);
                    }
                    ((SerialCorpusImpl)serializable).setDocumentPersistentID(i, object.getLRPersistenceId());
                    continue;
                }
                catch (Exception exception) {
                    throw new PersistenceException("Error while saving corpus: " + serializable + "because of an error storing document " + exception.getMessage(), exception);
                }
            }
        }
        serializable = new File(file, (String)object2);
        try {
            OutputStream outputStream = new FileOutputStream((File)serializable);
            if (!currentProtocolVersion.equals("1.0")) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            outputStream = new BufferedOutputStream(outputStream);
            object = new ObjectOutputStream(outputStream);
            ((ObjectOutputStream)object).writeObject(languageResource);
            ((ObjectOutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new PersistenceException("Couldn't write to storage file: " + iOException);
        }
        this.fireResourceWritten(new DatastoreEvent(this, 303, languageResource, (String)object2));
    }

    protected String constructPersistenceId(String string) {
        string = string.replaceAll("[\\/:\\*\\?\"<>|]", "_");
        return string + "___" + new Date().getTime() + "___" + SerialDataStore.random();
    }

    public LanguageResource getLr(String string, Object object) throws PersistenceException, SecurityException {
        File file = new File(this.storageDir, string);
        if (!file.exists() || !file.isDirectory()) {
            throw new PersistenceException("Can't find " + file);
        }
        File file2 = new File(file, (String)object);
        if (!file2.exists() || !file2.isFile()) {
            throw new PersistenceException("Can't find file " + file2);
        }
        LanguageResource languageResource = null;
        try {
            InputStream inputStream = new FileInputStream(file2);
            if (!currentProtocolVersion.equals("1.0")) {
                inputStream = new GZIPInputStream(inputStream);
            }
            inputStream = new BufferedInputStream(inputStream);
            GateAwareObjectInputStream gateAwareObjectInputStream = new GateAwareObjectInputStream(inputStream);
            languageResource = (LanguageResource)gateAwareObjectInputStream.readObject();
            gateAwareObjectInputStream.close();
        }
        catch (IOException iOException) {
            throw new PersistenceException("Couldn't read file " + file2 + ": " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PersistenceException("Couldn't find class " + string + ": " + classNotFoundException);
        }
        languageResource.setDataStore(this);
        languageResource.setLRPersistenceId(object);
        return languageResource;
    }

    public List getLrTypes() throws PersistenceException {
        if (this.storageDir == null || !this.storageDir.exists()) {
            throw new PersistenceException("Can't read storage directory");
        }
        String[] stringArray = this.filterIgnoredFileNames(this.storageDir.list());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(versionFileName)) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public List getLrIds(String string) throws PersistenceException {
        File file = new File(this.storageDir, string);
        if (!file.exists()) {
            return Arrays.asList(new String[0]);
        }
        return Arrays.asList(this.filterIgnoredFileNames(file.list()));
    }

    public List getLrNames(String string) throws PersistenceException {
        String[] stringArray = (String[])this.getLrIds(string).toArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = this.getLrName(stringArray[i]);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public String getLrName(Object object) {
        int n = ((String)object).lastIndexOf("___");
        object = ((String)object).substring(0, n);
        int n2 = ((String)object).lastIndexOf("___");
        return ((String)object).substring(0, n2);
    }

    public void setAutoSaving(boolean bl) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("SerialDataStore has no auto-save capability");
    }

    public boolean isAutoSaving() {
        return this.autoSaving;
    }

    protected static int random() {
        return randomiser.nextInt(9999);
    }

    public String toString() {
        String string = Strings.getNl();
        StringBuffer stringBuffer = new StringBuffer("SerialDataStore: ");
        stringBuffer.append("autoSaving: " + this.autoSaving);
        stringBuffer.append("; storageDir: " + this.storageDir);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.storageDir.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SerialDataStore)) {
            return false;
        }
        if (!((SerialDataStore)object).storageDir.equals(this.storageDir)) {
            return false;
        }
        if (((SerialDataStore)object).name == this.name) {
            return true;
        }
        return ((SerialDataStore)object).name.equals(this.name);
    }

    public synchronized void removeDatastoreListener(DatastoreListener datastoreListener) {
        if (this.datastoreListeners != null && this.datastoreListeners.contains(datastoreListener)) {
            Vector vector = (Vector)this.datastoreListeners.clone();
            vector.removeElement(datastoreListener);
            this.datastoreListeners = vector;
        }
    }

    public synchronized void addDatastoreListener(DatastoreListener datastoreListener) {
        Vector vector;
        Vector vector2 = vector = this.datastoreListeners == null ? new Vector(2) : (Vector)this.datastoreListeners.clone();
        if (!vector.contains(datastoreListener)) {
            vector.addElement(datastoreListener);
            this.datastoreListeners = vector;
        }
    }

    protected void fireResourceAdopted(DatastoreEvent datastoreEvent) {
        if (this.datastoreListeners != null) {
            Vector vector = this.datastoreListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((DatastoreListener)vector.elementAt(i)).resourceAdopted(datastoreEvent);
            }
        }
    }

    protected void fireResourceDeleted(DatastoreEvent datastoreEvent) {
        if (this.datastoreListeners != null) {
            Vector vector = this.datastoreListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((DatastoreListener)vector.elementAt(i)).resourceDeleted(datastoreEvent);
            }
        }
    }

    protected void fireResourceWritten(DatastoreEvent datastoreEvent) {
        if (this.datastoreListeners != null) {
            Vector vector = this.datastoreListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((DatastoreListener)vector.elementAt(i)).resourceWritten(datastoreEvent);
            }
        }
    }

    public String getIconName() {
        return "datastore";
    }

    public String getComment() {
        return "GATE serial datastore";
    }

    public boolean canReadLR(Object object) throws PersistenceException, SecurityException {
        return true;
    }

    public boolean canWriteLR(Object object) throws PersistenceException, SecurityException {
        return true;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public SecurityInfo getSecurityInfo(LanguageResource languageResource) throws PersistenceException {
        throw new UnsupportedOperationException("security information is not supported for DatabaseDataStore");
    }

    public void setSecurityInfo(LanguageResource languageResource, SecurityInfo securityInfo) throws PersistenceException, SecurityException {
        throw new UnsupportedOperationException("security information is not supported for DatabaseDataStore");
    }

    public void setSession(Session session) throws SecurityException {
    }

    public Session getSession(Session session) throws SecurityException {
        return null;
    }

    public boolean lockLr(LanguageResource languageResource) throws PersistenceException, SecurityException {
        return true;
    }

    public void unlockLr(LanguageResource languageResource) throws PersistenceException, SecurityException {
    }

    public List findLrIds(List list) throws PersistenceException {
        throw new UnsupportedOperationException("Serial DataStore does not support document retrieval.");
    }

    public List findLrIds(List list, String string) throws PersistenceException {
        throw new UnsupportedOperationException("Serial DataStore does not support document retrieval.");
    }

    protected String[] filterIgnoredFileNames(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        Vector<String> vector = new Vector<String>(stringArray.length);
        for (String string : stringArray) {
            if (string.startsWith(".")) continue;
            vector.add(string);
        }
        return vector.toArray(new String[0]);
    }
}

