/*
 * Decompiled with CFR 0.152.
 */
package gate.jape.parser;

import gate.Factory;
import gate.event.StatusListener;
import gate.jape.BasicPatternElement;
import gate.jape.ComplexPatternElement;
import gate.jape.Constraint;
import gate.jape.ConstraintGroup;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.KleeneOperator;
import gate.jape.LeftHandSide;
import gate.jape.MultiPhaseTransducer;
import gate.jape.PatternElement;
import gate.jape.RightHandSide;
import gate.jape.Rule;
import gate.jape.SinglePhaseTransducer;
import gate.jape.Transducer;
import gate.jape.constraint.AnnotationAccessor;
import gate.jape.constraint.SimpleAnnotationAccessor;
import gate.jape.parser.ParseCpslConstants;
import gate.jape.parser.ParseCpslTokenManager;
import gate.jape.parser.ParseException;
import gate.jape.parser.SimpleCharStream;
import gate.jape.parser.Token;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Pair;
import gate.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseCpsl
implements JapeConstants,
ParseCpslConstants {
    private static final Logger log = Logger.getLogger(ParseCpsl.class);
    private transient List myStatusListeners = new LinkedList();
    private int ruleNumber;
    private HashSet bindingNameSet = null;
    protected HashMap macrosMap;
    protected HashMap templatesMap;
    protected URL baseURL;
    protected String encoding;
    protected SinglePhaseTransducer curSPT;
    public ParseCpslTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[41];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public ParseCpsl(URL uRL, String string) throws IOException {
        this(uRL, string, new HashMap());
    }

    public ParseCpsl(URL uRL, String string, HashMap hashMap) throws IOException {
        this(uRL, string, hashMap, new HashMap());
    }

    public ParseCpsl(URL uRL, String string, HashMap hashMap, HashMap hashMap2) throws IOException {
        this(new BomStrippingInputStreamReader(uRL.openStream(), string), hashMap, hashMap2);
        this.baseURL = uRL;
        this.encoding = string;
    }

    public ParseCpsl(Reader reader, HashMap hashMap) {
        this(reader, hashMap, new HashMap());
    }

    public ParseCpsl(Reader reader, HashMap hashMap, HashMap hashMap2) {
        this(reader);
        this.macrosMap = hashMap;
        this.templatesMap = hashMap2;
    }

    public void addStatusListener(StatusListener statusListener) {
        this.myStatusListeners.add(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.myStatusListeners.remove(statusListener);
    }

    protected void fireStatusChangedEvent(String string) {
        Iterator iterator = this.myStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((StatusListener)iterator.next()).statusChanged(string);
        }
    }

    protected SinglePhaseTransducer createSinglePhaseTransducer(String string) {
        return new SinglePhaseTransducer(string);
    }

    protected ParseCpsl spawn(URL uRL) throws IOException {
        return new ParseCpsl(uRL, this.encoding, this.macrosMap, this.templatesMap);
    }

    protected void finishSPT(SinglePhaseTransducer singlePhaseTransducer) throws ParseException {
        if (this.ruleNumber == 0) {
            throw new ParseException("no rules defined in transducer " + singlePhaseTransducer.getName());
        }
        singlePhaseTransducer.setBaseURL(this.baseURL);
    }

    protected void finishBPE(BasicPatternElement basicPatternElement) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiPhaseTransducer MultiPhaseTransducer() throws ParseException {
        try {
            MultiPhaseTransducer multiPhaseTransducer = this._MultiPhaseTransducer();
            return multiPhaseTransducer;
        }
        finally {
            if (this.jj_input_stream.inputStream != null) {
                try {
                    this.jj_input_stream.inputStream.close();
                }
                catch (IOException iOException) {
                    log.warn((Object)("Couldn't close input stream while parsing " + this.baseURL), (Throwable)iOException);
                }
            }
        }
    }

    protected void appendJavaStringLiteral(StringBuffer stringBuffer, String string) {
        if (string == null) {
            stringBuffer.append("null");
        } else {
            Formatter formatter = null;
            stringBuffer.append("\"");
            block10: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\b': {
                        stringBuffer.append("\\b");
                        continue block10;
                    }
                    case '\f': {
                        stringBuffer.append("\\f");
                        continue block10;
                    }
                    case '\n': {
                        stringBuffer.append("\\n");
                        continue block10;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        continue block10;
                    }
                    case '\t': {
                        stringBuffer.append("\\t");
                        continue block10;
                    }
                    case '\"': {
                        stringBuffer.append("\\\"");
                        continue block10;
                    }
                    case '\'': {
                        stringBuffer.append("\\'");
                        continue block10;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        continue block10;
                    }
                    default: {
                        if (c < ' ' || c > '\u007f') {
                            if (formatter == null) {
                                formatter = new Formatter(stringBuffer);
                            }
                            formatter.format("\\u%04X", c);
                            continue block10;
                        }
                        stringBuffer.append(c);
                    }
                }
            }
            stringBuffer.append("\"");
        }
    }

    protected void appendAnnotationAdd(StringBuffer stringBuffer, String string, String string2) {
        String string3 = Strings.getNl();
        stringBuffer.append("      if(outputAS == inputAS) { // use nodes directly" + string3);
        stringBuffer.append("        outputAS.add(" + string3);
        stringBuffer.append("          " + string2 + ".firstNode(), ");
        stringBuffer.append(string2 + ".lastNode(), " + string3);
        stringBuffer.append("          ");
        this.appendJavaStringLiteral(stringBuffer, string);
        stringBuffer.append(", features" + string3);
        stringBuffer.append("        );" + string3);
        stringBuffer.append("      }" + string3);
        stringBuffer.append("      else { // use offsets" + string3);
        stringBuffer.append("        try {" + string3);
        stringBuffer.append("          outputAS.add(" + string3);
        stringBuffer.append("            " + string2 + ".firstNode().getOffset(), ");
        stringBuffer.append(string2 + ".lastNode().getOffset(), " + string3);
        stringBuffer.append("            ");
        this.appendJavaStringLiteral(stringBuffer, string);
        stringBuffer.append(", features" + string3);
        stringBuffer.append("          );" + string3);
        stringBuffer.append("        }" + string3);
        stringBuffer.append("        catch(gate.util.InvalidOffsetException ioe) {" + string3);
        stringBuffer.append("          throw new LuckyException(\"Invalid offset exception generated \" +" + string3);
        stringBuffer.append("               \"from offsets taken from same document!\");" + string3);
        stringBuffer.append("        }" + string3);
        stringBuffer.append("      }" + string3);
        stringBuffer.append("      // end of RHS assignment block");
    }

    protected Pair substituteTemplate(Token token, Map<String, Object> map) throws ParseException {
        Pair pair = (Pair)this.templatesMap.get(token.image);
        if (pair == null) {
            throw new ParseException(this.errorMsgPrefix(token) + "unknown template name " + token.image);
        }
        Pair pair2 = null;
        HashSet<String> hashSet = new HashSet<String>(map.keySet());
        if ((Integer)pair.first == 44) {
            log.debug((Object)("Substituting template " + token.image + " with map " + map + ". Template is " + pair));
            StringBuffer stringBuffer = new StringBuffer();
            Matcher matcher = Pattern.compile("\\$\\{([^\\}]+)\\}").matcher((String)pair.second);
            while (matcher.find()) {
                String string = matcher.group(1);
                if (map.containsKey(string)) {
                    matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(String.valueOf(map.get(string))));
                    hashSet.remove(string);
                    continue;
                }
                matcher.appendReplacement(stringBuffer, "\\${");
                stringBuffer.append(string);
                stringBuffer.append("}");
            }
            matcher.appendTail(stringBuffer);
            pair2 = new Pair();
            pair2.first = 44;
            pair2.second = stringBuffer.toString();
            log.debug((Object)("Template substitution produced " + pair2.second));
        } else {
            pair2 = pair;
        }
        if (!hashSet.isEmpty()) {
            throw new ParseException(this.errorMsgPrefix(token) + "invalid parameters " + hashSet + " for template " + token.image);
        }
        return pair2;
    }

    public void setBaseURL(URL uRL) {
        this.baseURL = uRL;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    private String errorMsgPrefix(Token token) {
        return (this.baseURL != null ? this.baseURL.toExternalForm() : "(No URL)") + (token == null ? " " : ":" + token.beginLine + ":" + token.beginColumn + ": ");
    }

    public final MultiPhaseTransducer _MultiPhaseTransducer() throws ParseException {
        SinglePhaseTransducer singlePhaseTransducer = null;
        MultiPhaseTransducer multiPhaseTransducer = new MultiPhaseTransducer();
        multiPhaseTransducer.setBaseURL(this.baseURL);
        Token token = null;
        Token token2 = null;
        String string = null;
        switch (this.jj_nt.kind) {
            case 11: {
                this.jj_consume_token(11);
                token = this.jj_consume_token(46);
                multiPhaseTransducer.setName(token.image);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 20: 
            case 21: {
                string = this.JavaImportBlock();
                block19: while (true) {
                    try {
                        singlePhaseTransducer = this.SinglePhaseTransducer(string);
                        multiPhaseTransducer.addPhase(singlePhaseTransducer.getName(), singlePhaseTransducer);
                        singlePhaseTransducer.setBaseURL(this.baseURL);
                    }
                    catch (Throwable throwable) {
                        throw new ParseException("Cannot parse a phase in " + this.baseURL + ": " + throwable.getMessage());
                    }
                    switch (this.jj_nt.kind) {
                        case 21: {
                            continue block19;
                        }
                    }
                    break;
                }
                this.jj_la1[1] = this.jj_gen;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                block20: while (true) {
                    ArrayList arrayList;
                    token2 = this.jj_consume_token(13);
                    ParseCpsl parseCpsl = null;
                    String string2 = token2.image + ".jape";
                    URL uRL = null;
                    try {
                        uRL = new URL(this.baseURL, string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new ParseException(this.errorMsgPrefix(token2) + "Read error " + malformedURLException.toString());
                    }
                    if (uRL == null) {
                        throw new ParseException(this.errorMsgPrefix(token2) + "Resource not found: base = " + this.baseURL.toString() + " path = " + string2);
                    }
                    this.fireStatusChangedEvent("Reading " + token2.image + "...");
                    try {
                        parseCpsl = this.spawn(uRL);
                    }
                    catch (IOException iOException) {
                        throw new ParseException(this.errorMsgPrefix(token2) + "Cannot open URL " + uRL.toExternalForm());
                    }
                    if (parseCpsl != null && (arrayList = parseCpsl.MultiPhaseTransducer().getPhases()) != null) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            multiPhaseTransducer.addPhase(((Transducer)arrayList.get(i)).getName(), (Transducer)arrayList.get(i));
                        }
                    }
                    switch (this.jj_nt.kind) {
                        case 13: {
                            continue block20;
                        }
                    }
                    break;
                }
                this.jj_la1[2] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(0);
        return multiPhaseTransducer;
    }

    public final SinglePhaseTransducer SinglePhaseTransducer(String string) throws ParseException {
        SinglePhaseTransducer singlePhaseTransducer;
        block39: {
            Rule rule;
            Token token;
            block38: {
                this.ruleNumber = 0;
                token = null;
                Token token2 = null;
                singlePhaseTransducer = null;
                rule = null;
                this.bindingNameSet = new HashSet();
                Token token3 = null;
                Token token4 = null;
                this.jj_consume_token(21);
                token = this.jj_consume_token(46);
                this.curSPT = singlePhaseTransducer = this.createSinglePhaseTransducer(token.image);
                block25: while (true) {
                    switch (this.jj_nt.kind) {
                        case 22: 
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            break block38;
                        }
                    }
                    switch (this.jj_nt.kind) {
                        case 22: {
                            this.jj_consume_token(22);
                            while (true) {
                                switch (this.jj_nt.kind) {
                                    case 46: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[5] = this.jj_gen;
                                        continue block25;
                                    }
                                }
                                token2 = this.jj_consume_token(46);
                                singlePhaseTransducer.addInput(token2.image);
                            }
                        }
                        case 23: {
                            this.jj_consume_token(23);
                            while (true) {
                                switch (this.jj_nt.kind) {
                                    case 46: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[6] = this.jj_gen;
                                        continue block25;
                                    }
                                }
                                token3 = this.jj_consume_token(46);
                                this.jj_consume_token(60);
                                switch (this.jj_nt.kind) {
                                    case 46: {
                                        token4 = this.jj_consume_token(46);
                                        break;
                                    }
                                    case 45: {
                                        token4 = this.jj_consume_token(45);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[7] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                singlePhaseTransducer.setOption(token3.image, token4.image);
                                if (token3.image.equalsIgnoreCase("control")) {
                                    if (token4.image.equalsIgnoreCase("appelt")) {
                                        singlePhaseTransducer.setRuleApplicationStyle(2);
                                        continue;
                                    }
                                    if (token4.image.equalsIgnoreCase("first")) {
                                        singlePhaseTransducer.setRuleApplicationStyle(3);
                                        continue;
                                    }
                                    if (token4.image.equalsIgnoreCase("brill")) {
                                        singlePhaseTransducer.setRuleApplicationStyle(1);
                                        continue;
                                    }
                                    if (token4.image.equalsIgnoreCase("once")) {
                                        singlePhaseTransducer.setRuleApplicationStyle(4);
                                        continue;
                                    }
                                    if (token4.image.equalsIgnoreCase("all")) {
                                        singlePhaseTransducer.setRuleApplicationStyle(5);
                                        continue;
                                    }
                                    System.err.println(this.errorMsgPrefix(token4) + "ignoring unknown control strategy " + 23 + " (should be brill, appelt, first, once or all)");
                                    continue;
                                }
                                if (token3.image.equalsIgnoreCase("debug")) {
                                    if (token4.image.equalsIgnoreCase("true") || token4.image.equalsIgnoreCase("yes") || token4.image.equalsIgnoreCase("y")) {
                                        singlePhaseTransducer.setDebugMode(true);
                                        continue;
                                    }
                                    singlePhaseTransducer.setDebugMode(false);
                                    continue;
                                }
                                if (!token3.image.equalsIgnoreCase("matchGroup")) continue;
                                if (token4.image.equalsIgnoreCase("true") || token4.image.equalsIgnoreCase("yes") || token4.image.equalsIgnoreCase("y")) {
                                    singlePhaseTransducer.setMatchGroupMode(true);
                                    continue;
                                }
                                singlePhaseTransducer.setMatchGroupMode(false);
                            }
                        }
                    }
                    break;
                }
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block28: while (true) {
                switch (this.jj_nt.kind) {
                    case 24: 
                    case 25: 
                    case 26: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        break block39;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 24: {
                        rule = this.Rule(token.image, string);
                        singlePhaseTransducer.addRule(rule);
                        continue block28;
                    }
                    case 25: {
                        this.MacroDef();
                        continue block28;
                    }
                    case 26: {
                        this.TemplateDef();
                        continue block28;
                    }
                }
                break;
            }
            this.jj_la1[10] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.finishSPT(singlePhaseTransducer);
        return singlePhaseTransducer;
    }

    public final String JavaImportBlock() throws ParseException {
        String string = "import java.io.*;\nimport java.util.*;\nimport gate.*;\nimport gate.jape.*;\nimport gate.creole.ontology.*;\nimport gate.annotation.*;\nimport gate.util.*;\n";
        String string2 = null;
        switch (this.jj_nt.kind) {
            case 20: {
                this.jj_consume_token(20);
                this.jj_consume_token(54);
                string2 = this.ConsumeBlock();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        if (string2 != null) {
            return string + string2;
        }
        return string;
    }

    public final Rule Rule(String string, String string2) throws ParseException {
        Token token = null;
        String string3 = null;
        Token token2 = null;
        int n = 0;
        LeftHandSide leftHandSide = null;
        RightHandSide rightHandSide = null;
        Rule rule = null;
        this.jj_consume_token(24);
        token = this.jj_consume_token(46);
        string3 = token.image;
        switch (this.jj_nt.kind) {
            case 27: {
                this.jj_consume_token(27);
                token2 = this.jj_consume_token(32);
                try {
                    n = Integer.parseInt(token2.image);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(this.errorMsgPrefix(token2) + "bad priority spec(" + token2.image + "), rule(" + string3 + ") - treating as 0");
                    n = 0;
                }
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        leftHandSide = this.LeftHandSide();
        this.jj_consume_token(69);
        rightHandSide = this.RightHandSide(string, string3, leftHandSide, string2);
        try {
            rightHandSide.createActionClass();
        }
        catch (JapeException japeException) {
            throw new ParseException(this.errorMsgPrefix(null) + "couldn't create rule RHS: " + japeException.toString());
        }
        rule = new Rule(string3, this.ruleNumber, n, leftHandSide, rightHandSide);
        if (this.curSPT.isInputRestricted()) {
            HashSet<String> hashSet = new HashSet<String>();
            leftHandSide.getConstraintGroup().getContainedAnnotationTypes(hashSet);
            for (String string4 : hashSet) {
                if (this.curSPT.hasInput(string4)) continue;
                System.err.println(this.errorMsgPrefix(null) + "Rule " + string3 + " contains unlisted annotation type " + string4);
            }
        }
        ++this.ruleNumber;
        return rule;
    }

    public final void MacroDef() throws ParseException {
        Token token = null;
        String[] stringArray = null;
        this.jj_consume_token(25);
        token = this.jj_consume_token(46);
        if (this.jj_2_1(2)) {
            stringArray = this.PatternElement(null);
        } else {
            switch (this.jj_nt.kind) {
                case 46: 
                case 49: 
                case 54: 
                case 61: {
                    stringArray = this.Action();
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.macrosMap.put(token.image, stringArray);
    }

    public final void TemplateDef() throws ParseException {
        Token token = null;
        Pair pair = null;
        this.jj_consume_token(26);
        token = this.jj_consume_token(46);
        this.jj_consume_token(60);
        pair = this.AttrVal();
        this.templatesMap.put(token.image, pair);
    }

    public final LeftHandSide LeftHandSide() throws ParseException {
        ConstraintGroup constraintGroup = new ConstraintGroup();
        LeftHandSide leftHandSide = new LeftHandSide(constraintGroup);
        this.ConstraintGroup(leftHandSide, constraintGroup);
        return leftHandSide;
    }

    public final void ConstraintGroup(LeftHandSide leftHandSide, ConstraintGroup constraintGroup) throws ParseException {
        PatternElement patternElement = null;
        block9: while (true) {
            patternElement = this.PatternElement(leftHandSide);
            constraintGroup.addPatternElement(patternElement);
            switch (this.jj_nt.kind) {
                case 44: 
                case 46: 
                case 54: 
                case 56: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[14] = this.jj_gen;
        block10: while (true) {
            switch (this.jj_nt.kind) {
                case 52: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(52);
            constraintGroup.createDisjunction();
            block11: while (true) {
                patternElement = this.PatternElement(leftHandSide);
                constraintGroup.addPatternElement(patternElement);
                switch (this.jj_nt.kind) {
                    case 44: 
                    case 46: 
                    case 54: 
                    case 56: {
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[16] = this.jj_gen;
        }
    }

    public final PatternElement PatternElement(LeftHandSide leftHandSide) throws ParseException {
        String string;
        PatternElement patternElement = null;
        Token token = null;
        boolean bl = false;
        switch (this.jj_nt.kind) {
            case 46: {
                token = this.jj_consume_token(46);
                bl = true;
                string = this.macrosMap.get(token.image);
                if (string == null) {
                    throw new ParseException(this.errorMsgPrefix(token) + "unknown macro name " + token.image);
                }
                if (string instanceof String[]) {
                    throw new ParseException(this.errorMsgPrefix(token) + "macro " + token.image + " references an Action, not a PatternElement");
                }
                if (!(string instanceof PatternElement)) {
                    throw new ParseException(this.errorMsgPrefix(token) + "macro " + token.image + " doesn't reference a PatternElement!");
                }
                patternElement = (PatternElement)((PatternElement)((Object)string)).clone();
                break;
            }
            case 44: 
            case 54: {
                patternElement = this.BasicPatternElement();
                break;
            }
            case 56: {
                patternElement = this.ComplexPatternElement(leftHandSide);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (patternElement instanceof ComplexPatternElement && (string = ((ComplexPatternElement)patternElement).getBindingName()) != null && leftHandSide != null) {
            try {
                leftHandSide.addBinding(string, (ComplexPatternElement)patternElement, this.bindingNameSet, bl);
            }
            catch (JapeException japeException) {
                System.err.println(this.errorMsgPrefix(null) + "duplicate binding name " + string + " - ignoring this binding! exception was: " + japeException.toString());
            }
        }
        return patternElement;
    }

    public final BasicPatternElement BasicPatternElement() throws ParseException {
        Token token = null;
        Constraint constraint = null;
        BasicPatternElement basicPatternElement = new BasicPatternElement();
        switch (this.jj_nt.kind) {
            case 54: {
                this.jj_consume_token(54);
                constraint = this.Constraint();
                basicPatternElement.addConstraint(constraint);
                block7: while (true) {
                    switch (this.jj_nt.kind) {
                        case 53: {
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(53);
                    constraint = this.Constraint();
                    basicPatternElement.addConstraint(constraint);
                }
                this.jj_consume_token(55);
                break;
            }
            case 44: {
                token = this.jj_consume_token(44);
                System.err.println(this.errorMsgPrefix(token) + "string shorthand not supported yet, ignoring: " + token.image);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.finishBPE(basicPatternElement);
        return basicPatternElement;
    }

    public final ComplexPatternElement ComplexPatternElement(LeftHandSide leftHandSide) throws ParseException {
        KleeneOperator kleeneOperator = null;
        Token token = null;
        ConstraintGroup constraintGroup = new ConstraintGroup();
        this.jj_consume_token(56);
        this.ConstraintGroup(leftHandSide, constraintGroup);
        this.jj_consume_token(57);
        switch (this.jj_nt.kind) {
            case 29: 
            case 58: {
                kleeneOperator = this.KleeneOperator();
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        block3 : switch (this.jj_nt.kind) {
            case 49: {
                this.jj_consume_token(49);
                switch (this.jj_nt.kind) {
                    case 46: {
                        token = this.jj_consume_token(46);
                        break block3;
                    }
                    case 32: {
                        token = this.jj_consume_token(32);
                        break block3;
                    }
                }
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        String string = null;
        if (token != null) {
            string = token.image;
        }
        return new ComplexPatternElement(constraintGroup, kleeneOperator, string);
    }

    public final KleeneOperator KleeneOperator() throws ParseException {
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Integer n = null;
        Integer n2 = null;
        switch (this.jj_nt.kind) {
            case 29: {
                token = this.jj_consume_token(29);
                if (token == null) {
                    return new KleeneOperator(KleeneOperator.Type.SINGLE);
                }
                KleeneOperator.Type type = KleeneOperator.Type.getFromSymbol(token.image);
                if (type != null) {
                    return new KleeneOperator(type);
                }
                System.err.println(this.errorMsgPrefix(token) + "ignoring uninterpretable Kleene op " + token.image);
                return new KleeneOperator(KleeneOperator.Type.SINGLE);
            }
            case 58: {
                this.jj_consume_token(58);
                token2 = this.jj_consume_token(32);
                switch (this.jj_nt.kind) {
                    case 53: {
                        this.jj_consume_token(53);
                        token3 = this.jj_consume_token(32);
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                    }
                }
                this.jj_consume_token(59);
                if (token2 != null) {
                    n = new Integer(token2.image);
                }
                if (token3 != null) {
                    n2 = new Integer(token3.image);
                }
                return new KleeneOperator(n, n2);
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Constraint Constraint() throws ParseException {
        Token token = null;
        Token token2 = null;
        AnnotationAccessor annotationAccessor = null;
        Token token3 = null;
        Object var5_5 = null;
        Pair pair = null;
        boolean bl = false;
        Constraint constraint = null;
        Constraint constraint2 = null;
        String string = null;
        switch (this.jj_nt.kind) {
            case 28: {
                this.jj_consume_token(28);
                bl = true;
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        token = this.jj_consume_token(46);
        constraint = Factory.getConstraintFactory().createConstraint(token.image);
        if (bl) {
            constraint.negate();
        }
        block3 : switch (this.jj_nt.kind) {
            case 31: 
            case 46: 
            case 51: {
                switch (this.jj_nt.kind) {
                    case 51: {
                        annotationAccessor = this.FeatureAccessor();
                        token3 = this.jj_consume_token(30);
                        pair = this.AttrVal();
                        string = token3.image;
                        constraint.addAttribute(Factory.getConstraintFactory().createPredicate(string, annotationAccessor, pair.second));
                        break block3;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        token2 = this.jj_consume_token(46);
                        token3 = this.jj_consume_token(30);
                        pair = this.AttrVal();
                        annotationAccessor = Factory.getConstraintFactory().createMetaPropertyAccessor(token2.image);
                        string = token3.image;
                        constraint.addAttribute(Factory.getConstraintFactory().createPredicate(string, annotationAccessor, pair.second));
                        break block3;
                    }
                    case 46: {
                        token3 = this.jj_consume_token(46);
                        switch (this.jj_nt.kind) {
                            case 54: {
                                this.jj_consume_token(54);
                                constraint2 = this.Constraint();
                                this.jj_consume_token(55);
                                break;
                            }
                            case 28: 
                            case 46: {
                                constraint2 = this.Constraint();
                                break;
                            }
                            default: {
                                this.jj_la1[26] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        string = token3.image;
                        annotationAccessor = new SimpleAnnotationAccessor();
                        constraint.addAttribute(Factory.getConstraintFactory().createPredicate(string, annotationAccessor, constraint2));
                        break block3;
                    }
                }
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        return constraint;
    }

    public final AnnotationAccessor FeatureAccessor() throws ParseException {
        Token token = null;
        AnnotationAccessor annotationAccessor = null;
        this.jj_consume_token(51);
        token = this.jj_consume_token(46);
        annotationAccessor = Factory.getConstraintFactory().createDefaultAccessor(token.image);
        return annotationAccessor;
    }

    public final Pair AttrVal() throws ParseException {
        Token token = null;
        Object var2_2 = null;
        Pair pair = new Pair();
        switch (this.jj_nt.kind) {
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                switch (this.jj_nt.kind) {
                    case 44: {
                        token = this.jj_consume_token(44);
                        break;
                    }
                    case 46: {
                        token = this.jj_consume_token(46);
                        break;
                    }
                    case 32: {
                        token = this.jj_consume_token(32);
                        break;
                    }
                    case 47: {
                        token = this.jj_consume_token(47);
                        break;
                    }
                    case 45: {
                        token = this.jj_consume_token(45);
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                pair.first = new Integer(token.kind);
                switch (token.kind) {
                    case 44: {
                        pair.second = token.image.substring(1, token.image.length() - 1);
                        break;
                    }
                    case 32: {
                        try {
                            pair.second = Long.valueOf(token.image);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println(this.errorMsgPrefix(token) + "couldn't parse integer " + token.image + " - treating as 0");
                            pair.second = new Long(0L);
                        }
                        break;
                    }
                    case 46: {
                        pair.second = new String(token.image);
                        break;
                    }
                    case 45: {
                        pair.second = Boolean.valueOf(token.image);
                        break;
                    }
                    case 47: {
                        try {
                            pair.second = Double.valueOf(token.image);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println(this.errorMsgPrefix(token) + "couldn't parse float " + token.image + " - treating as 0.0");
                            pair.second = new Double(0.0);
                        }
                        break;
                    }
                    default: {
                        System.err.println(this.errorMsgPrefix(token) + "didn't understand type of " + token.image + ": ignoring");
                        pair.second = new String("");
                    }
                }
                return pair;
            }
            case 58: {
                pair = this.TemplateCall();
                return pair;
            }
        }
        this.jj_la1[30] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Pair TemplateCall() throws ParseException {
        Token token = null;
        Token token2 = null;
        Pair pair = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.jj_consume_token(58);
        token = this.jj_consume_token(46);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block6;
                }
            }
            token2 = this.jj_consume_token(46);
            this.jj_consume_token(60);
            pair = this.AttrVal();
            hashMap.put(token2.image, pair.second);
            switch (this.jj_nt.kind) {
                case 53: {
                    this.jj_consume_token(53);
                    continue block6;
                }
            }
            this.jj_la1[32] = this.jj_gen;
        }
        this.jj_consume_token(59);
        return this.substituteTemplate(token, hashMap);
    }

    public final RightHandSide RightHandSide(String string, String string2, LeftHandSide leftHandSide, String string3) throws ParseException {
        String[] stringArray = new String[2];
        RightHandSide rightHandSide = new RightHandSide(string, string2, leftHandSide, string3);
        stringArray = this.Action();
        if (stringArray[0] != null && !this.bindingNameSet.contains(stringArray[0])) {
            throw new ParseException(this.errorMsgPrefix(null) + "unknown label in RHS action: " + stringArray[0]);
        }
        rightHandSide.addBlock(stringArray[0], stringArray[1]);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 53: {
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(53);
            stringArray = this.Action();
            if (stringArray[0] != null && !this.bindingNameSet.contains(stringArray[0])) {
                throw new ParseException(this.errorMsgPrefix(null) + "unknown label in RHS action: " + stringArray[0]);
            }
            rightHandSide.addBlock(stringArray[0], stringArray[1]);
        }
        return rightHandSide;
    }

    public final String[] Action() throws ParseException {
        String[] stringArray = new String[2];
        Token token = null;
        if (this.jj_2_2(3)) {
            stringArray = this.NamedJavaBlock();
        } else {
            switch (this.jj_nt.kind) {
                case 54: {
                    stringArray = this.AnonymousJavaBlock();
                    break;
                }
                case 49: 
                case 61: {
                    stringArray = this.AssignmentExpression();
                    break;
                }
                case 46: {
                    token = this.jj_consume_token(46);
                    Object v = this.macrosMap.get(token.image);
                    if (v == null) {
                        throw new ParseException(this.errorMsgPrefix(token) + "unknown macro name " + token.image);
                    }
                    if (v instanceof PatternElement) {
                        throw new ParseException(this.errorMsgPrefix(token) + "macro " + token.image + " references a PatternElement, not an Action");
                    }
                    if (!(v instanceof String[])) {
                        throw new ParseException(this.errorMsgPrefix(token) + "macro " + token.image + " doesn't reference an Action!");
                    }
                    stringArray = (String[])v;
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return stringArray;
    }

    public final String[] NamedJavaBlock() throws ParseException {
        String[] stringArray = new String[2];
        Token token = null;
        this.jj_consume_token(49);
        token = this.jj_consume_token(46);
        stringArray[0] = token.image;
        this.jj_consume_token(54);
        stringArray[1] = this.ConsumeBlock();
        return stringArray;
    }

    public final String[] AnonymousJavaBlock() throws ParseException {
        String[] stringArray = new String[2];
        stringArray[0] = null;
        this.jj_consume_token(54);
        stringArray[1] = this.ConsumeBlock();
        return stringArray;
    }

    public final String[] AssignmentExpression() throws ParseException {
        String[] stringArray = new String[2];
        StringBuffer stringBuffer = new StringBuffer();
        Token token = null;
        Token token2 = null;
        String string = null;
        String string2 = null;
        String string3 = Strings.getNl();
        String string4 = null;
        Pair pair = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        stringBuffer.append("// RHS assignment block" + string3);
        stringBuffer.append("      FeatureMap features = Factory.newFeatureMap();" + string3);
        switch (this.jj_nt.kind) {
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                throw new ParseException(":+ not a legal operator (no multi-span annots)");
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        token = this.jj_consume_token(46);
        stringArray[0] = token.image;
        string4 = stringArray[0] + "Annots";
        this.jj_consume_token(51);
        token = this.jj_consume_token(46);
        string = token.image;
        stringBuffer.append("      Object val = null;" + string3);
        this.jj_consume_token(60);
        this.jj_consume_token(54);
        block29: while (true) {
            switch (this.jj_nt.kind) {
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    break block29;
                }
            }
            token = this.jj_consume_token(46);
            this.jj_consume_token(60);
            string2 = token.image;
            switch (this.jj_nt.kind) {
                case 32: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: {
                    pair = this.AttrVal();
                    switch ((Integer)pair.first) {
                        case 44: {
                            stringBuffer.append("      val = ");
                            this.appendJavaStringLiteral(stringBuffer, pair.second.toString());
                            stringBuffer.append(";" + string3);
                            break;
                        }
                        case 32: {
                            stringBuffer.append("      try { val = Long.valueOf(");
                            this.appendJavaStringLiteral(stringBuffer, pair.second.toString());
                            stringBuffer.append("); }" + string3 + "      catch(NumberFormatException e) { }" + string3);
                            break;
                        }
                        case 46: {
                            stringBuffer.append("      val = ");
                            this.appendJavaStringLiteral(stringBuffer, pair.second.toString());
                            stringBuffer.append(";" + string3);
                            break;
                        }
                        case 45: {
                            stringBuffer.append("      val = Boolean.valueOf(");
                            this.appendJavaStringLiteral(stringBuffer, pair.second.toString());
                            stringBuffer.append(");" + string3);
                            break;
                        }
                        case 47: {
                            stringBuffer.append("      try { val = Double.valueOf(");
                            this.appendJavaStringLiteral(stringBuffer, pair.second.toString());
                            stringBuffer.append("); }" + string3 + "      catch(NumberFormatException e) { }" + string3);
                            break;
                        }
                        default: {
                            stringBuffer.append("      val = \"\";" + string3);
                        }
                    }
                    stringBuffer.append("      features.put(");
                    this.appendJavaStringLiteral(stringBuffer, string2);
                    stringBuffer.append(", val);");
                    stringBuffer.append(string3);
                    break;
                }
                case 49: {
                    this.jj_consume_token(49);
                    token = this.jj_consume_token(46);
                    string5 = token.image + "ExistingAnnots";
                    if (!this.bindingNameSet.contains(token.image)) {
                        throw new ParseException(this.errorMsgPrefix(token) + "unknown label in RHS action(2): " + token.image);
                    }
                    stringBuffer.append("      { // need a block for the existing annot set" + string3 + "        gate.AnnotationSet " + string5 + " = (gate.AnnotationSet)bindings.get(");
                    this.appendJavaStringLiteral(stringBuffer, token.image);
                    stringBuffer.append("); " + string3 + "        Object existingFeatureValue;" + string3);
                    switch (this.jj_nt.kind) {
                        case 51: {
                            this.jj_consume_token(51);
                            token = this.jj_consume_token(46);
                            string6 = token.image;
                            switch (this.jj_nt.kind) {
                                case 51: {
                                    token2 = this.jj_consume_token(51);
                                    break;
                                }
                                case 31: {
                                    token2 = this.jj_consume_token(31);
                                    break;
                                }
                                default: {
                                    this.jj_la1[37] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            token = this.jj_consume_token(46);
                            string8 = token2.image;
                            string7 = token.image;
                            stringBuffer.append("        if (" + string5 + " != null) {" + string3 + "          gate.AnnotationSet existingAnnots = " + string3 + "          " + string5 + ".get(");
                            this.appendJavaStringLiteral(stringBuffer, string6);
                            stringBuffer.append(");" + string3 + "          if (existingAnnots != null) {" + string3 + "            java.util.Iterator iter = existingAnnots.iterator();" + string3 + "            while(iter.hasNext()) {" + string3 + "              gate.Annotation existingA = (gate.Annotation) iter.next();" + string3);
                            if (string8.equals("@") && string7.equals("string")) {
                                stringBuffer.append("              int from = existingA.getStartNode().getOffset().intValue();" + string3 + "              int to   = existingA.getEndNode().getOffset().intValue();" + string3 + "              existingFeatureValue = doc.getContent().toString().substring(from,to);" + string3);
                            } else {
                                stringBuffer.append("existingFeatureValue = existingA.getFeatures().get(");
                                this.appendJavaStringLiteral(stringBuffer, string7);
                                stringBuffer.append(");" + string3);
                            }
                            stringBuffer.append("              if(existingFeatureValue != null) {" + string3 + "                features.put(");
                            this.appendJavaStringLiteral(stringBuffer, string2);
                            stringBuffer.append(", existingFeatureValue);" + string3 + "                break;" + string3 + "              }" + string3 + "            } // while" + string3 + "          } // if not null" + string3 + "        } // if not null" + string3);
                            break;
                        }
                        case 31: {
                            token2 = this.jj_consume_token(31);
                            token = this.jj_consume_token(46);
                            string8 = token2.image;
                            string7 = token.image;
                            if (string8.equals("@") && string7.equals("string")) {
                                stringBuffer.append("        if (" + string5 + " != null) {" + string3 + "          int from = " + string5 + ".firstNode().getOffset().intValue();" + string3 + "          int to   = " + string5 + ".lastNode().getOffset().intValue();" + string3 + "          existingFeatureValue = doc.getContent().toString().substring(from,to);" + string3 + "          if(existingFeatureValue != null) {" + string3 + "            features.put(");
                                this.appendJavaStringLiteral(stringBuffer, string2);
                                stringBuffer.append(", existingFeatureValue);" + string3 + "          }" + string3 + "        } // if not null" + string3);
                                break;
                            }
                            throw new ParseException(this.errorMsgPrefix(token) + "Unsupported RHS meta-property " + token.image);
                        }
                        default: {
                            this.jj_la1[38] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    stringBuffer.append("      } // block for existing annots" + string3);
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_nt.kind) {
                case 53: {
                    this.jj_consume_token(53);
                    continue block29;
                }
            }
            this.jj_la1[40] = this.jj_gen;
        }
        this.jj_consume_token(55);
        this.appendAnnotationAdd(stringBuffer, string, string4);
        stringArray[1] = stringBuffer.toString();
        return stringArray;
    }

    void appendSpecials(Token token, StringBuffer stringBuffer) throws ParseException {
        if (token != null) {
            this.appendSpecials(token.specialToken, stringBuffer);
            stringBuffer.append(token.image);
        }
    }

    String ConsumeBlock() throws ParseException {
        Token token;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        Token token2 = token = this.getNextToken();
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        stringBuffer.append("  // JAPE Source: " + this.baseURL + ":" + token2.beginLine + "\n");
        while (n != 0) {
            this.appendSpecials(token.specialToken, stringBuffer);
            if (token.image.equals("{")) {
                ++n;
            } else if (token.image.equals("}")) {
                --n;
            }
            if (n > 0) {
                if (token.kind == 44) {
                    this.appendJavaStringLiteral(stringBuffer, token.image.substring(1, token.image.length() - 1));
                } else {
                    stringBuffer.append(token.image);
                }
            }
            if (n == 0) continue;
            token = this.getNextToken();
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    private final boolean jj_3R_23() {
        Token token;
        if (this.jj_3R_25()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_25());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_17() {
        return this.jj_3R_19();
    }

    private final boolean jj_3R_15() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_scan_token(46)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_16() {
        return this.jj_scan_token(46);
    }

    private final boolean jj_3R_21() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private final boolean jj_3R_14() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_16()) {
            this.jj_scanpos = token;
            if (this.jj_3R_17()) {
                this.jj_scanpos = token;
                if (this.jj_3R_18()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_19() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_21()) {
            this.jj_scanpos = token;
            if (this.jj_3R_22()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_1() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_26() {
        return this.jj_scan_token(28);
    }

    private final boolean jj_3R_22() {
        return this.jj_scan_token(44);
    }

    private final boolean jj_3R_20() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private final boolean jj_3R_25() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_24() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_26()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(46);
    }

    private final boolean jj_3_2() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_18() {
        return this.jj_3R_20();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{2048, 0x200000, 8192, 0x301000, 0xC00000, 0, 0, 0, 0xC00000, 0x7000000, 0x7000000, 0x100000, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0x20000000, 0x10000000, 0x10000000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 16384, 16384, 24576, 0, 0, 0, 0, 0, 0x20424000, 20992000, 0x100000, 20992000, 20992000, 0x200000, 0x401000, 0x4000000, 16385, 131072, 0x200000, 0x4000000, 0, 0x404000, 540672, 540672, 61441, 67170305, 16384, 0x200000, 0x200000, 0x20424000, 0x20020000, 16384, 524288, 524288, 67301377, 0x200000};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public ParseCpsl(InputStream inputStream) {
        this(inputStream, null);
    }

    public ParseCpsl(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new ParseCpslTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 41; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 41; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ParseCpsl(Reader reader) {
        int n;
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new ParseCpslTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 41; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 41; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ParseCpsl(ParseCpslTokenManager parseCpslTokenManager) {
        int n;
        this.token_source = parseCpslTokenManager;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 41; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(ParseCpslTokenManager parseCpslTokenManager) {
        int n;
        this.token_source = parseCpslTokenManager;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 41; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[70];
        for (n2 = 0; n2 < 70; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 41; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 70; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        ParseCpsl.jj_la1_0();
        ParseCpsl.jj_la1_1();
        ParseCpsl.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

