/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Document;
import gate.annotation.AnnotationSetImpl;
import gate.jape.Constraint;
import gate.jape.JapeConstants;
import gate.jape.PatternElement;
import gate.util.Pair;
import gate.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPatternElement
extends PatternElement
implements JapeConstants,
Serializable {
    private static final boolean DEBUG = false;
    private ArrayList<Constraint> constraints1;
    private Constraint[] constraints2;
    private HashMap<Object, Constraint> constraintsMap = new HashMap();
    private int lastFailurePoint = -1;
    private AnnotationSet matchedAnnots;

    public BasicPatternElement() {
        this.constraints1 = new ArrayList();
        this.matchedAnnots = new AnnotationSetImpl((Document)null);
    }

    @Override
    public Object clone() {
        BasicPatternElement basicPatternElement = (BasicPatternElement)super.clone();
        basicPatternElement.constraintsMap = (HashMap)this.constraintsMap.clone();
        basicPatternElement.constraints1 = new ArrayList();
        int n = this.constraints1.size();
        for (int i = 0; i < n; ++i) {
            basicPatternElement.constraints1.add((Constraint)this.constraints1.get(i).clone());
        }
        return basicPatternElement;
    }

    public void addConstraint(Constraint constraint) {
        String string = constraint.getAnnotType();
        Pair pair = new Pair(string, constraint.isNegated());
        Constraint constraint2 = this.constraintsMap.get(pair);
        if (constraint2 == null) {
            this.constraintsMap.put(pair, constraint);
            this.constraints1.add(constraint);
        } else {
            constraint2.addAttributes(constraint.getAttributeSeq());
        }
    }

    public boolean isMultiType() {
        return this.constraints2 != null ? this.constraints2.length > 1 : (this.constraints1 != null ? this.constraints1.size() > 1 : false);
    }

    @Override
    public void finish() {
        int n = 0;
        this.constraints2 = new Constraint[this.constraints1.size()];
        Iterator<Constraint> iterator = this.constraints1.iterator();
        while (iterator.hasNext()) {
            Constraint constraint;
            this.constraints2[n] = constraint = iterator.next();
            this.constraints2[n++].finish();
        }
        this.constraints1 = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        Constraint[] constraintArray = this.getConstraints();
        for (int i = 0; i < constraintArray.length; ++i) {
            stringBuffer.append(constraintArray[i].shortDesc() + ",");
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        return stringBuffer.toString();
    }

    @Override
    public String toString(String string) {
        String string2 = Strings.getNl();
        String string3 = Strings.addPadding(string, 4);
        StringBuffer stringBuffer = new StringBuffer(string + "BPE: lastFailurePoint(" + this.lastFailurePoint + "); constraints(");
        if (this.constraints1 != null) {
            int n = this.constraints1.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2 + this.constraints1.get(i).getDisplayString(string3));
            }
        } else {
            int n = this.constraints2.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2 + this.constraints2[i].getDisplayString(string3));
            }
        }
        return stringBuffer.toString();
    }

    public String shortDesc() {
        String string = "";
        if (this.constraints1 != null) {
            int n = this.constraints1.size();
            for (int i = 0; i < n; ++i) {
                string = string + this.constraints1.get(i).toString();
            }
        } else {
            int n = this.constraints2.length;
            for (int i = 0; i < n; ++i) {
                string = string + this.constraints2[i].shortDesc();
            }
        }
        return string;
    }

    public ArrayList<Constraint> getUnfinishedConstraints() {
        return this.constraints1;
    }

    public Constraint[] getConstraints() {
        return this.constraints2;
    }
}

