/*
 * Decompiled with CFR 0.152.
 */
package gate.html;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.DocumentContentImpl;
import gate.corpora.RepositioningInfo;
import gate.event.StatusListener;
import gate.util.Err;
import gate.util.InvalidOffsetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.cyberneko.html.HTMLEventInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NekoHtmlDocumentHandler
implements XMLDocumentHandler,
XMLErrorHandler {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_GENERAL = false;
    private static final boolean DEBUG_ELEMENTS = false;
    private static final boolean DEBUG_CHARACTERS = false;
    private static final boolean DEBUG_UNUSED = false;
    public static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    private static final Comparator<Object> POSITION_INFO_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            Long l = null;
            if (object instanceof Long) {
                l = (Long)object;
            } else if (object instanceof RepositioningInfo.PositionInfo) {
                l = ((RepositioningInfo.PositionInfo)object).getOriginalPosition();
            }
            Long l2 = null;
            if (object2 instanceof Long) {
                l2 = (Long)object2;
            } else if (object2 instanceof RepositioningInfo.PositionInfo) {
                l2 = ((RepositioningInfo.PositionInfo)object).getOriginalPosition();
            }
            return l.compareTo(l2);
        }
    };
    private RepositioningInfo reposInfo = null;
    private RepositioningInfo ampCodingInfo = null;
    private Set<String> ignorableTags = null;
    int ignorableTagLevels = 0;
    static final int ELEMENTS_RATE = 128;
    private int[] lineOffsets;
    private StringBuilder tmpDocContent = null;
    private StringBuilder contentBuffer = new StringBuilder("");
    private boolean readCharacterStatus = false;
    private int charactersStartOffset;
    private Stack<CustomObject> stack = null;
    private Document doc = null;
    private AnnotationSet basicAS;
    protected List<StatusListener> myStatusListeners = new LinkedList<StatusListener>();
    private int elements = 0;
    protected int customObjectsId = 0;
    private LinkedList<CustomObject> colector = null;
    protected boolean addSpaceOnUnpack = true;
    protected boolean previousChunkEndedWithWS = false;

    public NekoHtmlDocumentHandler(Document document, AnnotationSet annotationSet, Set<String> set) {
        if (set == null) {
            set = new HashSet<String>();
        }
        this.stack = new Stack();
        this.tmpDocContent = new StringBuilder(document.getContent().size().intValue());
        this.colector = new LinkedList();
        this.doc = document;
        this.basicAS = annotationSet;
        this.customObjectsId = 0;
        this.ignorableTags = set;
        if (Gate.getUserConfig().get("Document_add_space_on_unpack") != null) {
            this.addSpaceOnUnpack = Gate.getUserConfig().getBoolean("Document_add_space_on_unpack");
        }
    }

    public void setLineOffsets(int[] nArray) {
        this.lineOffsets = nArray;
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.charactersAction();
        if (0 == ++this.elements % 128) {
            this.fireStatusChangedEvent("Processed elements : " + this.elements);
        }
        if (this.ignorableTags.contains(qName.localpart)) {
            ++this.ignorableTagLevels;
        }
        FeatureMap featureMap = Factory.newFeatureMap();
        for (int i = 0; i < xMLAttributes.getLength(); ++i) {
            featureMap.put(xMLAttributes.getLocalName(i), xMLAttributes.getValue(i));
        }
        this.customizeAppearanceOfDocumentWithStartTag(qName.localpart);
        Long l = new Long(this.tmpDocContent.length());
        CustomObject customObject = new CustomObject(qName.localpart, featureMap, l, l);
        this.stack.push(customObject);
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        int n;
        if (!this.readCharacterStatus) {
            if (this.reposInfo != null) {
                HTMLEventInfo hTMLEventInfo;
                HTMLEventInfo hTMLEventInfo2 = hTMLEventInfo = augmentations == null ? null : (HTMLEventInfo)augmentations.getItem(AUGMENTATIONS);
                if (hTMLEventInfo == null) {
                    Err.println("Warning: could not determine proper repositioning info for character chunk \"" + new String(xMLString.ch, xMLString.offset, xMLString.length) + "\" near offset " + this.charactersStartOffset + ".  Save preserving format may give incorret results.");
                } else {
                    n = hTMLEventInfo.getBeginLineNumber() - 1;
                    int n2 = hTMLEventInfo.getBeginColumnNumber() - 1;
                    this.charactersStartOffset = this.lineOffsets[n] + n2;
                }
            }
            this.contentBuffer = new StringBuilder();
        }
        this.readCharacterStatus = true;
        boolean bl = this.contentBuffer.length() == 0 || !Character.isWhitespace(this.contentBuffer.charAt(this.contentBuffer.length() - 1));
        for (n = xMLString.offset; n < xMLString.offset + xMLString.length; ++n) {
            if (!Character.isWhitespace(xMLString.ch[n])) {
                this.contentBuffer.append(xMLString.ch[n]);
                bl = true;
                continue;
            }
            if (!bl) continue;
            this.contentBuffer.append(' ');
            bl = false;
        }
    }

    public void charactersAction() throws XNIException {
        if (!this.readCharacterStatus) {
            return;
        }
        this.readCharacterStatus = false;
        if (this.contentBuffer.length() == 0) {
            return;
        }
        if (this.ignorableTagLevels > 0) {
            return;
        }
        boolean bl = Character.isWhitespace(this.contentBuffer.charAt(0));
        if (bl) {
            this.contentBuffer.deleteCharAt(0);
        }
        if (this.contentBuffer.length() == 0) {
            this.previousChunkEndedWithWS = bl;
            return;
        }
        boolean bl2 = Character.isWhitespace(this.contentBuffer.charAt(this.contentBuffer.length() - 1));
        if (bl2) {
            this.contentBuffer.setLength(this.contentBuffer.length() - 1);
        }
        int n = this.tmpDocContent.length();
        boolean bl3 = false;
        if (n != 0 && !Character.isWhitespace(this.tmpDocContent.charAt(n - 1)) && (this.previousChunkEndedWithWS || bl || this.addSpaceOnUnpack)) {
            this.tmpDocContent.append(' ');
            bl3 = true;
        }
        this.tmpDocContent.append((CharSequence)this.contentBuffer);
        if (this.reposInfo != null) {
            long l = this.charactersStartOffset;
            if (bl) {
                l = this.fixStartOffsetForWhitespace(l);
            }
            int n2 = n;
            if (bl3) {
                ++n2;
            }
            this.addRepositioningInfo(this.contentBuffer.length(), (int)l, n2);
        }
        Long l = new Long(this.tmpDocContent.length());
        CustomObject customObject2 = null;
        for (CustomObject customObject2 : this.stack) {
            if (bl3 && customObject2.getStart().equals(customObject2.getEnd())) {
                customObject2.setStart(new Long(customObject2.getStart() + 1L));
            }
            customObject2.setEnd(l);
        }
        this.previousChunkEndedWithWS = bl2;
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        this.endElement(qName, augmentations, false);
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations, true);
    }

    public void endElement(QName qName, Augmentations augmentations, boolean bl) throws XNIException {
        this.charactersAction();
        CustomObject customObject = null;
        if (this.ignorableTags.contains(qName.localpart)) {
            --this.ignorableTagLevels;
        }
        if (!this.stack.isEmpty()) {
            customObject = this.stack.pop();
            if (customObject.getStart().equals(customObject.getEnd()) && !bl) {
                customObject.getFM().put("isEmptyAndSpan", "true");
            }
            this.colector.add(customObject);
        }
        if (customObject != null && customObject.getStart().longValue() != customObject.getEnd().longValue()) {
            this.customizeAppearanceOfDocumentWithEndTag(qName.localpart);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        CustomObject customObject = null;
        this.doc.setContent(new DocumentContentImpl(this.tmpDocContent.toString()));
        if (this.basicAS == null) {
            this.basicAS = this.doc.getAnnotations("Original markups");
        }
        Collections.sort(this.colector);
        while (!this.colector.isEmpty()) {
            customObject = this.colector.getFirst();
            this.colector.remove(customObject);
            try {
                this.basicAS.add(customObject.getStart(), customObject.getEnd(), customObject.getElemName(), customObject.getFM());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                Err.prln("Error creating an annot :" + customObject + " Discarded...");
            }
        }
        this.fireStatusChangedEvent("Total elements : " + this.elements);
    }

    public void error(String string, String string2, XMLParseException xMLParseException) {
        xMLParseException.printStackTrace(Err.getPrintWriter());
    }

    public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        throw xMLParseException;
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.charactersAction();
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.charactersAction();
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.charactersAction();
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        this.charactersAction();
    }

    private long fixStartOffsetForWhitespace(long l) {
        int n = Collections.binarySearch(this.ampCodingInfo, l, POSITION_INFO_COMPARATOR);
        if (n < 0) {
            return l + 1L;
        }
        return l + ((RepositioningInfo.PositionInfo)this.ampCodingInfo.get(n)).getOriginalLength();
    }

    public void addRepositioningInfo(int n, int n2, int n3) {
        long l;
        long l2;
        RepositioningInfo.PositionInfo positionInfo = null;
        long l3 = n2;
        long l4 = 0L;
        for (int i = 0; i < this.ampCodingInfo.size(); ++i) {
            positionInfo = (RepositioningInfo.PositionInfo)this.ampCodingInfo.get(i);
            long l5 = positionInfo.getOriginalPosition();
            if (l5 < l3) continue;
            if (l5 > (long)(n2 + n) + l4) break;
            l2 = l5 - (l3 + l4);
            l = l3 - (long)n2;
            if (l2 > 0L) {
                this.reposInfo.addPositionInfo(l3 + l4, l2, (long)n3 + l, l2);
            }
            this.reposInfo.addPositionInfo(l5, positionInfo.getOriginalLength(), (long)n3 + l + l2, positionInfo.getCurrentLength());
            l3 = l3 + l2 + positionInfo.getCurrentLength();
            l4 += positionInfo.getOriginalLength() - positionInfo.getCurrentLength();
        }
        if ((l2 = (long)n - (l = l3 - (long)n2)) > 0L) {
            this.reposInfo.addPositionInfo(l3 + l4, l2, (long)n3 + l, l2);
        }
    }

    protected void customizeAppearanceOfDocumentWithStartTag(String string) {
        boolean bl = false;
        int n = this.tmpDocContent.length();
        if ("p".equals(string) && n >= 2 && '\n' != this.tmpDocContent.charAt(n - 2)) {
            this.tmpDocContent.append("\n");
            bl = true;
        }
        if ("br".equals(string)) {
            this.tmpDocContent.append("\n");
            bl = true;
        }
        if ("div".equals(string) && n > 0 && this.tmpDocContent.charAt(n - 1) != '\n') {
            this.tmpDocContent.append("\n");
            bl = true;
        }
        if (bl) {
            Long l = new Long(this.tmpDocContent.length());
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                ((CustomObject)iterator.next()).setEnd(l);
            }
        }
    }

    protected void customizeAppearanceOfDocumentWithEndTag(String string) {
        boolean bl = false;
        if ("p".equals(string) || "h1".equals(string) || "h2".equals(string) || "h3".equals(string) || "h4".equals(string) || "h5".equals(string) || "h6".equals(string) || "tr".equals(string) || "center".equals(string) || "li".equals(string)) {
            this.tmpDocContent.append("\n");
            bl = true;
        }
        if ("div".equals(string) && this.tmpDocContent.length() > 0 && this.tmpDocContent.charAt(this.tmpDocContent.length() - 1) != '\n') {
            this.tmpDocContent.append("\n");
            bl = true;
        }
        if ("title".equals(string)) {
            this.tmpDocContent.append("\n\n");
            bl = true;
        }
        if (bl) {
            Long l = new Long(this.tmpDocContent.length());
            for (CustomObject customObject : this.stack) {
                customObject.setEnd(l);
            }
        }
    }

    public void setRepositioningInfo(RepositioningInfo repositioningInfo) {
        this.reposInfo = repositioningInfo;
    }

    public RepositioningInfo getRepositioningInfo() {
        return this.reposInfo;
    }

    public void setAmpCodingInfo(RepositioningInfo repositioningInfo) {
        this.ampCodingInfo = repositioningInfo;
    }

    public RepositioningInfo getAmpCodingInfo() {
        return this.ampCodingInfo;
    }

    public void setIgnorableTags(Set<String> set) {
        this.ignorableTags = set;
    }

    public Set<String> getIgnorableTags() {
        return this.ignorableTags;
    }

    public int getCustomObjectsId() {
        return this.customObjectsId;
    }

    public void addStatusListener(StatusListener statusListener) {
        this.myStatusListeners.add(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.myStatusListeners.remove(statusListener);
    }

    protected void fireStatusChangedEvent(String string) {
        Iterator<StatusListener> iterator = this.myStatusListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().statusChanged(string);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
    }

    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CustomObject
    implements Comparable<CustomObject> {
        private String elemName = null;
        private FeatureMap fm = null;
        private Long start = null;
        private Long end = null;
        private Long id = null;

        public CustomObject(String string, FeatureMap featureMap, Long l, Long l2) {
            this.elemName = string;
            this.fm = featureMap;
            this.start = l;
            this.end = l2;
            this.id = new Long(NekoHtmlDocumentHandler.this.customObjectsId++);
        }

        @Override
        public int compareTo(CustomObject customObject) {
            return this.id.compareTo(customObject.getId());
        }

        public String getElemName() {
            return this.elemName;
        }

        public FeatureMap getFM() {
            return this.fm;
        }

        public Long getStart() {
            return this.start;
        }

        public Long getEnd() {
            return this.end;
        }

        public Long getId() {
            return this.id;
        }

        public void setElemName(String string) {
            this.elemName = string;
        }

        public void setFM(FeatureMap featureMap) {
            this.fm = featureMap;
        }

        public void setStart(Long l) {
            this.start = l;
        }

        public void setEnd(Long l) {
            this.end = l;
        }
    }
}

