/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.gui.MainFrame;
import gate.gui.ontology.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TopClassAction
extends AbstractAction {
    private static final long serialVersionUID = 3258409543049359926L;
    protected JTextField nameSpace;
    protected JTextField className;
    protected JPanel mainPanel = new JPanel(new GridBagLayout());
    protected Ontology ontology;

    public TopClassAction(String string, Icon icon) {
        super(string, icon);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)new JLabel("Name Space:"), gridBagConstraints);
        this.nameSpace = new JTextField(30);
        this.mainPanel.add((Component)this.nameSpace, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)new JLabel("Class Name:"), gridBagConstraints);
        this.className = new JTextField(30);
        this.mainPanel.add((Component)this.className, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.nameSpace.setText(this.ontology.getDefaultNameSpace() == null ? "http://gate.ac.uk/example#" : this.ontology.getDefaultNameSpace());
        JOptionPane jOptionPane = new JOptionPane(this.mainPanel, 3, 2, MainFrame.getIcon("ontology-topclass")){

            public void selectInitialValue() {
                TopClassAction.this.className.requestFocusInWindow();
                TopClassAction.this.className.selectAll();
            }
        };
        jOptionPane.createDialog(MainFrame.getInstance(), "New Top Class").setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object instanceof Integer && (Integer)object == 0) {
            String string = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string)) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Name Space: " + string + "\nExample: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.className.getText())) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Class Name: " + this.className.getText());
                return;
            }
            if (this.ontology.getOResourceFromMap(string + this.className.getText()) != null) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "<html>Resource <b>" + string + this.className.getText() + "</b> already exists.");
                return;
            }
            this.ontology.addOClass(new URI(this.nameSpace.getText() + this.className.getText(), false), (byte)0);
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }
}

