/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.Resource;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OConstants;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.OntologyModificationListener;
import gate.creole.ontology.RDFProperty;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.MainFrame;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.OntologyInstanceView;
import gate.gui.docview.TextualDocumentView;
import gate.gui.ontology.OntologyItemComparator;
import gate.util.LuckyException;
import gate.util.OptionsMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyClassView
extends AbstractDocumentView
implements CreoleListener,
OntologyModificationListener {
    protected TextualDocumentView textView;
    protected JTextArea textArea;
    protected OntologyInstanceView instanceView;
    protected JPanel mainPanel;
    protected JLabel messageLabel;
    protected JPanel treesPanel;
    protected JComboBox setComboBox;
    protected OClass selectedClass;
    protected Set<OClass> highlightedClasses;
    protected Map<OClass, Color> colorByClassMap;
    protected Map<OClass, List> highlightsDataByClassMap;
    protected Map<Ontology, JTree> treeByOntologyMap;
    protected List<String> hiddenClassesList;
    protected String selectedSet;
    protected OntologyItemComparator itemComparator;
    protected MouseStoppedMovingAction mouseStoppedMovingAction;
    protected TextMouseListener textMouseListener;
    protected Timer mouseMovementTimer;
    protected static final int MOUSE_MOVEMENT_TIMER_DELAY = 500;
    protected OptionsMap userConfig = Gate.getUserConfig();
    protected static final String ONTOLOGY = "ontology";
    protected static final String CLASS = "class";
    protected static final String INSTANCE = "inst";

    public OntologyClassView() {
        this.colorByClassMap = new HashMap<OClass, Color>();
        this.highlightedClasses = new HashSet<OClass>();
        this.highlightsDataByClassMap = new HashMap<OClass, List>();
        this.treeByOntologyMap = new HashMap<Ontology, JTree>();
        String string = this.getClass().getName() + '.';
        this.hiddenClassesList = this.userConfig.getList(string + "hiddenclasses");
        this.itemComparator = new OntologyItemComparator();
    }

    @Override
    protected void initGUI() {
        Serializable serializable;
        Object object;
        Iterator<DocumentView> iterator = this.owner.getCentralViews().iterator();
        while (this.textView == null && iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)object;
        }
        this.textArea = this.textView.getTextView();
        object = this.owner.getHorizontalViews().iterator();
        while (this.instanceView == null && object.hasNext()) {
            serializable = (DocumentView)object.next();
            if (!(serializable instanceof OntologyInstanceView)) continue;
            this.instanceView = (OntologyInstanceView)serializable;
        }
        this.instanceView.setOwner(this.owner);
        this.mainPanel = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridx = 0;
        this.treesPanel = new JPanel();
        this.treesPanel.setLayout(new GridBagLayout());
        boolean bl = false;
        List<LanguageResource> list = Gate.getCreoleRegister().getPublicLrInstances();
        for (LanguageResource languageResource : list) {
            if (!(languageResource instanceof Ontology)) continue;
            this.loadOntology((Ontology)languageResource);
            bl = true;
        }
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).anchor = 18;
        this.mainPanel.add((Component)new JScrollPane(this.treesPanel), serializable);
        this.setComboBox = new JComboBox();
        this.setComboBox.setEditable(true);
        this.setComboBox.setToolTipText("Annotation set where to load/save the annotations");
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).anchor = 15;
        this.mainPanel.add((Component)this.setComboBox, serializable);
        this.initListeners();
        ArrayList arrayList = new ArrayList();
        arrayList.add("");
        arrayList.addAll(this.document.getAnnotationSetNames());
        Collections.sort(arrayList);
        this.setComboBox.setModel(new DefaultComboBoxModel(new Vector(arrayList)));
        if (bl) {
            this.selectedSet = "";
            for (int i = 0; i < this.setComboBox.getItemCount(); ++i) {
                String string = (String)this.setComboBox.getItemAt(i);
                if (!this.setColorTreeNodesWhenInstancesFound(string)) continue;
                this.selectedSet = string;
                break;
            }
            this.setComboBox.setSelectedItem(this.selectedSet);
        } else {
            this.messageLabel = new JLabel("<html><p><font color=red>Load at least one ontology.");
            this.messageLabel.setHorizontalAlignment(0);
            this.messageLabel.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
            this.messageLabel.setBackground(UIManager.getColor("Tree.selectionBackground"));
            serializable = new GridBagConstraints();
            this.treesPanel.add((Component)this.messageLabel, serializable);
        }
    }

    protected void initListeners() {
        Gate.getCreoleRegister().addCreoleListener(this);
        this.setComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                OntologyClassView.this.selectedSet = (String)OntologyClassView.this.setComboBox.getSelectedItem();
                OntologyClassView.this.setColorTreeNodesWhenInstancesFound(OntologyClassView.this.selectedSet);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        for (OClass object : OntologyClassView.this.highlightedClasses) {
                            if (!OntologyClassView.this.highlightsDataByClassMap.containsKey(object)) continue;
                            OntologyClassView.this.textView.removeHighlights(OntologyClassView.this.highlightsDataByClassMap.get(object));
                        }
                        OntologyClassView.this.highlightsDataByClassMap.clear();
                        OntologyClassView.this.highlightedClasses.clear();
                        for (JTree jTree : OntologyClassView.this.treeByOntologyMap.values()) {
                            if (!jTree.isShowing()) continue;
                            jTree.revalidate();
                        }
                    }
                });
            }
        });
        this.mouseStoppedMovingAction = new MouseStoppedMovingAction();
        this.mouseMovementTimer = new Timer(500, this.mouseStoppedMovingAction);
        this.mouseMovementTimer.setRepeats(false);
        this.textMouseListener = new TextMouseListener();
    }

    @Override
    protected void registerHooks() {
        this.textArea.addMouseListener(this.textMouseListener);
        this.textArea.addMouseMotionListener(this.textMouseListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (OClass oClass : new HashSet<OClass>(OntologyClassView.this.highlightedClasses)) {
                    if (!OntologyClassView.this.highlightsDataByClassMap.containsKey(oClass)) continue;
                    OntologyClassView.this.textView.addHighlights(OntologyClassView.this.highlightsDataByClassMap.get(oClass));
                }
            }
        });
        if (!this.instanceView.isActive()) {
            this.owner.setBottomView(this.owner.horizontalViews.indexOf(this.instanceView));
        }
    }

    @Override
    protected void unregisterHooks() {
        this.textArea.removeMouseListener(this.textMouseListener);
        this.textArea.removeMouseMotionListener(this.textMouseListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (OClass oClass : OntologyClassView.this.highlightedClasses) {
                    if (!OntologyClassView.this.highlightsDataByClassMap.containsKey(oClass)) continue;
                    OntologyClassView.this.textView.removeHighlights(OntologyClassView.this.highlightsDataByClassMap.get(oClass));
                }
            }
        });
        if (this.instanceView.isActive()) {
            this.owner.setBottomView(-1);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        Gate.getCreoleRegister().removeCreoleListener(this);
        this.document = null;
        String string = this.getClass().getName() + '.';
        this.userConfig.put((Object)(string + "hiddenclasses"), this.hiddenClassesList);
    }

    @Override
    public Component getGUI() {
        return this.mainPanel;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void resourceLoaded(CreoleEvent creoleEvent) {
        if (creoleEvent.getResource() instanceof Ontology) {
            if (this.messageLabel != null && this.treesPanel.isAncestorOf(this.messageLabel)) {
                this.treesPanel.remove(this.messageLabel);
                this.selectedSet = "";
                for (int i = 0; i < this.setComboBox.getItemCount(); ++i) {
                    String string = (String)this.setComboBox.getItemAt(i);
                    if (!this.setColorTreeNodesWhenInstancesFound(string)) continue;
                    this.selectedSet = string;
                    break;
                }
                this.setComboBox.setSelectedItem(this.selectedSet);
            }
            Ontology ontology = (Ontology)creoleEvent.getResource();
            this.loadOntology(ontology);
            ontology.addOntologyModificationListener(this);
        }
    }

    @Override
    public void resourceUnloaded(CreoleEvent creoleEvent) {
        if (creoleEvent.getResource() instanceof Ontology) {
            Ontology ontology = (Ontology)creoleEvent.getResource();
            JTree jTree = this.treeByOntologyMap.remove(ontology);
            for (Component component : this.treesPanel.getComponents()) {
                if (!(component instanceof JPanel) || !((JPanel)component).isAncestorOf(jTree)) continue;
                this.treesPanel.remove(component);
            }
            this.treesPanel.revalidate();
        }
    }

    @Override
    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreClosed(CreoleEvent creoleEvent) {
    }

    @Override
    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    @Override
    public void resourceRelationChanged(Ontology ontology, OResource oResource, OResource oResource2, int n) {
    }

    @Override
    public void resourcePropertyValueChanged(Ontology ontology, OResource oResource, RDFProperty rDFProperty, Object object, int n) {
    }

    @Override
    public void resourcesRemoved(Ontology ontology, String[] stringArray) {
    }

    @Override
    public void resourceAdded(Ontology ontology, OResource oResource) {
        if (oResource instanceof OClass) {
            final JTree jTree = this.treeByOntologyMap.get(ontology);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getModel().getRoot();
            final Enumeration<TreeNode> enumeration = defaultMutableTreeNode.preorderEnumeration();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    while (enumeration.hasMoreElements()) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                        Object object = defaultMutableTreeNode.getUserObject();
                        if (object == null || object.equals("Loading...")) continue;
                        OClass oClass = (OClass)object;
                        Set<OClass> set = oClass.getSubClasses(OConstants.Closure.DIRECT_CLOSURE);
                        OntologyClassView.this.addNodes(jTree, defaultMutableTreeNode, set, false);
                    }
                }
            });
        }
    }

    @Override
    public void ontologyReset(Ontology ontology) {
    }

    protected boolean setColorTreeNodesWhenInstancesFound(String string) {
        Object object;
        Object object2;
        boolean bl = false;
        List<LanguageResource> list = Gate.getCreoleRegister().getPublicLrInstances();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (LanguageResource serializable : list) {
            if (!(serializable instanceof Ontology)) continue;
            object2 = (Ontology)serializable;
            object = object2.getDefaultNameSpace();
            object = ((String)object).substring(0, ((String)object).length() - 1);
            hashMap.put((String)object, object2);
        }
        for (Annotation annotation : this.document.getAnnotations(string).get("Mention")) {
            OClass oClass;
            object2 = annotation.getFeatures();
            if (object2.get(ONTOLOGY) == null || object2.get(CLASS) == null || object2.get(INSTANCE) == null || (object = (Ontology)hashMap.get((String)object2.get(ONTOLOGY))) == null || (oClass = object.getOClass(object.createOURI((String)object2.get(CLASS)))) == null) continue;
            this.colorByClassMap.put(oClass, AnnotationSetsView.getColor(string, oClass.getName()));
            bl = true;
        }
        return bl;
    }

    protected void loadOntology(final Ontology ontology) {
        final JTree jTree = new JTree(new Object[]{"Loading..."});
        this.treeByOntologyMap.put(ontology, jTree);
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setEditable(true);
        jTree.getSelectionModel().setSelectionMode(4);
        final JPanel jPanel = new JPanel(new BorderLayout());
        final JCheckBox jCheckBox = new JCheckBox(ontology.getName(), MainFrame.getIcon("closed"), false);
        jCheckBox.setSelectedIcon(MainFrame.getIcon("expanded"));
        jPanel.add((Component)jCheckBox, "North");
        jCheckBox.addActionListener(new ActionListener(){
            boolean isTreeBuilt = false;

            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBox.isSelected()) {
                    if (!this.isTreeBuilt) {
                        jTree.expandRow(0);
                        OntologyClassView.this.buildClassTree(jTree, ontology);
                        this.isTreeBuilt = true;
                    }
                    jPanel.add((Component)jTree, "Center");
                } else {
                    jPanel.remove(jTree);
                }
                OntologyClassView.this.treesPanel.repaint();
            }
        });
        jCheckBox.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.add(new JMenuItem(new AbstractAction("Show all root classes"){

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (!jCheckBox.isSelected()) {
                                jCheckBox.doClick();
                            }
                            OntologyClassView.this.hiddenClassesList.clear();
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getModel().getRoot();
                            Set<OClass> set = ontology.getOClasses(true);
                            OntologyClassView.this.addNodes(jTree, defaultMutableTreeNode, set, false);
                        }
                    }));
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        jTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (treeSelectionEvent.getNewLeadSelectionPath() == null) {
                    if (OntologyClassView.this.treeByOntologyMap.get(OntologyClassView.this.selectedClass.getOntology()).equals(jTree)) {
                        OntologyClassView.this.selectedClass = null;
                    }
                } else {
                    if (jTree.getSelectionCount() == 1) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent();
                        OntologyClassView.this.selectedClass = (OClass)defaultMutableTreeNode.getUserObject();
                    } else {
                        OntologyClassView.this.selectedClass = null;
                    }
                    for (JTree jTree2 : OntologyClassView.this.treeByOntologyMap.values()) {
                        if (jTree2.equals(jTree)) continue;
                        jTree2.clearSelection();
                    }
                }
                OntologyClassView.this.instanceView.updateInstanceTable(OntologyClassView.this.selectedClass);
            }
        });
        jTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = jTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (mouseEvent.isPopupTrigger() && !jTree.isPathSelected(treePath)) {
                    jTree.getSelectionModel().setSelectionPath(treePath);
                }
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                jPopupMenu.add(new JMenuItem(new AbstractAction("Hide selected classes"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreePath[] treePathArray;
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
                        for (TreePath treePath : treePathArray = jTree.getSelectionPaths()) {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                            if (defaultMutableTreeNode.getParent() == null) continue;
                            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                            Object object = defaultMutableTreeNode.getUserObject();
                            OClass oClass = (OClass)object;
                            OntologyClassView.this.hiddenClassesList.add(((Object)oClass.getONodeID()).toString());
                        }
                    }
                }));
                if (jTree.getSelectionCount() == 1) {
                    jPopupMenu.add(new JMenuItem(new AbstractAction("Show all sub classes"){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getSelectionPath().getLastPathComponent();
                            Object object = defaultMutableTreeNode.getUserObject();
                            OClass oClass = (OClass)object;
                            Set<OClass> set = oClass.getSubClasses(OConstants.Closure.DIRECT_CLOSURE);
                            OntologyClassView.this.addNodes(jTree, defaultMutableTreeNode, set, false);
                        }
                    }));
                }
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.treesPanel.add((Component)jPanel, gridBagConstraints);
    }

    protected void buildClassTree(final JTree jTree, Ontology ontology) {
        if (ontology == null) {
            return;
        }
        jTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                if (defaultMutableTreeNode2.getUserObject().equals("Loading...")) {
                    defaultMutableTreeNode.removeAllChildren();
                    Object object = defaultMutableTreeNode.getUserObject();
                    OClass oClass = (OClass)object;
                    Set<OClass> set = oClass.getSubClasses(OConstants.Closure.DIRECT_CLOSURE);
                    OntologyClassView.this.addNodes(jTree, defaultMutableTreeNode, set, true);
                }
            }

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        final DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(null, true);
        Set<OClass> set = ontology.getOClasses(true);
        this.addNodes(jTree, defaultMutableTreeNode, set, true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jTree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
                jTree.setCellRenderer(new ClassTreeCellRenderer());
                jTree.setCellEditor(new ClassTreeCellEditor(jTree));
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)jTree.getModel().getRoot();
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.children();
                while (enumeration.hasMoreElements()) {
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    jTree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                }
            }
        });
    }

    protected void addNodes(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode, Set<OClass> set, boolean bl) {
        ArrayList<OClass> arrayList;
        Serializable serializable;
        int n;
        ArrayList<OClass> arrayList2 = new ArrayList<OClass>();
        for (n = 0; n < defaultMutableTreeNode.getChildCount(); ++n) {
            serializable = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            arrayList = ((DefaultMutableTreeNode)serializable).getUserObject();
            if (arrayList instanceof OClass) {
                OClass oClass = (OClass)((Object)arrayList);
                arrayList2.add(oClass);
                continue;
            }
            if (!((Object)arrayList).equals("Loading...")) continue;
            defaultMutableTreeNode.removeAllChildren();
            arrayList2.clear();
            break;
        }
        n = -1;
        serializable = (DefaultTreeModel)jTree.getModel();
        arrayList = new ArrayList<OClass>(set);
        Collections.sort(arrayList, this.itemComparator);
        for (OClass oClass : arrayList) {
            if (++n > defaultMutableTreeNode.getChildCount()) {
                n = defaultMutableTreeNode.getChildCount();
            }
            if (bl) {
                if (this.hiddenClassesList.contains(((Object)oClass.getONodeID()).toString())) {
                    continue;
                }
            } else {
                this.hiddenClassesList.remove(((Object)oClass.getONodeID()).toString());
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(oClass);
            if (!(bl && arrayList2.contains(oClass) || oClass.getSubClasses(OConstants.Closure.DIRECT_CLOSURE).isEmpty())) {
                defaultMutableTreeNode2.insert(new DefaultMutableTreeNode("Loading..."), 0);
            }
            if (arrayList2.contains(oClass)) continue;
            ((DefaultTreeModel)serializable).insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
        }
        jTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    public void setClassHighlighted(final OClass oClass, boolean bl) {
        final JTree jTree = this.treeByOntologyMap.get(oClass.getOntology());
        if (bl) {
            final ArrayList<AnnotationDataImpl> arrayList = new ArrayList<AnnotationDataImpl>();
            AnnotationSet annotationSet = this.document.getAnnotations(this.selectedSet);
            String string = oClass.getOntology().getDefaultNameSpace();
            string = string.substring(0, string.length() - 1);
            for (Annotation annotation : annotationSet.get("Mention")) {
                FeatureMap featureMap = annotation.getFeatures();
                if (featureMap.get(ONTOLOGY) == null || !featureMap.get(ONTOLOGY).equals(string) || featureMap.get(CLASS) == null || !featureMap.get(CLASS).equals(((Object)oClass.getONodeID()).toString()) || featureMap.get(INSTANCE) == null) continue;
                arrayList.add(new AnnotationDataImpl(annotationSet, annotation));
            }
            this.highlightedClasses.add(oClass);
            if (arrayList.isEmpty()) {
                this.colorByClassMap.remove(oClass);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (OntologyClassView.this.highlightsDataByClassMap.containsKey(oClass)) {
                            OntologyClassView.this.textView.removeHighlights(OntologyClassView.this.highlightsDataByClassMap.get(oClass));
                        }
                        OntologyClassView.this.highlightsDataByClassMap.remove(oClass);
                        jTree.repaint();
                    }
                });
            } else {
                Object object;
                if (this.colorByClassMap.containsKey(oClass)) {
                    object = this.colorByClassMap.get(oClass);
                } else {
                    object = AnnotationSetsView.getColor(this.selectedSet, oClass.getName());
                    this.colorByClassMap.put(oClass, (Color)object);
                }
                SwingUtilities.invokeLater(new Runnable((Color)object, jTree){
                    final /* synthetic */ Color val$color;
                    final /* synthetic */ JTree val$tree;
                    {
                        this.val$color = color;
                        this.val$tree = jTree;
                    }

                    public void run() {
                        OntologyClassView.this.highlightsDataByClassMap.put(oClass, OntologyClassView.this.textView.addHighlights(arrayList, this.val$color));
                        this.val$tree.repaint();
                    }
                });
            }
        } else {
            this.highlightedClasses.remove(oClass);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (OntologyClassView.this.highlightsDataByClassMap.containsKey(oClass)) {
                        OntologyClassView.this.textView.removeHighlights(OntologyClassView.this.highlightsDataByClassMap.get(oClass));
                    }
                    jTree.repaint();
                }
            });
        }
    }

    public void highlightInstance(AnnotationSet annotationSet, Annotation annotation, final OClass oClass, final JTree jTree) {
        Color color;
        final AnnotationDataImpl annotationDataImpl = new AnnotationDataImpl(annotationSet, annotation);
        final ArrayList arrayList = this.highlightsDataByClassMap.containsKey(oClass) ? this.highlightsDataByClassMap.get(oClass) : new ArrayList();
        this.highlightedClasses.add(oClass);
        if (this.colorByClassMap.containsKey(oClass)) {
            color = this.colorByClassMap.get(oClass);
        } else {
            color = AnnotationSetsView.getColor(annotationSet.getName(), oClass.getName());
            this.colorByClassMap.put(oClass, color);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                arrayList.add(OntologyClassView.this.textView.addHighlight(annotationDataImpl, color));
                OntologyClassView.this.highlightsDataByClassMap.put(oClass, arrayList);
                jTree.repaint();
            }
        });
    }

    public String getSelectedSet() {
        return this.selectedSet;
    }

    protected class ClassTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        ClassTreeCellRenderer renderer;
        JTree tree;

        public ClassTreeCellEditor(JTree jTree) {
            this.renderer = new ClassTreeCellRenderer();
            this.tree = jTree;
        }

        public Object getCellEditorValue() {
            boolean bl = this.renderer.getCheckBox().isSelected();
            Object object = this.renderer.getUserObject();
            OClass oClass = (OClass)object;
            OntologyClassView.this.setClassHighlighted(oClass, bl);
            return object;
        }

        public boolean isCellEditable(EventObject eventObject) {
            Object object;
            MouseEvent mouseEvent;
            TreePath treePath;
            boolean bl = false;
            if (eventObject instanceof MouseEvent && (treePath = this.tree.getPathForLocation((mouseEvent = (MouseEvent)eventObject).getX(), mouseEvent.getY())) != null && (object = treePath.getLastPathComponent()) != null && object instanceof DefaultMutableTreeNode) {
                Rectangle rectangle = this.tree.getPathBounds(treePath);
                int n = mouseEvent.getX() - rectangle.x;
                JCheckBox jCheckBox = this.renderer.getCheckBox();
                bl = n > 0 && n < jCheckBox.getPreferredSize().width;
            }
            return bl;
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Component component = this.renderer.getTreeCellRendererComponent(jTree, object, true, bl2, bl3, n, true);
            this.renderer.getCheckBox().addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ClassTreeCellEditor.this.stopCellEditing();
                }
            });
            return component;
        }
    }

    protected class ClassTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected Object userObject;
        protected JCheckBox checkBox;
        protected JLabel label;
        private Color selectionColor = UIManager.getColor("Tree.selectionBackground");
        private Color backgroundColor = UIManager.getColor("Tree.textBackground");
        private Border normalBorder = BorderFactory.createLineBorder(this.backgroundColor, 1);
        private Border selectionBorder = BorderFactory.createLineBorder(this.selectionColor, 1);

        protected Object getUserObject() {
            return this.userObject;
        }

        protected JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public ClassTreeCellRenderer() {
            this.setLayout(new FlowLayout(0, 2, 0));
            this.setBorder(this.normalBorder);
            this.setOpaque(true);
            this.setBackground(this.backgroundColor);
            this.checkBox = new JCheckBox();
            this.checkBox.setMargin(new Insets(0, 0, 0, 0));
            this.checkBox.setOpaque(true);
            this.checkBox.setBackground(this.backgroundColor);
            this.add(this.checkBox);
            this.label = new JLabel();
            this.label.setOpaque(true);
            this.label.setBackground(this.backgroundColor);
            this.add(this.label);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            this.userObject = defaultMutableTreeNode.getUserObject();
            if (defaultMutableTreeNode.getUserObject() == null) {
                return this;
            }
            OClass oClass = (OClass)defaultMutableTreeNode.getUserObject();
            this.checkBox.setSelected(OntologyClassView.this.highlightedClasses.contains(oClass));
            this.checkBox.setBackground(bl ? this.selectionColor : this.backgroundColor);
            this.label.setText(oClass.getName());
            this.label.setBackground(OntologyClassView.this.colorByClassMap.containsKey(oClass) ? OntologyClassView.this.colorByClassMap.get(oClass) : (bl ? this.selectionColor : this.backgroundColor));
            this.setBackground(bl ? this.selectionColor : this.backgroundColor);
            this.setBorder(bl ? this.selectionBorder : this.normalBorder);
            return this;
        }
    }

    protected class MouseStoppedMovingAction
    extends AbstractAction {
        int textLocation;

        protected MouseStoppedMovingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            List<LanguageResource> list = Gate.getCreoleRegister().getPublicLrInstances();
            HashMap<String, Ontology> hashMap = new HashMap<String, Ontology>();
            for (LanguageResource object2 : list) {
                if (!(object2 instanceof Ontology)) continue;
                Serializable n2 = (Ontology)object2;
                object = n2.getDefaultNameSpace();
                object = ((String)object).substring(0, ((String)object).length() - 1);
                hashMap.put((String)object, (Ontology)n2);
            }
            String string = (String)OntologyClassView.this.setComboBox.getSelectedItem();
            for (Serializable n2 : OntologyClassView.this.document.getAnnotations(string).get("Mention").get(Math.max(0L, (long)(this.textLocation - 1)), Math.min(OntologyClassView.this.document.getContent().size(), (long)(this.textLocation + 1)))) {
                OClass oClass;
                Ontology ontology;
                object = n2.getFeatures();
                if (object.get(OntologyClassView.ONTOLOGY) == null || object.get(OntologyClassView.CLASS) == null || object.get(OntologyClassView.INSTANCE) == null || (ontology = (Ontology)hashMap.get((String)object.get(OntologyClassView.ONTOLOGY))) == null || (oClass = ontology.getOClass(ontology.createOURI((String)object.get(OntologyClassView.CLASS)))) == null || !OntologyClassView.this.highlightedClasses.contains(oClass)) continue;
                JTree jTree = OntologyClassView.this.treeByOntologyMap.get(ontology);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getModel().getRoot();
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.preorderEnumeration();
                boolean bl = false;
                while (!bl && enumeration.hasMoreElements()) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    bl = defaultMutableTreeNode.getUserObject() instanceof OClass && defaultMutableTreeNode.getUserObject().equals(oClass);
                }
                if (!bl) continue;
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                jTree.setSelectionPath(treePath);
                jTree.scrollPathToVisible(treePath);
                SwingUtilities.invokeLater(new Runnable((FeatureMap)object){
                    final /* synthetic */ FeatureMap val$features;
                    {
                        this.val$features = featureMap;
                    }

                    public void run() {
                        OntologyClassView.this.instanceView.selectInstance(ontology.getOInstance(ontology.createOURI((String)this.val$features.get(OntologyClassView.INSTANCE))));
                    }
                });
                break;
            }
            int n = OntologyClassView.this.textArea.getSelectionStart();
            int n2 = OntologyClassView.this.textArea.getSelectionEnd();
            object = OntologyClassView.this.textArea.getSelectedText();
            if (this.textLocation == -1 || OntologyClassView.this.selectedClass == null || object == null || n > this.textLocation || n2 < this.textLocation || n == n2) {
                return;
            }
            OntologyClassView.this.textArea.setSelectionStart(n);
            OntologyClassView.this.textArea.setSelectionEnd(n);
            OntologyClassView.this.instanceView.addSelectionToFilter(OntologyClassView.this.selectedSet, (String)object, n, n2);
        }

        public void setTextLocation(int n) {
            this.textLocation = n;
        }
    }

    protected class TextMouseListener
    extends MouseInputAdapter {
        protected TextMouseListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            OntologyClassView.this.mouseMovementTimer.stop();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiersEx();
            if ((n & 0x80) != 0) {
                OntologyClassView.this.mouseMovementTimer.stop();
                return;
            }
            if ((n & 0x400) != 0) {
                OntologyClassView.this.mouseMovementTimer.stop();
                return;
            }
            int n2 = OntologyClassView.this.textArea.viewToModel(mouseEvent.getPoint());
            try {
                block7: {
                    try {
                        Rectangle rectangle = OntologyClassView.this.textArea.modelToView(n2);
                        int n3 = 10;
                        rectangle = new Rectangle(rectangle.x - n3, rectangle.y - n3, rectangle.width + 2 * n3, rectangle.height + 2 * n3);
                        if (rectangle.contains(mouseEvent.getPoint())) {
                            OntologyClassView.this.mouseStoppedMovingAction.setTextLocation(n2);
                            break block7;
                        }
                        OntologyClassView.this.mouseStoppedMovingAction.setTextLocation(-1);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new LuckyException(badLocationException);
                    }
                }
                Object var7_7 = null;
                OntologyClassView.this.mouseMovementTimer.restart();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OntologyClassView.this.mouseMovementTimer.restart();
                throw throwable;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            OntologyClassView.this.mouseMovementTimer.stop();
        }
    }
}

