/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.FeatureMap;
import gate.Node;
import gate.annotation.AnnotationImpl;
import gate.annotation.NodeImpl;
import gate.gui.docview.AnnotationSetsView;
import gate.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.MouseInputAdapter;

public class AnnotationStack
extends JPanel {
    ArrayList<StackRow> stackRows;
    int maxTextLength = 150;
    int maxFeatureValueLength = 30;
    JButton lastRowButton;
    String text = "";
    int expressionStartOffset = 0;
    int expressionEndOffset = 0;
    int contextBeforeSize = 10;
    int contextAfterSize = 10;
    String expressionTooltip = "";
    StackMouseListener textMouseListener;
    StackMouseListener headerMouseListener;
    StackMouseListener annotationMouseListener;
    public static final int CROP_START = 0;
    public static final int CROP_MIDDLE = 1;
    public static final int CROP_END = 2;

    public AnnotationStack() {
        this.init();
    }

    public AnnotationStack(int n, int n2) {
        this.maxTextLength = n;
        this.maxFeatureValueLength = n2;
        this.init();
    }

    void init() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.stackRows = new ArrayList();
        this.textMouseListener = new StackMouseListener();
        this.headerMouseListener = new StackMouseListener();
        this.annotationMouseListener = new StackMouseListener();
    }

    public void addRow(String string, String string2, String string3, JButton jButton, String string4, int n) {
        this.stackRows.add(new StackRow(string, string2, string3, jButton, string4, n));
    }

    public void addAnnotation(int n, int n2, String string, FeatureMap featureMap) {
        this.stackRows.get(this.stackRows.size() - 1).addAnnotation(StackAnnotation.createAnnotation(n, n2, string, featureMap));
    }

    public void addAnnotation(Annotation annotation) {
        this.stackRows.get(this.stackRows.size() - 1).addAnnotation(StackAnnotation.createAnnotation(annotation));
    }

    public void clearAllRows() {
        this.stackRows.clear();
    }

    public void drawStack() {
        String string;
        this.removeAll();
        boolean bl = this.text.length() > this.maxTextLength;
        int n = this.text.length() - this.maxTextLength / 2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        JLabel jLabel = new JLabel("Context");
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        jLabel.setBorder(new CompoundBorder(new EtchedBorder(1, new Color(250, 250, 250), new Color(250, 250, 250).darker()), new EmptyBorder(new Insets(0, 2, 0, 2))));
        jLabel.setToolTipText("Expression and its context.");
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        int n2 = this.contextBeforeSize;
        int n3 = this.text.length() - this.contextAfterSize;
        for (int i = 0; i < this.text.length(); ++i) {
            gridBagConstraints.gridx = i + 1;
            if (bl) {
                if (i == this.maxTextLength / 2) {
                    this.add((Component)new JLabel("..."), gridBagConstraints);
                    i = n + 1;
                    continue;
                }
                if (i > n) {
                    gridBagConstraints.gridx -= n - this.maxTextLength / 2 + 1;
                }
            }
            JLabel object = new JLabel(this.text.substring(i, i + 1));
            if (i >= n2 && i < n3) {
                object.setBackground(new Color(240, 201, 184));
            } else {
                object.setBackground(Color.WHITE);
            }
            object.setOpaque(true);
            int n4 = this.text.lastIndexOf(" ", i);
            int n5 = this.text.indexOf(" ", i);
            string = this.text.substring(n4 == -1 ? 0 : n4, n5 == -1 ? this.text.length() : n5);
            object.addMouseListener(this.textMouseListener.createListener(string));
            this.add((Component)object, gridBagConstraints);
        }
        for (StackRow stackRow : this.stackRows) {
            String string2 = stackRow.getType();
            String string3 = stackRow.getFeature();
            if (string3 == null) {
                string3 = "";
            }
            if ((string = stackRow.getShortcut()) == null) {
                string = "";
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(0, 0, 3, 0);
            JLabel jLabel2 = new JLabel();
            String string4 = string2 + (string3.equals("") ? "" : ".") + string3;
            jLabel2.setText(!string.equals("") ? string : (stackRow.getSet() != null ? stackRow.getSet() + "#" + string4 : string4));
            jLabel2.setOpaque(true);
            jLabel2.setBackground(Color.WHITE);
            jLabel2.setBorder(new CompoundBorder(new EtchedBorder(1, new Color(250, 250, 250), new Color(250, 250, 250).darker()), new EmptyBorder(new Insets(0, 2, 0, 2))));
            if (string3.equals("")) {
                jLabel2.addMouseListener(this.headerMouseListener.createListener(string2));
            } else {
                jLabel2.addMouseListener(this.headerMouseListener.createListener(string2, string3));
            }
            gridBagConstraints.insets = new Insets(0, 10, 3, 10);
            this.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 3, 0);
            HashMap<Integer, TreeSet<Integer>> hashMap = new HashMap<Integer, TreeSet<Integer>>();
            int n6 = gridBagConstraints.gridy;
            for (StackAnnotation stackAnnotation : stackRow.getAnnotations()) {
                int n7;
                String string5;
                gridBagConstraints.gridx = stackAnnotation.getStartNode().getOffset().intValue() - this.expressionStartOffset + this.contextBeforeSize + 1;
                gridBagConstraints.gridwidth = stackAnnotation.getEndNode().getOffset().intValue() - stackAnnotation.getStartNode().getOffset().intValue();
                if (gridBagConstraints.gridx == 0) {
                    --gridBagConstraints.gridwidth;
                    gridBagConstraints.gridx = 1;
                } else if (gridBagConstraints.gridx < 0) {
                    gridBagConstraints.gridwidth += gridBagConstraints.gridx - 1;
                    gridBagConstraints.gridx = 1;
                }
                if (gridBagConstraints.gridx + gridBagConstraints.gridwidth > this.text.length()) {
                    gridBagConstraints.gridwidth = this.text.length() - gridBagConstraints.gridx + 1;
                }
                if (bl) {
                    if (gridBagConstraints.gridx > n + 1) {
                        gridBagConstraints.gridx -= n - this.maxTextLength / 2 + 1;
                    } else if (gridBagConstraints.gridx > this.maxTextLength / 2) {
                        if (gridBagConstraints.gridx + gridBagConstraints.gridwidth <= n + 3) continue;
                        gridBagConstraints.gridwidth -= n - gridBagConstraints.gridx + 2;
                        gridBagConstraints.gridx = this.maxTextLength / 2 + 2;
                    } else if (gridBagConstraints.gridx + gridBagConstraints.gridwidth >= this.maxTextLength / 2) {
                        gridBagConstraints.gridwidth = gridBagConstraints.gridx + gridBagConstraints.gridwidth < n ? this.maxTextLength / 2 - gridBagConstraints.gridx + 1 : (gridBagConstraints.gridwidth -= n - this.maxTextLength / 2 + 1);
                    }
                }
                if (gridBagConstraints.gridwidth == 0) {
                    gridBagConstraints.gridwidth = 1;
                }
                JLabel jLabel3 = new JLabel();
                Object v = stackAnnotation.getFeatures().get(string3);
                String string6 = string5 = v == null ? " " : Strings.toString(v);
                if (string5.length() > this.maxFeatureValueLength) {
                    jLabel3.setToolTipText(string5.length() > 500 ? "<html><textarea rows=\"30\" cols=\"40\" readonly=\"readonly\">" + string5.replaceAll("(.{50,60})\\b", "$1\n") + "</textarea></html>" : (string5.length() > 100 ? "<html><table width=\"500\" border=\"0\" cellspacing=\"0\"><tr><td>" + string5.replaceAll("\n", "<br>") + "</td></tr></table></html>" : string5));
                    string5 = stackRow.getCrop() == 0 ? "..." + string5.substring(string5.length() - this.maxFeatureValueLength - 1) : (stackRow.getCrop() == 2 ? string5.substring(0, this.maxFeatureValueLength - 2) + "..." : string5.substring(0, this.maxFeatureValueLength / 2) + "..." + string5.substring(string5.length() - this.maxFeatureValueLength / 2));
                }
                jLabel3.setText(string5);
                jLabel3.setBackground(AnnotationSetsView.getColor(stackRow.getSet(), stackAnnotation.getType()));
                jLabel3.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                jLabel3.setOpaque(true);
                if (string3.equals("")) {
                    jLabel3.addMouseListener(this.annotationMouseListener.createListener(stackRow.getSet(), string2, String.valueOf(stackAnnotation.getId())));
                    String string7 = Strings.toString((Object)stackAnnotation.getFeatures()).length() > 100 ? "500" : "100%";
                    String treeSet = "<html><table width=\"" + string7 + "\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">";
                    Color color = (Color)UIManager.get("ToolTip.background");
                    float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                    color = Color.getHSBColor(fArray[0], fArray[1], Math.max(0.0f, fArray[2] - fArray[2] * 0.075f));
                    String string8 = Integer.toHexString(color.getRed()) + Integer.toHexString(color.getGreen()) + Integer.toHexString(color.getBlue());
                    boolean bl2 = false;
                    for (Map.Entry entry : stackAnnotation.getFeatures().entrySet()) {
                        treeSet = treeSet + "<tr align=\"left\"" + (bl2 ? " bgcolor=\"#" + string8 + "\"" : "") + "><td><strong>" + entry.getKey() + "</strong></td><td>" + (Strings.toString(entry.getValue()).length() > 500 ? "<textarea rows=\"20\" cols=\"40\" cellspacing=\"0\">" + Strings.toString(entry.getValue()).replaceAll("(.{50,60})\\b", "$1\n") + "</textarea>" : Strings.toString(entry.getValue()).replaceAll("\n", "<br>")) + "</td></tr>";
                        bl2 = !bl2;
                    }
                    jLabel3.setToolTipText(treeSet + "</table></html>");
                } else {
                    jLabel3.addMouseListener(this.annotationMouseListener.createListener(stackRow.getSet(), string2, string3, Strings.toString(stackAnnotation.getFeatures().get(string3)), String.valueOf(stackAnnotation.getId())));
                }
                for (int i = n7 = gridBagConstraints.gridy; i <= n6 + 1; ++i) {
                    boolean bl3 = true;
                    for (int j = gridBagConstraints.gridx; j < gridBagConstraints.gridx + gridBagConstraints.gridwidth && bl3; ++j) {
                        bl3 = !hashMap.containsKey(j) || !((TreeSet)hashMap.get(j)).contains(i);
                    }
                    if (!bl3) continue;
                    gridBagConstraints.gridy = i;
                    break;
                }
                for (int bl3 = gridBagConstraints.gridx; bl3 < gridBagConstraints.gridx + gridBagConstraints.gridwidth; ++bl3) {
                    TreeSet<Integer> treeSet = (TreeSet<Integer>)hashMap.get(bl3);
                    if (treeSet == null) {
                        treeSet = new TreeSet<Integer>();
                    }
                    treeSet.add(gridBagConstraints.gridy);
                    hashMap.put(bl3, treeSet);
                }
                this.add((Component)jLabel3, gridBagConstraints);
                n6 = Math.max(n6, gridBagConstraints.gridy);
                gridBagConstraints.gridy = n7;
            }
            gridBagConstraints.gridwidth = 1;
            if (stackRow.getLastColumnButton() != null) {
                gridBagConstraints.gridx = Math.min(this.text.length(), this.maxTextLength) + 1;
                gridBagConstraints.insets = new Insets(0, 10, 3, 0);
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                this.add((Component)stackRow.getLastColumnButton(), gridBagConstraints);
                gridBagConstraints.insets = new Insets(0, 0, 3, 0);
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 10;
            }
            gridBagConstraints.gridy = n6;
        }
        if (this.lastRowButton != null) {
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            this.add((Component)this.lastRowButton, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = Math.min(this.text.length(), this.maxTextLength) + 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JLabel(""), gridBagConstraints);
        this.validate();
        this.updateUI();
    }

    public void setLastRowButton(JButton jButton) {
        this.lastRowButton = jButton;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setExpressionStartOffset(int n) {
        this.expressionStartOffset = n;
    }

    public void setExpressionEndOffset(int n) {
        this.expressionEndOffset = n;
    }

    public void setContextBeforeSize(int n) {
        this.contextBeforeSize = n;
    }

    public void setContextAfterSize(int n) {
        this.contextAfterSize = n;
    }

    public void setExpressionTooltip(String string) {
        this.expressionTooltip = string;
    }

    public void setTextMouseListener(StackMouseListener stackMouseListener) {
        this.textMouseListener = stackMouseListener;
    }

    public void setHeaderMouseListener(StackMouseListener stackMouseListener) {
        this.headerMouseListener = stackMouseListener;
    }

    public void setAnnotationMouseListener(StackMouseListener stackMouseListener) {
        this.annotationMouseListener = stackMouseListener;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StackRow {
        String set;
        String type;
        String feature;
        Set<StackAnnotation> annotations;
        JButton lastColumnButton;
        String shortcut;
        int crop;

        StackRow(String string, String string2, String string3, JButton jButton, String string4, int n) {
            this.set = string;
            this.type = string2;
            this.feature = string3;
            this.annotations = new HashSet<StackAnnotation>();
            this.lastColumnButton = jButton;
            this.shortcut = string4;
            this.crop = n;
        }

        public String getSet() {
            return this.set;
        }

        public String getType() {
            return this.type;
        }

        public String getFeature() {
            return this.feature;
        }

        public Set<StackAnnotation> getAnnotations() {
            return this.annotations;
        }

        public JButton getLastColumnButton() {
            return this.lastColumnButton;
        }

        public String getShortcut() {
            return this.shortcut;
        }

        public int getCrop() {
            return this.crop;
        }

        public void addAnnotation(StackAnnotation stackAnnotation) {
            this.annotations.add(stackAnnotation);
        }
    }

    private static class StackAnnotation
    extends AnnotationImpl {
        StackAnnotation(Integer n, Node node, Node node2, String string, FeatureMap featureMap) {
            super(n, node, node2, string, featureMap);
        }

        static StackAnnotation createAnnotation(int n, int n2, String string, FeatureMap featureMap) {
            NodeImpl nodeImpl = new NodeImpl(-1, Long.valueOf(n));
            NodeImpl nodeImpl2 = new NodeImpl(-1, Long.valueOf(n2));
            return new StackAnnotation(-1, nodeImpl, nodeImpl2, string, featureMap);
        }

        static StackAnnotation createAnnotation(Annotation annotation) {
            return new StackAnnotation(annotation.getId(), annotation.getStartNode(), annotation.getEndNode(), annotation.getType(), annotation.getFeatures());
        }
    }

    public static class StackMouseListener
    extends MouseInputAdapter {
        public MouseInputAdapter createListener(String ... stringArray) {
            return null;
        }
    }
}

