/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.annedit;

import gate.gui.MainFrame;
import gate.util.LuckyException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;

public class SearchExpressionsAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private JTextField sourceTextField;
    private Window annotationEditorWindow;
    private JCheckBox searchRegExpChk;

    public SearchExpressionsAction(JTextField jTextField, Window window, JCheckBox jCheckBox) {
        super("?");
        super.putValue("ShortDescription", "GATE search expression builder.");
        this.sourceTextField = jTextField;
        this.annotationEditorWindow = window;
        this.searchRegExpChk = jCheckBox;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = new String[]{"Number", "Person"};
        String[] stringArray2 = new String[]{"Any character", "The beginning of a line", "The end of a line", "All letters", "Letter uppercase", "Letter lowercase", "Letter titlecase", "Letter modifier", "Letter other", "All Numbers", "Number decimal digit", "Number letter", "Number other", "All punctuations", "Punctuation connector", "Punctuation dash", "Punctuation open", "Punctuation close", "Punctuation initial quote", "Punctuation final quote", "Punctuation other", "All symbols", "Symbol math", "Symbol currency", "Symbol modifier", "Symbol other", "All separators", "Separator space", "Separator line", "Separator paragraph", "All Marks", "Mark nonspacing", "Mark spacing combining", "Mark enclosing", "All others", "Other control", "Other format", "Other surrogate", "Other private use", "Other not assigned", "Any character except Category", "Category1 and/or Category2", "Category1 and Category2"};
        String[] stringArray3 = new String[]{"Either the selection or X", "Once or not at all", "Zero or more times", "One or more times", "Capturing group", "Non-capturing group"};
        final JTextField jTextField = new JTextField(25);
        jTextField.setText(this.sourceTextField.getText());
        JPanel jPanel = new JPanel();
        jPanel.setSize(0, 5);
        final JList<String> jList = new JList<String>(stringArray);
        jList.setVisibleRowCount(Math.min(10, stringArray.length));
        jList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(jList);
        final JButton jButton = new JButton("Replace search expression");
        jButton.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setSize(0, 5);
        final JList<String> jList2 = new JList<String>(stringArray2);
        jList2.setVisibleRowCount(Math.min(10, stringArray2.length));
        jList2.setSelectionMode(0);
        JScrollPane jScrollPane2 = new JScrollPane(jList2);
        final JButton jButton2 = new JButton("Insert at the caret position");
        jButton2.setEnabled(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setSize(0, 5);
        final JList<String> jList3 = new JList<String>(stringArray3);
        jList3.setVisibleRowCount(Math.min(10, stringArray3.length));
        jList3.setSelectionMode(0);
        JScrollPane jScrollPane3 = new JScrollPane(jList3);
        final JButton jButton3 = new JButton("Modify the selection");
        jButton3.setEnabled(false);
        jTextField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                jList3.setEnabled(jTextField.getSelectedText() != null);
            }
        });
        Object[] objectArray = new Object[]{"Current search expression:", jTextField, jPanel, jScrollPane, jButton, jPanel2, jScrollPane2, jButton2, jPanel3, jScrollPane3, jButton3};
        Object[] objectArray2 = new String[]{"OK", "Cancel"};
        JOptionPane jOptionPane = new JOptionPane(objectArray, 3, 0, null, objectArray2, "Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchExpressionsAction.this.modifySearchExpression(jList.getSelectedValue().toString(), jTextField);
            }
        });
        jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getClickCount() == 2) {
                    SearchExpressionsAction.this.modifySearchExpression(jList.getSelectedValue().toString(), jTextField);
                }
            }
        });
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (jList.getSelectedValue() != null) {
                    jButton.setEnabled(true);
                } else {
                    jButton.setEnabled(false);
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchExpressionsAction.this.modifySearchExpression(jList2.getSelectedValue().toString(), jTextField);
            }
        });
        jList2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getClickCount() == 2) {
                    SearchExpressionsAction.this.modifySearchExpression(jList2.getSelectedValue().toString(), jTextField);
                }
            }
        });
        jList2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (jList2.getSelectedValue() != null) {
                    jButton2.setEnabled(true);
                } else {
                    jButton2.setEnabled(false);
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchExpressionsAction.this.modifySearchExpression(jList3.getSelectedValue().toString(), jTextField);
            }
        });
        jList3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getClickCount() == 2 && jList3.isEnabled()) {
                    SearchExpressionsAction.this.modifySearchExpression(jList3.getSelectedValue().toString(), jTextField);
                }
            }
        });
        jList3.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (jList3.getSelectedValue() != null) {
                    jButton3.setEnabled(true);
                } else {
                    jButton3.setEnabled(false);
                }
            }
        });
        this.annotationEditorWindow.setVisible(false);
        JDialog jDialog = jOptionPane.createDialog(MainFrame.getInstance(), "GATE search expression builder");
        jTextField.setCaretPosition(this.sourceTextField.getSelectionStart() == this.sourceTextField.getCaretPosition() ? this.sourceTextField.getSelectionEnd() : this.sourceTextField.getSelectionStart());
        jTextField.moveCaretPosition(this.sourceTextField.getCaretPosition());
        jTextField.requestFocus();
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object.equals("OK")) {
            if (this.searchRegExpChk != null) {
                this.searchRegExpChk.setSelected(true);
            }
            this.sourceTextField.setText(jTextField.getText());
        }
        this.annotationEditorWindow.setVisible(true);
    }

    private void modifySearchExpression(String string, JTextField jTextField) {
        if (string == null || !(string instanceof String)) {
            return;
        }
        int n = jTextField.getCaretPosition();
        int n2 = jTextField.getSelectionStart();
        int n3 = jTextField.getSelectionEnd();
        try {
            if (string.equals("Number")) {
                jTextField.setText("\\b[\\p{N}][\\p{N},.]*\\b");
            } else if (string.equals("Person")) {
                jTextField.setText("\\p{Lu}\\p{L}+, \\p{Lu}\\.(?: \\p{Lu}\\.)*");
            } else if (string.equals("Either the selection or X")) {
                jTextField.getDocument().insertString(n2, "(?:", null);
                jTextField.getDocument().insertString(n3 + 3, ")|(?:X)", null);
            } else if (string.equals("Once or not at all")) {
                jTextField.getDocument().insertString(n2, "(?:", null);
                jTextField.getDocument().insertString(n3 + 3, ")?", null);
            } else if (string.equals("Zero or more times")) {
                jTextField.getDocument().insertString(n2, "(?:", null);
                jTextField.getDocument().insertString(n3 + 3, ")*", null);
            } else if (string.equals("One or more times")) {
                jTextField.getDocument().insertString(n2, "(?:", null);
                jTextField.getDocument().insertString(n3 + 3, ")+", null);
            } else if (string.equals("Capturing group")) {
                jTextField.getDocument().insertString(n2, "(?:", null);
                jTextField.getDocument().insertString(n3 + 3, ")", null);
            } else if (string.equals("Non-capturing group")) {
                jTextField.getDocument().insertString(n2, "(?:", null);
                jTextField.getDocument().insertString(n3 + 3, ")", null);
            } else if (string.equals("Any character")) {
                jTextField.getDocument().insertString(n, ".", null);
            } else if (string.equals("The beginning of a line")) {
                jTextField.getDocument().insertString(n, "^", null);
            } else if (string.equals("The end of a line")) {
                jTextField.getDocument().insertString(n, "$", null);
            } else if (string.equals("Any character except Category")) {
                jTextField.getDocument().insertString(n, "\\P{Category}", null);
            } else if (string.equals("Category1 and/or Category2")) {
                jTextField.getDocument().insertString(n, "[\\p{Category1}\\p{Category2}]", null);
            } else if (string.equals("Category1 and Category2")) {
                jTextField.getDocument().insertString(n, "[\\p{Category1}&&\\p{Category2}]", null);
            } else if (string.equals("All letters")) {
                jTextField.getDocument().insertString(n, "\\p{L}", null);
            } else if (string.equals("Letter uppercase")) {
                jTextField.getDocument().insertString(n, "\\p{Lu}", null);
            } else if (string.equals("Letter lowercase")) {
                jTextField.getDocument().insertString(n, "\\p{Ll}", null);
            } else if (string.equals("Letter titlecase")) {
                jTextField.getDocument().insertString(n, "\\p{Lt}", null);
            } else if (string.equals("Letter modifier")) {
                jTextField.getDocument().insertString(n, "\\p{Lm}", null);
            } else if (string.equals("Letter other")) {
                jTextField.getDocument().insertString(n, "\\p{Lo}", null);
            } else if (string.equals("All Marks")) {
                jTextField.getDocument().insertString(n, "\\p{M}", null);
            } else if (string.equals("Mark nonspacing")) {
                jTextField.getDocument().insertString(n, "\\p{Mn}", null);
            } else if (string.equals("Mark spacing combining")) {
                jTextField.getDocument().insertString(n, "\\p{Mc}", null);
            } else if (string.equals("Mark enclosing")) {
                jTextField.getDocument().insertString(n, "\\p{Me}", null);
            } else if (string.equals("All Numbers")) {
                jTextField.getDocument().insertString(n, "\\p{N}", null);
            } else if (string.equals("Number decimal digit")) {
                jTextField.getDocument().insertString(n, "\\p{Nd}", null);
            } else if (string.equals("Number letter")) {
                jTextField.getDocument().insertString(n, "\\p{Nl}", null);
            } else if (string.equals("Number other")) {
                jTextField.getDocument().insertString(n, "\\p{No}", null);
            } else if (string.equals("All separators")) {
                jTextField.getDocument().insertString(n, "\\p{Z}", null);
            } else if (string.equals("Separator space")) {
                jTextField.getDocument().insertString(n, "\\p{Zs}", null);
            } else if (string.equals("Separator line")) {
                jTextField.getDocument().insertString(n, "\\p{Zl}", null);
            } else if (string.equals("Separator paragraph")) {
                jTextField.getDocument().insertString(n, "\\p{Zp}", null);
            } else if (string.equals("All others")) {
                jTextField.getDocument().insertString(n, "\\p{C}", null);
            } else if (string.equals("Other control")) {
                jTextField.getDocument().insertString(n, "\\p{Cc}", null);
            } else if (string.equals("Other format")) {
                jTextField.getDocument().insertString(n, "\\p{Cf}", null);
            } else if (string.equals("Other surrogate")) {
                jTextField.getDocument().insertString(n, "\\p{Cs}", null);
            } else if (string.equals("Other private use")) {
                jTextField.getDocument().insertString(n, "\\p{Co}", null);
            } else if (string.equals("Other not assigned")) {
                jTextField.getDocument().insertString(n, "\\p{Cn}", null);
            } else if (string.equals("All punctuations")) {
                jTextField.getDocument().insertString(n, "\\p{P}", null);
            } else if (string.equals("Punctuation connector")) {
                jTextField.getDocument().insertString(n, "\\p{Pc}", null);
            } else if (string.equals("Punctuation dash")) {
                jTextField.getDocument().insertString(n, "\\p{Pd}", null);
            } else if (string.equals("Punctuation open")) {
                jTextField.getDocument().insertString(n, "\\p{Ps}", null);
            } else if (string.equals("Punctuation close")) {
                jTextField.getDocument().insertString(n, "\\p{Pe}", null);
            } else if (string.equals("Punctuation initial quote")) {
                jTextField.getDocument().insertString(n, "\\p{Pi}", null);
            } else if (string.equals("Punctuation final quote")) {
                jTextField.getDocument().insertString(n, "\\p{Pf}", null);
            } else if (string.equals("Punctuation other")) {
                jTextField.getDocument().insertString(n, "\\p{Po}", null);
            } else if (string.equals("All symbols")) {
                jTextField.getDocument().insertString(n, "\\p{S}", null);
            } else if (string.equals("Symbol math")) {
                jTextField.getDocument().insertString(n, "\\p{Sm}", null);
            } else if (string.equals("Symbol currency")) {
                jTextField.getDocument().insertString(n, "\\p{Sc}", null);
            } else if (string.equals("Symbol modifier")) {
                jTextField.getDocument().insertString(n, "\\p{Sk}", null);
            } else if (string.equals("Symbol other")) {
                jTextField.getDocument().insertString(n, "\\p{So}", null);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new LuckyException(badLocationException);
        }
        jTextField.requestFocus();
    }
}

