/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.annedit;

import gate.Factory;
import gate.FeatureMap;
import gate.creole.AnnotationSchema;
import gate.creole.FeatureSchema;
import gate.creole.ResourceInstantiationException;
import gate.swing.JChoice;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SchemaFeaturesEditor
extends JPanel {
    private static final String BOOLEAN_TRUE = "True";
    private static final String BOOLEAN_FALSE = "False";
    protected AnnotationSchema schema;
    protected Map<String, FeatureSchema> featureSchemas;
    protected FeatureMap featureMap;
    protected Map<String, FeatureEditor> featureEditors;

    public SchemaFeaturesEditor(AnnotationSchema annotationSchema) {
        this.schema = annotationSchema;
        this.featureSchemas = new LinkedHashMap<String, FeatureSchema>();
        if (annotationSchema != null && annotationSchema.getFeatureSchemaSet() != null) {
            for (FeatureSchema featureSchema : annotationSchema.getFeatureSchemaSet()) {
                this.featureSchemas.put(featureSchema.getFeatureName(), featureSchema);
            }
        }
        this.initGui();
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame("New Annotation Editor");
            AnnotationSchema annotationSchema = new AnnotationSchema();
            annotationSchema.setXmlFileUrl(new File("/home/valyt/tmp/bug/schema.xml").toURI().toURL());
            annotationSchema.init();
            final SchemaFeaturesEditor schemaFeaturesEditor = new SchemaFeaturesEditor(annotationSchema);
            jFrame.getContentPane().add((Component)schemaFeaturesEditor, "Center");
            jFrame.pack();
            jFrame.setVisible(true);
            JToolBar jToolBar = new JToolBar();
            jToolBar.add(new AbstractAction("New Values!"){

                public void actionPerformed(ActionEvent actionEvent) {
                    FeatureMap featureMap = Factory.newFeatureMap();
                    featureMap.put("boolean-false", new Boolean(true));
                    featureMap.put("boolean-true", new Boolean(false));
                    featureMap.put("nominal-long", "val10");
                    featureMap.put("nominal-short", "val6");
                    featureMap.put("free-text", "New text!");
                    schemaFeaturesEditor.editFeatureMap(featureMap);
                }
            });
            jToolBar.add(new AbstractAction("Null Values!"){

                public void actionPerformed(ActionEvent actionEvent) {
                    schemaFeaturesEditor.editFeatureMap(null);
                }
            });
            jFrame.getContentPane().add((Component)jToolBar, "North");
        }
        catch (HeadlessException headlessException) {
            headlessException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            resourceInstantiationException.printStackTrace();
        }
    }

    protected void initGui() {
        Object object;
        Object object2;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 0;
        gridBagConstraints.gridx = -1;
        this.featureEditors = new LinkedHashMap<String, FeatureEditor>();
        Set<FeatureSchema> set = this.schema.getFeatureSchemaSet();
        if (set != null) {
            for (FeatureSchema object3 : set) {
                FeatureEditor featureEditor;
                object2 = object3.getFeatureName();
                object = object3.getFeatureValue();
                if (object != null && ((String)object).length() == 0) {
                    object = null;
                }
                Object[] objectArray = null;
                Set set2 = object3.getPermittedValues();
                if (set2 != null && set2.size() > 0) {
                    objectArray = new String[set2.size()];
                    int n2 = 0;
                    for (Object e : set2) {
                        objectArray[n2++] = e.toString();
                    }
                    Arrays.sort(objectArray);
                }
                if (objectArray != null && objectArray.length > 0) {
                    featureEditor = new FeatureEditor((String)object2, (String[])objectArray, (String)object);
                } else if (object3.getFeatureValueClass().equals(Boolean.class)) {
                    Object object4 = null;
                    if (BOOLEAN_FALSE.equals(object)) {
                        object4 = false;
                    } else if (BOOLEAN_TRUE.equals(object)) {
                        object4 = true;
                    }
                    featureEditor = new FeatureEditor((String)object2, (Boolean)object4);
                } else {
                    featureEditor = new FeatureEditor((String)object2, (String)object);
                }
                featureEditor.setRequired(object3.isRequired());
                this.featureEditors.put((String)object2, featureEditor);
            }
        }
        for (String string : this.featureEditors.keySet()) {
            object2 = this.featureEditors.get(string);
            gridBagConstraints.gridy = n++;
            object = new JLabel("<html>" + string + (((FeatureEditor)object2).isRequired() ? "<b><font color='red'>*</font></b>: " : ": ") + "</html>");
            this.add((Component)object, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            this.add((Component)((FeatureEditor)object2).getGui(), gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 21;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    public void editFeatureMap(FeatureMap featureMap) {
        this.featureMap = featureMap;
        this.featureMapUpdated();
    }

    public void featureMapUpdated() {
        Serializable serializable;
        String string;
        Object object;
        if (this.featureMap != null) {
            for (String string2 : new HashSet(this.featureMap.keySet())) {
                if (!this.featureSchemas.keySet().contains(string2)) continue;
                object = this.featureSchemas.get(string2);
                string = this.featureMap.get(string2);
                serializable = ((FeatureSchema)object).getFeatureValueClass();
                if (serializable.equals(Boolean.class) || serializable.equals(Integer.class) || serializable.equals(Short.class) || serializable.equals(Byte.class) || serializable.equals(Float.class) || serializable.equals(Double.class)) {
                    if (((Class)serializable).isAssignableFrom(string.getClass())) continue;
                    this.featureMap.remove(string2);
                    continue;
                }
                if (!serializable.equals(String.class) || ((FeatureSchema)object).getPermittedValues() == null || ((FeatureSchema)object).getPermittedValues().contains(string)) continue;
                this.featureMap.remove(string2);
            }
        }
        for (String string2 : this.featureEditors.keySet()) {
            object = this.featureEditors.get(string2);
            String string3 = string = this.featureMap == null ? null : (String)this.featureMap.get(string2);
            if (string == null) {
                string = ((FeatureEditor)object).getDefaultValue();
                if (string != null && this.featureMap != null) {
                    this.featureMap.put(string2, string);
                }
            } else {
                serializable = this.featureSchemas.get(string2);
                Class<?> clazz = ((FeatureSchema)serializable).getFeatureValueClass();
                if (clazz.equals(Boolean.class)) {
                    string = (Boolean)((Object)string) != false ? BOOLEAN_TRUE : BOOLEAN_FALSE;
                } else if (!clazz.equals(String.class)) {
                    string = string.toString();
                }
            }
            ((FeatureEditor)object).setValue(string);
        }
    }

    protected class FeatureEditor {
        protected JTextField textField;
        protected JCheckBox checkbox;
        protected JChoice jchoice;
        protected Border defaultBorder;
        protected Border highlightBorder;
        protected FeatureType type;
        protected String featureName;
        protected JComponent gui;
        protected String[] values;
        protected boolean required;
        protected ActionListener sharedActionListener;
        protected String defaultValue;
        protected String value;
        private static final int MAX_BUTTONS_FLOW = 10;

        public FeatureEditor(String string, String[] stringArray, String string2) {
            this.featureName = string;
            this.type = FeatureType.nominal;
            this.values = stringArray;
            this.defaultValue = string2;
            this.buildGui();
        }

        public FeatureEditor(String string, Boolean bl) {
            this.featureName = string;
            this.type = FeatureType.bool;
            this.defaultValue = bl != null ? (bl != false ? SchemaFeaturesEditor.BOOLEAN_TRUE : SchemaFeaturesEditor.BOOLEAN_FALSE) : null;
            this.values = new String[]{SchemaFeaturesEditor.BOOLEAN_FALSE, SchemaFeaturesEditor.BOOLEAN_TRUE};
            this.buildGui();
        }

        public FeatureEditor(String string, String string2) {
            this.featureName = string;
            this.type = FeatureType.text;
            this.defaultValue = string2;
            this.values = null;
            this.buildGui();
        }

        protected void buildGui() {
            this.sharedActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = null;
                    if (actionEvent.getSource() == FeatureEditor.this.checkbox) {
                        object = new Boolean(FeatureEditor.this.checkbox.isSelected());
                    } else if (actionEvent.getSource() == FeatureEditor.this.textField) {
                        object = FeatureEditor.this.textField.getText();
                    } else if (actionEvent.getSource() == FeatureEditor.this.jchoice) {
                        object = FeatureEditor.this.jchoice.getSelectedItem();
                        if (object != null && FeatureEditor.this.type == FeatureType.bool) {
                            object = new Boolean(SchemaFeaturesEditor.BOOLEAN_TRUE == object);
                        }
                    } else if (actionEvent.getSource() == SchemaFeaturesEditor.this) {
                        object = FeatureEditor.this.getValue();
                    }
                    if (SchemaFeaturesEditor.this.featureMap != null && actionEvent.getSource() != SchemaFeaturesEditor.this) {
                        if (object != null) {
                            if (object != SchemaFeaturesEditor.this.featureMap.get(FeatureEditor.this.featureName)) {
                                SchemaFeaturesEditor.this.featureMap.put(FeatureEditor.this.featureName, object);
                            }
                        } else {
                            SchemaFeaturesEditor.this.featureMap.remove(FeatureEditor.this.featureName);
                        }
                    }
                    if (FeatureEditor.this.required && object == null) {
                        if (FeatureEditor.this.getGui().getBorder() != FeatureEditor.this.highlightBorder) {
                            FeatureEditor.this.getGui().setBorder(FeatureEditor.this.highlightBorder);
                        }
                    } else if (FeatureEditor.this.getGui().getBorder() != FeatureEditor.this.defaultBorder) {
                        FeatureEditor.this.getGui().setBorder(FeatureEditor.this.defaultBorder);
                    }
                }
            };
            this.gui = new JPanel();
            this.gui.setAlignmentX(0.0f);
            this.gui.setLayout(new BoxLayout(this.gui, 1));
            switch (this.type) {
                case nominal: {
                    this.jchoice = new JChoice(this.values);
                    this.jchoice.setDefaultButtonMargin(new Insets(0, 2, 0, 2));
                    this.jchoice.setMaximumFastChoices(20);
                    this.jchoice.setMaximumWidth(300);
                    this.jchoice.setSelectedItem(this.value);
                    this.jchoice.addActionListener(this.sharedActionListener);
                    this.gui.add(this.jchoice);
                    break;
                }
                case bool: {
                    this.jchoice = new JChoice(this.values);
                    this.jchoice.setDefaultButtonMargin(new Insets(0, 2, 0, 2));
                    this.jchoice.setMaximumFastChoices(20);
                    this.jchoice.setMaximumWidth(300);
                    if (SchemaFeaturesEditor.BOOLEAN_TRUE.equals(this.value)) {
                        this.jchoice.setSelectedItem(SchemaFeaturesEditor.BOOLEAN_TRUE);
                    } else if (SchemaFeaturesEditor.BOOLEAN_FALSE.equals(this.value)) {
                        this.jchoice.setSelectedItem(SchemaFeaturesEditor.BOOLEAN_FALSE);
                    } else {
                        this.jchoice.setSelectedItem(null);
                    }
                    this.jchoice.addActionListener(this.sharedActionListener);
                    this.gui.add(this.jchoice);
                    break;
                }
                case text: {
                    this.gui.setLayout(new BoxLayout(this.gui, 2));
                    this.textField = new JTextField(20);
                    if (this.value != null) {
                        this.textField.setText(this.value);
                    } else if (this.defaultValue != null) {
                        this.textField.setText(this.defaultValue);
                    }
                    this.textField.addActionListener(this.sharedActionListener);
                    this.textField.getDocument().addDocumentListener(new DocumentListener(){

                        public void changedUpdate(DocumentEvent documentEvent) {
                        }

                        public void insertUpdate(DocumentEvent documentEvent) {
                            FeatureEditor.this.sharedActionListener.actionPerformed(new ActionEvent(FeatureEditor.this.textField, 1001, null));
                        }

                        public void removeUpdate(DocumentEvent documentEvent) {
                            FeatureEditor.this.sharedActionListener.actionPerformed(new ActionEvent(FeatureEditor.this.textField, 1001, null));
                        }
                    });
                    this.gui.add(this.textField);
                }
            }
            this.defaultBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            this.highlightBorder = BorderFactory.createLineBorder(Color.RED, 2);
            this.gui.setBorder(this.defaultBorder);
        }

        public FeatureType getType() {
            return this.type;
        }

        public void setType(FeatureType featureType) {
            this.type = featureType;
        }

        public String[] getValues() {
            return this.values;
        }

        public void setValues(String[] stringArray) {
            this.values = stringArray;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String string) {
            this.defaultValue = string;
        }

        public void setValue(String string) {
            switch (this.type) {
                case nominal: {
                    this.jchoice.setSelectedItem(string);
                    break;
                }
                case bool: {
                    if (SchemaFeaturesEditor.BOOLEAN_TRUE.equals(string)) {
                        this.jchoice.setSelectedItem(SchemaFeaturesEditor.BOOLEAN_TRUE);
                        break;
                    }
                    if (SchemaFeaturesEditor.BOOLEAN_FALSE.equals(string)) {
                        this.jchoice.setSelectedItem(SchemaFeaturesEditor.BOOLEAN_FALSE);
                        break;
                    }
                    this.jchoice.setSelectedItem(null);
                    break;
                }
                case text: {
                    this.textField.setText(string);
                }
            }
            this.sharedActionListener.actionPerformed(new ActionEvent(SchemaFeaturesEditor.this, 1001, ""));
        }

        public Object getValue() {
            switch (this.type) {
                case nominal: {
                    return this.jchoice.getSelectedItem();
                }
                case bool: {
                    Object object = this.jchoice.getSelectedItem();
                    return object == null ? null : new Boolean(object == SchemaFeaturesEditor.BOOLEAN_TRUE);
                }
                case text: {
                    return this.textField.getText();
                }
            }
            return null;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public void setFeatureName(String string) {
            this.featureName = string;
        }

        public JComponent getGui() {
            if (this.gui == null) {
                this.buildGui();
            }
            return this.gui;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean bl) {
            this.required = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FeatureType {
        nominal,
        bool,
        text;

    }
}

