/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.gui.MainFrame;
import gate.swing.XJFileChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class TrecWebFileInputDialog
extends JPanel {
    JTextField urlTextField;
    JButton filerBtn;
    JTextField encodingTextField;

    public TrecWebFileInputDialog() {
        this.initGUIComponents();
        this.initListeners();
    }

    protected void initGUIComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("TrecWeb File URL:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.urlTextField = new JTextField(40);
        this.add((Component)this.urlTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        this.filerBtn = new JButton(MainFrame.getIcon("open-file"));
        this.add((Component)this.filerBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Encoding:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.encodingTextField = new JTextField(15);
        this.add((Component)this.encodingTextField, gridBagConstraints);
    }

    protected void initListeners() {
        this.filerBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XJFileChooser xJFileChooser = MainFrame.getFileChooser();
                xJFileChooser.setFileSelectionMode(0);
                xJFileChooser.setDialogTitle("Select a file");
                xJFileChooser.resetChoosableFileFilters();
                xJFileChooser.setAcceptAllFileFilterUsed(true);
                xJFileChooser.setFileFilter(xJFileChooser.getAcceptAllFileFilter());
                int n = xJFileChooser.showOpenDialog(TrecWebFileInputDialog.this);
                if (n == 0) {
                    try {
                        TrecWebFileInputDialog.this.urlTextField.setText(xJFileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void setUrlString(String string) {
        this.urlTextField.setText(string);
    }

    public String getUrlString() {
        return this.urlTextField.getText();
    }

    public String getEncoding() {
        return this.encodingTextField.getText();
    }

    public void setEncoding(String string) {
        this.encodingTextField.setText(string);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Gate.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFrame jFrame = new JFrame("Foo");
        TrecWebFileInputDialog trecWebFileInputDialog = new TrecWebFileInputDialog();
        jFrame.getContentPane().add(trecWebFileInputDialog);
        jFrame.pack();
        jFrame.setResizable(false);
        jFrame.setVisible(true);
    }
}

