/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import com.ontotext.gate.vr.Gaze;
import gate.Controller;
import gate.CreoleRegister;
import gate.DataStore;
import gate.DataStoreRegister;
import gate.Document;
import gate.Executable;
import gate.Factory;
import gate.Gate;
import gate.LanguageResource;
import gate.Main;
import gate.ProcessingResource;
import gate.Resource;
import gate.VisualResource;
import gate.creole.ANNIEConstants;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.SerialAnalyserController;
import gate.creole.gazetteer.Gazetteer;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.ActionsPublisher;
import gate.gui.AnnotationDiffGUI;
import gate.gui.BootStrapDialog;
import gate.gui.Handle;
import gate.gui.HelpFrame;
import gate.gui.ListEditorDialog;
import gate.gui.LogArea;
import gate.gui.NameBearerHandle;
import gate.gui.NewResourceDialog;
import gate.gui.OkCancelDialog;
import gate.gui.OptionsDialog;
import gate.gui.PluginManagerUI;
import gate.gui.Splash;
import gate.gui.TabHighlighter;
import gate.persist.PersistenceException;
import gate.security.Group;
import gate.security.SecurityException;
import gate.security.Session;
import gate.security.User;
import gate.swing.ErrorDialog;
import gate.swing.JMenuButton;
import gate.swing.XJFileChooser;
import gate.swing.XJMenu;
import gate.swing.XJMenuItem;
import gate.swing.XJPopupMenu;
import gate.swing.XJTabbedPane;
import gate.util.Benchmark;
import gate.util.CorpusBenchmarkTool;
import gate.util.ExtensionFileFilter;
import gate.util.Files;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.LuckyException;
import gate.util.NameBearer;
import gate.util.OptionsMap;
import gate.util.Out;
import gate.util.persistence.PersistenceManager;
import gate.util.reporting.DocTimeReporter;
import gate.util.reporting.PRTimeReporter;
import gate.util.reporting.exceptions.BenchmarkReportException;
import guk.Editor;
import guk.im.GateIMDescriptor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import junit.framework.Assert;
import mpi.alt.java.awt.im.spi.lookup.LookupDescriptor;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends JFrame
implements ProgressListener,
StatusListener,
CreoleListener {
    protected static final Logger log = Logger.getLogger(MainFrame.class);
    protected JMenuBar menuBar;
    protected JSplitPane mainSplit;
    protected JSplitPane leftSplit;
    protected JLabel statusBar;
    protected JButton alertButton;
    protected JProgressBar progressBar;
    protected JProgressBar globalProgressBar;
    protected XJTabbedPane mainTabbedPane;
    protected JScrollPane lowerScroll;
    protected JPopupMenu appsPopup;
    protected JPopupMenu dssPopup;
    protected JPopupMenu lrsPopup;
    protected JPopupMenu prsPopup;
    protected JCheckBoxMenuItem verboseModeItem;
    protected JTree resourcesTree;
    protected JScrollPane resourcesTreeScroll;
    protected DefaultTreeModel resourcesTreeModel;
    protected DefaultMutableTreeNode resourcesTreeRoot;
    protected DefaultMutableTreeNode applicationsRoot;
    protected DefaultMutableTreeNode languageResourcesRoot;
    protected DefaultMutableTreeNode processingResourcesRoot;
    protected DefaultMutableTreeNode datastoresRoot;
    protected Splash splash;
    protected PluginManagerUI pluginManager;
    protected LogArea logArea;
    protected JScrollPane logScroll;
    protected JToolBar toolbar;
    protected static XJFileChooser fileChooser;
    private static MainFrame instance;
    protected OptionsDialog optionsDialog;
    protected CartoonMinder animator;
    protected TabHighlighter logHighlighter;
    protected NewResourceDialog newResourceDialog;
    protected HelpFrame helpFrame;
    protected static Map<String, Icon> iconByName;
    protected static Collection<Component> guiRoots;
    protected static final String[] ICON_EXTENSIONS;
    private static JDialog guiLock;
    private static final Pattern START_RUNNING_PATTERN;
    private boolean titleChangable = false;

    public static Icon getIcon(String string) {
        Icon icon = iconByName.get(string);
        for (int i = 0; i < ICON_EXTENSIONS.length && icon == null; ++i) {
            String string2 = ICON_EXTENSIONS[i];
            String string3 = string + string2;
            URL uRL = string3.charAt(0) == '/' ? Files.getResource(string3) : Files.getGateResource("/img/" + string3);
            if (uRL == null) continue;
            icon = new ImageIcon(uRL);
            iconByName.put(string, icon);
        }
        return icon;
    }

    public static MainFrame getInstance() {
        if (instance == null) {
            instance = new MainFrame();
        }
        return instance;
    }

    public static XJFileChooser getFileChooser() {
        return fileChooser;
    }

    public PrintStream getOriginalOut() {
        return this.logArea.getOriginalOut();
    }

    public PrintStream getOriginalErr() {
        return this.logArea.getOriginalErr();
    }

    protected Handle findHandleForResource(Resource resource) {
        Handle handle = null;
        Enumeration<TreeNode> enumeration = this.resourcesTreeRoot.breadthFirstEnumeration();
        while (enumeration.hasMoreElements() && handle == null) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof DefaultMutableTreeNode) || !((defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode).getUserObject() instanceof Handle) || ((Handle)defaultMutableTreeNode.getUserObject()).getTarget() != resource) continue;
            handle = (Handle)defaultMutableTreeNode.getUserObject();
        }
        return handle;
    }

    public Handle select(Resource resource) {
        Handle handle = this.findHandleForResource(resource);
        if (handle != null) {
            this.select(handle);
        }
        return handle;
    }

    protected void select(Handle handle) {
        JComponent jComponent;
        final JComponent jComponent2 = handle.getLargeView();
        if (handle.viewsBuilt() && this.mainTabbedPane.indexOfComponent(handle.getLargeView()) != -1) {
            if (jComponent2 != null) {
                this.mainTabbedPane.setSelectedComponent(jComponent2);
            }
        } else if (jComponent2 != null) {
            this.mainTabbedPane.addTab(handle.getTitle(), handle.getIcon(), jComponent2, handle.getTooltipText());
            this.mainTabbedPane.setSelectedComponent(handle.getLargeView());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (jComponent2 != null) {
                        if (jComponent2 instanceof JTabbedPane && ((JTabbedPane)jComponent2).getSelectedComponent() != null) {
                            ((JTabbedPane)jComponent2).getSelectedComponent().requestFocus();
                        } else {
                            jComponent2.requestFocus();
                        }
                    }
                }
            });
        }
        if ((jComponent = handle.getSmallView()) != null) {
            this.lowerScroll.getViewport().setView(jComponent);
        } else {
            this.lowerScroll.getViewport().setView(null);
        }
    }

    public MainFrame() {
        this((GraphicsConfiguration)null);
    }

    public MainFrame(GraphicsConfiguration graphicsConfiguration) {
        this(false, graphicsConfiguration);
    }

    public MainFrame(boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        instance = this;
        guiRoots.add(this);
        if (fileChooser == null) {
            fileChooser = new XJFileChooser();
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setAcceptAllFileFilterUsed(true);
            guiRoots.add(fileChooser);
            JDialog jDialog = new JDialog(this, "", true);
            Container container = jDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)fileChooser, "Center");
            jDialog.pack();
            jDialog.getContentPane().removeAll();
            jDialog.dispose();
            jDialog = null;
        }
        this.enableEvents(64L);
        this.initLocalData(bl);
        this.initGuiComponents(bl);
        this.initListeners(bl);
    }

    protected void initLocalData(boolean bl) {
        this.resourcesTreeRoot = new DefaultMutableTreeNode("GATE", true);
        this.applicationsRoot = new DefaultMutableTreeNode("Applications", true);
        this.languageResourcesRoot = bl ? new DefaultMutableTreeNode("Documents", true) : new DefaultMutableTreeNode("Language Resources", true);
        this.processingResourcesRoot = new DefaultMutableTreeNode("Processing Resources", true);
        this.datastoresRoot = new DefaultMutableTreeNode("Datastores", true);
        this.resourcesTreeRoot.add(this.applicationsRoot);
        this.resourcesTreeRoot.add(this.languageResourcesRoot);
        this.resourcesTreeRoot.add(this.processingResourcesRoot);
        this.resourcesTreeRoot.add(this.datastoresRoot);
        this.resourcesTreeModel = new ResourcesTreeModel(this.resourcesTreeRoot, true);
    }

    protected void initGuiComponents(boolean bl) {
        Serializable serializable2;
        String string;
        this.getContentPane().setLayout(new BorderLayout());
        Integer n = Gate.getUserConfig().getInt("Main_frame_width");
        Integer n2 = Gate.getUserConfig().getInt("Main_frame_height");
        this.setSize(new Dimension(n == null ? 800 : n, n2 == null ? 600 : n2));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(Files.getGateResource("/img/gate-icon.png")));
        this.resourcesTree = new ResourcesTree();
        this.resourcesTree.setModel(this.resourcesTreeModel);
        this.resourcesTree.setRowHeight(0);
        this.resourcesTree.setEditable(true);
        ResourcesTreeCellRenderer resourcesTreeCellRenderer = new ResourcesTreeCellRenderer();
        this.resourcesTree.setCellRenderer(resourcesTreeCellRenderer);
        this.resourcesTree.setCellEditor(new ResourcesTreeCellEditor(this.resourcesTree, resourcesTreeCellRenderer));
        this.resourcesTree.setRowHeight(0);
        this.resourcesTree.expandRow(0);
        this.resourcesTree.expandRow(1);
        this.resourcesTree.expandRow(2);
        this.resourcesTree.expandRow(3);
        this.resourcesTree.expandRow(4);
        this.resourcesTree.getSelectionModel().setSelectionMode(4);
        this.resourcesTree.setEnabled(true);
        ToolTipManager.sharedInstance().registerComponent(this.resourcesTree);
        this.resourcesTreeScroll = new JScrollPane(this.resourcesTree);
        this.resourcesTree.setDragEnabled(true);
        this.resourcesTree.setTransferHandler(new TransferHandler(){

            public int getSourceActions(JComponent jComponent) {
                return 1;
            }

            protected Transferable createTransferable(JComponent jComponent) {
                TreePath[] treePathArray = MainFrame.this.resourcesTree.getSelectionPaths();
                if (treePathArray == null) {
                    return new StringSelection("");
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (TreePath treePath : treePathArray) {
                    Handle handle;
                    if (treePath == null) continue;
                    Object object = treePath.getLastPathComponent();
                    if (!((object = ((DefaultMutableTreeNode)object).getUserObject()) instanceof Handle) || !((handle = (Handle)object).getTarget() instanceof Document)) continue;
                    arrayList.add(((Document)handle.getTarget()).getName());
                }
                return new StringSelection("ResourcesTree" + Arrays.toString(arrayList.toArray()));
            }

            protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            }

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                return false;
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                return false;
            }
        });
        this.lowerScroll = new JScrollPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new OverlayLayout(jPanel));
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setOpaque(false);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setOpaque(false);
        jPanel3.add(Box.createVerticalGlue());
        jPanel3.add(jPanel2);
        jPanel4.add(jPanel3);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel.add(jPanel4);
        jPanel.add(this.lowerScroll);
        this.animator = new CartoonMinder(jPanel2);
        Thread thread = new Thread(Thread.currentThread().getThreadGroup(), this.animator, "MainFrame animation");
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        this.leftSplit = new JSplitPane(0, this.resourcesTreeScroll, jPanel);
        this.leftSplit.setResizeWeight(0.7);
        this.leftSplit.setContinuousLayout(true);
        this.leftSplit.setOneTouchExpandable(true);
        this.logArea = new LogArea();
        this.logScroll = new JScrollPane(this.logArea);
        Out.prln("GATE " + Main.version + " build " + Main.build + " started at " + new Date().toString());
        Out.prln("and using Java " + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " on " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version") + ".");
        this.mainTabbedPane = new XJTabbedPane(1);
        this.mainTabbedPane.insertTab("Messages", null, this.logScroll, "GATE log", 0);
        this.logHighlighter = new TabHighlighter(this.mainTabbedPane, this.logScroll, Color.red);
        this.mainSplit = new JSplitPane(1, this.leftSplit, this.mainTabbedPane);
        this.mainSplit.setDividerLocation(this.leftSplit.getPreferredSize().width + 10);
        this.getContentPane().add((Component)this.mainSplit, "Center");
        this.mainSplit.setContinuousLayout(true);
        this.mainSplit.setOneTouchExpandable(true);
        this.statusBar = new JLabel();
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        UIManager.put("ProgressBar.cellSpacing", 0);
        this.progressBar = new JProgressBar(0);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder());
        this.progressBar.setForeground(new Color(150, 75, 150));
        this.progressBar.setStringPainted(false);
        this.globalProgressBar = new JProgressBar(0);
        this.globalProgressBar.setBorder(BorderFactory.createEmptyBorder());
        this.globalProgressBar.setForeground(new Color(150, 75, 150));
        this.globalProgressBar.setStringPainted(true);
        Icon icon = MainFrame.getIcon("crystal-clear-app-error");
        this.alertButton = new JButton(icon);
        this.alertButton.setToolTipText("There was no error");
        this.alertButton.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 5));
        this.alertButton.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        this.alertButton.setEnabled(false);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel5.add((Component)this.statusBar, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        jPanel5.add((Component)this.progressBar, gridBagConstraints);
        jPanel5.add((Component)this.globalProgressBar, gridBagConstraints);
        jPanel5.add((Component)this.alertButton, gridBagConstraints);
        this.getContentPane().add((Component)jPanel5, "South");
        this.progressBar.setVisible(false);
        this.globalProgressBar.setVisible(false);
        this.newResourceDialog = new NewResourceDialog(this, "Resource parameters", true);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Color.WHITE);
        jPanel6.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        JLabel jLabel = new JLabel(MainFrame.getIcon("splash"));
        jPanel6.add((Component)jLabel, gridBagConstraints2);
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = 2;
        try {
            string = Files.getGateResourceAsString("splash.html");
        }
        catch (IOException iOException) {
            string = "GATE";
            log.error((Object)"Couldn't get splash.html resource.", (Throwable)iOException);
        }
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setHorizontalAlignment(0);
        jPanel6.add((Component)jLabel2, gridBagConstraints2);
        gridBagConstraints2.gridy = 3;
        jLabel2 = new JLabel("<HTML><FONT color=\"blue\">Version <B>" + Main.version + "</B></FONT>" + ", <FONT color=\"red\">build <B>" + Main.build + "</B></FONT>" + "<P><B>JVM version</B>: " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + "</HTML>");
        gridBagConstraints2.fill = 2;
        jPanel6.add((Component)jLabel2, gridBagConstraints2);
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = 0;
        final JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.splash.setVisible(false);
            }
        });
        jButton.setBackground(Color.white);
        jPanel6.add((Component)jButton, gridBagConstraints2);
        this.splash = new Splash((Window)this, jPanel6);
        this.splash.getRootPane().setDefaultButton(jButton);
        InputMap inputMap = ((JComponent)this.splash.getContentPane()).getInputMap(2);
        ActionMap actionMap = ((JComponent)this.splash.getContentPane()).getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Apply");
        actionMap.put("Apply", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Cancel");
        actionMap.put("Cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton.doClick();
            }
        });
        this.menuBar = new JMenuBar();
        XJMenu xJMenu = new XJMenu("File", null, this);
        xJMenu.setMnemonic(70);
        LiveMenu liveMenu = new LiveMenu(3);
        liveMenu.setText("New Application");
        liveMenu.setIcon(MainFrame.getIcon("applications"));
        xJMenu.add(liveMenu);
        LiveMenu liveMenu2 = new LiveMenu(1);
        liveMenu2.setText("New Language Resource");
        liveMenu2.setIcon(MainFrame.getIcon("lrs"));
        xJMenu.add(liveMenu2);
        LiveMenu liveMenu3 = new LiveMenu(2);
        liveMenu3.setText("New Processing Resource");
        liveMenu3.setIcon(MainFrame.getIcon("prs"));
        xJMenu.add(liveMenu3);
        XJMenu xJMenu2 = new XJMenu("Datastores", "Repositories for large data", this);
        xJMenu2.setIcon(MainFrame.getIcon("datastores"));
        xJMenu2.add(new XJMenuItem(new NewDSAction(), this));
        xJMenu2.add(new XJMenuItem(new OpenDSAction(), this));
        xJMenu.add(xJMenu2);
        xJMenu.addSeparator();
        xJMenu.add(new XJMenuItem(new LoadResourceFromFileAction(), this));
        RecentAppsMenu recentAppsMenu = new RecentAppsMenu();
        recentAppsMenu.setText("Recent Applications");
        recentAppsMenu.setIcon(MainFrame.getIcon("open-application"));
        xJMenu.add(recentAppsMenu);
        XJMenu xJMenu3 = new XJMenu("Load ANNIE System", "Application that adds morphosyntaxic and semantic annotations", this);
        xJMenu3.setIcon(MainFrame.getIcon("annie-application"));
        xJMenu3.add(new XJMenuItem(new LoadANNIEWithDefaultsAction(), this));
        xJMenu3.add(new XJMenuItem(new LoadANNIEWithoutDefaultsAction(), this));
        xJMenu.add(xJMenu3);
        xJMenu.add(new XJMenuItem(new LoadApplicationAction("Load LingPipe System", "LingPipe", "resources/lingpipe.gapp"), this));
        xJMenu.add(new XJMenuItem(new LoadApplicationAction("Load OpenNLP System", "OpenNLP", "resources/opennlp.gapp"), this));
        xJMenu.add(new XJMenuItem(new ManagePluginsAction(), this));
        if (!Gate.runningOnMac()) {
            xJMenu.addSeparator();
            xJMenu.add(new XJMenuItem(new ExitGateAction(), this));
        }
        this.menuBar.add(xJMenu);
        XJMenu xJMenu4 = new XJMenu("Options", null, this);
        xJMenu4.setMnemonic(79);
        boolean bl2 = false;
        this.optionsDialog = new OptionsDialog(this);
        if (!Gate.runningOnMac()) {
            xJMenu4.add(new XJMenuItem(new AbstractAction("Configuration"){
                private static final long serialVersionUID = 1L;
                {
                    this.putValue("ShortDescription", "Edit GATE options");
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.optionsDialog.showDialog();
                    MainFrame.this.optionsDialog.dispose();
                }
            }, this));
            bl2 = true;
        }
        XJMenu xJMenu5 = null;
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        try {
            Class.forName("guk.im.GateIMDescriptor");
            arrayList.addAll(Arrays.asList(new GateIMDescriptor().getAvailableLocales()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName("mpi.alt.java.awt.im.spi.lookup.LookupDescriptor");
            arrayList.addAll(Arrays.asList(new LookupDescriptor().getAvailableLocales()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Collections.sort(arrayList, new Comparator<Locale>(){

            @Override
            public int compare(Locale locale, Locale locale2) {
                return locale.getDisplayName().compareTo(locale2.getDisplayName());
            }
        });
        if (!arrayList.isEmpty()) {
            xJMenu5 = new XJMenu("Input Methods");
            serializable2 = new ButtonGroup();
            LocaleSelectorMenuItem localeSelectorMenuItem = new LocaleSelectorMenuItem();
            xJMenu5.add(localeSelectorMenuItem);
            localeSelectorMenuItem.setSelected(true);
            xJMenu5.addSeparator();
            ((ButtonGroup)serializable2).add(localeSelectorMenuItem);
            for (Locale serializable3 : arrayList) {
                localeSelectorMenuItem = new LocaleSelectorMenuItem(serializable3);
                xJMenu5.add(localeSelectorMenuItem);
                ((ButtonGroup)serializable2).add(localeSelectorMenuItem);
            }
        }
        if (xJMenu5 != null) {
            xJMenu4.add(xJMenu5);
            bl2 = true;
        }
        if (bl2) {
            this.menuBar.add(xJMenu4);
        }
        serializable2 = new ToolsMenu("Tools", null, this);
        ((AbstractButton)serializable2).setMnemonic(84);
        ((JMenu)serializable2).add(new XJMenuItem(new NewAnnotDiffAction(), this));
        final XJMenuItem xJMenuItem = new XJMenuItem(new AbstractAction("Clear Profiling History"){
            {
                this.putValue("ShortDescription", "Clear profiling history otherwise the report is cumulative.");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(System.getProperty("java.io.tmpdir"), "gate-benchmark-log.txt");
                if (file.exists() && !file.delete()) {
                    log.info((Object)("Error when deleting the file:\n" + file.getAbsolutePath()));
                }
            }
        }, this);
        XJMenu xJMenu6 = new XJMenu("Profiling Reports", "Generates profiling reports from processing resources", this);
        xJMenu6.setIcon(MainFrame.getIcon("gazetteer"));
        xJMenu6.add(new XJMenuItem(new AbstractAction("Start Profiling Applications"){
            boolean benchmarkWasEnabled;
            {
                super(string);
                this.putValue("ShortDescription", "Toggles the profiling of processing resources");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.getValue("Name").equals("Start Profiling Applications")) {
                    FileAppender fileAppender;
                    xJMenuItem.setEnabled(false);
                    this.benchmarkWasEnabled = Benchmark.isBenchmarkingEnabled();
                    Benchmark.setBenchmarkingEnabled(true);
                    PatternLayout patternLayout = new PatternLayout("%m%n");
                    File file = new File(System.getProperty("java.io.tmpdir"), "gate-benchmark-log.txt");
                    try {
                        fileAppender = new FileAppender((Layout)patternLayout, file.getAbsolutePath(), true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return;
                    }
                    fileAppender.setName("gate-benchmark");
                    Benchmark.logger.addAppender((Appender)fileAppender);
                    this.putValue("Name", "Stop Profiling Applications");
                } else {
                    Benchmark.setBenchmarkingEnabled(this.benchmarkWasEnabled);
                    Benchmark.logger.removeAppender("gate-benchmark");
                    this.putValue("Name", "Start Profiling Applications");
                    xJMenuItem.setEnabled(true);
                }
            }
        }, this));
        xJMenu6.add(xJMenuItem);
        xJMenu6.addSeparator();
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        jCheckBoxMenuItem.setAction(new AbstractAction("Report Zero Time Entries"){

            public void actionPerformed(ActionEvent actionEvent) {
                Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".reportzerotime"), (Object)jCheckBoxMenuItem.isSelected());
            }
        });
        jCheckBoxMenuItem.setSelected(Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".reportzerotimes"));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
        jRadioButtonMenuItem.setAction(new AbstractAction("Sort by Execution"){

            public void actionPerformed(ActionEvent actionEvent) {
                Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".reportsorttime"), (Object)false);
            }
        });
        jRadioButtonMenuItem.setSelected(Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".reportsorttime") == false);
        buttonGroup.add(jRadioButtonMenuItem);
        final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem();
        jRadioButtonMenuItem2.setAction(new AbstractAction("Sort by Time"){

            public void actionPerformed(ActionEvent actionEvent) {
                Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".reportsorttime"), (Object)true);
            }
        });
        jRadioButtonMenuItem2.setSelected(Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".reportsorttime"));
        buttonGroup.add(jRadioButtonMenuItem2);
        xJMenu6.add(new XJMenuItem(new AbstractAction("Report on Processing Resources"){
            {
                super(string);
                this.putValue("ShortDescription", "Report time taken by each processing resource");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PRTimeReporter pRTimeReporter = new PRTimeReporter();
                pRTimeReporter.setBenchmarkFile(new File(System.getProperty("java.io.tmpdir"), "gate-benchmark-log.txt"));
                pRTimeReporter.setSuppressZeroTimeEntries(!jCheckBoxMenuItem.isSelected());
                pRTimeReporter.setSortOrder(jRadioButtonMenuItem2.isSelected() ? "time_taken" : "exec_order");
                try {
                    pRTimeReporter.executeReport();
                }
                catch (BenchmarkReportException benchmarkReportException) {
                    benchmarkReportException.printStackTrace();
                    return;
                }
                MainFrame.this.showHelpFrame("file://" + pRTimeReporter.getReportFile(), "processing times report");
            }
        }, this));
        xJMenu6.add(jCheckBoxMenuItem);
        xJMenu6.add(jRadioButtonMenuItem2);
        xJMenu6.add(jRadioButtonMenuItem);
        xJMenu6.addSeparator();
        xJMenu6.add(new XJMenuItem(new AbstractAction("Report on Documents Processed"){
            {
                this.putValue("ShortDescription", "Report most time consuming documents");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                DocTimeReporter docTimeReporter = new DocTimeReporter();
                docTimeReporter.setBenchmarkFile(new File(System.getProperty("java.io.tmpdir"), "gate-benchmark-log.txt"));
                String string2 = Gate.getUserConfig().getString(MainFrame.class.getName() + ".reportmaxdocs");
                if (string2 != null) {
                    docTimeReporter.setMaxDocumentInReport(string2.equals("All") ? -1 : Integer.valueOf(string2));
                }
                if ((string = Gate.getUserConfig().getString(MainFrame.class.getName() + ".reportprregex")) != null) {
                    docTimeReporter.setPRMatchingRegex(string.equals("") ? "all_prs" : string);
                }
                try {
                    docTimeReporter.executeReport();
                }
                catch (BenchmarkReportException benchmarkReportException) {
                    benchmarkReportException.printStackTrace();
                    return;
                }
                MainFrame.this.showHelpFrame("file://" + docTimeReporter.getReportFile(), "documents time report");
            }
        }, this));
        String string2 = Gate.getUserConfig().getString(MainFrame.class.getName() + ".reportmaxdocs");
        if (string2 == null) {
            string2 = "10";
        }
        xJMenu6.add(new XJMenuItem(new AbstractAction("Set Max Documents (" + string2 + ")"){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = JOptionPane.showInputDialog(instance, "Set the maximum of documents to report", "Report options", 3, null, new Object[]{"All", "10", "20", "30", "40", "50", "100"}, "10");
                if (object != null) {
                    Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".reportmaxdocs"), object);
                    this.putValue("Name", "Set Max Documents (" + object + ")");
                }
            }
        }, this));
        String string3 = Gate.getUserConfig().getString(MainFrame.class.getName() + ".reportprregex");
        if (string3 == null || string3.equals("")) {
            string3 = "All";
        }
        xJMenu6.add(new XJMenuItem(new AbstractAction("Set PR Matching Regex (" + string3 + ")"){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(instance, "Set the processing resource regex filter\nLeave empty to not filter", "Report options", 3);
                if (string != null) {
                    Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".reportprregex"), string);
                    if (string.equals("")) {
                        string = "All";
                    }
                    this.putValue("Name", "Set PR Matching Regex (" + string + ")");
                }
            }
        }, this));
        ((JMenu)serializable2).add(xJMenu6);
        ((JMenu)serializable2).add(new XJMenuItem(new NewBootStrapAction(), this));
        XJMenu xJMenu7 = new XJMenu("Corpus Benchmark", "Compares processed and human-annotated annotations", this);
        xJMenu7.setIcon(MainFrame.getIcon("corpus-benchmark"));
        ((JMenu)serializable2).add(xJMenu7);
        xJMenu7.add(new XJMenuItem(new NewCorpusEvalAction(), this));
        xJMenu7.addSeparator();
        xJMenu7.add(new XJMenuItem(new GenerateStoredCorpusEvalAction(), this));
        xJMenu7.addSeparator();
        xJMenu7.add(new XJMenuItem(new StoredMarkedCorpusEvalAction(), this));
        xJMenu7.add(new XJMenuItem(new CleanMarkedCorpusEvalAction(), this));
        xJMenu7.addSeparator();
        this.verboseModeItem = new JCheckBoxMenuItem(new VerboseModeCorpusEvalToolAction());
        xJMenu7.add(this.verboseModeItem);
        ((JMenu)serializable2).add(new XJMenuItem(new AbstractAction("Unicode Editor", MainFrame.getIcon("unicode")){
            private static final long serialVersionUID = 1L;
            {
                this.putValue("ShortDescription", "Editor for testing character encoding");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                new Editor();
            }
        }, this));
        ((JMenu)serializable2).addSeparator();
        ((ToolsMenu)serializable2).staticItemsAdded();
        if (((JMenu)serializable2).getMenuComponent(((JMenu)serializable2).getMenuComponentCount() - 1) instanceof JSeparator) {
            ((JMenu)serializable2).remove(((JMenu)serializable2).getMenuComponentCount() - 1);
        }
        this.menuBar.add((JMenu)serializable2);
        XJMenu xJMenu8 = new XJMenu("Help", null, this);
        xJMenu8.setMnemonic(72);
        xJMenu8.add(new XJMenuItem(new HelpUserGuideAction(), this));
        xJMenu8.add(new XJMenuItem(new HelpUserGuideInContextAction(), this));
        xJMenu8.add(new XJMenuItem(new AbstractAction("Keyboard Shortcuts"){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showHelpFrame("sec:developer:keyboard", "shortcuts");
            }
        }, this));
        xJMenu8.addSeparator();
        xJMenu8.add(new XJMenuItem(new AbstractAction("Using GATE Developer"){
            {
                this.putValue("ShortDescription", "To read first");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showHelpFrame("chap:developer", "Using GATE Developer");
            }
        }, this));
        xJMenu8.add(new XJMenuItem(new AbstractAction("Demo Movies"){
            {
                this.putValue("ShortDescription", "Movie tutorials");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showHelpFrame("http://gate.ac.uk/demos/movies.html", "movies");
            }
        }, this));
        xJMenu8.add(new XJMenuItem(new HelpMailingListAction(), this));
        xJMenu8.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(new ToggleToolTipsAction());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".hidetooltips").booleanValue()) {
            toolTipManager.setEnabled(false);
            jCheckBoxMenuItem2.setSelected(false);
        } else {
            toolTipManager.setEnabled(true);
            jCheckBoxMenuItem2.setSelected(true);
        }
        xJMenu8.add(jCheckBoxMenuItem2);
        xJMenu8.add(new XJMenuItem(new AbstractAction("What's New"){
            {
                this.putValue("ShortDescription", "List new features and important changes");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showHelpFrame("chap:changes", "changes");
            }
        }, this));
        if (!Gate.runningOnMac()) {
            xJMenu8.add(new XJMenuItem(new HelpAboutAction(), this));
        }
        this.menuBar.add(xJMenu8);
        this.setJMenuBar(this.menuBar);
        this.lrsPopup = new XJPopupMenu();
        LiveMenu liveMenu4 = new LiveMenu(1);
        liveMenu4.setText("New");
        this.lrsPopup.add(liveMenu4);
        guiRoots.add(this.lrsPopup);
        guiRoots.add(liveMenu4);
        this.prsPopup = new XJPopupMenu();
        LiveMenu liveMenu5 = new LiveMenu(2);
        liveMenu5.setText("New");
        this.prsPopup.add(liveMenu5);
        guiRoots.add(this.prsPopup);
        guiRoots.add(liveMenu5);
        this.dssPopup = new XJPopupMenu();
        this.dssPopup.add(new NewDSAction());
        this.dssPopup.add(new OpenDSAction());
        guiRoots.add(this.dssPopup);
        this.toolbar = new JToolBar(0);
        this.toolbar.setFloatable(false);
        JButton jButton2 = new JButton(new LoadResourceFromFileAction());
        jButton2.setToolTipText(jButton2.getText());
        jButton2.setText("");
        this.toolbar.add(jButton2);
        this.toolbar.addSeparator();
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new LoadANNIEWithDefaultsAction());
        jPopupMenu.add(new LoadANNIEWithoutDefaultsAction());
        JMenuButton jMenuButton = new JMenuButton(jPopupMenu);
        jMenuButton.setIcon(MainFrame.getIcon("annie-application"));
        jMenuButton.setToolTipText("Load ANNIE System");
        this.toolbar.add(jMenuButton);
        this.toolbar.addSeparator();
        LiveMenu liveMenu6 = new LiveMenu(1);
        jMenuButton = new JMenuButton(liveMenu6);
        jMenuButton.setToolTipText("New Language Resource");
        jMenuButton.setIcon(MainFrame.getIcon("lrs"));
        this.toolbar.add(jMenuButton);
        LiveMenu liveMenu7 = new LiveMenu(2);
        jMenuButton = new JMenuButton(liveMenu7);
        jMenuButton.setToolTipText("New Processing Resource");
        jMenuButton.setIcon(MainFrame.getIcon("prs"));
        this.toolbar.add(jMenuButton);
        LiveMenu liveMenu8 = new LiveMenu(3);
        jMenuButton = new JMenuButton(liveMenu8);
        jMenuButton.setToolTipText("New Application");
        jMenuButton.setIcon(MainFrame.getIcon("applications"));
        this.toolbar.add(jMenuButton);
        this.toolbar.addSeparator();
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        jPopupMenu2.add(new NewDSAction());
        jPopupMenu2.add(new OpenDSAction());
        jMenuButton = new JMenuButton(jPopupMenu2);
        jMenuButton.setToolTipText("Datastores");
        jMenuButton.setIcon(MainFrame.getIcon("datastores"));
        this.toolbar.add(jMenuButton);
        this.toolbar.addSeparator();
        jButton2 = new JButton(new ManagePluginsAction());
        jButton2.setToolTipText(jButton2.getText());
        jButton2.setText("");
        this.toolbar.add(jButton2);
        this.toolbar.addSeparator();
        jButton2 = new JButton(new NewAnnotDiffAction());
        jButton2.setToolTipText(jButton2.getText());
        jButton2.setText("");
        this.toolbar.add(jButton2);
        this.toolbar.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)this.toolbar, "North");
    }

    protected void initListeners(boolean bl) {
        Gate.getCreoleRegister().addCreoleListener(this);
        this.resourcesTree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    new ShowSelectedResourcesAction().actionPerformed(null);
                } else if (keyEvent.getKeyCode() == 127) {
                    new CloseSelectedResourcesAction().actionPerformed(null);
                } else if (keyEvent.getKeyCode() == 127 && keyEvent.getModifiers() == 64) {
                    new CloseRecursivelySelectedResourcesAction().actionPerformed(null);
                }
            }
        });
        this.resourcesTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = MainFrame.this.resourcesTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (mouseEvent.isPopupTrigger() && !MainFrame.this.resourcesTree.isPathSelected(treePath)) {
                    MainFrame.this.resourcesTree.getSelectionModel().setSelectionPath(treePath);
                }
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                Object object;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                TreePath treePath = MainFrame.this.resourcesTree.getClosestPathForLocation(n, n2);
                JPopupMenu jPopupMenu = null;
                Handle handle = null;
                if (treePath != null && (object = treePath.getLastPathComponent()) != MainFrame.this.resourcesTreeRoot) {
                    if (object == MainFrame.this.applicationsRoot) {
                        MainFrame.this.appsPopup = new XJPopupMenu();
                        LiveMenu object2 = new LiveMenu(3);
                        object2.setText("New");
                        MainFrame.this.appsPopup.add(object2);
                        guiRoots.add(MainFrame.this.appsPopup);
                        guiRoots.add(object2);
                        MainFrame.this.appsPopup.add(new XJMenuItem(new LoadResourceFromFileAction(), MainFrame.this));
                        Component[] componentArray = new RecentAppsMenu().getMenuComponents();
                        if (componentArray.length > 0) {
                            MainFrame.this.appsPopup.addSeparator();
                            MainFrame.this.appsPopup.add("Recent Applications:");
                        }
                        for (Component component : componentArray) {
                            MainFrame.this.appsPopup.add(component);
                        }
                        jPopupMenu = MainFrame.this.appsPopup;
                    } else if (object == MainFrame.this.languageResourcesRoot) {
                        jPopupMenu = MainFrame.this.lrsPopup;
                    } else if (object == MainFrame.this.processingResourcesRoot) {
                        jPopupMenu = MainFrame.this.prsPopup;
                    } else if (object == MainFrame.this.datastoresRoot) {
                        jPopupMenu = MainFrame.this.dssPopup;
                    } else if ((object = ((DefaultMutableTreeNode)object).getUserObject()) instanceof Handle) {
                        handle = (Handle)object;
                        fileChooser.setResource(handle.getTarget().getClass().getName());
                        if (mouseEvent.isPopupTrigger()) {
                            jPopupMenu = handle.getPopup();
                        }
                    }
                }
                if (mouseEvent.isPopupTrigger()) {
                    if (MainFrame.this.resourcesTree.getSelectionCount() > 1) {
                        jPopupMenu = new XJPopupMenu();
                        jPopupMenu.add(new XJMenuItem(new CloseSelectedResourcesAction(), MainFrame.this));
                        for (TreePath treePath2 : object = MainFrame.this.resourcesTree.getSelectionPaths()) {
                            Object object2 = ((DefaultMutableTreeNode)treePath2.getLastPathComponent()).getUserObject();
                            if (!(object2 instanceof NameBearerHandle) || !(((NameBearerHandle)object2).getTarget() instanceof Controller)) continue;
                            jPopupMenu.add(new XJMenuItem(new CloseRecursivelySelectedResourcesAction(), MainFrame.this));
                            break;
                        }
                        for (TreePath treePath3 : object = MainFrame.this.resourcesTree.getSelectionPaths()) {
                            Object object3 = ((DefaultMutableTreeNode)treePath3.getLastPathComponent()).getUserObject();
                            if (!(object3 instanceof Handle) || ((Handle)object3).getLargeView() != null && MainFrame.this.mainTabbedPane.indexOfComponent(((Handle)object3).getLargeView()) != -1) continue;
                            jPopupMenu.add(new XJMenuItem(new ShowSelectedResourcesAction(), MainFrame.this));
                            break;
                        }
                        for (TreePath treePath4 : object = MainFrame.this.resourcesTree.getSelectionPaths()) {
                            Object object4 = ((DefaultMutableTreeNode)treePath4.getLastPathComponent()).getUserObject();
                            if (!(object4 instanceof Handle) || !((Handle)object4).viewsBuilt() || ((Handle)object4).getLargeView() == null || MainFrame.this.mainTabbedPane.indexOfComponent(((Handle)object4).getLargeView()) == -1) continue;
                            jPopupMenu.add(new XJMenuItem(new CloseViewsForSelectedResourcesAction(), MainFrame.this));
                            break;
                        }
                        jPopupMenu.show(MainFrame.this.resourcesTree, mouseEvent.getX(), mouseEvent.getY());
                    } else if (jPopupMenu != null) {
                        if (handle != null) {
                            if (handle instanceof NameBearerHandle) {
                                jPopupMenu.insert(new XJMenuItem(((NameBearerHandle)handle).getCloseAction(), MainFrame.this), 0);
                            }
                            if (handle instanceof NameBearerHandle && handle.getTarget() instanceof Controller) {
                                jPopupMenu.insert(new XJMenuItem(((NameBearerHandle)handle).getCloseRecursivelyAction(), MainFrame.this), 1);
                            }
                            if (handle.viewsBuilt() && handle.getLargeView() != null && MainFrame.this.mainTabbedPane.indexOfComponent(handle.getLargeView()) != -1) {
                                jPopupMenu.insert(new XJMenuItem(new CloseViewAction(handle), MainFrame.this), 2);
                            } else {
                                jPopupMenu.insert(new XJMenuItem(new ShowResourceAction(handle), MainFrame.this), 2);
                            }
                            jPopupMenu.insert(new XJMenuItem(new RenameResourceAction(treePath), MainFrame.this), 3);
                            if (handle instanceof NameBearerHandle) {
                                jPopupMenu.insert(new XJMenuItem(new HelpOnItemTreeAction((NameBearerHandle)handle), MainFrame.this), 4);
                            }
                        }
                        jPopupMenu.show(MainFrame.this.resourcesTree, mouseEvent.getX(), mouseEvent.getY());
                    }
                } else if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2 && handle != null) {
                    MainFrame.this.select(handle);
                }
            }
        });
        this.resourcesTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                Object object2;
                if (!Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".treeselectview").booleanValue()) {
                    return;
                }
                if (MainFrame.this.resourcesTree.getSelectionPaths() != null && MainFrame.this.resourcesTree.getSelectionPaths().length == 1 && (object2 = ((DefaultMutableTreeNode)(object = treeSelectionEvent.getPath().getLastPathComponent())).getUserObject()) instanceof Handle && ((Handle)object2).viewsBuilt() && MainFrame.this.mainTabbedPane.indexOfComponent(((Handle)object2).getLargeView()) != -1) {
                    MainFrame.this.select((Handle)object2);
                }
            }
        });
        InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("control F4"), "Close resource");
        inputMap.put(KeyStroke.getKeyStroke("shift F4"), "Close recursively");
        inputMap.put(KeyStroke.getKeyStroke("control H"), "Hide");
        inputMap.put(KeyStroke.getKeyStroke("control shift H"), "Hide all");
        inputMap.put(KeyStroke.getKeyStroke("control S"), "Save As XML");
        if (inputMap.get(KeyStroke.getKeyStroke("CONTEXT_MENU")) == null) {
            inputMap.put(KeyStroke.getKeyStroke("CONTEXT_MENU"), "Show context menu");
        }
        ActionMap actionMap = ((JComponent)instance.getContentPane()).getActionMap();
        actionMap.put("Show context menu", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component component = keyboardFocusManager.getFocusOwner();
                if (component != null) {
                    Point point = null;
                    Rectangle rectangle = null;
                    if (component instanceof JTable && ((JTable)component).getSelectedRowCount() > 0) {
                        JTable jTable = (JTable)component;
                        rectangle = jTable.getCellRect(jTable.getSelectionModel().getLeadSelectionIndex(), jTable.convertColumnIndexToView(jTable.getSelectedColumn()), false);
                    } else if (component instanceof JTree && ((JTree)component).getSelectionCount() > 0) {
                        JTree jTree = (JTree)component;
                        rectangle = jTree.getRowBounds(jTree.getSelectionModel().getLeadSelectionRow());
                    } else {
                        point = new Point(component.getX() - 1, component.getY() - 1);
                    }
                    if (point == null) {
                        point = new Point(new Double(rectangle.getMinX() + 1.0).intValue(), new Double(rectangle.getMaxY() - 1.0).intValue());
                    }
                    component.dispatchEvent(new MouseEvent(component, 501, actionEvent.getWhen(), 4096, point.x, point.y, 1, true, 3));
                }
            }
        });
        this.mainTabbedPane.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JComponent jComponent = (JComponent)MainFrame.this.mainTabbedPane.getSelectedComponent();
                Enumeration<TreeNode> enumeration = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
                boolean bl = false;
                DefaultMutableTreeNode defaultMutableTreeNode = MainFrame.this.resourcesTreeRoot;
                while (!bl && enumeration.hasMoreElements()) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    bl = defaultMutableTreeNode.getUserObject() instanceof Handle && ((Handle)defaultMutableTreeNode.getUserObject()).viewsBuilt() && ((Handle)defaultMutableTreeNode.getUserObject()).getLargeView() == jComponent;
                }
                ActionMap actionMap = ((JComponent)instance.getContentPane()).getActionMap();
                if (bl) {
                    Serializable serializable;
                    Handle handle = (Handle)defaultMutableTreeNode.getUserObject();
                    if (Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".viewselecttree").booleanValue()) {
                        serializable = new TreePath(defaultMutableTreeNode.getPath());
                        MainFrame.this.resourcesTree.setSelectionPath((TreePath)serializable);
                        MainFrame.this.resourcesTree.scrollPathToVisible((TreePath)serializable);
                    }
                    MainFrame.this.lowerScroll.getViewport().setView(handle.getSmallView());
                    serializable = (JComponent)MainFrame.this.mainTabbedPane.getSelectedComponent();
                    actionMap.put("Close resource", ((JComponent)serializable).getActionMap().get("Close resource"));
                    actionMap.put("Close recursively", ((JComponent)serializable).getActionMap().get("Close recursively"));
                    actionMap.put("Hide", new CloseViewAction(handle));
                    actionMap.put("Hide all", new HideAllAction());
                    actionMap.put("Save As XML", ((JComponent)serializable).getActionMap().get("Save As XML"));
                } else {
                    MainFrame.this.lowerScroll.getViewport().setView(null);
                    actionMap.put("Close resource", null);
                    actionMap.put("Close recursively", null);
                    actionMap.put("Hide", null);
                    actionMap.put("Hide all", null);
                    actionMap.put("Save As XML", null);
                }
            }
        });
        this.mainTabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.isPopupTrigger() && (n = MainFrame.this.mainTabbedPane.getIndexAt(mouseEvent.getPoint())) != -1) {
                    JComponent jComponent = (JComponent)MainFrame.this.mainTabbedPane.getComponentAt(n);
                    Enumeration<TreeNode> enumeration = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
                    boolean bl = false;
                    DefaultMutableTreeNode defaultMutableTreeNode = MainFrame.this.resourcesTreeRoot;
                    while (!bl && enumeration.hasMoreElements()) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                        bl = defaultMutableTreeNode.getUserObject() instanceof Handle && ((Handle)defaultMutableTreeNode.getUserObject()).viewsBuilt() && ((Handle)defaultMutableTreeNode.getUserObject()).getLargeView() == jComponent;
                    }
                    if (bl) {
                        Handle handle = (Handle)defaultMutableTreeNode.getUserObject();
                        JPopupMenu jPopupMenu = handle.getPopup();
                        CloseViewAction closeViewAction = new CloseViewAction(handle);
                        XJMenuItem xJMenuItem = new XJMenuItem(closeViewAction, MainFrame.this);
                        jPopupMenu.insert(xJMenuItem, 0);
                        if (MainFrame.this.mainTabbedPane.getTabCount() > 2) {
                            HideAllAction hideAllAction = new HideAllAction();
                            xJMenuItem = new XJMenuItem(hideAllAction, MainFrame.this);
                            jPopupMenu.insert(xJMenuItem, 1);
                        }
                        jPopupMenu.show(MainFrame.this.mainTabbedPane, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                MainFrame.this.leftSplit.setDividerLocation(0.7);
            }

            public void componentResized(ComponentEvent componentEvent) {
                int n = MainFrame.this.getWidth();
                MainFrame.this.statusBar.setPreferredSize(new Dimension(n * 65 / 100, MainFrame.this.statusBar.getPreferredSize().height));
                MainFrame.this.progressBar.setPreferredSize(new Dimension(n * 20 / 100, MainFrame.this.progressBar.getPreferredSize().height));
                MainFrame.this.progressBar.setMinimumSize(new Dimension(80, 0));
                MainFrame.this.globalProgressBar.setPreferredSize(new Dimension(n * 10 / 100, MainFrame.this.globalProgressBar.getPreferredSize().height));
                MainFrame.this.globalProgressBar.setMinimumSize(new Dimension(80, 0));
            }
        });
        if (bl) {
            this.mainSplit.setDividerSize(0);
            this.mainSplit.getTopComponent().setVisible(false);
            this.mainSplit.getTopComponent().addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent componentEvent) {
                }

                public void componentMoved(ComponentEvent componentEvent) {
                    MainFrame.this.mainSplit.setDividerLocation(0);
                }

                public void componentResized(ComponentEvent componentEvent) {
                    MainFrame.this.mainSplit.setDividerLocation(0);
                }

                public void componentShown(ComponentEvent componentEvent) {
                    MainFrame.this.mainSplit.setDividerLocation(0);
                }
            });
        }
        this.logArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changeOccured();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changeOccured();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            protected void changeOccured() {
                MainFrame.this.logHighlighter.highlight();
            }
        });
        this.logArea.addPropertyChangeListener("document", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MainFrame.this.logArea.getDocument().addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changeOccured();
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changeOccured();
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.changeOccured();
                    }

                    protected void changeOccured() {
                        MainFrame.this.logHighlighter.highlight();
                    }
                });
            }
        });
        Gate.listeners.put("gate.event.StatusListener", this);
        Gate.listeners.put("gate.event.ProgressListener", this);
        if (Gate.runningOnMac()) {
            this.initMacListeners();
        }
    }

    protected void initMacListeners() {
        try {
            Class<?> clazz = Gate.getClassLoader().loadClass("com.apple.eawt.Application");
            Class<?> clazz2 = Gate.getClassLoader().loadClass("com.apple.eawt.ApplicationListener");
            Class<?> clazz3 = Gate.getClassLoader().loadClass("com.apple.eawt.ApplicationEvent");
            final Method method = clazz3.getMethod("setHandled", Boolean.TYPE);
            InvocationHandler invocationHandler = new InvocationHandler(){
                private Action aboutAction;
                private Action exitAction;
                {
                    this.aboutAction = new HelpAboutAction();
                    this.exitAction = new ExitGateAction();
                }

                public Object invoke(Object object, Method method2, Object[] objectArray) throws Throwable {
                    Object object2 = objectArray[0];
                    if ("handleAbout".equals(method2.getName())) {
                        method.invoke(object2, Boolean.TRUE);
                        this.aboutAction.actionPerformed(null);
                    } else if ("handleQuit".equals(method2.getName())) {
                        method.invoke(object2, Boolean.FALSE);
                        this.exitAction.actionPerformed(null);
                    } else if ("handlePreferences".equals(method2.getName())) {
                        method.invoke(object2, Boolean.TRUE);
                        MainFrame.this.optionsDialog.showDialog();
                        MainFrame.this.optionsDialog.dispose();
                    }
                    return null;
                }
            };
            Object object = Proxy.newProxyInstance(Gate.getClassLoader(), new Class[]{clazz2}, invocationHandler);
            Method method2 = clazz.getMethod("getApplication", new Class[0]);
            Object object2 = method2.invoke(null, new Object[0]);
            Method method3 = clazz.getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            method3.invoke(object2, Boolean.TRUE);
            Method method4 = clazz.getMethod("addApplicationListener", clazz2);
            method4.invoke(object2, object);
        }
        catch (Throwable throwable) {
            String string = "There was a problem setting up the Mac application\nmenu.  Your options/session will not be saved if you exit\nwith \u2318Q, use the close button at the top-leftcorner\nof this window instead.";
            this.alertButton.setAction(new AlertAction(throwable, string, null));
        }
    }

    @Override
    public void progressChanged(int n) {
        int n2 = this.progressBar.getValue();
        if (!this.animator.isActive()) {
            this.animator.activate();
        }
        if (n2 != n) {
            SwingUtilities.invokeLater(new ProgressBarUpdater(n));
        }
    }

    @Override
    public void processFinished() {
        SwingUtilities.invokeLater(new ProgressBarUpdater(0));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.globalProgressBar.setVisible(false);
            }
        });
        this.animator.deactivate();
    }

    @Override
    public void statusChanged(String string) {
        SwingUtilities.invokeLater(new StatusBarUpdater(string));
        if (string != null) {
            Matcher matcher = START_RUNNING_PATTERN.matcher(string);
            if (matcher.matches()) {
                final int n = Integer.valueOf(matcher.group(1));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MainFrame.this.globalProgressBar.setMaximum(n);
                        MainFrame.this.globalProgressBar.setValue(0);
                        MainFrame.this.globalProgressBar.setString("0/" + n);
                        MainFrame.this.globalProgressBar.setVisible(true);
                    }
                });
            } else if (string.startsWith("Finished running ")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MainFrame.this.globalProgressBar.setValue(MainFrame.this.globalProgressBar.getValue() + 1);
                        MainFrame.this.globalProgressBar.setString(MainFrame.this.globalProgressBar.getValue() + "/" + MainFrame.this.globalProgressBar.getMaximum());
                    }
                });
            }
        }
    }

    @Override
    public void resourceLoaded(CreoleEvent creoleEvent) {
        final Resource resource = creoleEvent.getResource();
        if (Gate.getHiddenAttribute(resource.getFeatures()) || resource instanceof VisualResource) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NameBearerHandle nameBearerHandle = new NameBearerHandle(resource, MainFrame.this);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(nameBearerHandle, false);
                if (resource instanceof Controller) {
                    MainFrame.this.resourcesTreeModel.insertNodeInto(defaultMutableTreeNode, MainFrame.this.applicationsRoot, 0);
                } else if (resource instanceof ProcessingResource) {
                    MainFrame.this.resourcesTreeModel.insertNodeInto(defaultMutableTreeNode, MainFrame.this.processingResourcesRoot, 0);
                } else if (resource instanceof LanguageResource) {
                    MainFrame.this.resourcesTreeModel.insertNodeInto(defaultMutableTreeNode, MainFrame.this.languageResourcesRoot, 0);
                }
                nameBearerHandle.addProgressListener(MainFrame.this);
                nameBearerHandle.addStatusListener(MainFrame.this);
            }
        });
    }

    @Override
    public void resourceUnloaded(CreoleEvent creoleEvent) {
        final Resource resource = creoleEvent.getResource();
        if (Gate.getHiddenAttribute(resource.getFeatures())) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                if (resource instanceof Controller) {
                    defaultMutableTreeNode = MainFrame.this.applicationsRoot;
                } else if (resource instanceof ProcessingResource) {
                    defaultMutableTreeNode = MainFrame.this.processingResourcesRoot;
                } else if (resource instanceof LanguageResource) {
                    defaultMutableTreeNode = MainFrame.this.languageResourcesRoot;
                }
                if (defaultMutableTreeNode != null) {
                    Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                    while (enumeration.hasMoreElements()) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                        if (((NameBearerHandle)defaultMutableTreeNode2.getUserObject()).getTarget() != resource) continue;
                        MainFrame.this.resourcesTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
                        Handle handle = (Handle)defaultMutableTreeNode2.getUserObject();
                        if (handle.viewsBuilt()) {
                            if (MainFrame.this.mainTabbedPane.indexOfComponent(handle.getLargeView()) != -1) {
                                MainFrame.this.mainTabbedPane.remove(handle.getLargeView());
                            }
                            if (MainFrame.this.lowerScroll.getViewport().getView() == handle.getSmallView()) {
                                MainFrame.this.lowerScroll.getViewport().setView(null);
                            }
                        }
                        handle.cleanup();
                        return;
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void datastoreOpened(CreoleEvent creoleEvent) {
        Serializable serializable;
        Object object;
        DataStore dataStore = creoleEvent.getDatastore();
        if (dataStore.getName() == null || dataStore.getName().length() == 0) {
            object = dataStore.getStorageUrl();
            serializable = new StringBuilder();
            int n = 0;
            block4: for (int i = ((String)object).length() - 1; i >= 0 && n != 2; --i) {
                char c = ((String)object).charAt(i);
                switch (n) {
                    case 0: {
                        if (c == '/') continue block4;
                        n = 1;
                        ((StringBuilder)serializable).insert(0, c);
                        continue block4;
                    }
                    case 1: {
                        if (c == '/') {
                            n = 2;
                            continue block4;
                        }
                        ((StringBuilder)serializable).insert(0, c);
                        continue block4;
                    }
                    default: {
                        throw new LuckyException("A phanthom state of things!");
                    }
                }
            }
            if (((StringBuilder)serializable).length() > 0) {
                object = ((StringBuilder)serializable).toString();
            }
            dataStore.setName((String)object);
        }
        object = new NameBearerHandle(dataStore, this);
        serializable = new DefaultMutableTreeNode(object, false);
        this.resourcesTreeModel.insertNodeInto((MutableTreeNode)((Object)serializable), this.datastoresRoot, 0);
        ((NameBearerHandle)object).addProgressListener(this);
        ((NameBearerHandle)object).addStatusListener(this);
    }

    @Override
    public void datastoreCreated(CreoleEvent creoleEvent) {
        this.datastoreOpened(creoleEvent);
    }

    @Override
    public void datastoreClosed(CreoleEvent creoleEvent) {
        DataStore dataStore = creoleEvent.getDatastore();
        DefaultMutableTreeNode defaultMutableTreeNode = this.datastoresRoot;
        if (defaultMutableTreeNode != null) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (((NameBearerHandle)defaultMutableTreeNode2.getUserObject()).getTarget() != dataStore) continue;
                this.resourcesTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
                NameBearerHandle nameBearerHandle = (NameBearerHandle)defaultMutableTreeNode2.getUserObject();
                if (nameBearerHandle.viewsBuilt() && this.mainTabbedPane.indexOfComponent(nameBearerHandle.getLargeView()) != -1) {
                    this.mainTabbedPane.remove(nameBearerHandle.getLargeView());
                }
                if (this.lowerScroll.getViewport().getView() == nameBearerHandle.getSmallView()) {
                    this.lowerScroll.getViewport().setView(null);
                }
                return;
            }
        }
    }

    @Override
    public void resourceRenamed(Resource resource, String string, String string2) {
        Handle handle = this.findHandleForResource(resource);
        if (handle != null) {
            for (int i = 0; i < this.mainTabbedPane.getTabCount(); ++i) {
                if (!this.mainTabbedPane.getTitleAt(i).equals(string) || this.mainTabbedPane.getComponentAt(i) != handle.getLargeView()) continue;
                this.mainTabbedPane.setTitleAt(i, string2);
                return;
            }
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            new ExitGateAction().actionPerformed(null);
        }
        super.processWindowEvent(windowEvent);
    }

    public static Map<String, EventListener> getListeners() {
        return Gate.getListeners();
    }

    public static Collection<Component> getGuiRoots() {
        return guiRoots;
    }

    public static synchronized void lockGUI(final String string) {
        if (MainFrame.getGuiRoots() == null || MainFrame.getGuiRoots().isEmpty()) {
            return;
        }
        MainFrame.unlockGUI();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = new Object[]{new JButton(new StopAction())};
                JOptionPane jOptionPane = new JOptionPane(string, 2, -1, null, objectArray, null);
                Component component = (Component)((ArrayList)MainFrame.getGuiRoots()).get(0);
                Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
                JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, "Please wait", true){
                    private static final long serialVersionUID = 1L;

                    protected void processWindowEvent(WindowEvent windowEvent) {
                        if (windowEvent.getID() == 201) {
                            this.getToolkit().beep();
                        }
                    }
                } : (window instanceof Dialog ? new JDialog((Dialog)window, "Please wait", true){
                    private static final long serialVersionUID = 1L;

                    protected void processWindowEvent(WindowEvent windowEvent) {
                        if (windowEvent.getID() == 201) {
                            this.getToolkit().beep();
                        }
                    }
                } : new JDialog(JOptionPane.getRootFrame(), "Please wait", true){
                    private static final long serialVersionUID = 1L;

                    protected void processWindowEvent(WindowEvent windowEvent) {
                        if (windowEvent.getID() == 201) {
                            this.getToolkit().beep();
                        }
                    }
                });
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)jOptionPane, "Center");
                jDialog.pack();
                jDialog.setLocationRelativeTo(component);
                jDialog.setDefaultCloseOperation(0);
                guiLock = jDialog;
                guiLock.setVisible(true);
            }
        });
        while (guiLock == null || !guiLock.isShowing()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                log.debug((Object)"Interrupted sleep when the GUI is locked.", (Throwable)interruptedException);
            }
        }
    }

    public static synchronized void unlockGUI() {
        if (MainFrame.getGuiRoots() == null || MainFrame.getGuiRoots().isEmpty()) {
            return;
        }
        if (guiLock != null) {
            guiLock.setVisible(false);
            guiLock.dispose();
        }
        guiLock = null;
    }

    public void setTitleChangable(boolean bl) {
        this.titleChangable = bl;
    }

    @Override
    public synchronized void setTitle(String string) {
        if (this.titleChangable) {
            super.setTitle(string);
        }
    }

    protected DataStore createSerialDataStore() {
        DataStore dataStore = null;
        fileChooser.setDialogTitle("Please create a new empty directory");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.setResource("gate.persist.SerialDataStore");
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                URL uRL = fileChooser.getSelectedFile().toURI().toURL();
                dataStore = Factory.createDataStore("gate.persist.SerialDataStore", uRL.toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, "Invalid location for the datastore\n " + malformedURLException.toString(), "GATE", 0);
            }
            catch (PersistenceException persistenceException) {
                JOptionPane.showMessageDialog(this, "Datastore creation error!\n " + persistenceException.toString(), "GATE", 0);
            }
        }
        return dataStore;
    }

    protected DataStore openSerialDataStore() {
        DataStore dataStore = null;
        fileChooser.setDialogTitle("Select the datastore directory");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.setResource("gate.persist.SerialDataStore");
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                URL uRL = fileChooser.getSelectedFile().toURI().toURL();
                dataStore = Factory.openDataStore("gate.persist.SerialDataStore", uRL.toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, "Invalid location for the datastore\n " + malformedURLException.toString(), "GATE", 0);
            }
            catch (PersistenceException persistenceException) {
                JOptionPane.showMessageDialog(this, "Datastore opening error!\n " + persistenceException.toString(), "GATE", 0);
            }
        }
        return dataStore;
    }

    protected DataStore openDocServiceDataStore() {
        DataStore dataStore = null;
        try {
            String string = JOptionPane.showInputDialog(this, "Enter document service URL", "http://localhost:8080/docservice/services/docservice");
            dataStore = Factory.openDataStore("gleam.docservice.gate.DocServiceDataStore", string);
        }
        catch (Exception exception) {
            String string = "Error when opening the Datastore.";
            this.alertButton.setAction(new AlertAction(exception, string, null));
        }
        return dataStore;
    }

    protected DataStore createSearchableDataStore() {
        try {
            JPanel jPanel = new JPanel(new GridBagLayout());
            final JTextField jTextField = new JTextField("", 20);
            final JTextField jTextField2 = new JTextField("", 20);
            JTextField jTextField3 = new JTextField("Token", 20);
            jTextField3.setToolTipText("Examples: Token, AnnotationSetName.Token, <null>.Token");
            JCheckBox jCheckBox = new JCheckBox("Create Tokens Automatically");
            jCheckBox.setSelected(true);
            JTextField jTextField4 = new JTextField("", 20);
            jTextField4.setToolTipText("Examples: Sentence, AnnotationSetName.Sentence, <null>.Sentence");
            final ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("Key");
            final JTextField jTextField5 = new JTextField("", 20);
            jTextField5.setText("Key");
            jTextField5.setEditable(false);
            JButton jButton = new JButton(MainFrame.getIcon("edit-list"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ListEditorDialog listEditorDialog = new ListEditorDialog((Component)instance, arrayList, "java.lang.String");
                    List list = listEditorDialog.showDialog();
                    if (list != null) {
                        arrayList.clear();
                        arrayList.addAll(list);
                        if (arrayList.size() > 0) {
                            String string = arrayList.get(0) == null ? "<null>" : (String)arrayList.get(0);
                            for (int i = 1; i < arrayList.size(); ++i) {
                                string = string + ";" + (arrayList.get(i) == null ? "<null>" : (String)arrayList.get(i));
                            }
                            jTextField5.setText(string);
                        } else {
                            jTextField5.setText("");
                        }
                    }
                }
            });
            JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"include", "exclude"});
            jTextField5.setToolTipText("Leave blank for indexing all annotation sets");
            final ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("SpaceToken");
            arrayList2.add("Split");
            final JTextField jTextField6 = new JTextField("", 20);
            jTextField6.setText("SpaceToken;Split");
            jTextField6.setEditable(false);
            JButton jButton2 = new JButton(MainFrame.getIcon("edit-list"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ListEditorDialog listEditorDialog = new ListEditorDialog((Component)instance, arrayList2, "java.lang.String");
                    List list = listEditorDialog.showDialog();
                    if (list != null) {
                        arrayList2.clear();
                        arrayList2.addAll(list);
                        if (arrayList2.size() > 0) {
                            String string = arrayList2.get(0) == null ? "<null>" : (String)arrayList2.get(0);
                            for (int i = 1; i < arrayList2.size(); ++i) {
                                string = string + ";" + (arrayList2.get(i) == null ? "<null>" : (String)arrayList2.get(i));
                            }
                            jTextField6.setText(string);
                        } else {
                            jTextField6.setText("");
                        }
                    }
                }
            });
            JComboBox<String> jComboBox2 = new JComboBox<String>(new String[]{"include", "exclude"});
            jComboBox2.setSelectedIndex(1);
            jTextField6.setToolTipText("Leave blank for inclusion of all features");
            JButton jButton3 = new JButton(MainFrame.getIcon("open-file"));
            JButton jButton4 = new JButton(MainFrame.getIcon("open-file"));
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    fileChooser.setDialogTitle("Please create a new empty directory for datastore");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setResource("gate.DataStore.data");
                    if (fileChooser.showOpenDialog(MainFrame.this) == 0) {
                        try {
                            jTextField.setText(fileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                        }
                        catch (Exception exception) {
                            jTextField.setText("");
                        }
                    }
                }
            });
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    fileChooser.setDialogTitle("Please create a new empty directory for datastore");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setResource("gate.DataStore.index");
                    if (fileChooser.showOpenDialog(MainFrame.this) == 0) {
                        try {
                            jTextField2.setText(fileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                        }
                        catch (Exception exception) {
                            jTextField2.setText("");
                        }
                    }
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jPanel.add((Component)new JLabel("Datastore URL:"), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            jPanel.add((Component)jTextField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)jButton3, gridBagConstraints);
            jButton3.setBorderPainted(false);
            jButton3.setContentAreaFilled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jPanel.add((Component)new JLabel("Index Location:"), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            jPanel.add((Component)jTextField2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)jButton4, gridBagConstraints);
            jButton4.setBorderPainted(false);
            jButton4.setContentAreaFilled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jPanel.add((Component)new JLabel("Annotation Sets:"), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            jPanel.add(jComboBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            jPanel.add((Component)jTextField5, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)jButton, gridBagConstraints);
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jPanel.add((Component)new JLabel("Base Token Type:"), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)jTextField3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jPanel.add((Component)jCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jPanel.add((Component)new JLabel("Index Unit Type:"), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)jTextField4, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jPanel.add((Component)new JLabel("Features:"), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            jPanel.add(jComboBox2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            jPanel.add((Component)jTextField6, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)jButton2, gridBagConstraints);
            jButton2.setBorderPainted(false);
            jButton2.setContentAreaFilled(false);
            boolean bl = false;
            while (!bl) {
                int n = JOptionPane.showOptionDialog(instance, jPanel, "SearchableDataStore", -1, 2, MainFrame.getIcon("empty"), new String[]{"OK", "Cancel"}, "OK");
                if (n == 0) {
                    Object object;
                    Class[] classArray;
                    if (jTextField.getText().equals(jTextField2.getText())) {
                        JOptionPane.showMessageDialog(instance, "Datastore and index may not be in the same directory", "Error", 0);
                        continue;
                    }
                    bl = true;
                    DataStore dataStore = Factory.createDataStore("gate.persist.LuceneDataStoreImpl", jTextField.getText());
                    Class[] classArray2 = new Class[]{URL.class};
                    Constructor<?> constructor = Class.forName("gate.creole.annic.lucene.LuceneIndexer", true, Gate.getClassLoader()).getConstructor(classArray2);
                    Object obj = constructor.newInstance(new URL(jTextField2.getText()));
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("INDEX_LOCATION_URL", new URL(jTextField2.getText()));
                    hashMap.put("BASE_TOKEN_ANNOTATION_TYPE", jTextField3.getText());
                    hashMap.put("INDEX_UNIT_ANNOTATION_TYPE", jTextField4.getText());
                    hashMap.put("CREATE_TOKENS_AUTOMATICALLY", jCheckBox.isSelected());
                    if (jTextField5.getText().trim().length() > 0) {
                        classArray = new ArrayList();
                        object = jTextField5.getText().trim().split(";");
                        if (object != null && ((String[])object).length > 0) {
                            classArray.addAll(Arrays.asList(object));
                        }
                        if (jComboBox.getSelectedIndex() == 0) {
                            hashMap.put("ANNOTATION_SETS_NAMES_TO_INCLUDE", classArray);
                            hashMap.put("ANNOTATION_SETS_NAMES_TO_EXCLUDE", new ArrayList());
                        } else {
                            hashMap.put("ANNOTATION_SETS_NAMES_TO_EXCLUDE", classArray);
                            hashMap.put("ANNOTATION_SETS_NAMES_TO_INCLUDE", new ArrayList());
                        }
                    } else {
                        hashMap.put("ANNOTATION_SETS_NAMES_TO_EXCLUDE", new ArrayList());
                        hashMap.put("ANNOTATION_SETS_NAMES_TO_INCLUDE", new ArrayList());
                    }
                    if (jTextField6.getText().trim().length() > 0) {
                        classArray = new ArrayList();
                        object = jTextField6.getText().trim().split(";");
                        if (object != null && ((String[])object).length > 0) {
                            classArray.addAll(Arrays.asList(object));
                        }
                        if (jComboBox2.getSelectedIndex() == 0) {
                            hashMap.put("FEATURES_TO_INCLUDE", classArray);
                            hashMap.put("FEATURES_TO_EXCLUDE", new ArrayList());
                        } else {
                            hashMap.put("FEATURES_TO_EXCLUDE", classArray);
                            hashMap.put("FEATURES_TO_INCLUDE", new ArrayList());
                        }
                    } else {
                        hashMap.put("FEATURES_TO_EXCLUDE", new ArrayList());
                        hashMap.put("FEATURES_TO_INCLUDE", new ArrayList());
                    }
                    classArray = new Class[]{Class.forName("gate.creole.annic.Indexer", true, Gate.getClassLoader()), Map.class};
                    object = dataStore.getClass().getMethod("setIndexer", classArray);
                    ((Method)object).invoke((Object)dataStore, obj, hashMap);
                    Constructor<?> constructor2 = Class.forName("gate.creole.annic.lucene.LuceneSearcher", true, Gate.getClassLoader()).getConstructor(new Class[0]);
                    Object obj2 = constructor2.newInstance(new Object[0]);
                    Class[] classArray3 = new Class[]{Class.forName("gate.creole.annic.Searcher", true, Gate.getClassLoader())};
                    Method method = dataStore.getClass().getMethod("setSearcher", classArray3);
                    method.invoke((Object)dataStore, obj2);
                    return dataStore;
                }
                bl = true;
            }
            return null;
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception);
        }
    }

    protected DataStore openSearchableDataStore() {
        DataStore dataStore = null;
        fileChooser.setDialogTitle("Select the datastore directory");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setResource("gate.DataStore.data");
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                URL uRL = fileChooser.getSelectedFile().toURI().toURL();
                dataStore = Factory.openDataStore("gate.persist.LuceneDataStoreImpl", uRL.toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, "Invalid location for the datastore\n " + malformedURLException.toString(), "GATE", 0);
            }
            catch (PersistenceException persistenceException) {
                JOptionPane.showMessageDialog(this, "Datastore opening error!\n " + persistenceException.toString(), "GATE", 0);
            }
        }
        return dataStore;
    }

    public void showHelpFrame(String string, String string2) {
        URL uRL;
        if (string2 == null) {
            string2 = "unknown";
        }
        if (string != null && !string.startsWith("http://") && !string.startsWith("file://")) {
            string = "http://gate.ac.uk/userguide/" + string;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(this, string == null ? "There is no help page for this resource !\n\nFind the developper of the resource:\n" + string2 + "\n" + "and force him/her to put one." : "The URL of the page for " + string2 + " is invalid.\n" + string, "GATE", 1);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                block24: {
                    StringBuilder stringBuilder = new StringBuilder(uRL.toString());
                    if (uRL.toString().startsWith("http://gate.ac.uk/userguide/")) {
                        int n = stringBuilder.length();
                        if (uRL.getRef() != null) {
                            n -= uRL.getRef().length() + 1;
                        }
                        if (uRL.getQuery() == null) {
                            stringBuilder.insert(n, '?');
                        } else {
                            stringBuilder.insert(n, "&");
                        }
                        stringBuilder.insert(n + 1, "gateVersion=" + Main.version);
                    }
                    Action[] actionArray = new Action[]{new AbstractAction("Show configuration"){

                        public void actionPerformed(ActionEvent actionEvent) {
                            MainFrame.this.optionsDialog.showDialog();
                            MainFrame.this.optionsDialog.dispose();
                        }
                    }};
                    String string = Gate.getUserConfig().getString(MainFrame.class.getName() + ".browsercommandline");
                    if (string == null || string.equals("") || string.equals("Set dynamically when you display help.")) {
                        Process process = null;
                        try {
                            string = "rundll32 url.dll,FileProtocolHandler " + stringBuilder.toString();
                            try {
                                process = Runtime.getRuntime().exec(string);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (process != null && process.waitFor() == 0) break block24;
                            string = "xdg-open " + stringBuilder.toString();
                            try {
                                process = Runtime.getRuntime().exec(string);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (process != null && process.waitFor() == 0) break block24;
                            string = "kfmclient exec " + stringBuilder.toString();
                            try {
                                process = Runtime.getRuntime().exec(string);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (process != null && process.waitFor() == 0) break block24;
                            string = "gnome-open " + stringBuilder.toString();
                            try {
                                process = Runtime.getRuntime().exec(string);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (process != null && process.waitFor() == 0) break block24;
                            string = "open " + stringBuilder.toString();
                            try {
                                process = Runtime.getRuntime().exec(string);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (process == null || process.waitFor() != 0) {
                                String string2 = "Unable to determine the default browser.\nWill use a Java browser. To use a custom command line\ngo to the Options menu then Configuration.";
                                MainFrame.this.alertButton.setAction(new AlertAction(null, string2, actionArray));
                                MainFrame.this.displayJavaHelpBrowser(stringBuilder.toString());
                            }
                        }
                        catch (java.lang.SecurityException securityException) {
                            JOptionPane.showMessageDialog(instance, securityException.getMessage(), "Help Error", 0);
                            log.error((Object)"Help browser Error", (Throwable)securityException);
                        }
                        catch (InterruptedException interruptedException) {
                            JOptionPane.showMessageDialog(instance, interruptedException.getMessage(), "Help Error", 0);
                            log.error((Object)"Help browser Error", (Throwable)interruptedException);
                        }
                    } else if (!string.equals("Internal Java browser.")) {
                        string = string.replaceFirst("%file", stringBuilder.toString());
                        try {
                            Runtime.getRuntime().exec(string);
                        }
                        catch (Exception exception) {
                            String string3 = "Unable to call the custom browser command.\n(" + string + ")\n\n" + "Please go to the Options menu then Configuration.";
                            MainFrame.this.alertButton.setAction(new AlertAction(exception, string3, actionArray));
                        }
                    } else {
                        MainFrame.this.displayJavaHelpBrowser(stringBuilder.toString());
                    }
                }
            }
        };
        Thread thread = new Thread(runnable, "showHelpFrame");
        thread.start();
    }

    private void displayJavaHelpBrowser(String string) {
        Object object;
        if (this.helpFrame == null) {
            this.helpFrame = new HelpFrame();
            this.helpFrame.setSize(800, 600);
            this.helpFrame.setDefaultCloseOperation(1);
            Dimension dimension = this.helpFrame.getSize();
            object = Toolkit.getDefaultToolkit().getScreenSize();
            Point point = new Point(0, 0);
            this.helpFrame.setLocation(point.x + (((Dimension)object).width - dimension.width) / 2, point.y + (((Dimension)object).height - dimension.height) / 2);
        }
        try {
            this.helpFrame.setPage(new URL(string));
        }
        catch (IOException iOException) {
            object = "Error when loading help page.";
            this.alertButton.setAction(new AlertAction(iOException, (String)object, null));
            return;
        }
        this.helpFrame.setVisible(false);
        this.helpFrame.setVisible(true);
    }

    static {
        iconByName = new HashMap<String, Icon>();
        guiRoots = new ArrayList<Component>();
        ICON_EXTENSIONS = new String[]{"", ".png", ".gif"};
        guiLock = null;
        START_RUNNING_PATTERN = Pattern.compile("Start running .* on (\\d+) documents?");
    }

    class AlertAction
    extends AbstractAction {
        private java.util.Timer timer = new java.util.Timer("MainFrame alert tooltip hide timer", true);
        Throwable error;
        String message;
        Action[] actions;

        public AlertAction(Throwable throwable, String string, Action[] actionArray) {
            if (throwable == null) {
                log.info((Object)string);
            } else {
                log.error((Object)string, throwable);
            }
            String string2 = "<html>" + (throwable == null ? "Important information:<br>" : "There was a problem:<br>") + string.substring(0, Math.min(300, string.length())).replaceAll("(.{40,50}(?:\\b|\\.|/))", "$1<br>") + "</html>";
            final int n = string2.split("<br>").length;
            this.putValue("SmallIcon", MainFrame.getIcon("crystal-clear-app-error"));
            this.putValue("ShortDescription", string2);
            this.error = throwable;
            this.message = string;
            if (actionArray == null) {
                this.actions = new Action[1];
            } else {
                this.actions = new Action[actionArray.length + 1];
                System.arraycopy(actionArray, 0, this.actions, 0, actionArray.length);
            }
            this.actions[this.actions.length - 1] = new HelpMailingListAction(string);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!instance.isShowing()) {
                        return;
                    }
                    MainFrame.this.alertButton.setEnabled(true);
                    JToolTip jToolTip = MainFrame.this.alertButton.createToolTip();
                    jToolTip.setTipText(MainFrame.this.alertButton.getToolTipText());
                    PopupFactory popupFactory = PopupFactory.getSharedInstance();
                    final Popup popup = popupFactory.getPopup(MainFrame.this.alertButton, jToolTip, instance.getLocationOnScreen().x + instance.getWidth() / 2 - 100, instance.getLocationOnScreen().y + instance.getHeight() - 30 - n * 10);
                    jToolTip.addMouseListener(new MouseAdapter(){

                        public void mouseClicked(MouseEvent mouseEvent) {
                            popup.hide();
                            MainFrame.this.alertButton.doClick();
                        }
                    });
                    popup.show();
                    Date date = new Date(System.currentTimeMillis() + 4000L);
                    AlertAction.this.timer.schedule(new TimerTask(){

                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    popup.hide();
                                }
                            });
                        }
                    }, date);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ErrorDialog.show(this.error, this.message, instance, MainFrame.getIcon("root"), this.actions);
        }
    }

    class NewGazetteerEditorAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NewGazetteerEditorAction() {
            super("Gazetteer Editor", MainFrame.getIcon("gazetteer"));
            this.putValue("ShortDescription", "Start the Gazetteer Editor");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Gaze gaze = new Gaze();
            try {
                JFrame jFrame = new JFrame();
                gaze.init();
                jFrame.setTitle("Gazetteer Editor");
                jFrame.getContentPane().add(gaze);
                HashSet<LanguageResource> hashSet = new HashSet<LanguageResource>(Gate.getCreoleRegister().getLrInstances("gate.creole.gazetteer.DefaultGazetteer"));
                if (hashSet.isEmpty()) {
                    return;
                }
                for (LanguageResource languageResource : hashSet) {
                    Gazetteer gazetteer = (Gazetteer)((Object)languageResource);
                    if (!gazetteer.getListsURL().toString().endsWith(System.getProperty("gate.slug.gazetteer"))) continue;
                    gaze.setTarget(gazetteer);
                }
                jFrame.setSize(700, 500);
                jFrame.setLocation(300, 200);
                jFrame.setVisible(true);
                gaze.setVisible(true);
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                String string = "Failed to instanciate the gazetteer editor.";
                Action[] actionArray = new Action[]{new AbstractAction("Load plugins manager"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new ManagePluginsAction().actionPerformed(null);
                    }
                }};
                MainFrame.this.alertButton.setAction(new AlertAction(resourceInstantiationException, string, actionArray));
            }
        }
    }

    class LocaleSelectorMenuItem
    extends JRadioButtonMenuItem {
        private static final long serialVersionUID = 1L;
        Locale myLocale;
        JRadioButtonMenuItem me;

        public LocaleSelectorMenuItem(Locale locale) {
            super(locale.getDisplayName());
            this.me = this;
            this.myLocale = locale;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (Component component : MainFrame.getGuiRoots()) {
                        if (!(component instanceof Window)) continue;
                        LocaleSelectorMenuItem.this.me.setSelected(component.getInputContext().selectInputMethod(LocaleSelectorMenuItem.this.myLocale));
                    }
                }
            });
        }

        public LocaleSelectorMenuItem() {
            super("System Default  >>" + Locale.getDefault().getDisplayName() + "<<");
            this.me = this;
            this.myLocale = Locale.getDefault();
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (Component component : MainFrame.getGuiRoots()) {
                        if (!(component instanceof Window)) continue;
                        LocaleSelectorMenuItem.this.me.setSelected(component.getInputContext().selectInputMethod(LocaleSelectorMenuItem.this.myLocale));
                    }
                }
            });
        }
    }

    class CartoonMinder
    implements Runnable {
        boolean dying = false;
        boolean active = false;
        final String lock = "lock";
        JPanel targetPanel;
        JLabel imageLabel;

        CartoonMinder(JPanel jPanel) {
            this.targetPanel = jPanel;
            this.imageLabel = new JLabel(MainFrame.getIcon("working"));
            this.imageLabel.setOpaque(false);
            this.imageLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            String string = "lock";
            synchronized ("lock") {
                boolean bl = this.active;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activate() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CartoonMinder.this.targetPanel.add(CartoonMinder.this.imageLabel);
                }
            });
            String string = "lock";
            synchronized ("lock") {
                this.active = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deactivate() {
            String string = "lock";
            synchronized ("lock") {
                this.active = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CartoonMinder.this.targetPanel.removeAll();
                        CartoonMinder.this.targetPanel.repaint();
                    }
                });
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            String string = "lock";
            synchronized ("lock") {
                this.dying = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            String string = "lock";
            // MONITORENTER : "lock"
            boolean bl = this.dying;
            // MONITOREXIT : string
            while (!bl) {
                String string2 = "lock";
                // MONITORENTER : "lock"
                boolean bl2 = this.active;
                // MONITOREXIT : string2
                if (bl2 && this.targetPanel.isVisible()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CartoonMinder.this.targetPanel.getParent().getParent().invalidate();
                            CartoonMinder.this.targetPanel.getParent().getParent().repaint();
                        }
                    });
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    log.debug((Object)"Animation interrupted", (Throwable)interruptedException);
                }
                string2 = "lock";
                // MONITORENTER : "lock"
                bl = this.dying;
                // MONITOREXIT : string2
            }
        }
    }

    class StatusBarUpdater
    implements Runnable {
        String text;

        StatusBarUpdater(String string) {
            this.text = string;
        }

        public void run() {
            MainFrame.this.statusBar.setText(this.text);
        }
    }

    class ProgressBarUpdater
    implements Runnable {
        int value;

        ProgressBarUpdater(int n) {
            this.value = n;
        }

        public void run() {
            if (this.value == 0) {
                MainFrame.this.progressBar.setVisible(false);
            } else {
                MainFrame.this.progressBar.setVisible(true);
            }
            MainFrame.this.progressBar.setValue(this.value);
        }
    }

    protected class ResourcesTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 1L;

        ResourcesTreeModel(TreeNode treeNode, boolean bl) {
            super(treeNode, bl);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof Handle) {
                Handle handle = (Handle)object2;
                Object object3 = handle.getTarget();
                if (object3 instanceof Resource) {
                    Gate.getCreoleRegister().setResourceName((Resource)object3, (String)object);
                } else if (object3 instanceof NameBearer) {
                    ((NameBearer)object3).setName((String)object);
                    for (int i = 0; i < MainFrame.this.mainTabbedPane.getTabCount(); ++i) {
                        if (MainFrame.this.mainTabbedPane.getComponentAt(i) != handle.getLargeView()) continue;
                        MainFrame.this.mainTabbedPane.setTitleAt(i, (String)object);
                        break;
                    }
                }
            }
            this.nodeChanged(defaultMutableTreeNode);
        }
    }

    protected class ResourcesTreeCellEditor
    extends DefaultTreeCellEditor {
        ResourcesTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
        }

        protected void startEditingTimer() {
            if (this.timer == null) {
                this.timer = new Timer(500, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Component component = super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
            if (this.renderer != null) {
                this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, false);
                this.editingIcon = this.renderer.getIcon();
            }
            return component;
        }
    }

    protected class ResourcesTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        public ResourcesTreeCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object == MainFrame.this.resourcesTreeRoot) {
                this.setIcon(MainFrame.getIcon("root"));
                this.setToolTipText("Resources tree root ");
            } else if (object == MainFrame.this.applicationsRoot) {
                this.setIcon(MainFrame.getIcon("applications"));
                this.setToolTipText("Run processes on data ");
            } else if (object == MainFrame.this.languageResourcesRoot) {
                this.setIcon(MainFrame.getIcon("lrs"));
                this.setToolTipText("Data used for annotating ");
            } else if (object == MainFrame.this.processingResourcesRoot) {
                this.setIcon(MainFrame.getIcon("prs"));
                this.setToolTipText("Processes that annotate data ");
            } else if (object == MainFrame.this.datastoresRoot) {
                this.setIcon(MainFrame.getIcon("datastores"));
                this.setToolTipText("Repositories for large data ");
            } else if ((object = ((DefaultMutableTreeNode)object).getUserObject()) instanceof Handle) {
                this.setIcon(((Handle)object).getIcon());
                this.setText(((Handle)object).getTitle());
                this.setToolTipText(((Handle)object).getTooltipText());
            }
            return this;
        }
    }

    class ToggleToolTipsAction
    extends AbstractAction {
        public ToggleToolTipsAction() {
            super("Show Tooltips");
            this.putValue("ShortDescription", "Tooltips appear in help balloon like this one");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    if (toolTipManager.isEnabled()) {
                        toolTipManager.setEnabled(false);
                        Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".hidetooltips"), (Object)false);
                    } else {
                        toolTipManager.setEnabled(true);
                        Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".hidetooltips"), (Object)true);
                    }
                }
            };
            Thread thread = new Thread(runnable, "ToggleToolTipsAction");
            thread.start();
        }
    }

    class HelpOnItemTreeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        NameBearerHandle resource;

        HelpOnItemTreeAction(NameBearerHandle nameBearerHandle) {
            super("Help");
            this.putValue("ShortDescription", "Help on this resource");
            this.resource = nameBearerHandle;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            String string = null;
            String string2 = this.resource.getTarget().getClass().getName();
            if (this.resource.getTarget() instanceof Resource) {
                object = (ResourceData)Gate.getCreoleRegister().get(string2);
                string = ((ResourceData)object).getHelpURL();
            }
            if (string == null) {
                object = Gate.getCreoleRegister().getLargeVRsForResource(string2);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(string3);
                    if (resourceData == null || resourceData.getHelpURL() == null) continue;
                    string = resourceData.getHelpURL();
                    break;
                }
            }
            MainFrame.this.showHelpFrame(string, string2);
        }
    }

    class HelpUserGuideInContextAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public HelpUserGuideInContextAction() {
            super("Contextual User Guide");
            this.putValue("ShortDescription", "Online help for the selected component");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)MainFrame.this.mainTabbedPane.getSelectedComponent();
            if (jComponent == null) {
                return;
            }
            Enumeration<TreeNode> enumeration = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
            boolean bl = false;
            DefaultMutableTreeNode defaultMutableTreeNode = MainFrame.this.resourcesTreeRoot;
            while (!bl && enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                bl = defaultMutableTreeNode.getUserObject() instanceof Handle && ((Handle)defaultMutableTreeNode.getUserObject()).viewsBuilt() && ((Handle)defaultMutableTreeNode.getUserObject()).getLargeView() == jComponent;
            }
            if (bl && (Handle)defaultMutableTreeNode.getUserObject() instanceof NameBearerHandle) {
                new HelpOnItemTreeAction((NameBearerHandle)defaultMutableTreeNode.getUserObject()).actionPerformed(null);
            } else if (MainFrame.this.mainTabbedPane.getTitleAt(MainFrame.this.mainTabbedPane.getSelectedIndex()).equals("Messages")) {
                MainFrame.this.showHelpFrame("sec:developer:gui", "messages pane");
            } else {
                MainFrame.this.showHelpFrame(null, defaultMutableTreeNode.getUserObject().getClass().getName());
            }
        }
    }

    class HelpUserGuideAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public HelpUserGuideAction() {
            super("User Guide Contents");
            this.putValue("ShortDescription", "Contents of the online user guide");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.showHelpFrame("", "help contents");
        }
    }

    class HelpMailingListAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        String keywords;

        public HelpMailingListAction() {
            super("Search in Mailing List");
            this.putValue("ShortDescription", "Search keywords in GATE users mailing list");
            this.keywords = null;
        }

        public HelpMailingListAction(String string) {
            super("Search in Mailing List");
            this.keywords = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.keywords == null) {
                this.keywords = JOptionPane.showInputDialog(instance, "Please enter your search keywords.", (String)this.getValue("Name"), 3);
                if (this.keywords == null || this.keywords.trim().length() == 0) {
                    return;
                }
            }
            try {
                MainFrame.this.showHelpFrame("http://sourceforge.net/search/index.php?group_id=143829&form_submit=Search&type_of_search=mlists&q=" + URLEncoder.encode(this.keywords, "UTF-8"), "mailing list");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string = "The Character Encoding is not supported.";
                MainFrame.this.alertButton.setAction(new AlertAction(unsupportedEncodingException, string, null));
            }
            finally {
                this.keywords = null;
            }
        }
    }

    class HelpAboutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public HelpAboutAction() {
            super("About");
            this.putValue("ShortDescription", "Show developers names and version");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.splash.showSplash();
        }
    }

    class ResourceToolTip
    extends JToolTip {
        private static final long serialVersionUID = 1L;
        JLabel iconLabel;
        JLabel textLabel;
        JPanel tipComponent;

        public ResourceToolTip() {
            this.setLayout(new BoxLayout(this, 0));
            this.tipComponent = new JPanel();
            this.tipComponent.setOpaque(false);
            this.tipComponent.setLayout(new BoxLayout(this.tipComponent, 0));
            this.tipComponent.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.iconLabel = new JLabel(MainFrame.getIcon("annie-application"));
            this.iconLabel.setText(null);
            this.iconLabel.setOpaque(false);
            this.tipComponent.add(this.iconLabel);
            this.textLabel = new JLabel();
            this.textLabel.setOpaque(false);
            this.tipComponent.add(Box.createHorizontalStrut(10));
            this.tipComponent.add(this.textLabel);
            this.add(this.tipComponent);
        }

        public void setTipText(String string) {
        }

        public void setValue(Object object) {
            if (object != null) {
                if (object instanceof String) {
                    String string = (String)object;
                    if (string.equals("GATE")) {
                        this.textLabel.setText("Resources tree root ");
                        this.iconLabel.setIcon(MainFrame.getIcon("root"));
                    } else if (string.equals("Applications")) {
                        this.textLabel.setText("Applications: run processes on data ");
                        this.iconLabel.setIcon(MainFrame.getIcon("applications"));
                    } else if (string.equals("Language Resources")) {
                        this.textLabel.setText("Language Resources: data used for annotating ");
                        this.iconLabel.setIcon(MainFrame.getIcon("lrs"));
                    } else if (string.equals("Processing Resources")) {
                        this.textLabel.setText("Processing Resources: processes that annotate data ");
                        this.iconLabel.setIcon(MainFrame.getIcon("prs"));
                    } else if (string.equals("Datastores")) {
                        this.textLabel.setText("Datastores: repositories for large data ");
                        this.iconLabel.setIcon(MainFrame.getIcon("datastores"));
                    } else {
                        this.textLabel.setText(string);
                        this.iconLabel.setIcon(null);
                    }
                } else if (object instanceof NameBearerHandle) {
                    NameBearerHandle nameBearerHandle = (NameBearerHandle)object;
                    this.textLabel.setText(nameBearerHandle.getTooltipText());
                    this.iconLabel.setIcon(nameBearerHandle.getIcon());
                } else {
                    this.textLabel.setText(null);
                    this.iconLabel.setIcon(null);
                }
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.tipComponent.getPreferredSize();
            Insets insets = this.getInsets();
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
    }

    class ResourcesTree
    extends JTree {
        private static final long serialVersionUID = 1L;
        ResourceToolTip myToolTip;

        public ResourcesTree() {
            this.myToolTip = new ResourceToolTip();
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = super.getToolTipText(mouseEvent);
            if (mouseEvent != null) {
                Point point = mouseEvent.getPoint();
                int n = this.getRowForLocation(point.x, point.y);
                if (n != -1) {
                    TreePath treePath = this.getPathForRow(n);
                    Object object = treePath.getLastPathComponent();
                    Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                    this.myToolTip.setValue(object2);
                }
            }
            return string;
        }

        public JToolTip createToolTip() {
            return this.myToolTip;
        }
    }

    class ToolsMenu
    extends XJMenu
    implements CreoleListener {
        protected int firstPluginItem;
        protected IdentityHashMap<Resource, List<JMenuItem>> itemsByResource;

        public ToolsMenu(String string, String string2, StatusListener statusListener) {
            super(string, string2, statusListener);
            this.firstPluginItem = 0;
            this.itemsByResource = new IdentityHashMap();
            Gate.getCreoleRegister().addCreoleListener(this);
        }

        public void staticItemsAdded() {
            this.firstPluginItem = this.getItemCount();
            this.processExistingTools();
        }

        protected void processExistingTools() {
            Set<String> set = Gate.getCreoleRegister().getToolTypes();
            for (String string : set) {
                List<Resource> list = ((ResourceData)Gate.getCreoleRegister().get(string)).getInstantiations();
                for (Resource resource : list) {
                    if (!(resource instanceof ActionsPublisher)) continue;
                    this.toolLoaded(resource);
                }
            }
        }

        public void resourceLoaded(CreoleEvent creoleEvent) {
            Resource resource = creoleEvent.getResource();
            if (((ResourceData)Gate.getCreoleRegister().get(resource.getClass().getName())).isTool() && resource instanceof ActionsPublisher) {
                this.toolLoaded(resource);
            }
        }

        protected void toolLoaded(Resource resource) {
            List list = ((ActionsPublisher)((Object)resource)).getActions();
            ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
            for (Action action : list) {
                arrayList.add(this.addMenuItem(action));
            }
            this.itemsByResource.put(resource, arrayList);
        }

        protected JMenuItem addMenuItem(Action action) {
            JMenuItem jMenuItem;
            int n;
            JMenuItem jMenuItem2 = this;
            int n2 = this.firstPluginItem;
            String[] stringArray = (String[])action.getValue("gate.MenuPath");
            if (stringArray != null) {
                block0: for (String string : stringArray) {
                    JMenuItem jMenuItem3;
                    for (int i = n2; i < jMenuItem2.getItemCount(); ++i) {
                        jMenuItem3 = jMenuItem2.getItem(i);
                        if (jMenuItem3 instanceof XJMenu && jMenuItem3.getText().equals(string)) {
                            n2 = 0;
                            jMenuItem2 = (XJMenu)jMenuItem3;
                            continue block0;
                        }
                        if (jMenuItem3.getText().compareTo(string) < 0) break;
                    }
                    jMenuItem3 = new XJMenu(string, string, this.listener);
                    jMenuItem2.add(jMenuItem3);
                    n2 = 0;
                    jMenuItem2 = jMenuItem3;
                }
            }
            for (n = n2; n < jMenuItem2.getItemCount() && ((jMenuItem = jMenuItem2.getItem(n)) == null || jMenuItem.getText().compareTo((String)action.getValue("Name")) <= 0); ++n) {
            }
            return jMenuItem2.insert(new XJMenuItem(action, this.listener), n);
        }

        public void resourceUnloaded(CreoleEvent creoleEvent) {
            Resource resource = creoleEvent.getResource();
            List<JMenuItem> list = this.itemsByResource.remove(resource);
            if (list != null) {
                for (JMenuItem jMenuItem : list) {
                    this.removeMenuItem(jMenuItem);
                }
            }
        }

        protected void removeMenuItem(JMenuItem jMenuItem) {
            Action action = jMenuItem.getAction();
            XJMenu xJMenu = this;
            int n = this.firstPluginItem;
            JMenu jMenu = null;
            String[] stringArray = (String[])action.getValue("gate.MenuPath");
            if (stringArray != null) {
                for (String string : stringArray) {
                    JMenuItem jMenuItem2;
                    block5: {
                        for (int i = n; i < xJMenu.getItemCount(); ++i) {
                            jMenuItem2 = xJMenu.getItem(i);
                            if (!(jMenuItem2 instanceof XJMenu) || !jMenuItem2.getText().equals(string)) {
                                continue;
                            }
                            break block5;
                        }
                        return;
                    }
                    n = 0;
                    jMenu = xJMenu;
                    xJMenu = (XJMenu)jMenuItem2;
                }
            }
            xJMenu.remove(jMenuItem);
            if (xJMenu.getItemCount() == 0 && jMenu != null) {
                jMenu.remove(xJMenu);
            }
        }

        public void datastoreClosed(CreoleEvent creoleEvent) {
        }

        public void datastoreCreated(CreoleEvent creoleEvent) {
        }

        public void datastoreOpened(CreoleEvent creoleEvent) {
        }

        public void resourceRenamed(Resource resource, String string, String string2) {
        }
    }

    class RecentAppsMenu
    extends XJMenu {
        public RecentAppsMenu() {
            this.init();
            this.addMenuItems();
        }

        protected void init() {
            this.addMenuListener(new MenuListener(){

                public void menuCanceled(MenuEvent menuEvent) {
                }

                public void menuDeselected(MenuEvent menuEvent) {
                    MainFrame.this.statusChanged("");
                }

                public void menuSelected(MenuEvent menuEvent) {
                    RecentAppsMenu.this.removeAll();
                    RecentAppsMenu.this.addMenuItems();
                    if (RecentAppsMenu.this.getMenuComponentCount() == 0) {
                        RecentAppsMenu.this.add("No Recent Applications");
                    }
                }
            });
        }

        protected void addMenuItems() {
            final Map<String, String> map = fileChooser.getLocations();
            final String string = map.get("applications");
            if (string == null || string.equals("")) {
                return;
            }
            for (final String string2 : string.split(";")) {
                final String string3 = map.get("application." + string2);
                XJMenuItem xJMenuItem = new XJMenuItem(new AbstractAction(string2, MainFrame.getIcon("open-application")){
                    {
                        super(string5, icon);
                        this.putValue("ShortDescription", string3);
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Runnable runnable = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    File file = new File(string3);
                                    PersistenceManager.loadObjectFromFile(file);
                                }
                                catch (Exception exception) {
                                    String string = "Couldn't reload application.\n" + exception.getMessage();
                                    MainFrame.this.alertButton.setAction(new AlertAction(exception, string, null));
                                    if (exception instanceof IOException) {
                                        map.put("applications", string.replaceFirst(string2 + ";?", ""));
                                        fileChooser.setLocations(map);
                                    }
                                }
                                finally {
                                    MainFrame.this.processFinished();
                                }
                            }
                        };
                        Thread thread = new Thread(runnable, "Reload application");
                        thread.setPriority(1);
                        thread.start();
                    }
                }, MainFrame.this);
                xJMenuItem.addMenuKeyListener(new MenuKeyListener(){

                    public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
                    }

                    public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
                        if (menuKeyEvent.getKeyCode() == 127) {
                            map.put("applications", string.replaceFirst(string2 + ";?", ""));
                            fileChooser.setLocations(map);
                        }
                    }

                    public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
                    }
                });
                this.add(xJMenuItem);
            }
            this.add(new XJMenuItem(new AbstractAction("Clear List"){

                public void actionPerformed(ActionEvent actionEvent) {
                    map.put("applications", "");
                    fileChooser.setLocations(map);
                }
            }, MainFrame.this));
        }
    }

    class LiveMenu
    extends XJMenu {
        protected int type;
        public static final int LR = 1;
        public static final int PR = 2;
        public static final int APP = 3;

        public LiveMenu(int n) {
            this.type = n;
            this.init();
        }

        protected void init() {
            this.addMenuListener(new MenuListener(){

                public void menuCanceled(MenuEvent menuEvent) {
                }

                public void menuDeselected(MenuEvent menuEvent) {
                    MainFrame.this.statusChanged("");
                }

                public void menuSelected(MenuEvent menuEvent) {
                    List<String> list;
                    LiveMenu.this.removeAll();
                    CreoleRegister creoleRegister = Gate.getCreoleRegister();
                    switch (LiveMenu.this.type) {
                        case 1: {
                            list = creoleRegister.getPublicLrTypes();
                            break;
                        }
                        case 2: {
                            list = new ArrayList<String>(creoleRegister.getPublicPrTypes());
                            list.removeAll(creoleRegister.getPublicControllerTypes());
                            break;
                        }
                        case 3: {
                            list = creoleRegister.getPublicControllerTypes();
                            break;
                        }
                        default: {
                            throw new GateRuntimeException("Unknown LiveMenu type: " + LiveMenu.this.type);
                        }
                    }
                    if (list != null) {
                        if (!list.isEmpty()) {
                            Serializable serializable;
                            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
                            Iterator<String> iterator = list.iterator();
                            while (iterator.hasNext()) {
                                serializable = (ResourceData)creoleRegister.get(iterator.next());
                                hashMap.put(((ResourceData)serializable).getName(), serializable);
                            }
                            serializable = new ArrayList(hashMap.keySet());
                            Collections.sort(serializable);
                            iterator = serializable.iterator();
                            while (iterator.hasNext()) {
                                ResourceData resourceData = (ResourceData)hashMap.get(iterator.next());
                                LiveMenu.this.add(new XJMenuItem(new NewResourceAction(resourceData), MainFrame.this));
                            }
                        } else if (LiveMenu.this.type == 2) {
                            LiveMenu.this.add(new AbstractAction("Add ANNIE Resources to this Menu"){
                                {
                                    this.putValue("ShortDescription", "Load the ANNIE plugin.");
                                }

                                public void actionPerformed(ActionEvent actionEvent) {
                                    try {
                                        URL uRL = new File(Gate.getPluginsHome(), "ANNIE").toURI().toURL();
                                        Gate.getCreoleRegister().registerDirectories(uRL);
                                        Gate.addAutoloadPlugin(uRL);
                                    }
                                    catch (Exception exception) {
                                        log.error((Object)"Unable to load ANNIE plugin.", (Throwable)exception);
                                    }
                                }
                            });
                        }
                    }
                    switch (LiveMenu.this.type) {
                        case 1: {
                            MainFrame.this.statusChanged("Data used for annotating");
                            break;
                        }
                        case 2: {
                            MainFrame.this.statusChanged("Processes that annotate data");
                            break;
                        }
                        case 3: {
                            MainFrame.this.statusChanged("Run processes on data");
                            break;
                        }
                        default: {
                            MainFrame.this.statusChanged("Unknown resource: " + LiveMenu.this.type);
                        }
                    }
                }
            });
        }
    }

    class OpenDSAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public OpenDSAction() {
            super("Open Datastore");
            this.putValue("ShortDescription", "Open a datastore");
            this.putValue("SmallIcon", MainFrame.getIcon("datastore"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Map<String, String> map = DataStoreRegister.getDataStoreClassNames();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<String, String> object : map.entrySet()) {
                hashMap.put(object.getValue(), object.getKey());
            }
            if (!hashMap.isEmpty()) {
                JLabel jLabel = new JLabel("Select a type of Datastore:");
                JList<Object> jList = new JList<Object>(hashMap.keySet().toArray());
                String string = Gate.getUserConfig().getString(MainFrame.class.getName() + ".datastoretype");
                if (hashMap.containsKey(string)) {
                    jList.setSelectedValue(string, true);
                } else {
                    jList.setSelectedIndex(0);
                }
                jList.setVisibleRowCount(Math.min(10, jList.getModel().getSize()));
                jList.setSelectionMode(0);
                final JOptionPane jOptionPane = new JOptionPane(new Object[]{jLabel, new JScrollPane(jList)}, 3, 2, MainFrame.getIcon("datastore"), new String[]{"OK", "Cancel", "Help"}, "OK");
                final JDialog jDialog = new JDialog(MainFrame.this, "Open a datastore", true);
                jDialog.setContentPane(jOptionPane);
                jList.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getClickCount() == 2) {
                            jOptionPane.setValue("OK");
                            jDialog.setVisible(false);
                        }
                    }
                });
                jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object = jOptionPane.getValue();
                        if (object == null || object.equals(JOptionPane.UNINITIALIZED_VALUE)) {
                            return;
                        }
                        if (jDialog.isVisible() && propertyChangeEvent.getSource() == jOptionPane && propertyChangeEvent.getPropertyName().equals("value")) {
                            if (jOptionPane.getValue().equals("Help")) {
                                jOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                                MainFrame.this.showHelpFrame("sec:datastores", "gate.persist.SerialDataStore");
                            } else {
                                jDialog.setVisible(false);
                            }
                        }
                    }
                });
                jDialog.pack();
                jDialog.setLocationRelativeTo(MainFrame.this);
                jDialog.setVisible(true);
                Object object = jOptionPane.getValue();
                if (object == null) {
                    return;
                }
                String string2 = (String)hashMap.get(jList.getSelectedValue());
                if (object.equals("OK") && !jList.isSelectionEmpty()) {
                    Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".datastoretype"), jList.getSelectedValue());
                    if (string2.indexOf("SerialDataStore") != -1) {
                        MainFrame.this.openSerialDataStore();
                    } else if (string2.indexOf("LuceneDataStoreImpl") != -1) {
                        MainFrame.this.openSearchableDataStore();
                    } else if (string2.indexOf("DocServiceDataStore") != -1) {
                        MainFrame.this.openDocServiceDataStore();
                    } else if (string2.equals("gate.persist.OracleDataStore") || string2.equals("gate.persist.PostgresDataStore")) {
                        Object object2;
                        Object object32;
                        ArrayList arrayList = new ArrayList();
                        for (Object object32 : DataStoreRegister.getConfigData().keySet()) {
                            object2 = (String)object32;
                            if (!((String)object2).startsWith("url")) continue;
                            arrayList.add(DataStoreRegister.getConfigData().get(object2));
                        }
                        if (arrayList.isEmpty()) {
                            throw new GateRuntimeException("JDBC URL not configured in gate.xml");
                        }
                        Object object4 = (String)arrayList.get(0);
                        if (arrayList.size() > 1) {
                            object32 = arrayList.toArray();
                            object = JOptionPane.showInputDialog(MainFrame.this, "Select a database", "GATE", 3, null, object32, object32[0]);
                            if (object != null) {
                                object4 = (String)object;
                            } else {
                                return;
                            }
                        }
                        object32 = null;
                        object2 = null;
                        try {
                            Session persistenceException2;
                            Group group;
                            Object securityException;
                            object2 = Factory.createAccessController((String)object4);
                            Assert.assertNotNull((Object)object2);
                            object2.open();
                            try {
                                securityException = "";
                                String string3 = "";
                                String string4 = "";
                                JPanel jPanel = new JPanel();
                                jPanel.setLayout(new BoxLayout(jPanel, 0));
                                JPanel jPanel2 = new JPanel();
                                jPanel2.setLayout(new BoxLayout(jPanel2, 1));
                                jPanel2.add(new JLabel("User name: "));
                                jPanel2.add(new JLabel("Password: "));
                                jPanel2.add(new JLabel("Group: "));
                                JPanel jPanel3 = new JPanel();
                                jPanel3.setLayout(new BoxLayout(jPanel3, 1));
                                JTextField jTextField = new JTextField(30);
                                jPanel3.add(jTextField);
                                JPasswordField jPasswordField = new JPasswordField(30);
                                jPanel3.add(jPasswordField);
                                JComboBox<Object> jComboBox = new JComboBox<Object>(object2.listGroups().toArray());
                                jComboBox.setSelectedIndex(0);
                                jPanel3.add(jComboBox);
                                jPanel.add(jPanel2);
                                jPanel.add(Box.createHorizontalStrut(20));
                                jPanel.add(jPanel3);
                                if (OkCancelDialog.showDialog(MainFrame.this.getContentPane(), jPanel, "Please enter login details")) {
                                    securityException = jTextField.getText();
                                    string3 = new String(jPasswordField.getPassword());
                                    string4 = (String)jComboBox.getSelectedItem();
                                    if (((String)securityException).equals("") || string3.equals("") || string4.equals("")) {
                                        JOptionPane.showMessageDialog(MainFrame.this, "You must provide non-empty user name, password and group!", "Login error", 0);
                                        return;
                                    }
                                } else if (OkCancelDialog.userHasPressedCancel) {
                                    return;
                                }
                                group = object2.findGroup(string4);
                                User persistenceException = object2.findUser((String)securityException);
                                persistenceException2 = object2.login((String)securityException, string3, group.getID());
                            }
                            catch (SecurityException securityException2) {
                                JOptionPane.showMessageDialog(MainFrame.this, securityException2.getMessage(), "Login error", 0);
                                object2.close();
                                return;
                            }
                            if (!object2.isValidSession(persistenceException2)) {
                                JOptionPane.showMessageDialog(MainFrame.this, "Incorrect session obtained. Probably there is a problem with the database!", "Login error", 0);
                                object2.close();
                                return;
                            }
                            object32 = Factory.openDataStore(string2, (String)object4);
                            object32.setSession(persistenceException2);
                            securityException = Factory.newFeatureMap();
                            securityException.put("user", persistenceException);
                            securityException.put("group", group);
                            DataStoreRegister.addSecurityData((DataStore)object32, (Map)securityException);
                        }
                        catch (PersistenceException securityException) {
                            JOptionPane.showMessageDialog(MainFrame.this, "Datastore open error!\n " + securityException.toString(), "GATE", 0);
                        }
                        catch (SecurityException securityException) {
                            JOptionPane.showMessageDialog(MainFrame.this, "User identification error!\n " + securityException.toString(), "GATE", 0);
                            try {
                                if (object2 != null) {
                                    object2.close();
                                }
                                if (object32 != null) {
                                    object32.close();
                                }
                            }
                            catch (PersistenceException persistenceException) {
                                JOptionPane.showMessageDialog(MainFrame.this, "Persistence error!\n " + persistenceException.toString(), "GATE", 0);
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(MainFrame.this, "Support for this type of datastores is not implemenented!\n", "GATE", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(MainFrame.this, "Could not find any registered types of datastores...\nCheck your GATE installation!", "GATE", 0);
            }
        }
    }

    class ExitGateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ExitGateAction() {
            super("Exit GATE");
            this.putValue("ShortDescription", "Closes the application");
            this.putValue("SmallIcon", MainFrame.getIcon("crystal-clear-action-exit"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt F4"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    HashSet hashSet;
                    Serializable serializable;
                    ArrayList<Serializable> arrayList;
                    Serializable serializable2;
                    OptionsMap optionsMap = Gate.getUserConfig();
                    try {
                        if (optionsMap.getBoolean("Save_options_on_exit").booleanValue()) {
                            serializable2 = Integer.valueOf(MainFrame.this.getWidth());
                            arrayList = MainFrame.this.getHeight();
                            optionsMap.put((Object)"Main_frame_width", serializable2);
                            optionsMap.put((Object)"Main_frame_height", arrayList);
                            Gate.writeUserConfig();
                        } else {
                            serializable2 = Gate.getOriginalUserConfig();
                            ((OptionsMap)serializable2).put((Object)"Save_options_on_exit", (Object)false);
                            optionsMap.clear();
                            optionsMap.putAll(serializable2);
                            Gate.writeUserConfig();
                        }
                    }
                    catch (GateException gateException) {
                        arrayList = "Failed to save config data.";
                        MainFrame.this.alertButton.setAction(new AlertAction(gateException, (String)((Object)arrayList), null));
                    }
                    serializable2 = Gate.getUserSessionFile();
                    if (optionsMap.getBoolean("Save_session_on_exit").booleanValue()) {
                        try {
                            arrayList = new ArrayList<Resource>(Gate.getCreoleRegister().getAllInstances("gate.Controller"));
                            serializable = arrayList.iterator();
                            while (serializable.hasNext()) {
                                if (!Gate.getHiddenAttribute(((Controller)serializable.next()).getFeatures())) continue;
                                serializable.remove();
                            }
                            PersistenceManager.saveObjectToFile(arrayList, (File)serializable2, true, false);
                        }
                        catch (Exception exception) {
                            serializable = "Failed to save session data.";
                            MainFrame.this.alertButton.setAction(new AlertAction(exception, (String)((Object)serializable), null));
                        }
                    } else if (((File)serializable2).exists() && !((File)serializable2).delete()) {
                        log.error((Object)"Error when deleting the session file.");
                    }
                    System.setErr(MainFrame.this.logArea.getOriginalErr());
                    System.setOut(MainFrame.this.logArea.getOriginalOut());
                    arrayList = new ArrayList<Component>(MainFrame.getGuiRoots());
                    while (!arrayList.isEmpty()) {
                        serializable = (Component)arrayList.remove(0);
                        if (!(serializable instanceof Window)) continue;
                        hashSet = (Window)serializable;
                        arrayList.addAll(Arrays.asList(((Window)((Object)hashSet)).getOwnedWindows()));
                        ((Window)((Object)hashSet)).setVisible(false);
                        ((Window)((Object)hashSet)).dispose();
                    }
                    if (MainFrame.this.helpFrame != null) {
                        MainFrame.this.helpFrame.dispose();
                    }
                    try {
                        serializable = new ArrayList<List<Resource>>();
                        serializable.add(Gate.getCreoleRegister().getAllInstances(LanguageResource.class.getName()));
                        serializable.add(Gate.getCreoleRegister().getAllInstances(ProcessingResource.class.getName()));
                        serializable.add(Gate.getCreoleRegister().getAllInstances(Controller.class.getName()));
                        for (List object : serializable) {
                            for (Resource throwable : object) {
                                try {
                                    Factory.deleteResource(throwable);
                                }
                                catch (Throwable throwable2) {
                                    log.error((Object)"Some problems occurred when cleaning up the resources.", throwable2);
                                }
                            }
                        }
                        if (Gate.getDataStoreRegister() != null) {
                            hashSet = new HashSet(Gate.getDataStoreRegister());
                            for (Iterator iterator : hashSet) {
                                try {
                                    if (!(iterator instanceof DataStore)) continue;
                                    ((DataStore)((Object)iterator)).close();
                                }
                                catch (Throwable throwable) {
                                    log.error((Object)"Some problems occurred when closing the datastores.", throwable);
                                }
                            }
                        }
                    }
                    catch (GateException gateException) {
                        log.error((Object)"A problem occurred when exiting from GATE.", (Throwable)gateException);
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Shutdown thread");
            thread.setPriority(1);
            thread.start();
        }
    }

    class ShowResourceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        Handle handle;

        public ShowResourceAction(Handle handle) {
            super("Show");
            this.putValue("ShortDescription", "Show this resource");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("Enter"));
            this.handle = handle;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.select(ShowResourceAction.this.handle);
                }
            });
        }
    }

    class ShowSelectedResourcesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ShowSelectedResourcesAction() {
            super("Show all");
            this.putValue("ShortDescription", "Show the selected resources");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("Enter"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    TreePath[] treePathArray = MainFrame.this.resourcesTree.getSelectionPaths();
                    if (treePathArray == null) {
                        return;
                    }
                    if (treePathArray.length > 10) {
                        Object[] objectArray = new Object[]{"Open the " + treePathArray.length + " objects", "Don't open"};
                        int n = JOptionPane.showOptionDialog(instance, "Do you want to open " + treePathArray.length + " objects in the central tabbed pane ?", "Warning", -1, 3, null, objectArray, objectArray[1]);
                        if (n == 1 || n == -1) {
                            return;
                        }
                    }
                    for (TreePath treePath : treePathArray) {
                        if (treePath == null) continue;
                        Object object = treePath.getLastPathComponent();
                        if (!((object = ((DefaultMutableTreeNode)object).getUserObject()) instanceof Handle)) continue;
                        final Handle handle = (Handle)object;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MainFrame.this.select(handle);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(runnable, "ShowSelectedResourcesAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class HideAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public HideAllAction() {
            super("Hide all");
            this.putValue("ShortDescription", "Hide all resource views");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift H"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Enumeration<TreeNode> enumeration = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!(defaultMutableTreeNode.getUserObject() instanceof Handle) || MainFrame.this.mainTabbedPane.indexOfComponent(((Handle)defaultMutableTreeNode.getUserObject()).getLargeView()) == -1) continue;
                final Handle handle = (Handle)defaultMutableTreeNode.getUserObject();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        new CloseViewAction(handle).actionPerformed(null);
                    }
                });
            }
        }
    }

    class CloseRecursivelySelectedResourcesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseRecursivelySelectedResourcesAction() {
            super("Close Recursively all");
            this.putValue("ShortDescription", "Close recursively the selected resources");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    TreePath[] treePathArray;
                    for (TreePath treePath : treePathArray = MainFrame.this.resourcesTree.getSelectionPaths()) {
                        final Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                        if (!(object instanceof NameBearerHandle)) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ((NameBearerHandle)object).getCloseRecursivelyAction().actionPerformed(null);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(runnable, "CloseRecursivelySelectedResourcesAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class CloseSelectedResourcesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseSelectedResourcesAction() {
            super("Close all");
            this.putValue("ShortDescription", "Close the selected resources");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    TreePath[] treePathArray;
                    for (TreePath treePath : treePathArray = MainFrame.this.resourcesTree.getSelectionPaths()) {
                        final Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                        if (!(object instanceof NameBearerHandle)) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ((NameBearerHandle)object).getCloseAction().actionPerformed(null);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(runnable, "CloseSelectedResourcesAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class RenameResourceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        TreePath path;

        RenameResourceAction(TreePath treePath) {
            super("Rename");
            this.putValue("ShortDescription", "Rename this resource");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F2"));
            this.path = treePath;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.resourcesTree.startEditingAtPath(this.path);
        }
    }

    class CloseViewsForSelectedResourcesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseViewsForSelectedResourcesAction() {
            super("Hide all");
            this.putValue("ShortDescription", "Hide the selected resources");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    TreePath[] treePathArray;
                    for (TreePath treePath : treePathArray = MainFrame.this.resourcesTree.getSelectionPaths()) {
                        final Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                        if (!(object instanceof Handle)) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                new CloseViewAction((Handle)object).actionPerformed(null);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(runnable, "CloseViewsForSelectedResourcesAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class CloseViewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        Handle handle;

        public CloseViewAction(Handle handle) {
            super("Hide");
            this.putValue("ShortDescription", "Hide this resource view");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control H"));
            this.handle = handle;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.mainTabbedPane.remove(CloseViewAction.this.handle.getLargeView());
                    MainFrame.this.mainTabbedPane.setSelectedIndex(MainFrame.this.mainTabbedPane.getTabCount() - 1);
                    CloseViewAction.this.handle.removeViews();
                }
            });
        }
    }

    class LoadResourceFromFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LoadResourceFromFileAction() {
            super("Restore Application from File");
            this.putValue("ShortDescription", "Restores a previously saved application from a file");
            this.putValue("SmallIcon", MainFrame.getIcon("open-application"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("GATE Application files", "gapp");
            fileChooser.addChoosableFileFilter(extensionFileFilter);
            fileChooser.setDialogTitle("Select a file for this resource");
            fileChooser.setFileSelectionMode(2);
            fileChooser.setResource("lastapplication");
            if (fileChooser.showOpenDialog(MainFrame.this) == 0) {
                final File file = fileChooser.getSelectedFile();
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Object object = PersistenceManager.loadObjectFromFile(file);
                            if (object instanceof Resource) {
                                Map<String, String> map = fileChooser.getLocations();
                                Resource resource = (Resource)object;
                                map.put("application." + resource.getName(), file.getCanonicalPath());
                                map.put("application.zip." + resource.getName(), file.getCanonicalPath().replaceFirst("\\.[^.]{3,5}$", ".zip"));
                                String string = map.get("applications");
                                if (string == null) {
                                    string = "";
                                }
                                string = string.replaceFirst("\\Q" + resource.getName() + "\\E;?", "");
                                string = resource.getName() + ";" + string;
                                map.put("applications", string);
                                fileChooser.setLocations(map);
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            log.error((Object)"Error when saving the resource URL.", (Throwable)malformedURLException);
                        }
                        catch (Exception exception) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    String string = exception.getMessage();
                                    MainFrame.this.alertButton.setAction(new AlertAction(exception, string, null));
                                }
                            });
                        }
                        finally {
                            MainFrame.this.processFinished();
                        }
                    }
                };
                Thread thread = new Thread(runnable, "LoadResourceFromFileAction");
                thread.setPriority(1);
                thread.start();
            }
        }
    }

    class NewDSAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NewDSAction() {
            super("Create Datastore");
            this.putValue("ShortDescription", "Create a new datastore");
            this.putValue("SmallIcon", MainFrame.getIcon("datastore"));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Map<String, String> map = DataStoreRegister.getDataStoreClassNames();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                hashMap.put(entry.getValue(), entry.getKey());
            }
            if (!hashMap.isEmpty()) {
                JLabel jLabel = new JLabel("Select a type of Datastore:");
                JList<Object> jList = new JList<Object>(hashMap.keySet().toArray());
                String string = Gate.getUserConfig().getString(MainFrame.class.getName() + ".datastoretype");
                if (hashMap.containsKey(string)) {
                    jList.setSelectedValue(string, true);
                } else {
                    jList.setSelectedIndex(0);
                }
                jList.setVisibleRowCount(Math.min(10, jList.getModel().getSize()));
                jList.setSelectionMode(0);
                final JOptionPane jOptionPane = new JOptionPane(new Object[]{jLabel, new JScrollPane(jList)}, 3, 2, MainFrame.getIcon("datastore"), new String[]{"OK", "Cancel", "Help"}, "OK");
                final JDialog jDialog = new JDialog(MainFrame.this, "Create a datastore", true);
                jDialog.setContentPane(jOptionPane);
                jList.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getClickCount() == 2) {
                            jOptionPane.setValue("OK");
                            jDialog.setVisible(false);
                        }
                    }
                });
                jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object = jOptionPane.getValue();
                        if (object == null || object.equals(JOptionPane.UNINITIALIZED_VALUE)) {
                            return;
                        }
                        if (jDialog.isVisible() && propertyChangeEvent.getSource() == jOptionPane && propertyChangeEvent.getPropertyName().equals("value")) {
                            if (jOptionPane.getValue().equals("Help")) {
                                jOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                                MainFrame.this.showHelpFrame("sec:datastores", "gate.persist.SerialDataStore");
                            } else {
                                jDialog.setVisible(false);
                            }
                        }
                    }
                });
                jDialog.pack();
                jDialog.setLocationRelativeTo(MainFrame.this);
                jDialog.setVisible(true);
                Object object = jOptionPane.getValue();
                if (object == null) {
                    return;
                }
                String string2 = (String)hashMap.get(jList.getSelectedValue());
                if (!object.equals("OK") || jList.isSelectionEmpty()) return;
                Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".datastoretype"), jList.getSelectedValue());
                if (string2.equals("gate.persist.SerialDataStore")) {
                    MainFrame.this.createSerialDataStore();
                    return;
                } else if (string2.equals("gate.persist.LuceneDataStoreImpl")) {
                    MainFrame.this.createSearchableDataStore();
                    return;
                } else {
                    if (!string2.equals("gate.persist.OracleDataStore")) throw new UnsupportedOperationException("Unimplemented option!\nUse a serial datastore");
                    JOptionPane.showMessageDialog(MainFrame.this, "Oracle datastores can only be created by your Oracle administrator!", "GATE", 0);
                }
                return;
            } else {
                JOptionPane.showMessageDialog(MainFrame.this, "Could not find any registered types of datastores...\nCheck your GATE installation!", "GATE", 0);
            }
        }
    }

    static class StopAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public StopAction() {
            super(" Stop! ");
            this.putValue("ShortDescription", "Stops the current action");
        }

        public boolean isEnabled() {
            return Gate.getExecutable() != null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Executable executable = Gate.getExecutable();
            if (executable != null) {
                executable.interrupt();
            }
        }
    }

    class NewResourceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        ResourceData rData;

        public NewResourceAction(ResourceData resourceData) {
            super(resourceData.getName());
            this.putValue("ShortDescription", resourceData.getComment());
            this.rData = resourceData;
            this.putValue("SmallIcon", MainFrame.getIcon(resourceData.getIcon()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    MainFrame.this.newResourceDialog.setTitle("Parameters for the new " + NewResourceAction.this.rData.getName());
                    fileChooser.setResource(NewResourceAction.this.rData.getClassName());
                    MainFrame.this.newResourceDialog.show(NewResourceAction.this.rData);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    class LoadCreoleRepositoryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LoadCreoleRepositoryAction() {
            super("Load a CREOLE Repository");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Box box = Box.createHorizontalBox();
            Box box2 = Box.createVerticalBox();
            JTextField jTextField = new JTextField(20);
            box2.add(new JLabel("Type an URL"));
            box2.add(jTextField);
            box.add(box2);
            box.add(Box.createHorizontalStrut(10));
            box.add(new JLabel("or"));
            box.add(Box.createHorizontalStrut(10));
            Box box3 = Box.createVerticalBox();
            box3.add(new JLabel("Select a directory"));
            class URLfromFileAction
            extends AbstractAction {
                private static final long serialVersionUID = 1L;
                JTextField textField;

                URLfromFileAction(JTextField jTextField) {
                    super(null, MainFrame.getIcon("open-file"));
                    this.putValue("ShortDescription", "Click to select a directory");
                    this.textField = jTextField;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    fileChooser.setResource("gate.CreoleRegister");
                    int n = fileChooser.showOpenDialog(MainFrame.this);
                    if (n == 0) {
                        try {
                            this.textField.setText(fileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new GateRuntimeException(malformedURLException.toString());
                        }
                    }
                }
            }
            JButton jButton = new JButton(new URLfromFileAction(jTextField));
            box3.add(jButton);
            box.add(box3);
            int n = JOptionPane.showConfirmDialog(MainFrame.this, box, "Enter an URL to the directory containig the \"creole.xml\" file", 2, 3, null);
            if (n == 0) {
                try {
                    URL uRL = new URL(jTextField.getText());
                    Gate.getCreoleRegister().registerDirectories(uRL);
                }
                catch (Exception exception) {
                    String string = "There was a problem when registering your CREOLE directory.";
                    MainFrame.this.alertButton.setAction(new AlertAction(exception, string, null));
                }
            }
        }
    }

    class ManagePluginsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ManagePluginsAction() {
            super("Manage CREOLE Plugins");
            this.putValue("ShortDescription", "Load, unload, add and remove CREOLE plugins");
            this.putValue("SmallIcon", MainFrame.getIcon("creole-plugins"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.pluginManager == null) {
                MainFrame.this.pluginManager = new PluginManagerUI(MainFrame.this);
                MainFrame.this.pluginManager.setModal(true);
                MainFrame.getGuiRoots().add(MainFrame.this.pluginManager);
                MainFrame.this.pluginManager.pack();
                Dimension dimension = MainFrame.this.getGraphicsConfiguration().getBounds().getSize();
                Dimension dimension2 = MainFrame.this.pluginManager.getPreferredSize();
                int n = dimension2.width > dimension.width ? dimension.width * 3 / 4 : dimension2.width;
                int n2 = dimension2.height > dimension.height ? dimension.height * 3 / 4 : dimension2.height;
                MainFrame.this.pluginManager.setSize(n, n2);
                MainFrame.this.pluginManager.validate();
                int n3 = (dimension.width - n) / 2;
                int n4 = (dimension.height - n2) / 2;
                MainFrame.this.pluginManager.setLocation(n3, n4);
            }
            fileChooser.setResource(PluginManagerUI.class.getName());
            MainFrame.this.pluginManager.setVisible(true);
            MainFrame.this.pluginManager.dispose();
        }
    }

    class NewBootStrapAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NewBootStrapAction() {
            super("BootStrap Wizard", MainFrame.getIcon("application"));
            this.putValue("ShortDescription", "Create a generic resource to be completed");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BootStrapDialog bootStrapDialog = new BootStrapDialog(MainFrame.this);
            bootStrapDialog.setVisible(true);
        }
    }

    class LoadApplicationAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private String pluginDir;
        private String applicationFile;

        public LoadApplicationAction(String string, String string2, String string3) {
            super("Load " + string2 + " System");
            this.pluginDir = null;
            this.applicationFile = null;
            this.pluginDir = string2;
            this.applicationFile = string3;
            this.putValue("ShortDescription", "Load " + string2 + " with default parameters");
            this.putValue("SmallIcon", MainFrame.getIcon("open-application"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    MainFrame.lockGUI(LoadApplicationAction.this.pluginDir + " is being loaded...");
                    try {
                        long l = System.currentTimeMillis();
                        PersistenceManager.loadObjectFromFile(new File(new File(Gate.getPluginsHome(), LoadApplicationAction.this.pluginDir), LoadApplicationAction.this.applicationFile));
                        long l2 = System.currentTimeMillis();
                        MainFrame.this.statusChanged(LoadApplicationAction.this.pluginDir + " loaded in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                    }
                    catch (Exception exception) {
                        String string = "There was an error when loading the " + LoadApplicationAction.this.pluginDir + " application.";
                        MainFrame.this.alertButton.setAction(new AlertAction(exception, string, null));
                    }
                    finally {
                        MainFrame.unlockGUI();
                    }
                }
            };
            Thread thread = new Thread(runnable, "LoadApplicationAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class LoadANNIEWithoutDefaultsAction
    extends AbstractAction
    implements ANNIEConstants {
        private static final long serialVersionUID = 1L;

        public LoadANNIEWithoutDefaultsAction() {
            super("without Defaults");
            this.putValue("ShortDescription", "Load ANNIE without default parameters");
            this.putValue("SmallIcon", MainFrame.getIcon("annie-application"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    SerialAnalyserController serialAnalyserController;
                    MainFrame.lockGUI("ANNIE is being loaded...");
                    try {
                        serialAnalyserController = (SerialAnalyserController)PersistenceManager.loadObjectFromFile(new File(new File(Gate.getPluginsHome(), "ANNIE"), "ANNIE_with_defaults.gapp"));
                        MainFrame.this.statusChanged("ANNIE loaded!");
                        MainFrame.unlockGUI();
                    }
                    catch (Exception exception) {
                        MainFrame.unlockGUI();
                        String string = "There was an error when loading the ANNIE application.";
                        MainFrame.this.alertButton.setAction(new AlertAction(exception, string, null));
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ArrayList arrayList = new ArrayList(serialAnalyserController.getPRs());
                            for (ProcessingResource processingResource : arrayList) {
                                try {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            int n = MainFrame.this.resourcesTree.getRowForPath(new TreePath(MainFrame.this.processingResourcesRoot.getPath()));
                                            MainFrame.this.resourcesTree.setSelectionRow(n += MainFrame.this.processingResourcesRoot.getChildCount());
                                            MainFrame.this.resourcesTree.scrollRowToVisible(n);
                                        }
                                    });
                                    ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
                                    if (resourceData == null) {
                                        throw new ResourceInstantiationException(processingResource.getName() + " was not possible to load.");
                                    }
                                    fileChooser.setResource(resourceData.getClassName());
                                    if (MainFrame.this.newResourceDialog.show(resourceData, "Parameters for the new " + resourceData.getName())) {
                                        serialAnalyserController.add((ProcessingResource)Factory.createResource(processingResource.getClass().getName(), MainFrame.this.newResourceDialog.getSelectedParameters()));
                                    }
                                    Factory.deleteResource(processingResource);
                                }
                                catch (ResourceInstantiationException resourceInstantiationException) {
                                    String string = "There was an error when creating the resource: " + processingResource.getName() + ".";
                                    MainFrame.this.alertButton.setAction(new AlertAction(resourceInstantiationException, string, null));
                                }
                            }
                        }
                    });
                }
            };
            Thread thread = new Thread(runnable, "LoadANNIEWithoutDefaultsAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class LoadANNIEWithDefaultsAction
    extends AbstractAction
    implements ANNIEConstants {
        private static final long serialVersionUID = 1L;

        public LoadANNIEWithDefaultsAction() {
            super("with Defaults");
            this.putValue("ShortDescription", "Load ANNIE with default parameters");
            this.putValue("SmallIcon", MainFrame.getIcon("annie-application"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    MainFrame.lockGUI("ANNIE is being loaded...");
                    try {
                        long l = System.currentTimeMillis();
                        PersistenceManager.loadObjectFromFile(new File(new File(Gate.getPluginsHome(), "ANNIE"), "ANNIE_with_defaults.gapp"));
                        long l2 = System.currentTimeMillis();
                        MainFrame.this.statusChanged("ANNIE loaded in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                    }
                    catch (Exception exception) {
                        String string = "There was an error when loading the ANNIE application.";
                        MainFrame.this.alertButton.setAction(new AlertAction(exception, string, null));
                    }
                    finally {
                        MainFrame.unlockGUI();
                    }
                }
            };
            Thread thread = new Thread(runnable, "LoadANNIEWithDefaultsAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class VerboseModeCorpusEvalToolAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected boolean verboseMode;

        public VerboseModeCorpusEvalToolAction() {
            super("Verbose Mode");
            this.verboseMode = false;
        }

        public boolean isVerboseMode() {
            return this.verboseMode;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(actionEvent.getSource() instanceof JCheckBoxMenuItem)) {
                return;
            }
            this.verboseMode = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
        }
    }

    class GenerateStoredCorpusEvalAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public GenerateStoredCorpusEvalAction() {
            super("Store Corpus for Future Evaluation");
            this.putValue("ShortDescription", "Store corpus for future evaluation");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    fileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName());
                    int n = fileChooser.showOpenDialog(MainFrame.this);
                    File file = fileChooser.getSelectedFile();
                    if (n == 1 || file == null) {
                        return;
                    }
                    fileChooser.setDialogTitle("Please select the application that you want to run");
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName() + ".application");
                    n = fileChooser.showOpenDialog(MainFrame.this);
                    File file2 = fileChooser.getSelectedFile();
                    if (n == 1 || file2 == null) {
                        return;
                    }
                    CorpusBenchmarkTool corpusBenchmarkTool = new CorpusBenchmarkTool();
                    corpusBenchmarkTool.setStartDirectory(file);
                    corpusBenchmarkTool.setApplicationFile(file2);
                    corpusBenchmarkTool.setGenerateMode(true);
                    Out.prln("Processing and storing documents for future evaluation.");
                    corpusBenchmarkTool.init();
                    corpusBenchmarkTool.execute();
                    corpusBenchmarkTool.unloadPRs();
                    Out.prln("Finished!");
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "GenerateStoredCorpusEvalAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class CleanMarkedCorpusEvalAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CleanMarkedCorpusEvalAction() {
            super("Human Marked Against Current Processing Results");
            this.putValue("ShortDescription", "Compares current processed set with human-annotated set");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    fileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName());
                    int n = fileChooser.showOpenDialog(MainFrame.this);
                    File file = fileChooser.getSelectedFile();
                    if (n == 1 || file == null) {
                        return;
                    }
                    fileChooser.setDialogTitle("Please select the application that you want to run");
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName() + ".application");
                    n = fileChooser.showOpenDialog(MainFrame.this);
                    File file2 = fileChooser.getSelectedFile();
                    if (n == 1 || file2 == null) {
                        return;
                    }
                    CorpusBenchmarkTool corpusBenchmarkTool = new CorpusBenchmarkTool();
                    corpusBenchmarkTool.setStartDirectory(file);
                    corpusBenchmarkTool.setApplicationFile(file2);
                    corpusBenchmarkTool.setMarkedClean(true);
                    corpusBenchmarkTool.setVerboseMode(MainFrame.this.verboseModeItem.isSelected());
                    Out.prln("Evaluating human-marked documents against current processing results.");
                    corpusBenchmarkTool.init();
                    corpusBenchmarkTool.execute();
                    corpusBenchmarkTool.printStatistics();
                    Out.prln("Overall average precision: " + corpusBenchmarkTool.getPrecisionAverage());
                    Out.prln("Overall average recall: " + corpusBenchmarkTool.getRecallAverage());
                    Out.prln("Overall average fMeasure : " + corpusBenchmarkTool.getFMeasureAverage());
                    Out.prln("Finished!");
                    corpusBenchmarkTool.unloadPRs();
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "CleanMarkedCorpusEvalAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class StoredMarkedCorpusEvalAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public StoredMarkedCorpusEvalAction() {
            super("Human Marked Against Stored Processing Results");
            this.putValue("ShortDescription", "Compares stored processed set with human-annotated set");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    fileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName());
                    int n = fileChooser.showOpenDialog(MainFrame.this);
                    File file = fileChooser.getSelectedFile();
                    if (n == 1 || file == null) {
                        return;
                    }
                    CorpusBenchmarkTool corpusBenchmarkTool = new CorpusBenchmarkTool();
                    corpusBenchmarkTool.setStartDirectory(file);
                    corpusBenchmarkTool.setMarkedStored(true);
                    corpusBenchmarkTool.setVerboseMode(MainFrame.this.verboseModeItem.isSelected());
                    Out.prln("Evaluating human-marked documents against pre-stored results.");
                    corpusBenchmarkTool.init();
                    corpusBenchmarkTool.execute();
                    corpusBenchmarkTool.printStatistics();
                    Out.prln("<BR>Overall average precision: " + corpusBenchmarkTool.getPrecisionAverage());
                    Out.prln("<BR>Overall average recall: " + corpusBenchmarkTool.getRecallAverage());
                    Out.prln("<BR>Overall average fMeasure : " + corpusBenchmarkTool.getFMeasureAverage());
                    Out.prln("<BR>Finished!");
                    corpusBenchmarkTool.unloadPRs();
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "StoredMarkedCorpusEvalAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class NewCorpusEvalAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NewCorpusEvalAction() {
            super("Default Mode");
            this.putValue("ShortDescription", "Compares stored processed set with current processed set and human-annotated set");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    fileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName());
                    int n = fileChooser.showOpenDialog(MainFrame.this);
                    File file = fileChooser.getSelectedFile();
                    if (n == 1 || file == null) {
                        return;
                    }
                    fileChooser.setDialogTitle("Please select the application that you want to run");
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName() + ".application");
                    n = fileChooser.showOpenDialog(MainFrame.this);
                    File file2 = fileChooser.getSelectedFile();
                    if (n == 1 || file2 == null) {
                        return;
                    }
                    CorpusBenchmarkTool corpusBenchmarkTool = new CorpusBenchmarkTool();
                    corpusBenchmarkTool.setStartDirectory(file);
                    corpusBenchmarkTool.setApplicationFile(file2);
                    corpusBenchmarkTool.setVerboseMode(MainFrame.this.verboseModeItem.isSelected());
                    Out.prln("Please wait while GATE tools are initialised.");
                    corpusBenchmarkTool.init();
                    corpusBenchmarkTool.execute();
                    corpusBenchmarkTool.printStatistics();
                    Out.prln("<BR>Overall average precision: " + corpusBenchmarkTool.getPrecisionAverage());
                    Out.prln("<BR>Overall average recall: " + corpusBenchmarkTool.getRecallAverage());
                    Out.prln("<BR>Overall average fMeasure : " + corpusBenchmarkTool.getFMeasureAverage());
                    Out.prln("<BR>Finished!");
                    corpusBenchmarkTool.unloadPRs();
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "NewCorpusEvalAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class NewAnnotDiffAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NewAnnotDiffAction() {
            super("Annotation Diff", MainFrame.getIcon("annotation-diff"));
            this.putValue("ShortDescription", "Compare annotations and features in one or two documents");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Enumeration<TreeNode> enumeration = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
            Handle handle = null;
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!(defaultMutableTreeNode.getUserObject() instanceof Handle) || !MainFrame.this.mainTabbedPane.getSelectedComponent().equals(((Handle)defaultMutableTreeNode.getUserObject()).getLargeView())) continue;
                handle = (Handle)defaultMutableTreeNode.getUserObject();
                break;
            }
            String string = null;
            if (handle != null && handle.getTarget() instanceof Document) {
                string = ((Document)handle.getTarget()).getName();
            }
            AnnotationDiffGUI annotationDiffGUI = string != null ? new AnnotationDiffGUI("Annotation Diff Tool", string, string, null, null, null, null) : new AnnotationDiffGUI("Annotation Diff Tool");
            annotationDiffGUI.pack();
            annotationDiffGUI.setLocationRelativeTo(MainFrame.this);
            annotationDiffGUI.setVisible(true);
        }
    }
}

