/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.corpora.SerialCorpusImpl;
import gate.creole.AbstractVisualResource;
import gate.creole.annic.Hit;
import gate.creole.annic.PatternAnnotation;
import gate.creole.annic.SearchException;
import gate.creole.annic.Searcher;
import gate.creole.annic.lucene.QueryParser;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.gui.MainFrame;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.AnnotationStack;
import gate.gui.docview.TextualDocumentView;
import gate.persist.LuceneDataStoreImpl;
import gate.persist.PersistenceException;
import gate.persist.SerialDataStore;
import gate.swing.BlockingGlassPane;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.ExtensionFileFilter;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CreoleResource(name="Lucene Datastore Searcher", guiType=GuiType.LARGE, resourceDisplayed="gate.creole.annic.SearchableDataStore", comment="GUI allowing to write a query with a JAPE derived syntax for querying\n a Lucene Datastore and display the results with a stacked view of the\n annotations and their values.", helpURL="http://gate.ac.uk/userguide/chap:annic")
public class LuceneDataStoreSearchGUI
extends AbstractVisualResource
implements DatastoreListener {
    private Object target;
    private List<Hit> results;
    private Map<String, List<String>> allAnnotTypesAndFeaturesFromDatastore;
    private Map<String, Set<String>> populatedAnnotationTypesAndFeatures;
    private XJTable resultTable;
    private ResultTableModel resultTableModel;
    private JButton configureStackViewButton;
    private XJTable globalStatisticsTable;
    private XJTable oneRowStatisticsTable;
    private Comparator<Integer> integerComparator;
    private Collator stringCollator;
    private JSplitPane bottomSplitPane;
    private JTabbedPane statisticsTabbedPane;
    private QueryTextArea queryTextArea;
    private JComboBox corpusToSearchIn;
    private JComboBox annotationSetsToSearchIn;
    private List<Object> corpusIds;
    private String[] annotationSetIDsFromDataStore;
    private JSlider numberOfResultsSlider;
    private JSlider contextSizeSlider;
    private JLabel titleResults;
    private JButton nextResults;
    private int pageOfResults;
    int noOfResults;
    private AnnotationStack centerPanel;
    private ExecuteQueryAction executeQueryAction;
    private NextResultsAction nextResultsAction;
    private ExportResultsAction exportResultsAction;
    private ConfigureStackViewFrame configureStackViewFrame;
    String[] columnNames = new String[]{"Display", "Shortcut", "Annotation type", "Feature", "Crop"};
    private static final int DISPLAY = 0;
    private static final int SHORTCUT = 1;
    private static final int ANNOTATION_TYPE = 2;
    private static final int FEATURE = 3;
    private static final int CROP = 4;
    private static final int maxStackRows = 100;
    private int numStackRows = 0;
    private String[][] stackRows = new String[101][this.columnNames.length];
    private ConfigureStackViewTableModel configureStackViewTableModel;
    private DefaultTableModel oneRowStatisticsTableModel;
    private DefaultTableModel globalStatisticsTableModel;
    private Vector<String> oneRowStatisticsTableToolTips;
    private Searcher searcher;
    private boolean errorOnLastQuery;

    @Override
    public Resource init() {
        this.results = new ArrayList<Hit>();
        this.allAnnotTypesAndFeaturesFromDatastore = new HashMap<String, List<String>>();
        this.corpusIds = new ArrayList<Object>();
        this.populatedAnnotationTypesAndFeatures = new HashMap<String, Set<String>>();
        this.noOfResults = 0;
        for (int i = 0; i <= 100; ++i) {
            this.stackRows[i][0] = "true";
            this.stackRows[i][1] = "";
            this.stackRows[i][2] = "";
            this.stackRows[i][3] = "";
            this.stackRows[i][4] = "Crop end";
        }
        String string = LuceneDataStoreSearchGUI.class.getName() + ".";
        if (Gate.getUserConfig().containsKey(string + "rows")) {
            List<String> list = Gate.getUserConfig().getList(string + "rows");
            for (int i = 0; i < list.size() && i < 100 * this.columnNames.length; ++i) {
                this.stackRows[i / this.columnNames.length][i % this.columnNames.length] = list.get(i);
                if (i % this.columnNames.length != 0) continue;
                ++this.numStackRows;
            }
        }
        this.initGui();
        this.updateViews();
        this.validate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
            }
        });
        return this;
    }

    @Override
    public void cleanup() {
        this.configureStackViewFrame.dispose();
    }

    protected void initGui() {
        this.setLayout(new BorderLayout());
        this.stringCollator = Collator.getInstance();
        this.stringCollator.setStrength(2);
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string == null || string2 == null) {
                    return 0;
                }
                return LuceneDataStoreSearchGUI.this.stringCollator.compare(string.substring(string.trim().lastIndexOf(32) + 1), string2.substring(string2.trim().lastIndexOf(32) + 1));
            }
        };
        this.integerComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                if (n == null || n2 == null) {
                    return 0;
                }
                return n.compareTo(n2);
            }
        };
        this.configureStackViewFrame = new ConfigureStackViewFrame("Stack view configuration");
        this.configureStackViewFrame.setIconImage(((ImageIcon)MainFrame.getIcon("crystal-clear-action-window-new")).getImage());
        this.configureStackViewFrame.setLocationRelativeTo(this);
        this.configureStackViewFrame.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "close row manager");
        this.configureStackViewFrame.getRootPane().getActionMap().put("close row manager", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LuceneDataStoreSearchGUI.this.configureStackViewFrame.setVisible(false);
            }
        });
        this.configureStackViewFrame.validate();
        this.configureStackViewFrame.setSize(200, 300);
        this.configureStackViewFrame.pack();
        MainFrame.getInstance().addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                LuceneDataStoreSearchGUI.this.configureStackViewFrame.dispose();
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 3));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.queryTextArea = new QueryTextArea();
        this.queryTextArea.setToolTipText("<html>Enter a query to search the datastore.<br><small>'{' or '.' activate auto-completion.<br>Ctrl+Enter add a new line.</small></html>");
        this.queryTextArea.setLineWrap(true);
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        jPanel.add((Component)new JScrollPane(this.queryTextArea), gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = -1;
        jPanel.add((Component)new JLabel("Corpus: "), gridBagConstraints);
        this.corpusToSearchIn = new JComboBox();
        this.corpusToSearchIn.addItem("Entire datastore");
        this.corpusToSearchIn.setPrototypeDisplayValue("Entire datastore");
        this.corpusToSearchIn.setToolTipText("Select the corpus to search in.");
        if (this.target == null || this.target instanceof Searcher) {
            this.corpusToSearchIn.setEnabled(false);
        }
        this.corpusToSearchIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LuceneDataStoreSearchGUI.this.updateAnnotationSetsList();
                    }
                });
            }
        });
        jPanel.add((Component)this.corpusToSearchIn, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut(4), gridBagConstraints);
        jPanel.add((Component)new JLabel("Annotation set: "), gridBagConstraints);
        this.annotationSetsToSearchIn = new JComboBox();
        this.annotationSetsToSearchIn.setPrototypeDisplayValue("Combined sets");
        this.annotationSetsToSearchIn.setToolTipText("Select the annotation set to search in.");
        this.annotationSetsToSearchIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LuceneDataStoreSearchGUI.this.updateAnnotationTypesList();
            }
        });
        jPanel.add((Component)this.annotationSetsToSearchIn, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        JLabel jLabel = new JLabel("Results: ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.numberOfResultsSlider = new JSlider(1, 1100, 50);
        this.numberOfResultsSlider.setToolTipText("50 results per page");
        this.numberOfResultsSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue() > LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getMaximum() - 100) {
                    LuceneDataStoreSearchGUI.this.numberOfResultsSlider.setToolTipText("Retrieve all results.");
                    LuceneDataStoreSearchGUI.this.nextResults.setText("Retrieve all results.");
                    LuceneDataStoreSearchGUI.this.nextResultsAction.setEnabled(false);
                } else {
                    LuceneDataStoreSearchGUI.this.numberOfResultsSlider.setToolTipText("Retrieve " + LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue() + " results per page.");
                    LuceneDataStoreSearchGUI.this.nextResults.setText("Next page of " + LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue() + " results");
                    if (LuceneDataStoreSearchGUI.this.searcher.getHits().length == LuceneDataStoreSearchGUI.this.noOfResults) {
                        LuceneDataStoreSearchGUI.this.nextResultsAction.setEnabled(true);
                    }
                }
                ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(LuceneDataStoreSearchGUI.this.numberOfResultsSlider, 503, 0L, 0, 0, 0, 0, false));
            }
        });
        this.numberOfResultsSlider.addMouseListener(new MouseAdapter(){
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            int initialDelay;
            int reshowDelay;
            int dismissDelay;
            boolean enabled;

            public void mouseEntered(MouseEvent mouseEvent) {
                this.initialDelay = this.toolTipManager.getInitialDelay();
                this.reshowDelay = this.toolTipManager.getReshowDelay();
                this.dismissDelay = this.toolTipManager.getDismissDelay();
                this.enabled = this.toolTipManager.isEnabled();
                this.toolTipManager.setInitialDelay(0);
                this.toolTipManager.setReshowDelay(0);
                this.toolTipManager.setDismissDelay(Integer.MAX_VALUE);
                this.toolTipManager.setEnabled(true);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                this.toolTipManager.setInitialDelay(this.initialDelay);
                this.toolTipManager.setReshowDelay(this.reshowDelay);
                this.toolTipManager.setDismissDelay(this.dismissDelay);
                this.toolTipManager.setEnabled(this.enabled);
            }
        });
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.numberOfResultsSlider, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(Box.createHorizontalStrut(4), gridBagConstraints);
        JLabel jLabel2 = new JLabel("Context size: ");
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.contextSizeSlider = new JSlider(1, 50, 5);
        this.contextSizeSlider.setToolTipText("Display 5 tokens of context in the results.");
        this.contextSizeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LuceneDataStoreSearchGUI.this.contextSizeSlider.setToolTipText("Display " + LuceneDataStoreSearchGUI.this.contextSizeSlider.getValue() + " tokens of context in the results.");
                ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(LuceneDataStoreSearchGUI.this.contextSizeSlider, 503, 0L, 0, 0, 0, 0, false));
            }
        });
        this.contextSizeSlider.addMouseListener(new MouseAdapter(){
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            int initialDelay;
            int reshowDelay;
            int dismissDelay;
            boolean enabled;

            public void mouseEntered(MouseEvent mouseEvent) {
                this.initialDelay = this.toolTipManager.getInitialDelay();
                this.reshowDelay = this.toolTipManager.getReshowDelay();
                this.dismissDelay = this.toolTipManager.getDismissDelay();
                this.enabled = this.toolTipManager.isEnabled();
                this.toolTipManager.setInitialDelay(0);
                this.toolTipManager.setReshowDelay(0);
                this.toolTipManager.setDismissDelay(Integer.MAX_VALUE);
                this.toolTipManager.setEnabled(true);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                this.toolTipManager.setInitialDelay(this.initialDelay);
                this.toolTipManager.setReshowDelay(this.reshowDelay);
                this.toolTipManager.setDismissDelay(this.dismissDelay);
                this.toolTipManager.setEnabled(this.enabled);
            }
        });
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.contextSizeSlider, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 2;
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.executeQueryAction = new ExecuteQueryAction();
        ButtonBorder buttonBorder = new ButtonBorder(new Color(240, 240, 240), new Insets(0, 2, 0, 3), false);
        buttonBorder.setAction(this.executeQueryAction);
        jPanel2.add(buttonBorder);
        ClearQueryAction clearQueryAction = new ClearQueryAction();
        ButtonBorder buttonBorder2 = new ButtonBorder(new Color(240, 240, 240), new Insets(4, 2, 4, 3), false);
        buttonBorder2.setAction(clearQueryAction);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(buttonBorder2);
        this.nextResultsAction = new NextResultsAction();
        this.nextResultsAction.setEnabled(false);
        this.nextResults = new ButtonBorder(new Color(240, 240, 240), new Insets(0, 0, 0, 3), false);
        this.nextResults.setAction(this.nextResultsAction);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.nextResults);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.centerPanel = new AnnotationStack(150, 30);
        this.configureStackViewButton = new ButtonBorder(new Color(250, 250, 250), new Insets(0, 0, 0, 3), true);
        this.configureStackViewButton.setHorizontalAlignment(2);
        this.configureStackViewButton.setAction(new ConfigureStackViewAction());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.titleResults = new JLabel("Results");
        this.titleResults.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        jPanel2.add(this.titleResults);
        jPanel2.add(Box.createHorizontalStrut(5), gridBagConstraints);
        this.exportResultsAction = new ExportResultsAction();
        this.exportResultsAction.setEnabled(false);
        ButtonBorder buttonBorder3 = new ButtonBorder(new Color(240, 240, 240), new Insets(0, 0, 0, 3), false);
        buttonBorder3.setAction(this.exportResultsAction);
        jPanel2.add((Component)buttonBorder3, gridBagConstraints);
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        this.resultTableModel = new ResultTableModel();
        this.resultTable = new XJTable(this.resultTableModel);
        this.resultTable.setDefaultRenderer(String.class, new ResultTableCellRenderer());
        this.resultTable.setEnableHidingColumns(true);
        this.resultTable.addMouseListener(new MouseAdapter(){
            private JPopupMenu mousePopup;
            JMenuItem menuItem;

            public void mousePressed(MouseEvent mouseEvent) {
                int n = LuceneDataStoreSearchGUI.this.resultTable.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.isPopupTrigger() && !LuceneDataStoreSearchGUI.this.resultTable.isRowSelected(n)) {
                    LuceneDataStoreSearchGUI.this.resultTable.getSelectionModel().setSelectionInterval(n, n);
                }
                if (mouseEvent.isPopupTrigger()) {
                    this.createPopup();
                    this.mousePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.createPopup();
                    this.mousePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            private void createPopup() {
                this.mousePopup = new JPopupMenu();
                this.menuItem = new JMenuItem("Remove the selected result" + (LuceneDataStoreSearchGUI.this.resultTable.getSelectedRowCount() > 1 ? "s" : ""));
                this.mousePopup.add(this.menuItem);
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        int[] nArray = LuceneDataStoreSearchGUI.this.resultTable.getSelectedRows();
                        for (n = 0; n < nArray.length; ++n) {
                            nArray[n] = LuceneDataStoreSearchGUI.this.resultTable.rowViewToModel(nArray[n]);
                        }
                        Arrays.sort(nArray);
                        for (n = nArray.length - 1; n >= 0; --n) {
                            LuceneDataStoreSearchGUI.this.results.remove(nArray[n]);
                        }
                        LuceneDataStoreSearchGUI.this.resultTable.clearSelection();
                        LuceneDataStoreSearchGUI.this.resultTableModel.fireTableDataChanged();
                        mousePopup.setVisible(false);
                    }
                });
                if (LuceneDataStoreSearchGUI.this.target instanceof LuceneDataStoreImpl && SwingUtilities.getRoot(LuceneDataStoreSearchGUI.this) instanceof MainFrame) {
                    this.menuItem = new JMenuItem("Open the selected document" + (LuceneDataStoreSearchGUI.this.resultTable.getSelectedRowCount() > 1 ? "s" : ""));
                    this.menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Object object;
                            Object object2;
                            HashSet<gate.creole.annic.Pattern> hashSet = new HashSet<gate.creole.annic.Pattern>();
                            HashSet<String> hashSet2 = new HashSet<String>();
                            for (int n : LuceneDataStoreSearchGUI.this.resultTable.getSelectedRows()) {
                                int n2 = LuceneDataStoreSearchGUI.this.resultTable.rowViewToModel(n);
                                object2 = (gate.creole.annic.Pattern)LuceneDataStoreSearchGUI.this.results.get(n2);
                                if (hashSet2.contains(((Hit)object2).getDocumentID())) continue;
                                hashSet.add((gate.creole.annic.Pattern)object2);
                                hashSet2.add(((Hit)object2).getDocumentID());
                            }
                            if (hashSet.size() > 10) {
                                object = new Object[]{"Open the " + hashSet.size() + " documents", "Don't open"};
                                int n = JOptionPane.showOptionDialog(LuceneDataStoreSearchGUI.this, "Do you want to open " + hashSet.size() + " documents in the central tabbed pane ?", "Warning", -1, 3, null, (Object[])object, object[1]);
                                if (n == 1 || n == -1) {
                                    return;
                                }
                            }
                            object = hashSet.iterator();
                            while (object.hasNext()) {
                                Document document;
                                final gate.creole.annic.Pattern pattern = (gate.creole.annic.Pattern)object.next();
                                FeatureMap featureMap = Factory.newFeatureMap();
                                featureMap.put("DataStore", LuceneDataStoreSearchGUI.this.target);
                                featureMap.put("LRPersistenceId", pattern.getDocumentID());
                                try {
                                    document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
                                }
                                catch (GateException gateException) {
                                    gateException.printStackTrace();
                                    return;
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        MainFrame.getInstance().select(document);
                                    }
                                });
                                if (hashSet.size() != 1) continue;
                                Date date = new Date(System.currentTimeMillis() + 2000L);
                                object2 = new Timer("Annic show document timer", true);
                                ((Timer)object2).schedule(new TimerTask(){

                                    public void run() {
                                        LuceneDataStoreSearchGUI.this.showResultInDocument(document, pattern);
                                    }
                                }, date);
                            }
                        }
                    });
                    this.mousePopup.add(this.menuItem);
                }
            }
        });
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    LuceneDataStoreSearchGUI.this.updateStackView();
                }
            }
        });
        this.resultTable.setColumnSelectionAllowed(false);
        this.resultTable.setRowSelectionAllowed(true);
        this.resultTable.setSortable(true);
        this.resultTable.setComparator(0, comparator);
        this.resultTable.setComparator(1, this.stringCollator);
        this.resultTable.setComparator(2, this.stringCollator);
        JScrollPane jScrollPane = new JScrollPane(this.resultTable, 20, 30);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)jScrollPane, gridBagConstraints);
        this.statisticsTabbedPane = new JTabbedPane();
        this.globalStatisticsTable = new XJTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.globalStatisticsTableModel = new DefaultTableModel(new Object[]{"Annotation Type", "Count"}, 0);
        this.globalStatisticsTable.setModel(this.globalStatisticsTableModel);
        this.globalStatisticsTable.setComparator(0, this.stringCollator);
        this.globalStatisticsTable.setComparator(1, this.integerComparator);
        this.globalStatisticsTable.setSortedColumn(1);
        this.globalStatisticsTable.setAscending(false);
        this.statisticsTabbedPane.addTab("Global", null, new JScrollPane(this.globalStatisticsTable), "Global statistics on the Corpus and Annotation Set selected.");
        this.statisticsTabbedPane.addMouseListener(new MouseAdapter(){
            private JPopupMenu mousePopup;
            JMenuItem menuItem;

            public void mousePressed(MouseEvent mouseEvent) {
                int n = LuceneDataStoreSearchGUI.this.statisticsTabbedPane.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                if (mouseEvent.isPopupTrigger() && n > 0) {
                    this.createPopup(n);
                    this.mousePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                int n = LuceneDataStoreSearchGUI.this.statisticsTabbedPane.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                if (mouseEvent.isPopupTrigger() && n > 0) {
                    this.createPopup(n);
                    this.mousePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            private void createPopup(final int n) {
                this.mousePopup = new JPopupMenu();
                if (n == 1) {
                    this.menuItem = new JMenuItem("Clear table");
                    this.menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.setRowCount(0);
                        }
                    });
                } else {
                    this.menuItem = new JMenuItem("Close tab");
                    this.menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            LuceneDataStoreSearchGUI.this.statisticsTabbedPane.remove(n);
                        }
                    });
                }
                this.mousePopup.add(this.menuItem);
            }
        });
        this.oneRowStatisticsTable = new XJTable(){

            public boolean isCellEditable(int n, int n2) {
                return n2 == 2;
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent && n2 != 2) {
                    ((JComponent)component).setToolTipText("<html>" + (String)LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.get(this.rowViewToModel(n)) + "</html>");
                }
                return component;
            }
        };
        this.oneRowStatisticsTableModel = new DefaultTableModel(new Object[]{"Annotation Type/Feature", "Count", ""}, 0);
        this.oneRowStatisticsTable.setModel(this.oneRowStatisticsTableModel);
        class RemoveCellEditorRenderer
        extends AbstractCellEditor
        implements TableCellRenderer,
        TableCellEditor,
        ActionListener {
            private JButton button = new JButton();

            public RemoveCellEditorRenderer() {
                this.button.setHorizontalAlignment(0);
                this.button.setIcon(MainFrame.getIcon("crystal-clear-action-button-cancel"));
                this.button.setToolTipText("Remove this row.");
                this.button.setContentAreaFilled(false);
                this.button.setBorderPainted(false);
                this.button.setMargin(new Insets(0, 0, 0, 0));
                this.button.addActionListener(this);
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.button.setSelected(bl);
                return this.button;
            }

            public boolean shouldSelectCell(EventObject eventObject) {
                return false;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getEditingRow();
                this.fireEditingStopped();
                LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.removeRow(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowViewToModel(n));
            }

            public Object getCellEditorValue() {
                return null;
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.button.setSelected(bl);
                return this.button;
            }
        }
        this.oneRowStatisticsTable.getColumnModel().getColumn(2).setCellEditor(new RemoveCellEditorRenderer());
        this.oneRowStatisticsTable.getColumnModel().getColumn(2).setCellRenderer(new RemoveCellEditorRenderer());
        this.oneRowStatisticsTable.setComparator(0, this.stringCollator);
        this.oneRowStatisticsTable.setComparator(1, this.integerComparator);
        this.statisticsTabbedPane.addTab("One item", null, new JScrollPane(this.oneRowStatisticsTable), "<html>One item statistics.<br>Right-click on an annotation<br>to add statistics here.");
        this.oneRowStatisticsTableToolTips = new Vector();
        this.bottomSplitPane = new JSplitPane(1);
        Dimension dimension = new Dimension(0, 0);
        jPanel3.setMinimumSize(dimension);
        this.statisticsTabbedPane.setMinimumSize(dimension);
        this.bottomSplitPane.add(jPanel3);
        this.bottomSplitPane.add(this.statisticsTabbedPane);
        this.bottomSplitPane.setOneTouchExpandable(true);
        this.bottomSplitPane.setResizeWeight(0.75);
        this.bottomSplitPane.setContinuousLayout(true);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.add(new JScrollPane(this.centerPanel, 20, 30));
        jSplitPane.add(this.bottomSplitPane);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setContinuousLayout(true);
        JSplitPane jSplitPane2 = new JSplitPane(0);
        jSplitPane2.add(jPanel);
        jSplitPane2.add(jSplitPane);
        jSplitPane2.setContinuousLayout(true);
        this.add((Component)jSplitPane2, "Center");
    }

    private void showResultInDocument(Document document, gate.creole.annic.Pattern pattern) {
        try {
            AbstractDocumentView abstractDocumentView = null;
            for (Resource resource : Gate.getCreoleRegister().getAllInstances("gate.gui.docview.TextualDocumentView")) {
                if (!((TextualDocumentView)resource).getDocument().getName().equals(document.getName())) continue;
                abstractDocumentView = (TextualDocumentView)resource;
                break;
            }
            if (abstractDocumentView != null && abstractDocumentView.getOwner() != null) {
                abstractDocumentView.getOwner().setRightView(0);
                try {
                    ((TextualDocumentView)abstractDocumentView).getTextView().scrollRectToVisible(((TextualDocumentView)abstractDocumentView).getTextView().modelToView(pattern.getRightContextEndOffset()));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    return;
                }
                ((TextualDocumentView)abstractDocumentView).getTextView().select(pattern.getLeftContextStartOffset(), pattern.getRightContextEndOffset());
                ((TextualDocumentView)abstractDocumentView).getTextView().requestFocus();
            }
            for (Resource resource : Gate.getCreoleRegister().getAllInstances("gate.gui.docview.AnnotationSetsView")) {
                AnnotationSetsView annotationSetsView = (AnnotationSetsView)resource;
                if (annotationSetsView == null || !annotationSetsView.isActive() || !annotationSetsView.getDocument().getName().equals(document.getName())) continue;
                for (int i = 0; i < this.numStackRows; ++i) {
                    String string;
                    if (this.stackRows[i][0].equals("false") || (string = this.stackRows[i][2]).equals("Token")) continue;
                    String string2 = pattern.getAnnotationSetName();
                    if (string2.equals("<null>") && document.getAnnotations().getAllTypes().contains(string)) {
                        annotationSetsView.setTypeSelected(null, string, true);
                        continue;
                    }
                    if (!document.getAnnotationSetNames().contains(string2) || !document.getAnnotations(string2).getAllTypes().contains(string)) continue;
                    annotationSetsView.setTypeSelected(string2, string, true);
                }
                break;
            }
        }
        catch (GateException gateException) {
            gateException.printStackTrace();
        }
    }

    protected void updateViews() {
        if (this.searcher != null) {
            Collections.addAll(this.results, this.searcher.getHits());
            this.resultTableModel.fireTableDataChanged();
        }
        if (this.results.size() > 0) {
            String string = this.queryTextArea.getText().trim();
            if (string.length() > 0 && !this.results.isEmpty()) {
                int n;
                do {
                    n = this.findStackRow(0, "one time");
                    this.deleteStackRow(n);
                } while (n >= 0);
                Matcher matcher = Pattern.compile("\\{([^\\{\\}=,.]+)(?:(?:\\.([^=]+)==\"([^\\}\"]+)\")|(?:==([^\\}]+)))?(?:, ?([^\\{\\}=,.]+)(?:(?:\\.([^=]+)==\"([^\\}\"]+)\")|(?:==([^\\}]+)))?)?\\}").matcher(string);
                while (matcher.find()) {
                    for (int i = 0; i <= 4; i += 4) {
                        String string2 = null;
                        String string3 = null;
                        n = -1;
                        if (matcher.group(1 + i) != null && matcher.group(2 + i) == null && matcher.group(3 + i) == null && matcher.group(4 + i) == null) {
                            string2 = matcher.group(1 + i);
                            string3 = "";
                            n = this.findStackRow(2, string2, 3, string3);
                        } else if (matcher.group(1 + i) != null && matcher.group(2 + i) == null && matcher.group(3 + i) == null) {
                            String string4 = matcher.group(1 + i);
                            n = this.findStackRow(1, string4);
                        } else if (matcher.group(1 + i) != null && matcher.group(2 + i) != null && matcher.group(4 + i) == null) {
                            string2 = matcher.group(1 + i);
                            string3 = matcher.group(2 + i);
                            n = this.findStackRow(2, string2, 3, string3);
                        }
                        if (n >= 0) {
                            this.stackRows[n][0] = "true";
                            continue;
                        }
                        if (string2 == null || string3 == null || this.numStackRows >= 100) continue;
                        this.stackRows[this.numStackRows][0] = "one time";
                        this.stackRows[this.numStackRows][1] = "";
                        this.stackRows[this.numStackRows][2] = string2;
                        this.stackRows[this.numStackRows][3] = string3;
                        this.stackRows[this.numStackRows][4] = "Crop end";
                        ++this.numStackRows;
                    }
                }
                this.configureStackViewTableModel.fireTableDataChanged();
            }
            this.exportResultsAction.setEnabled(true);
            if (this.numberOfResultsSlider.getValue() <= this.numberOfResultsSlider.getMaximum() - 100) {
                this.nextResultsAction.setEnabled(true);
            }
            if (this.searcher.getHits().length < this.noOfResults) {
                this.nextResultsAction.setEnabled(false);
            }
            this.resultTable.setRowSelectionInterval(0, 0);
            this.resultTable.scrollRectToVisible(this.resultTable.getCellRect(0, 0, true));
        } else if (this.queryTextArea.getText().trim().length() < 1) {
            this.centerPanel.removeAll();
            this.centerPanel.add((Component)new JTextArea("Have a look at the statistics table at the bottom right\nfor the most frequent annotations.\n\nEnter a query in the text area at the top and press Enter.\n\nFor example: {Person} to retrieve Person annotations."), new GridBagConstraints());
            this.centerPanel.updateUI();
            this.nextResultsAction.setEnabled(false);
            this.exportResultsAction.setEnabled(false);
        } else {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridy = -1;
            if (this.errorOnLastQuery) {
                this.errorOnLastQuery = false;
            } else {
                this.centerPanel.removeAll();
                this.centerPanel.add((Component)new JTextArea("No result found for your query."), gridBagConstraints);
                if (!this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") || !this.annotationSetsToSearchIn.getSelectedItem().equals("All sets")) {
                    gridBagConstraints.insets = new Insets(20, 0, 0, 0);
                    this.centerPanel.add((Component)new JTextArea("Consider increasing the number of documents to search in selecting \"Entire datastore\" as corpus\n and \"All sets\" as annotation set in the drop-down lists."), gridBagConstraints);
                }
            }
            gridBagConstraints.insets = new Insets(20, 0, 0, 0);
            this.centerPanel.add((Component)new JTextArea("Try one of these types of query:\n- word (each word must match a Token)\n- {AnnotationType}\n- {AnnotationType==\"text\"}\n- {AnnotationType.feature==\"value\"}\n- {AnnotationType, AnnotationType}\n- ({A}\u2223{B}) (means A or B)\n- ({A})+n (means one and up to n occurrences)\n- ({A})*n (means zero or up to n occurrences)\n"), gridBagConstraints);
            this.centerPanel.updateUI();
            this.exportResultsAction.setEnabled(false);
            this.nextResultsAction.setEnabled(false);
        }
    }

    protected void updateStackView() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        if (this.resultTable.getSelectedRow() == -1) {
            this.centerPanel.removeAll();
            if (this.resultTable.getRowCount() > 0) {
                this.centerPanel.add((Component)new JLabel("Select a row in the results table below."), gridBagConstraints);
            } else if (this.numberOfResultsSlider.getValue() > this.numberOfResultsSlider.getMaximum() - 100) {
                this.centerPanel.add((Component)new JLabel("Retrieving all results..."), gridBagConstraints);
            } else {
                this.centerPanel.add((Component)new JLabel("Retrieving " + this.numberOfResultsSlider.getValue() + " results..."), gridBagConstraints);
            }
            this.centerPanel.validate();
            this.centerPanel.repaint();
            return;
        }
        gate.creole.annic.Pattern pattern = (gate.creole.annic.Pattern)this.results.get(this.resultTable.rowViewToModel(this.resultTable.getSelectionModel().getLeadSelectionIndex()));
        this.centerPanel.setText(pattern.getPatternText());
        this.centerPanel.setExpressionStartOffset(pattern.getStartOffset());
        this.centerPanel.setExpressionEndOffset(pattern.getEndOffset());
        this.centerPanel.setContextBeforeSize(pattern.getStartOffset() - pattern.getLeftContextStartOffset());
        this.centerPanel.setContextAfterSize(pattern.getRightContextEndOffset() - pattern.getEndOffset());
        this.centerPanel.setLastRowButton(this.configureStackViewButton);
        this.centerPanel.setTextMouseListener(new TextMouseListener());
        this.centerPanel.setHeaderMouseListener(new HeaderMouseListener());
        this.centerPanel.setAnnotationMouseListener(new AnnotationMouseListener());
        this.centerPanel.clearAllRows();
        for (int i = 0; i < this.numStackRows; ++i) {
            PatternAnnotation[] patternAnnotationArray;
            if (this.stackRows[i][0].equals("false")) continue;
            String string = this.stackRows[i][2];
            String string2 = this.stackRows[i][3];
            String string3 = this.stackRows[i][1];
            ButtonBorder buttonBorder = new ButtonBorder(new Color(250, 250, 250), new Insets(0, 3, 0, 3), true);
            buttonBorder.setIcon(MainFrame.getIcon("crystal-clear-action-edit-remove"));
            buttonBorder.setToolTipText("Hide this row.");
            final String string4 = string;
            final String string5 = string2;
            buttonBorder.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = LuceneDataStoreSearchGUI.this.findStackRow(2, string4, 3, string5);
                    if (n >= 0) {
                        ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[n][0] = "false";
                        LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
                    }
                    LuceneDataStoreSearchGUI.this.updateStackView();
                }
            });
            int n = this.stackRows[i][4].equals("Crop start") ? 0 : (this.stackRows[i][4].equals("Crop end") ? 2 : 1);
            this.centerPanel.addRow(null, string, string2, buttonBorder, string3, n);
            PatternAnnotation[] patternAnnotationArray2 = patternAnnotationArray = string2.equals("") ? pattern.getPatternAnnotations(string) : pattern.getPatternAnnotations(string, string2);
            if (patternAnnotationArray == null || patternAnnotationArray.length <= 0) continue;
            for (PatternAnnotation patternAnnotation : patternAnnotationArray) {
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.putAll(patternAnnotation.getFeatures());
                this.centerPanel.addAnnotation(patternAnnotation.getStartOffset(), patternAnnotation.getEndOffset(), patternAnnotation.getType(), featureMap);
            }
        }
        this.centerPanel.drawStack();
    }

    protected void updateAnnotationSetsList() {
        String string = this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)this.corpusIds.get(this.corpusToSearchIn.getSelectedIndex() - 1);
        TreeSet<Object> treeSet = new TreeSet<Object>(this.stringCollator);
        treeSet.addAll(this.getAnnotationSetNames(string));
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(treeSet.toArray());
        defaultComboBoxModel.insertElementAt("All sets", 0);
        this.annotationSetsToSearchIn.setModel(defaultComboBoxModel);
        this.annotationSetsToSearchIn.setSelectedItem("All sets");
        TreeSet<Object> treeSet2 = new TreeSet<Object>(this.stringCollator);
        treeSet2.addAll(this.getTypesAndFeatures(null, null).keySet());
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.setMaximumRowCount(10);
        jComboBox.setModel(new DefaultComboBoxModel<Object>(treeSet2.toArray()));
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        defaultCellEditor.setClickCountToStart(0);
        this.configureStackViewFrame.getTable().getColumnModel().getColumn(2).setCellEditor(defaultCellEditor);
    }

    protected void updateAnnotationTypesList() {
        String string = this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)this.corpusIds.get(this.corpusToSearchIn.getSelectedIndex() - 1);
        String string2 = this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)this.annotationSetsToSearchIn.getSelectedItem();
        this.populatedAnnotationTypesAndFeatures = this.getTypesAndFeatures(string, string2);
        int n = 0;
        try {
            TreeSet<Object> treeSet = new TreeSet<Object>(this.stringCollator);
            treeSet.addAll(this.populatedAnnotationTypesAndFeatures.keySet());
            this.globalStatisticsTableModel.setRowCount(0);
            for (String string3 : treeSet) {
                int n2 = this.searcher.freq(string, string2, string3);
                this.globalStatisticsTableModel.addRow(new Object[]{string3, n2});
                n += n2;
            }
        }
        catch (SearchException searchException) {
            searchException.printStackTrace();
            return;
        }
        if (n == 0) {
            this.centerPanel.removeAll();
            this.centerPanel.add((Component)new JLabel("<html>There is no annotation for the moment for the selected corpus and annotation set.<br><br>Select another corpus or annotation set or wait for the end of the automatic indexation."), new GridBagConstraints());
        }
    }

    protected Set<String> getAnnotationSetNames(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null) {
            for (String string2 : this.annotationSetIDsFromDataStore) {
                string2 = string2.substring(string2.indexOf(59) + 1);
                hashSet.add(string2);
            }
        } else {
            for (String string3 : this.annotationSetIDsFromDataStore) {
                if (!string3.startsWith(string + ";")) continue;
                string3 = string3.substring(string3.indexOf(59) + 1);
                hashSet.add(string3);
            }
        }
        return hashSet;
    }

    protected Map<String, Set<String>> getTypesAndFeatures(String string, String string2) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        if (string == null && string2 == null) {
            for (String string3 : this.allAnnotTypesAndFeaturesFromDatastore.keySet()) {
                String string4 = string3.substring(string3.lastIndexOf(59) + 1);
                Set<String> set = hashMap.get(string4);
                if (set == null) {
                    set = new HashSet<String>();
                    hashMap.put(string4, set);
                }
                set.addAll((Collection<String>)this.allAnnotTypesAndFeaturesFromDatastore.get(string3));
            }
        } else if (string == null) {
            for (String string5 : this.allAnnotTypesAndFeaturesFromDatastore.keySet()) {
                String string6 = string5.substring(string5.indexOf(59) + 1);
                if (!string6.startsWith(string2 + ";")) continue;
                Set<String> set = hashMap.get(string6 = string6.substring(string6.indexOf(59) + 1));
                if (set == null) {
                    set = new HashSet<String>();
                    hashMap.put(string6, set);
                }
                set.addAll((Collection<String>)this.allAnnotTypesAndFeaturesFromDatastore.get(string5));
            }
        } else if (string2 == null) {
            for (String string7 : this.allAnnotTypesAndFeaturesFromDatastore.keySet()) {
                if (!string7.startsWith(string + ";")) continue;
                String string8 = string7.substring(string7.lastIndexOf(59) + 1);
                Set<String> set = hashMap.get(string8);
                if (set == null) {
                    set = new HashSet<String>();
                    hashMap.put(string8, set);
                }
                set.addAll((Collection<String>)this.allAnnotTypesAndFeaturesFromDatastore.get(string7));
            }
        } else {
            for (String string9 : this.allAnnotTypesAndFeaturesFromDatastore.keySet()) {
                if (!string9.startsWith(string + ";" + string2 + ";")) continue;
                String string10 = string9.substring(string9.lastIndexOf(59) + 1);
                Set<String> set = hashMap.get(string10);
                if (set == null) {
                    set = new HashSet<String>();
                    hashMap.put(string10, set);
                }
                set.addAll((Collection<String>)this.allAnnotTypesAndFeaturesFromDatastore.get(string9));
            }
        }
        return hashMap;
    }

    protected int findStackRow(Object ... objectArray) {
        int n;
        if (objectArray.length % 2 != 0) {
            return -2;
        }
        for (n = 0; n < objectArray.length; n += 2) {
            if (objectArray[n] == null || objectArray[n + 1] == null) {
                return -2;
            }
            try {
                if (Integer.parseInt(objectArray[n].toString()) < 0 || Integer.parseInt(objectArray[n].toString()) > this.columnNames.length - 1) {
                    return -2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return -2;
            }
            if (objectArray[n + 1] instanceof String) continue;
            return -2;
        }
        for (n = 0; n < this.numStackRows; ++n) {
            int n2 = 0;
            for (int i = 0; i < objectArray.length; i += 2) {
                if (!this.stackRows[n][Integer.parseInt(objectArray[i].toString())].equals(objectArray[i + 1])) continue;
                ++n2;
            }
            if (n2 != objectArray.length / 2) continue;
            return n;
        }
        return -1;
    }

    protected boolean deleteStackRow(int n) {
        if (n < 0 || n > this.numStackRows) {
            return false;
        }
        for (int i = n; i < this.numStackRows; ++i) {
            System.arraycopy(this.stackRows[i + 1], 0, this.stackRows[i], 0, this.columnNames.length);
        }
        this.stackRows[this.numStackRows][0] = "true";
        this.stackRows[this.numStackRows][1] = "";
        this.stackRows[this.numStackRows][2] = "";
        this.stackRows[this.numStackRows][3] = "";
        this.stackRows[this.numStackRows][4] = "Crop end";
        --this.numStackRows;
        return true;
    }

    protected void saveStackViewConfiguration() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.numStackRows; ++i) {
            arrayList.addAll(Arrays.asList(this.stackRows[i]));
        }
        Gate.getUserConfig().put((Object)(LuceneDataStoreSearchGUI.class.getName() + ".rows"), Strings.toString(arrayList));
    }

    @Override
    public void setTarget(Object object) {
        if (!(object instanceof LuceneDataStoreImpl) && !(object instanceof Searcher)) {
            throw new IllegalArgumentException("The GATE LuceneDataStoreSearchGUI can only be used with a GATE LuceneDataStores!\n" + object.getClass().toString() + " is not a GATE LuceneDataStore or an object of Searcher!");
        }
        this.target = object;
        if (object instanceof LuceneDataStoreImpl) {
            ((LuceneDataStoreImpl)object).addDatastoreListener(this);
            this.corpusToSearchIn.setEnabled(true);
            this.searcher = ((LuceneDataStoreImpl)object).getSearcher();
            this.updateSetsTypesAndFeatures();
            try {
                List list = ((LuceneDataStoreImpl)object).getLrIds(SerialCorpusImpl.class.getName());
                if (this.corpusIds != null) {
                    for (Object e : list) {
                        String string = ((LuceneDataStoreImpl)object).getLrName(e);
                        this.corpusIds.add(e);
                        ((DefaultComboBoxModel)this.corpusToSearchIn.getModel()).addElement(string);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LuceneDataStoreSearchGUI.this.corpusToSearchIn.updateUI();
                        LuceneDataStoreSearchGUI.this.corpusToSearchIn.setSelectedItem("Entire datastore");
                    }
                });
            }
            catch (PersistenceException persistenceException) {
                System.out.println("Couldn't find any available corpusIds.");
                throw new GateRuntimeException(persistenceException);
            }
        }
        this.searcher = (Searcher)object;
        this.corpusToSearchIn.setEnabled(false);
        try {
            this.annotationSetIDsFromDataStore = this.searcher.getIndexedAnnotationSetNames();
            this.allAnnotTypesAndFeaturesFromDatastore = this.searcher.getAnnotationTypesMap();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LuceneDataStoreSearchGUI.this.updateAnnotationSetsList();
                }
            });
        }
        catch (SearchException searchException) {
            throw new GateRuntimeException(searchException);
        }
    }

    @Override
    public void resourceAdopted(DatastoreEvent datastoreEvent) {
    }

    @Override
    public void resourceDeleted(DatastoreEvent datastoreEvent) {
        Resource resource = datastoreEvent.getResource();
        if (resource instanceof Corpus) {
            Object object = datastoreEvent.getResourceID();
            int n = this.corpusIds.indexOf(object);
            if (n < 0) {
                return;
            }
            ((DefaultComboBoxModel)this.corpusToSearchIn.getModel()).removeElementAt(++n);
        }
        this.updateSetsTypesAndFeatures();
    }

    @Override
    public void resourceWritten(DatastoreEvent datastoreEvent) {
        Object object;
        Resource resource = datastoreEvent.getResource();
        if (resource instanceof Corpus && !this.corpusIds.contains(object = datastoreEvent.getResourceID())) {
            this.corpusIds.add(object);
            ((DefaultComboBoxModel)this.corpusToSearchIn.getModel()).addElement(resource.getName());
        }
        this.updateSetsTypesAndFeatures();
    }

    protected void updateSetsTypesAndFeatures() {
        try {
            this.annotationSetIDsFromDataStore = this.searcher.getIndexedAnnotationSetNames();
            this.allAnnotTypesAndFeaturesFromDatastore = this.searcher.getAnnotationTypesMap();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LuceneDataStoreSearchGUI.this.updateAnnotationSetsList();
                }
            });
        }
        catch (SearchException searchException) {
            throw new GateRuntimeException(searchException);
        }
    }

    protected class ButtonBorder
    extends JButton {
        public ButtonBorder(Color color, Insets insets, final boolean bl) {
            final CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(1, color, color.darker()), new EmptyBorder(insets));
            final CompoundBorder compoundBorder2 = new CompoundBorder(new EtchedBorder(1, color, color.darker().darker()), new EmptyBorder(insets));
            this.setBorder(compoundBorder);
            this.setBorderPainted(bl);
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    JButton jButton = (JButton)mouseEvent.getComponent();
                    jButton.setBorder(compoundBorder2);
                    jButton.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    JButton jButton = (JButton)mouseEvent.getComponent();
                    jButton.setBorder(compoundBorder);
                    jButton.setBorderPainted(bl);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    JButton jButton = (JButton)mouseEvent.getComponent();
                    jButton.setContentAreaFilled(true);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    JButton jButton = (JButton)mouseEvent.getComponent();
                    jButton.setContentAreaFilled(false);
                }
            });
            this.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    JButton jButton = (JButton)focusEvent.getComponent();
                    jButton.setBorder(compoundBorder2);
                    jButton.setBorderPainted(true);
                }

                public void focusLost(FocusEvent focusEvent) {
                    JButton jButton = (JButton)focusEvent.getComponent();
                    jButton.setBorder(compoundBorder);
                    jButton.setBorderPainted(bl);
                }
            });
        }
    }

    protected class QueryTextArea
    extends JTextArea
    implements DocumentListener,
    MouseListener {
        private static final String ENTER_ACTION = "enter";
        private static final String NEW_LINE = "new line";
        private static final String CANCEL_ACTION = "cancel";
        private static final String DOWN_ACTION = "down";
        private static final String UP_ACTION = "up";
        private static final String UNDO_ACTION = "undo";
        private static final String REDO_ACTION = "redo";
        private static final String NEXT_RESULT = "next result";
        private static final String PREVIOUS_RESULT = "previous result";
        protected DefaultListModel queryListModel;
        protected JList queryList;
        protected JWindow queryPopupWindow;
        protected JPopupMenu mousePopup;
        protected UndoManager undo;
        protected UndoAction undoAction;
        protected RedoAction redoAction;
        protected int start;
        protected int end;
        protected int mode;
        protected static final int INSERT = 0;
        protected static final int POPUP_TYPES = 1;
        protected static final int POPUP_FEATURES = 2;
        protected static final int PROGRAMMATIC = 3;

        public QueryTextArea() {
            this.getDocument().addDocumentListener(this);
            this.addMouseListener(this);
            this.addAncestorListener(new AncestorListener(){

                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }

                public void ancestorAdded(AncestorEvent ancestorEvent) {
                }

                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    QueryTextArea.this.queryPopupWindow.dispose();
                }
            });
            InputMap inputMap = this.getInputMap(0);
            InputMap inputMap2 = this.getInputMap(2);
            ActionMap actionMap = this.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), ENTER_ACTION);
            actionMap.put(ENTER_ACTION, new EnterAction());
            inputMap.put(KeyStroke.getKeyStroke("control ENTER"), NEW_LINE);
            actionMap.put(NEW_LINE, new NewLineAction());
            inputMap2.put(KeyStroke.getKeyStroke("ESCAPE"), CANCEL_ACTION);
            actionMap.put(CANCEL_ACTION, new CancelAction());
            inputMap.put(KeyStroke.getKeyStroke("DOWN"), DOWN_ACTION);
            actionMap.put(DOWN_ACTION, new DownAction());
            inputMap.put(KeyStroke.getKeyStroke("UP"), UP_ACTION);
            actionMap.put(UP_ACTION, new UpAction());
            this.undoAction = new UndoAction();
            inputMap.put(KeyStroke.getKeyStroke("control Z"), UNDO_ACTION);
            actionMap.put(UNDO_ACTION, this.undoAction);
            this.redoAction = new RedoAction();
            inputMap.put(KeyStroke.getKeyStroke("control Y"), REDO_ACTION);
            actionMap.put(REDO_ACTION, this.redoAction);
            inputMap.put(KeyStroke.getKeyStroke("alt DOWN"), NEXT_RESULT);
            actionMap.put(NEXT_RESULT, new NextResultAction());
            inputMap.put(KeyStroke.getKeyStroke("alt UP"), PREVIOUS_RESULT);
            actionMap.put(PREVIOUS_RESULT, new PreviousResultAction());
            this.queryListModel = new DefaultListModel();
            this.queryList = new JList(this.queryListModel);
            this.queryList.setSelectionMode(0);
            this.queryList.setBackground(Color.WHITE);
            this.queryList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        new EnterAction().actionPerformed(null);
                    }
                }
            });
            this.queryPopupWindow = new JWindow();
            this.queryPopupWindow.add(new JScrollPane(this.queryList));
            this.mousePopup = new JPopupMenu();
            this.mousePopup.add(new JMenuItem(new MultiplierAction(0, 1)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(0, 2)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(0, 3)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(0, 4)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(0, 5)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(1, 2)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(1, 3)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(1, 4)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(1, 5)));
            this.undo = new UndoManager();
            this.getDocument().addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    QueryTextArea.this.undo.addEdit(undoableEditEvent.getEdit());
                    QueryTextArea.this.undoAction.updateUndoState();
                    QueryTextArea.this.redoAction.updateRedoState();
                }
            });
            this.start = 0;
            this.end = 0;
            this.mode = 0;
            this.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent caretEvent) {
                    if (!(QueryTextArea.this.mode != 1 && QueryTextArea.this.mode != 2 || QueryTextArea.this.getCaretPosition() >= QueryTextArea.this.start && QueryTextArea.this.getCaretPosition() <= QueryTextArea.this.end + 1)) {
                        QueryTextArea.this.cleanup();
                    }
                }
            });
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            block6: {
                int n;
                block7: {
                    if (this.mode == 3 || this.mode == 0) {
                        return;
                    }
                    n = documentEvent.getOffset();
                    if (documentEvent.getLength() != 1 || n < this.start || n > this.end) {
                        this.cleanup();
                        return;
                    }
                    if (this.mode != 1) break block7;
                    this.end = n;
                    String string = this.getText().substring(this.start, this.end);
                    if (!string.matches("[a-zA-Z0-9]+")) {
                        return;
                    }
                    for (int i = 0; i < this.queryList.getModel().getSize(); ++i) {
                        if (!this.startsWithIgnoreCase((String)this.queryList.getModel().getElementAt(i), string)) continue;
                        this.queryPopupWindow.setVisible(true);
                        this.queryList.setSelectedIndex(i);
                        this.queryList.ensureIndexIsVisible(i);
                        break block6;
                    }
                    break block6;
                }
                if (this.mode != 2) break block6;
                this.end = n;
                String string = this.getText().substring(this.start, this.end);
                if (!string.matches("[a-zA-Z0-9]+")) {
                    return;
                }
                for (int i = 0; i < this.queryList.getModel().getSize(); ++i) {
                    if (!this.startsWithIgnoreCase((String)this.queryList.getModel().getElementAt(i), string)) continue;
                    this.queryPopupWindow.setVisible(true);
                    this.queryList.setSelectedIndex(i);
                    this.queryList.ensureIndexIsVisible(i);
                    break;
                }
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            String string;
            if (this.mode == 3) {
                return;
            }
            int n = documentEvent.getOffset();
            if (documentEvent.getLength() != 1) {
                this.cleanup();
                return;
            }
            String string2 = Character.toString(this.getText().charAt(n));
            String string3 = n > 0 ? Character.toString(this.getText().charAt(n - 1)) : "";
            String string4 = string = n + 1 < this.getText().length() ? Character.toString(this.getText().charAt(n + 1)) : "";
            if ((string2.equals("{") && !string3.equals("\\") || string2.equals(",") && string.equals("}")) && this.mode == 0) {
                this.mode = 1;
                this.start = n + 1;
                this.end = n + 1;
                SwingUtilities.invokeLater(new PopupTypeTask());
            } else if (string2.equals(".") && this.mode == 0) {
                this.mode = 2;
                this.start = n + 1;
                this.end = n + 1;
                SwingUtilities.invokeLater(new PopupFeatureTask());
            } else if (string2.matches("[a-zA-Z0-9]") && this.mode == 1) {
                this.end = n;
                String string5 = this.getText().substring(this.start, this.end + 1);
                boolean bl = false;
                if (string5.matches("[a-zA-Z0-9]+")) {
                    for (int i = 0; i < this.queryList.getModel().getSize(); ++i) {
                        if (!this.startsWithIgnoreCase((String)this.queryList.getModel().getElementAt(i), string5)) continue;
                        this.queryPopupWindow.setVisible(true);
                        this.queryList.setSelectedIndex(i);
                        this.queryList.ensureIndexIsVisible(i);
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    this.queryPopupWindow.setVisible(false);
                }
            } else if (string2.matches("[a-zA-Z0-9]") && this.mode == 2) {
                this.end = n;
                String string6 = this.getText().substring(this.start, this.end + 1);
                boolean bl = false;
                if (string6.matches("[a-zA-Z0-9]+")) {
                    for (int i = 0; i < this.queryList.getModel().getSize(); ++i) {
                        if (!this.startsWithIgnoreCase((String)this.queryList.getModel().getElementAt(i), string6)) continue;
                        this.queryPopupWindow.setVisible(true);
                        this.queryList.setSelectedIndex(i);
                        this.queryList.ensureIndexIsVisible(i);
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    this.queryPopupWindow.setVisible(false);
                }
            }
        }

        private boolean startsWithIgnoreCase(String string, String string2) {
            return string.toUpperCase().startsWith(string2.toUpperCase());
        }

        private void cleanup() {
            this.mode = 0;
            this.queryPopupWindow.setVisible(false);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.createPopup(mouseEvent);
                this.mousePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.createPopup(mouseEvent);
                this.mousePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void createPopup(MouseEvent mouseEvent) {
            if (!(this.getSelectedText() != null && QueryParser.isValidQuery(this.getSelectedText()) || this.getDocument().getLength() <= 3)) {
                int n = this.viewToModel(mouseEvent.getPoint());
                if (n >= this.getDocument().getLength()) {
                    n = this.getDocument().getLength() - 1;
                }
                int n2 = this.getText().substring(0, n + 1).lastIndexOf("{");
                int n3 = this.getText().substring(n, this.getDocument().getLength()).indexOf("}") + n;
                if (n2 != -1 && n3 != -1 && QueryParser.isValidQuery(this.getText().substring(n2, n3 + 1))) {
                    this.setSelectionStart(n2);
                    this.setSelectionEnd(n3 + 1);
                }
            }
        }

        private class RedoAction
        extends AbstractAction {
            public RedoAction() {
                super("Redo");
                this.setEnabled(false);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QueryTextArea.this.undo.redo();
                }
                catch (CannotRedoException cannotRedoException) {
                    System.out.println("Unable to redo: " + cannotRedoException);
                    cannotRedoException.printStackTrace();
                }
                this.updateRedoState();
                QueryTextArea.this.undoAction.updateUndoState();
            }

            protected void updateRedoState() {
                if (QueryTextArea.this.undo.canRedo()) {
                    this.setEnabled(true);
                    this.putValue("Name", QueryTextArea.this.undo.getRedoPresentationName());
                } else {
                    this.setEnabled(false);
                    this.putValue("Name", "Redo");
                }
            }
        }

        private class UndoAction
        extends AbstractAction {
            public UndoAction() {
                super("Undo");
                this.setEnabled(false);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QueryTextArea.this.undo.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    System.out.println("Unable to undo: " + cannotUndoException);
                    cannotUndoException.printStackTrace();
                }
                this.updateUndoState();
                QueryTextArea.this.redoAction.updateRedoState();
            }

            protected void updateUndoState() {
                if (QueryTextArea.this.undo.canUndo()) {
                    this.setEnabled(true);
                    this.putValue("Name", QueryTextArea.this.undo.getUndoPresentationName());
                } else {
                    this.setEnabled(false);
                    this.putValue("Name", "Undo");
                }
            }
        }

        private class NewLineAction
        extends AbstractAction {
            private NewLineAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QueryTextArea.this.getDocument().insertString(QueryTextArea.this.getCaretPosition(), "\n", null);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        private class NextResultAction
        extends AbstractAction {
            private NextResultAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() + 1 < LuceneDataStoreSearchGUI.this.resultTable.getRowCount()) {
                    LuceneDataStoreSearchGUI.this.resultTable.setRowSelectionInterval(LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() + 1, LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() + 1);
                    LuceneDataStoreSearchGUI.this.resultTable.scrollRectToVisible(LuceneDataStoreSearchGUI.this.resultTable.getCellRect(LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() + 1, 0, true));
                }
            }
        }

        private class PreviousResultAction
        extends AbstractAction {
            private PreviousResultAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() > 0) {
                    LuceneDataStoreSearchGUI.this.resultTable.setRowSelectionInterval(LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() - 1, LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() - 1);
                    LuceneDataStoreSearchGUI.this.resultTable.scrollRectToVisible(LuceneDataStoreSearchGUI.this.resultTable.getCellRect(LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() - 1, 0, true));
                }
            }
        }

        private class UpAction
        extends AbstractAction {
            private UpAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (QueryTextArea.this.mode == 1) {
                    int n2 = QueryTextArea.this.queryList.getSelectedIndex();
                    if (n2 > 0) {
                        QueryTextArea.this.queryList.setSelectedIndex(n2 - 1);
                        QueryTextArea.this.queryList.ensureIndexIsVisible(n2 - 1);
                    }
                } else if (QueryTextArea.this.mode == 2 && (n = QueryTextArea.this.queryList.getSelectedIndex()) > 0) {
                    QueryTextArea.this.queryList.setSelectedIndex(n - 1);
                    QueryTextArea.this.queryList.ensureIndexIsVisible(n - 1);
                }
            }
        }

        private class DownAction
        extends AbstractAction {
            private DownAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (QueryTextArea.this.mode == 1) {
                    int n2 = QueryTextArea.this.queryList.getSelectedIndex();
                    if (n2 + 1 < QueryTextArea.this.queryList.getModel().getSize()) {
                        QueryTextArea.this.queryList.setSelectedIndex(n2 + 1);
                        QueryTextArea.this.queryList.ensureIndexIsVisible(n2 + 1);
                    }
                } else if (QueryTextArea.this.mode == 2 && (n = QueryTextArea.this.queryList.getSelectedIndex()) + 1 < QueryTextArea.this.queryList.getModel().getSize()) {
                    QueryTextArea.this.queryList.setSelectedIndex(n + 1);
                    QueryTextArea.this.queryList.ensureIndexIsVisible(n + 1);
                }
            }
        }

        private class CancelAction
        extends AbstractAction {
            private CancelAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                QueryTextArea.this.cleanup();
            }
        }

        private class EnterAction
        extends AbstractAction {
            private EnterAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)QueryTextArea.this.queryList.getSelectedValue();
                if (QueryTextArea.this.mode == 1) {
                    if (string == null) {
                        return;
                    }
                    QueryTextArea.this.mode = 3;
                    try {
                        if (QueryTextArea.this.end < QueryTextArea.this.getDocument().getLength()) {
                            QueryTextArea.this.getDocument().remove(QueryTextArea.this.start, QueryTextArea.this.end - QueryTextArea.this.start + 1);
                        }
                        QueryTextArea.this.getDocument().insertString(QueryTextArea.this.start, string, null);
                        if (QueryTextArea.this.getText().charAt(QueryTextArea.this.start - 1) != ',') {
                            QueryTextArea.this.getDocument().insertString(QueryTextArea.this.start + string.length(), "}", null);
                            QueryTextArea.this.setCaretPosition(QueryTextArea.this.getCaretPosition() - 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else if (QueryTextArea.this.mode == 2) {
                    if (string == null) {
                        return;
                    }
                    QueryTextArea.this.mode = 3;
                    try {
                        if (QueryTextArea.this.end < QueryTextArea.this.getDocument().getLength() && QueryTextArea.this.getText().charAt(QueryTextArea.this.end) != '}') {
                            QueryTextArea.this.getDocument().remove(QueryTextArea.this.start, QueryTextArea.this.end - QueryTextArea.this.start + 1);
                        }
                        QueryTextArea.this.getDocument().insertString(QueryTextArea.this.start, string, null);
                        QueryTextArea.this.getDocument().insertString(QueryTextArea.this.start + string.length(), "==\"\"", null);
                        QueryTextArea.this.setCaretPosition(QueryTextArea.this.getCaretPosition() - 1);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else {
                    LuceneDataStoreSearchGUI.this.executeQueryAction.actionPerformed(null);
                }
                QueryTextArea.this.cleanup();
            }
        }

        private class PopupFeatureTask
        implements Runnable {
            private PopupFeatureTask() {
            }

            public void run() {
                int n = Math.max(QueryTextArea.this.getText().substring(0, QueryTextArea.this.end - 1).lastIndexOf("{"), Math.max(QueryTextArea.this.getText().substring(0, QueryTextArea.this.end - 1).lastIndexOf(","), QueryTextArea.this.getText().substring(0, QueryTextArea.this.end - 1).lastIndexOf(", ") + 1));
                String string = QueryTextArea.this.getText().substring(n + 1, QueryTextArea.this.end - 1);
                if (!LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.containsKey(string)) {
                    QueryTextArea.this.cleanup();
                    return;
                }
                try {
                    TreeSet<Object> treeSet = new TreeSet<Object>(LuceneDataStoreSearchGUI.this.stringCollator);
                    treeSet.addAll((Collection)LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.get(string));
                    QueryTextArea.this.queryListModel.clear();
                    for (String string2 : treeSet) {
                        QueryTextArea.this.queryListModel.addElement(string2);
                    }
                    QueryTextArea.this.queryList.setVisibleRowCount(Math.min(12, treeSet.size()));
                    Rectangle rectangle = QueryTextArea.this.modelToView(QueryTextArea.this.getCaret().getDot());
                    QueryTextArea.this.queryPopupWindow.setLocation(QueryTextArea.this.getLocationOnScreen().x + (int)rectangle.getMaxX(), QueryTextArea.this.getLocationOnScreen().y + (int)rectangle.getMaxY());
                    QueryTextArea.this.queryPopupWindow.pack();
                    QueryTextArea.this.queryPopupWindow.setVisible(true);
                    if (QueryTextArea.this.queryListModel.getSize() == 1) {
                        QueryTextArea.this.queryList.setSelectedIndex(0);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        private class PopupTypeTask
        implements Runnable {
            private PopupTypeTask() {
            }

            public void run() {
                try {
                    TreeSet<Object> treeSet = new TreeSet<Object>(LuceneDataStoreSearchGUI.this.stringCollator);
                    treeSet.addAll(LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.keySet());
                    if (treeSet.isEmpty()) {
                        treeSet.add("No annotation type found !");
                    }
                    QueryTextArea.this.queryListModel.clear();
                    for (String string : treeSet) {
                        QueryTextArea.this.queryListModel.addElement(string);
                    }
                    QueryTextArea.this.queryList.setVisibleRowCount(Math.min(12, treeSet.size()));
                    Rectangle rectangle = QueryTextArea.this.modelToView(QueryTextArea.this.getCaret().getDot());
                    QueryTextArea.this.queryPopupWindow.setLocation(QueryTextArea.this.getLocationOnScreen().x + (int)rectangle.getMaxX(), QueryTextArea.this.getLocationOnScreen().y + (int)rectangle.getMaxY());
                    QueryTextArea.this.queryPopupWindow.pack();
                    QueryTextArea.this.queryPopupWindow.setVisible(true);
                    if (QueryTextArea.this.queryListModel.getSize() == 1) {
                        QueryTextArea.this.queryList.setSelectedIndex(0);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        private class MultiplierAction
        extends AbstractAction {
            int from;
            int upto;

            public MultiplierAction(int n, int n2) {
                super(n + " to " + n2 + " time" + (n2 == 1 ? "" : "s"));
                this.from = n;
                this.upto = n2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QueryTextArea.this.getDocument().insertString(QueryTextArea.this.getSelectionStart(), "(", null);
                    QueryTextArea.this.getDocument().insertString(QueryTextArea.this.getSelectionEnd(), ")" + (this.from == 0 ? "*" : "+") + this.upto, null);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConfigureStackViewTableModel
    extends AbstractTableModel {
        private final int REMOVE;

        protected ConfigureStackViewTableModel() {
            this.REMOVE = LuceneDataStoreSearchGUI.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return Math.min(LuceneDataStoreSearchGUI.this.numStackRows + 1, 101);
        }

        @Override
        public int getColumnCount() {
            return LuceneDataStoreSearchGUI.this.columnNames.length + 1;
        }

        @Override
        public String getColumnName(int n) {
            return n == this.REMOVE ? "Add/Remove" : LuceneDataStoreSearchGUI.this.columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == this.REMOVE) {
                return null;
            }
            return LuceneDataStoreSearchGUI.this.stackRows[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == this.REMOVE) {
                return;
            }
            String string = object instanceof String ? (String)object : "value should be a String";
            if (n2 == 1 && !string.equals("")) {
                if (LuceneDataStoreSearchGUI.this.getTypesAndFeatures(null, null).keySet().contains(string)) {
                    JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "A Shortcut cannot have the same name as an Annotation type.", "Alert", 0);
                    return;
                }
                int n3 = LuceneDataStoreSearchGUI.this.findStackRow(1, string);
                if (n3 >= 0 && n3 != n) {
                    JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "A Shortcut with the same name already exists.", "Alert", 0);
                    return;
                }
            }
            String string2 = string;
            ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[n][n2] = string;
            if (!LuceneDataStoreSearchGUI.this.stackRows[n][1].equals("")) {
                if (LuceneDataStoreSearchGUI.this.stackRows[n][2].equals("") || LuceneDataStoreSearchGUI.this.stackRows[n][3].equals("")) {
                    LuceneDataStoreSearchGUI.this.configureStackViewFrame.getTable().getColumnModel().getColumn(n2).getCellEditor().cancelCellEditing();
                    this.fireTableCellUpdated(n, n2);
                    ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[n][n2] = string2;
                    JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "A Shortcut need to have a Feature.\nChoose a Feature or delete the Shortcut value.", "Alert", 0);
                    return;
                }
                int n4 = LuceneDataStoreSearchGUI.this.findStackRow(2, LuceneDataStoreSearchGUI.this.stackRows[n][2], 3, LuceneDataStoreSearchGUI.this.stackRows[n][3]);
                if (n4 >= 0 && n4 != n && !LuceneDataStoreSearchGUI.this.stackRows[n4][1].equals("")) {
                    LuceneDataStoreSearchGUI.this.configureStackViewFrame.getTable().getColumnModel().getColumn(n2).getCellEditor().cancelCellEditing();
                    ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[n][n2] = string2;
                    this.fireTableCellUpdated(n, n2);
                    JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "You can only have one Shortcut for a couple (Annotation type, Feature).", "Alert", 0);
                    return;
                }
            }
            if (LuceneDataStoreSearchGUI.this.stackRows[n][0].equals("one time")) {
                ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[n][0] = "true";
            }
            ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[n][n2] = string;
            this.fireTableRowsUpdated(n, n);
            LuceneDataStoreSearchGUI.this.updateStackView();
            LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
        }
    }

    protected class ConfigureStackViewFrame
    extends JFrame {
        private final int REMOVE;
        private JTable stackRowsJTable;

        public ConfigureStackViewFrame(String string) {
            super(string);
            this.REMOVE = LuceneDataStoreSearchGUI.this.columnNames.length;
            this.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(20, 31);
            jScrollPane.getViewport().setOpaque(true);
            LuceneDataStoreSearchGUI.this.configureStackViewTableModel = new ConfigureStackViewTableModel();
            this.stackRowsJTable = new XJTable(LuceneDataStoreSearchGUI.this.configureStackViewTableModel);
            ((XJTable)this.stackRowsJTable).setSortable(false);
            String[] stringArray = new String[]{"Crop middle", "Crop start", "Crop end"};
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            this.stackRowsJTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JCheckBox jCheckBox = new JCheckBox();
                    jCheckBox.setHorizontalAlignment(0);
                    jCheckBox.setToolTipText("Tick to display this row in central section.");
                    jCheckBox.setSelected(!jTable.getValueAt(n, n2).equals("false"));
                    return jCheckBox;
                }
            });
            final class DisplayCellEditor
            extends AbstractCellEditor
            implements TableCellEditor,
            ActionListener {
                JCheckBox checkBox = new JCheckBox();

                public DisplayCellEditor() {
                    this.checkBox.setHorizontalAlignment(0);
                    this.checkBox.addActionListener(this);
                }

                public boolean shouldSelectCell(EventObject eventObject) {
                    return false;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.fireEditingStopped();
                }

                public Object getCellEditorValue() {
                    return this.checkBox.isSelected() ? "true" : "false";
                }

                public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                    this.checkBox.setSelected(!jTable.getValueAt(n, n2).equals("false"));
                    return this.checkBox;
                }
            }
            this.stackRowsJTable.getColumnModel().getColumn(0).setCellEditor(new DisplayCellEditor());
            this.stackRowsJTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (component instanceof JComponent) {
                        ((JComponent)component).setToolTipText("Shortcut can be used in queries instead of \"AnnotationType.Feature\".");
                    }
                    component.setBackground(UIManager.getColor("CheckBox.background"));
                    return component;
                }
            });
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
            defaultCellEditor.setClickCountToStart(0);
            this.stackRowsJTable.getColumnModel().getColumn(1).setCellEditor(defaultCellEditor);
            this.stackRowsJTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    String[] stringArray = new String[]{LuceneDataStoreSearchGUI.this.stackRows[n][2]};
                    return new JComboBox<String>(stringArray);
                }
            });
            final class FeatureCellEditor
            extends AbstractCellEditor
            implements TableCellEditor,
            ActionListener {
                private JComboBox featuresBox = new JComboBox();

                public FeatureCellEditor() {
                    this.featuresBox.setMaximumRowCount(10);
                    this.featuresBox.addActionListener(this);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.fireEditingStopped();
                }

                public Object getCellEditorValue() {
                    return this.featuresBox.getSelectedItem() == null ? "" : this.featuresBox.getSelectedItem();
                }

                public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                    TreeSet<Object> treeSet = new TreeSet<Object>(LuceneDataStoreSearchGUI.this.stringCollator);
                    if (LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.containsKey((String)ConfigureStackViewFrame.this.stackRowsJTable.getValueAt(n, 2))) {
                        treeSet.addAll((Collection)LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.get((String)ConfigureStackViewFrame.this.stackRowsJTable.getValueAt(n, 2)));
                    }
                    DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(treeSet.toArray());
                    defaultComboBoxModel.insertElementAt("", 0);
                    this.featuresBox.setModel(defaultComboBoxModel);
                    this.featuresBox.setSelectedItem(treeSet.contains((String)ConfigureStackViewFrame.this.stackRowsJTable.getValueAt(n, n2)) ? ConfigureStackViewFrame.this.stackRowsJTable.getValueAt(n, n2) : "");
                    return this.featuresBox;
                }
            }
            this.stackRowsJTable.getColumnModel().getColumn(3).setCellEditor(new FeatureCellEditor());
            this.stackRowsJTable.getColumnModel().getColumn(3).setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    String[] stringArray = new String[]{LuceneDataStoreSearchGUI.this.stackRows[n][3]};
                    return new JComboBox<String>(stringArray);
                }
            });
            defaultCellEditor = new DefaultCellEditor(jComboBox);
            defaultCellEditor.setClickCountToStart(0);
            this.stackRowsJTable.getColumnModel().getColumn(4).setCellEditor(defaultCellEditor);
            this.stackRowsJTable.getColumnModel().getColumn(4).setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    String[] stringArray = new String[]{LuceneDataStoreSearchGUI.this.stackRows[n][4]};
                    return new JComboBox<String>(stringArray);
                }
            });
            final class AddRemoveCellEditorRenderer
            extends AbstractCellEditor
            implements TableCellRenderer,
            TableCellEditor,
            ActionListener {
                private JButton button = new JButton();

                public AddRemoveCellEditorRenderer() {
                    this.button.setHorizontalAlignment(0);
                    this.button.addActionListener(this);
                }

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (n == LuceneDataStoreSearchGUI.this.numStackRows) {
                        this.button.setIcon(MainFrame.getIcon("crystal-clear-action-edit-add"));
                        this.button.setToolTipText("Click to add this line.");
                    } else {
                        this.button.setIcon(MainFrame.getIcon("crystal-clear-action-button-cancel"));
                        this.button.setToolTipText("Click to remove this line.");
                    }
                    this.button.setSelected(bl);
                    return this.button;
                }

                public boolean shouldSelectCell(EventObject eventObject) {
                    return false;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ConfigureStackViewFrame.this.stackRowsJTable.getEditingRow();
                    this.fireEditingStopped();
                    if (n == LuceneDataStoreSearchGUI.this.numStackRows) {
                        if (LuceneDataStoreSearchGUI.this.stackRows[n][2] != null && !LuceneDataStoreSearchGUI.this.stackRows[n][2].equals("")) {
                            if (LuceneDataStoreSearchGUI.this.numStackRows == 100) {
                                JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "The number of rows is limited to 100.", "Alert", 0);
                            } else {
                                LuceneDataStoreSearchGUI.this.numStackRows++;
                                LuceneDataStoreSearchGUI.this.configureStackViewTableModel.fireTableRowsInserted(n, n + 1);
                                LuceneDataStoreSearchGUI.this.updateStackView();
                                LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
                            }
                        } else {
                            JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "Fill at least the Annotation type column.", "Alert", 0);
                        }
                    } else {
                        LuceneDataStoreSearchGUI.this.deleteStackRow(n);
                        LuceneDataStoreSearchGUI.this.configureStackViewTableModel.fireTableDataChanged();
                        LuceneDataStoreSearchGUI.this.updateStackView();
                        LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
                    }
                }

                public Object getCellEditorValue() {
                    return null;
                }

                public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                    this.button.setIcon(MainFrame.getIcon(n == LuceneDataStoreSearchGUI.this.numStackRows ? "crystal-clear-action-edit-add" : "crystal-clear-action-button-cancel"));
                    return this.button;
                }
            }
            this.stackRowsJTable.getColumnModel().getColumn(this.REMOVE).setCellEditor(new AddRemoveCellEditorRenderer());
            this.stackRowsJTable.getColumnModel().getColumn(this.REMOVE).setCellRenderer(new AddRemoveCellEditorRenderer());
            jScrollPane.setViewportView(this.stackRowsJTable);
            this.add((Component)jScrollPane, "Center");
        }

        public JTable getTable() {
            return this.stackRowsJTable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ResultTableModel
    extends AbstractTableModel {
        public static final int MAX_COL_WIDTH = 40;
        public static final int LEFT_CONTEXT_COLUMN = 0;
        public static final int RESULT_COLUMN = 1;
        public static final int RIGHT_CONTEXT_COLUMN = 2;
        public static final int FEATURES_COLUMN = 3;
        public static final int QUERY_COLUMN = 4;
        public static final int DOCUMENT_COLUMN = 5;
        public static final int SET_COLUMN = 6;
        public static final int COLUMN_COUNT = 7;
        protected Map<String, String> featureByTypeMap = new HashMap<String, String>();

        @Override
        public int getRowCount() {
            return LuceneDataStoreSearchGUI.this.results.size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Left context";
                }
                case 1: {
                    return "Match";
                }
                case 2: {
                    return "Right context";
                }
                case 3: {
                    return "Features";
                }
                case 4: {
                    return "Query";
                }
                case 5: {
                    return "Document";
                }
                case 6: {
                    return "Annotation set";
                }
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            gate.creole.annic.Pattern pattern = (gate.creole.annic.Pattern)LuceneDataStoreSearchGUI.this.results.get(n);
            switch (n2) {
                case 0: {
                    return pattern.getPatternText(pattern.getLeftContextStartOffset(), pattern.getStartOffset()).replaceAll("[\n ]+", " ");
                }
                case 1: {
                    return pattern.getPatternText(pattern.getStartOffset(), pattern.getEndOffset());
                }
                case 2: {
                    return pattern.getPatternText(pattern.getEndOffset(), pattern.getRightContextEndOffset()).replaceAll("[\n ]+", " ");
                }
                case 3: {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (Map.Entry<String, String> entry : this.featureByTypeMap.entrySet()) {
                        String string = entry.getKey();
                        String string2 = entry.getValue();
                        List<PatternAnnotation> list = pattern.getPatternAnnotations(pattern.getStartOffset(), pattern.getEndOffset());
                        stringBuffer.append(string).append('.').append(string2).append('=');
                        for (PatternAnnotation patternAnnotation : list) {
                            if (!patternAnnotation.getType().equals(string) || patternAnnotation.getFeature(string2) == null) continue;
                            stringBuffer.append(patternAnnotation.getFeatures().get(string2)).append(", ");
                        }
                        if (stringBuffer.length() <= 2) continue;
                        if (stringBuffer.codePointAt(stringBuffer.length() - 2) == 44) {
                            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                            stringBuffer.append("; ");
                            continue;
                        }
                        if (stringBuffer.codePointAt(stringBuffer.length() - 1) != 61) continue;
                        stringBuffer.delete(stringBuffer.length() - string.length() - string2.length() - 2, stringBuffer.length());
                    }
                    if (stringBuffer.length() > 2) {
                        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                    }
                    return stringBuffer.toString();
                }
                case 4: {
                    return pattern.getQueryString();
                }
                case 5: {
                    return pattern.getDocumentID();
                }
                case 6: {
                    return pattern.getAnnotationSetName();
                }
            }
            return Object.class;
        }

        @Override
        public void fireTableDataChanged() {
            this.featureByTypeMap.clear();
            for (int i = 0; i < LuceneDataStoreSearchGUI.this.numStackRows; ++i) {
                if (LuceneDataStoreSearchGUI.this.stackRows[i][0].equals("false") || LuceneDataStoreSearchGUI.this.stackRows[i][3].equals("")) continue;
                String string = LuceneDataStoreSearchGUI.this.stackRows[i][3];
                String string2 = LuceneDataStoreSearchGUI.this.stackRows[i][2];
                this.featureByTypeMap.put(string2, string);
            }
            super.fireTableDataChanged();
        }
    }

    protected class ResultTableCellRenderer
    extends DefaultTableCellRenderer {
        protected ResultTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = (String)object;
            int n3 = LuceneDataStoreSearchGUI.this.resultTable.convertColumnIndexToModel(n2);
            switch (n3) {
                case 1: 
                case 3: {
                    if (string.length() > 40) {
                        string = string.substring(0, 20) + "..." + string.substring(string.length() - 20);
                    }
                    string = string.replaceAll("(?:\r?\n)|\r", " ");
                    string = string.replaceAll("\t", " ");
                    break;
                }
            }
            Component component = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            if (!(component instanceof JLabel)) {
                return component;
            }
            JLabel jLabel = (JLabel)component;
            jLabel.setHorizontalAlignment(2);
            String string2 = null;
            switch (n3) {
                case 0: {
                    jLabel.setHorizontalAlignment(4);
                    break;
                }
                case 1: 
                case 3: {
                    if (((String)object).length() > 40) {
                        string2 = (String)object;
                        if (string2.length() > 1000) {
                            string2 = string2.substring(0, 500) + "<br>...<br>" + string2.substring(string2.length() - 500);
                        }
                        string2 = string2.replaceAll("\\s*\n\\s*", "<br>");
                        string2 = string2.replaceAll("\\s+", " ");
                        string2 = "<html><table width=\"" + (string2.length() > 150 ? "500" : "100%") + "\" border=\"0\" cellspacing=\"0\">" + "<tr><td>" + string2 + "</td></tr>" + "</table></html>";
                    }
                    if (n3 != 1) break;
                    jLabel.setHorizontalAlignment(0);
                    break;
                }
            }
            jLabel.setToolTipText(string2);
            return jLabel;
        }
    }

    protected class HeaderMouseListener
    extends AnnotationStack.StackMouseListener {
        String type;
        String feature;
        String description;
        String toolTip;
        String descriptionTemplate;
        String toolTipTemplate;
        JPopupMenu mousePopup;
        JMenuItem menuItem;
        XJTable table;
        JWindow popupWindow;
        int row;
        final String corpusID;
        final String annotationSetID;
        final String corpusName;
        final String annotationSetName;
        boolean isTooltipSet;

        public HeaderMouseListener() {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.isTooltipSet = false;
        }

        public HeaderMouseListener(String string, String string2) {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.isTooltipSet = false;
            this.type = string;
            this.feature = string2;
            this.descriptionTemplate = string + "." + string2 + " (kind)";
            this.toolTipTemplate = "Statistics in kind<br>on Corpus: " + this.corpusName + "<br>and Annotation Set: " + this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString();
            this.init();
        }

        public HeaderMouseListener(String string) {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.isTooltipSet = false;
            this.type = string;
            this.descriptionTemplate = string + " (kind)";
            this.toolTipTemplate = "Statistics in kind<br>on Corpus: " + this.corpusName + "<br>and Annotation Set: " + this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString();
            this.init();
        }

        void init() {
            LuceneDataStoreSearchGUI.this.addAncestorListener(new AncestorListener(){

                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }

                public void ancestorAdded(AncestorEvent ancestorEvent) {
                }

                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    if (HeaderMouseListener.this.popupWindow != null) {
                        HeaderMouseListener.this.popupWindow.dispose();
                    }
                }
            });
            this.row = LuceneDataStoreSearchGUI.this.findStackRow(2, this.type, 3, this.feature == null ? "" : this.feature);
        }

        public MouseInputAdapter createListener(String ... stringArray) {
            switch (stringArray.length) {
                case 1: {
                    return new HeaderMouseListener(stringArray[0]);
                }
                case 2: {
                    return new HeaderMouseListener(stringArray[0], stringArray[1]);
                }
            }
            return null;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (!this.isTooltipSet && component instanceof JLabel) {
                this.isTooltipSet = true;
                JLabel jLabel = (JLabel)component;
                String string = "";
                if (this.feature != null) {
                    int n = LuceneDataStoreSearchGUI.this.resultTable.rowViewToModel(LuceneDataStoreSearchGUI.this.resultTable.getSelectionModel().getLeadSelectionIndex());
                    if (!LuceneDataStoreSearchGUI.this.stackRows[n][1].equals("")) {
                        string = "Shortcut for " + this.type + "." + this.feature + ".<br>";
                    }
                }
                jLabel.setToolTipText("<html>" + string + "Double click to choose annotation feature.<br>" + "Right click to get statistics.</html>");
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.dispose();
                return;
            }
            if (mouseEvent.getButton() != 1 || mouseEvent.getClickCount() != 2) {
                return;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            if (LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.containsKey(this.type)) {
                treeSet.addAll((Collection)LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.get(this.type));
            }
            treeSet.add(" ");
            final JList<Object> jList = new JList<Object>(treeSet.toArray());
            jList.setVisibleRowCount(Math.min(8, treeSet.size()));
            jList.setSelectionMode(0);
            jList.setBackground(Color.WHITE);
            jList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 1) {
                        String string = (String)jList.getSelectedValue();
                        if (string.equals(" ")) {
                            string = "";
                        }
                        ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[HeaderMouseListener.this.row][3] = string;
                        LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
                        HeaderMouseListener.this.popupWindow.setVisible(false);
                        HeaderMouseListener.this.popupWindow.dispose();
                        LuceneDataStoreSearchGUI.this.updateStackView();
                    }
                }
            });
            this.popupWindow = new JWindow();
            this.popupWindow.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        HeaderMouseListener.this.popupWindow.setVisible(false);
                        HeaderMouseListener.this.popupWindow.dispose();
                    }
                }
            });
            this.popupWindow.add(new JScrollPane(jList));
            Component component = mouseEvent.getComponent();
            this.popupWindow.setBounds(component.getLocationOnScreen().x, component.getLocationOnScreen().y + component.getHeight(), component.getWidth(), Math.min(8 * component.getHeight(), treeSet.size() * component.getHeight()));
            this.popupWindow.pack();
            this.popupWindow.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = LuceneDataStoreSearchGUI.this.stackRows[HeaderMouseListener.this.row][3];
                    if (string.equals("")) {
                        string = " ";
                    }
                    jList.setSelectedValue(string, true);
                    HeaderMouseListener.this.popupWindow.requestFocusInWindow();
                }
            });
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.createPopup(mouseEvent);
                this.mousePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.createPopup(mouseEvent);
                this.mousePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private int checkStatistics() {
            boolean bl = false;
            int n = 0;
            for (int i = 0; i < LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount(); ++i) {
                String string = (String)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(i, 0);
                String string2 = (String)LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.get(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowViewToModel(n));
                if (string.equals(this.description) && string2.equals(this.toolTip)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            return bl ? n : -1;
        }

        private void addStatistics(String string, int n, int n2, MouseEvent mouseEvent) {
            Object object;
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (!jLabel.getToolTipText().contains(string)) {
                object = jLabel.getToolTipText();
                object = ((String)object).replaceAll("</?html>", "");
                object = string + " = " + n + "<br>" + (String)object;
                object = "<html>" + (String)object + "</html>";
                jLabel.setToolTipText((String)object);
            }
            if ((double)LuceneDataStoreSearchGUI.this.bottomSplitPane.getDividerLocation() / LuceneDataStoreSearchGUI.this.bottomSplitPane.getSize().getWidth() < 0.9) {
                LuceneDataStoreSearchGUI.this.statisticsTabbedPane.setSelectedIndex(1);
                LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.setRowSelectionInterval(n2, n2);
                LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.scrollRectToVisible(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getCellRect(n2, 0, true));
            } else {
                object = jLabel.createToolTip();
                ((JToolTip)object).setTipText(string + " = " + n);
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                final Popup popup = popupFactory.getPopup(jLabel, (Component)object, mouseEvent.getX() + mouseEvent.getComponent().getLocationOnScreen().x, mouseEvent.getY() + mouseEvent.getComponent().getLocationOnScreen().y);
                popup.show();
                Date date = new Date(System.currentTimeMillis() + 2000L);
                Timer timer = new Timer("Annic statistics hide tooltip timer", true);
                timer.schedule(new TimerTask(){

                    public void run() {
                        popup.hide();
                    }
                }, date);
            }
        }

        private void createPopup(final MouseEvent mouseEvent) {
            this.mousePopup = new JPopupMenu();
            if (this.type != null && this.feature != null) {
                this.menuItem = new JMenuItem("Occurrences in datastore");
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "datastore");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "datastore");
                        int n2 = HeaderMouseListener.this.checkStatistics();
                        if (n2 == -1) {
                            try {
                                n = LuceneDataStoreSearchGUI.this.searcher.freq(HeaderMouseListener.this.corpusID, HeaderMouseListener.this.annotationSetID, HeaderMouseListener.this.type, HeaderMouseListener.this.feature);
                            }
                            catch (SearchException searchException) {
                                searchException.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, n, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                        }
                        HeaderMouseListener.this.addStatistics("datastore", n, n2, mouseEvent);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in matches");
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "matches");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches");
                        int n2 = HeaderMouseListener.this.checkStatistics();
                        if (n2 == -1) {
                            try {
                                n = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, null, true, false);
                            }
                            catch (SearchException searchException) {
                                searchException.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, n, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                        }
                        HeaderMouseListener.this.addStatistics("matches", n, n2, mouseEvent);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "contexts");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "contexts");
                        int n2 = HeaderMouseListener.this.checkStatistics();
                        if (n2 == -1) {
                            try {
                                n = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, null, false, true);
                            }
                            catch (SearchException searchException) {
                                searchException.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, n, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                        }
                        HeaderMouseListener.this.addStatistics("contexts", n, n2, mouseEvent);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in matches+contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "mch+ctxt");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches+contexts");
                        int n2 = HeaderMouseListener.this.checkStatistics();
                        if (n2 == -1) {
                            try {
                                n = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, null, true, true);
                            }
                            catch (SearchException searchException) {
                                searchException.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, n, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                        }
                        HeaderMouseListener.this.addStatistics("matches+contexts", n, n2, mouseEvent);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.mousePopup.addSeparator();
                this.menuItem = new JMenuItem("All values from matches");
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Map<String, Integer> map;
                        try {
                            map = LuceneDataStoreSearchGUI.this.searcher.freqForAllValues(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, true, false);
                        }
                        catch (SearchException searchException) {
                            searchException.printStackTrace();
                            return;
                        }
                        DefaultTableModel defaultTableModel = new DefaultTableModel();
                        defaultTableModel.addColumn(HeaderMouseListener.this.type + '.' + HeaderMouseListener.this.feature + " (matches)");
                        defaultTableModel.addColumn("Count");
                        for (Map.Entry<String, Integer> entry : map.entrySet()) {
                            defaultTableModel.addRow(new Object[]{entry.getKey(), entry.getValue()});
                        }
                        HeaderMouseListener.this.table = new XJTable(){

                            public boolean isCellEditable(int n, int n2) {
                                return false;
                            }
                        };
                        HeaderMouseListener.this.table.setModel(defaultTableModel);
                        HeaderMouseListener.this.table.setComparator(0, LuceneDataStoreSearchGUI.this.stringCollator);
                        HeaderMouseListener.this.table.setComparator(1, LuceneDataStoreSearchGUI.this.integerComparator);
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.addTab(String.valueOf(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1), null, new JScrollPane(HeaderMouseListener.this.table), "<html>Statistics in matches<br>on Corpus: " + HeaderMouseListener.this.corpusName + "<br>and Annotation Set: " + HeaderMouseListener.this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString() + "</html>");
                        if ((double)LuceneDataStoreSearchGUI.this.bottomSplitPane.getDividerLocation() / LuceneDataStoreSearchGUI.this.bottomSplitPane.getSize().getWidth() > 0.75) {
                            LuceneDataStoreSearchGUI.this.bottomSplitPane.setDividerLocation(0.66);
                        }
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.setSelectedIndex(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("All values from contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Map<String, Integer> map;
                        try {
                            map = LuceneDataStoreSearchGUI.this.searcher.freqForAllValues(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, false, true);
                        }
                        catch (SearchException searchException) {
                            searchException.printStackTrace();
                            return;
                        }
                        DefaultTableModel defaultTableModel = new DefaultTableModel();
                        defaultTableModel.addColumn(HeaderMouseListener.this.type + '.' + HeaderMouseListener.this.feature + " (contexts)");
                        defaultTableModel.addColumn("Count");
                        for (Map.Entry<String, Integer> entry : map.entrySet()) {
                            defaultTableModel.addRow(new Object[]{entry.getKey(), entry.getValue()});
                        }
                        HeaderMouseListener.this.table = new XJTable(){

                            public boolean isCellEditable(int n, int n2) {
                                return false;
                            }
                        };
                        HeaderMouseListener.this.table.setModel(defaultTableModel);
                        HeaderMouseListener.this.table.setComparator(0, LuceneDataStoreSearchGUI.this.stringCollator);
                        HeaderMouseListener.this.table.setComparator(1, LuceneDataStoreSearchGUI.this.integerComparator);
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.addTab(String.valueOf(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1), null, new JScrollPane(HeaderMouseListener.this.table), "<html>Statistics in contexts<br>on Corpus: " + HeaderMouseListener.this.corpusName + "<br>and Annotation Set: " + HeaderMouseListener.this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString() + "</html>");
                        if ((double)LuceneDataStoreSearchGUI.this.bottomSplitPane.getDividerLocation() / LuceneDataStoreSearchGUI.this.bottomSplitPane.getSize().getWidth() > 0.75) {
                            LuceneDataStoreSearchGUI.this.bottomSplitPane.setDividerLocation(0.66);
                        }
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.setSelectedIndex(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("All values from matches+contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Map<String, Integer> map;
                        try {
                            map = LuceneDataStoreSearchGUI.this.searcher.freqForAllValues(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, true, true);
                        }
                        catch (SearchException searchException) {
                            searchException.printStackTrace();
                            return;
                        }
                        DefaultTableModel defaultTableModel = new DefaultTableModel();
                        defaultTableModel.addColumn(HeaderMouseListener.this.type + '.' + HeaderMouseListener.this.feature + " (mch+ctxt)");
                        defaultTableModel.addColumn("Count");
                        for (Map.Entry<String, Integer> entry : map.entrySet()) {
                            defaultTableModel.addRow(new Object[]{entry.getKey(), entry.getValue()});
                        }
                        HeaderMouseListener.this.table = new XJTable(){

                            public boolean isCellEditable(int n, int n2) {
                                return false;
                            }
                        };
                        HeaderMouseListener.this.table.setModel(defaultTableModel);
                        HeaderMouseListener.this.table.setComparator(0, LuceneDataStoreSearchGUI.this.stringCollator);
                        HeaderMouseListener.this.table.setComparator(1, LuceneDataStoreSearchGUI.this.integerComparator);
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.addTab(String.valueOf(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1), null, new JScrollPane(HeaderMouseListener.this.table), "<html>Statistics in matches+contexts<br>on Corpus: " + HeaderMouseListener.this.corpusName + "<br>and Annotation Set: " + HeaderMouseListener.this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString() + "</html>");
                        if ((double)LuceneDataStoreSearchGUI.this.bottomSplitPane.getDividerLocation() / LuceneDataStoreSearchGUI.this.bottomSplitPane.getSize().getWidth() > 0.75) {
                            LuceneDataStoreSearchGUI.this.bottomSplitPane.setDividerLocation(0.66);
                        }
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.setSelectedIndex(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1);
                    }
                });
                this.mousePopup.add(this.menuItem);
            } else {
                this.menuItem = new JMenuItem("Occurrences in datastore");
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "datastore");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "datastore");
                        int n2 = HeaderMouseListener.this.checkStatistics();
                        if (n2 == -1) {
                            try {
                                n = LuceneDataStoreSearchGUI.this.searcher.freq(HeaderMouseListener.this.corpusID, HeaderMouseListener.this.annotationSetID, HeaderMouseListener.this.type);
                            }
                            catch (SearchException searchException) {
                                searchException.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, n, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                        }
                        HeaderMouseListener.this.addStatistics("datastore", n, n2, mouseEvent);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in matches");
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "matches");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches");
                        int n2 = HeaderMouseListener.this.checkStatistics();
                        if (n2 == -1) {
                            try {
                                n = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, true, false);
                            }
                            catch (SearchException searchException) {
                                searchException.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, n, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                        }
                        HeaderMouseListener.this.addStatistics("matches", n, n2, mouseEvent);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "contexts");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "contexts");
                        int n2 = HeaderMouseListener.this.checkStatistics();
                        if (n2 == -1) {
                            try {
                                n = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, false, true);
                            }
                            catch (SearchException searchException) {
                                searchException.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, n, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                        }
                        HeaderMouseListener.this.addStatistics("contexts", n, n2, mouseEvent);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in matches+contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "mch+ctxt");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches+contexts");
                        int n2 = HeaderMouseListener.this.checkStatistics();
                        if (n2 == -1) {
                            try {
                                n = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, true, true);
                            }
                            catch (SearchException searchException) {
                                searchException.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, n, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                        }
                        HeaderMouseListener.this.addStatistics("matches+contexts", n, n2, mouseEvent);
                    }
                });
                this.mousePopup.add(this.menuItem);
            }
        }
    }

    protected class AnnotationMouseListener
    extends AnnotationStack.StackMouseListener {
        String type;
        String feature;
        String text;
        String description;
        String toolTip;
        String descriptionTemplate;
        String toolTipTemplate;
        JPopupMenu mousePopup;
        JMenuItem menuItem;
        final String corpusID;
        final String annotationSetID;
        final String corpusName;
        final String annotationSetName;
        ToolTipManager toolTipManager;
        int dismissDelay;
        int initialDelay;
        int reshowDelay;
        boolean enabled;
        boolean isTooltipSet;

        public AnnotationMouseListener() {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.toolTipManager = ToolTipManager.sharedInstance();
            this.isTooltipSet = false;
        }

        public AnnotationMouseListener(String string, String string2, String string3) {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.toolTipManager = ToolTipManager.sharedInstance();
            this.isTooltipSet = false;
            this.type = string;
            this.feature = string2;
            this.text = string3;
            String string4 = string3.replace("\\s", "").length() > 20 ? string3.replace("\\s", "").substring(0, 20) + "..." : string3.replace("\\s", "");
            this.descriptionTemplate = string + "." + string2 + "==\"" + string4 + "\" (kind)";
            this.toolTipTemplate = "Statistics in kind<br>on Corpus: " + this.corpusName + "<br>and Annotation Set: " + this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString();
        }

        public AnnotationMouseListener(String string) {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.toolTipManager = ToolTipManager.sharedInstance();
            this.isTooltipSet = false;
            this.type = string;
        }

        public MouseInputAdapter createListener(String ... stringArray) {
            switch (stringArray.length) {
                case 3: {
                    return new AnnotationMouseListener(stringArray[1]);
                }
                case 5: {
                    return new AnnotationMouseListener(stringArray[1], stringArray[2], stringArray[3]);
                }
            }
            return null;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.dismissDelay = this.toolTipManager.getDismissDelay();
            this.initialDelay = this.toolTipManager.getInitialDelay();
            this.reshowDelay = this.toolTipManager.getReshowDelay();
            this.enabled = this.toolTipManager.isEnabled();
            Component component = mouseEvent.getComponent();
            if (this.feature != null && !this.isTooltipSet && component instanceof JLabel) {
                this.isTooltipSet = true;
                JLabel jLabel = (JLabel)component;
                String string = jLabel.getToolTipText();
                string = string == null || string.equals("") ? "" : string.replaceAll("</?html>", "") + "<br>";
                string = "<html>" + string + "Right click to get statistics.</html>";
                jLabel.setToolTipText(string);
            }
            this.toolTipManager.setDismissDelay(Integer.MAX_VALUE);
            this.toolTipManager.setInitialDelay(0);
            this.toolTipManager.setReshowDelay(0);
            this.toolTipManager.setEnabled(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.toolTipManager.setDismissDelay(this.dismissDelay);
            this.toolTipManager.setInitialDelay(this.initialDelay);
            this.toolTipManager.setReshowDelay(this.reshowDelay);
            this.toolTipManager.setEnabled(this.enabled);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && this.type != null && this.feature != null) {
                this.createPopup(mouseEvent);
                this.mousePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                this.updateQuery();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && this.type != null && this.feature != null) {
                this.createPopup(mouseEvent);
                this.mousePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void updateQuery() {
            int n;
            int n2 = LuceneDataStoreSearchGUI.this.queryTextArea.getCaretPosition();
            String string = LuceneDataStoreSearchGUI.this.queryTextArea.getText();
            String string2 = this.type != null && this.feature != null ? ((n = LuceneDataStoreSearchGUI.this.findStackRow(2, this.type, 3, this.feature)) >= 0 && !LuceneDataStoreSearchGUI.this.stackRows[n][1].equals("") ? "{" + LuceneDataStoreSearchGUI.this.stackRows[n][1] + "==\"" + this.text + "\"}" : "{" + this.type + "." + this.feature + "==\"" + this.text + "\"}") : (this.type != null ? "{" + this.type + "}" : this.text);
            String string3 = LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart() == LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd() ? string.substring(0, n2) : string.substring(0, LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart());
            String string4 = LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart() == LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd() ? string.substring(n2, string.length()) : string.substring(LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd(), string.length());
            LuceneDataStoreSearchGUI.this.queryTextArea.setText(string3 + string2 + string4);
        }

        private int checkStatistics() {
            boolean bl = false;
            int n = 0;
            for (int i = 0; i < LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount(); ++i) {
                String string = (String)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(i, 0);
                String string2 = (String)LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.get(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowViewToModel(n));
                if (string.equals(this.description) && string2.equals(this.toolTip)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            return bl ? n : -1;
        }

        private void addStatistics(String string, int n, int n2, MouseEvent mouseEvent) {
            Object object;
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (!jLabel.getToolTipText().contains(string)) {
                object = jLabel.getToolTipText();
                object = ((String)object).replaceAll("</?html>", "");
                object = string + " = " + n + "<br>" + (String)object;
                object = "<html>" + (String)object + "</html>";
                jLabel.setToolTipText((String)object);
            }
            if ((double)LuceneDataStoreSearchGUI.this.bottomSplitPane.getDividerLocation() / LuceneDataStoreSearchGUI.this.bottomSplitPane.getSize().getWidth() < 0.9) {
                LuceneDataStoreSearchGUI.this.statisticsTabbedPane.setSelectedIndex(1);
                LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.setRowSelectionInterval(n2, n2);
                LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.scrollRectToVisible(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getCellRect(n2, 0, true));
            } else {
                object = jLabel.createToolTip();
                ((JToolTip)object).setTipText(string + " = " + n);
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                final Popup popup = popupFactory.getPopup(jLabel, (Component)object, mouseEvent.getX() + mouseEvent.getComponent().getLocationOnScreen().x, mouseEvent.getY() + mouseEvent.getComponent().getLocationOnScreen().y);
                popup.show();
                Date date = new Date(System.currentTimeMillis() + 2000L);
                Timer timer = new Timer("Annic statistics hide tooltip timer", true);
                timer.schedule(new TimerTask(){

                    public void run() {
                        popup.hide();
                    }
                }, date);
            }
        }

        private void createPopup(final MouseEvent mouseEvent) {
            this.mousePopup = new JPopupMenu();
            this.menuItem = new JMenuItem("Occurrences in datastore");
            this.menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    AnnotationMouseListener.this.description = AnnotationMouseListener.this.descriptionTemplate.replaceFirst("kind", "datastore");
                    AnnotationMouseListener.this.toolTip = AnnotationMouseListener.this.toolTipTemplate.replaceFirst("kind", "datastore");
                    int n2 = AnnotationMouseListener.this.checkStatistics();
                    if (n2 == -1) {
                        try {
                            n = LuceneDataStoreSearchGUI.this.searcher.freq(AnnotationMouseListener.this.corpusID, AnnotationMouseListener.this.annotationSetID, AnnotationMouseListener.this.type, AnnotationMouseListener.this.feature, AnnotationMouseListener.this.text);
                        }
                        catch (SearchException searchException) {
                            searchException.printStackTrace();
                            return;
                        }
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{AnnotationMouseListener.this.description, n, ""});
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(AnnotationMouseListener.this.toolTip);
                        n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                    } else {
                        n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                    }
                    AnnotationMouseListener.this.addStatistics("datastore", n, n2, mouseEvent);
                }
            });
            this.mousePopup.add(this.menuItem);
            this.menuItem = new JMenuItem("Occurrences in matches");
            this.menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    AnnotationMouseListener.this.description = AnnotationMouseListener.this.descriptionTemplate.replaceFirst("kind", "matches");
                    AnnotationMouseListener.this.toolTip = AnnotationMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches");
                    int n2 = AnnotationMouseListener.this.checkStatistics();
                    if (n2 == -1) {
                        try {
                            n = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, AnnotationMouseListener.this.type, AnnotationMouseListener.this.feature, AnnotationMouseListener.this.text, true, false);
                        }
                        catch (SearchException searchException) {
                            searchException.printStackTrace();
                            return;
                        }
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{AnnotationMouseListener.this.description, n, ""});
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(AnnotationMouseListener.this.toolTip);
                        n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                    } else {
                        n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                    }
                    AnnotationMouseListener.this.addStatistics("matches", n, n2, mouseEvent);
                }
            });
            this.mousePopup.add(this.menuItem);
            this.menuItem = new JMenuItem("Occurrences in contexts");
            this.menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    AnnotationMouseListener.this.description = AnnotationMouseListener.this.descriptionTemplate.replaceFirst("kind", "contexts");
                    AnnotationMouseListener.this.toolTip = AnnotationMouseListener.this.toolTipTemplate.replaceFirst("kind", "contexts");
                    int n2 = AnnotationMouseListener.this.checkStatistics();
                    if (n2 == -1) {
                        try {
                            n = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, AnnotationMouseListener.this.type, AnnotationMouseListener.this.feature, AnnotationMouseListener.this.text, false, true);
                        }
                        catch (SearchException searchException) {
                            searchException.printStackTrace();
                            return;
                        }
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{AnnotationMouseListener.this.description, n, ""});
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(AnnotationMouseListener.this.toolTip);
                        n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                    } else {
                        n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                    }
                    AnnotationMouseListener.this.addStatistics("contexts", n, n2, mouseEvent);
                }
            });
            this.mousePopup.add(this.menuItem);
            this.menuItem = new JMenuItem("Occurrences in matches+contexts");
            this.menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    AnnotationMouseListener.this.description = AnnotationMouseListener.this.descriptionTemplate.replaceFirst("kind", "mch+ctxt");
                    AnnotationMouseListener.this.toolTip = AnnotationMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches+contexts");
                    int n2 = AnnotationMouseListener.this.checkStatistics();
                    if (n2 == -1) {
                        try {
                            n = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, AnnotationMouseListener.this.type, AnnotationMouseListener.this.feature, AnnotationMouseListener.this.text, true, true);
                        }
                        catch (SearchException searchException) {
                            searchException.printStackTrace();
                            return;
                        }
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{AnnotationMouseListener.this.description, n, ""});
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(AnnotationMouseListener.this.toolTip);
                        n2 = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                    } else {
                        n = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, 1);
                    }
                    AnnotationMouseListener.this.addStatistics("matches+contexts", n, n2, mouseEvent);
                }
            });
            this.mousePopup.add(this.menuItem);
        }
    }

    public class TextMouseListener
    extends AnnotationStack.StackMouseListener {
        String text;
        boolean isTooltipSet = false;

        public TextMouseListener() {
        }

        public TextMouseListener(String string) {
            this.text = string;
        }

        public MouseInputAdapter createListener(String ... stringArray) {
            return new TextMouseListener(stringArray[0]);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                int n = LuceneDataStoreSearchGUI.this.queryTextArea.getCaretPosition();
                String string = LuceneDataStoreSearchGUI.this.queryTextArea.getText();
                String string2 = this.text;
                String string3 = LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart() == LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd() ? string.substring(0, n) : string.substring(0, LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart());
                String string4 = LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart() == LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd() ? string.substring(n, string.length()) : string.substring(LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd(), string.length());
                LuceneDataStoreSearchGUI.this.queryTextArea.setText(string3 + string2 + string4);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (!this.isTooltipSet && component instanceof JLabel) {
                this.isTooltipSet = true;
                JLabel jLabel = (JLabel)component;
                gate.creole.annic.Pattern pattern = (gate.creole.annic.Pattern)LuceneDataStoreSearchGUI.this.results.get(LuceneDataStoreSearchGUI.this.resultTable.rowViewToModel(LuceneDataStoreSearchGUI.this.resultTable.getSelectionModel().getLeadSelectionIndex()));
                jLabel.setToolTipText("The query that matched this expression was: " + pattern.getQueryString() + ".");
            }
        }
    }

    protected class ConfigureStackViewAction
    extends AbstractAction {
        public ConfigureStackViewAction() {
            super("Configure", MainFrame.getIcon("crystal-clear-action-edit-add"));
            super.putValue("ShortDescription", "Configure the view");
            super.putValue("MnemonicKey", 37);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LuceneDataStoreSearchGUI.this.configureStackViewFrame.setVisible(false);
            LuceneDataStoreSearchGUI.this.configureStackViewFrame.setVisible(true);
        }
    }

    protected class NextResultsAction
    extends AbstractAction {
        public NextResultsAction() {
            super("Next page of " + LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue() + " results", MainFrame.getIcon("crystal-clear-action-loopnone"));
            super.putValue("ShortDescription", "Show next page of results.");
            super.putValue("MnemonicKey", 39);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final BlockingGlassPane blockingGlassPane = new BlockingGlassPane();
            LuceneDataStoreSearchGUI.this.getRootPane().setGlassPane(blockingGlassPane);
            blockingGlassPane.block(true);
            if (LuceneDataStoreSearchGUI.this.results.size() > 0) {
                LuceneDataStoreSearchGUI.this.results.clear();
                LuceneDataStoreSearchGUI.this.resultTableModel.fireTableDataChanged();
            } else {
                LuceneDataStoreSearchGUI.this.updateStackView();
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    LuceneDataStoreSearchGUI.this.noOfResults = LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue();
                    try {
                        try {
                            LuceneDataStoreSearchGUI.this.searcher.next(LuceneDataStoreSearchGUI.this.noOfResults);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object var3_2 = null;
                            LuceneDataStoreSearchGUI.this.updateViews();
                            LuceneDataStoreSearchGUI.this.pageOfResults++;
                            LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                            if (LuceneDataStoreSearchGUI.this.searcher.getHits().length < LuceneDataStoreSearchGUI.this.noOfResults) {
                                LuceneDataStoreSearchGUI.this.nextResultsAction.setEnabled(false);
                            }
                            LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    blockingGlassPane.block(false);
                                }
                            });
                            return;
                        }
                        Object var3_1 = null;
                        LuceneDataStoreSearchGUI.this.updateViews();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        LuceneDataStoreSearchGUI.this.updateViews();
                        LuceneDataStoreSearchGUI.this.pageOfResults++;
                        LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                        if (LuceneDataStoreSearchGUI.this.searcher.getHits().length < LuceneDataStoreSearchGUI.this.noOfResults) {
                            LuceneDataStoreSearchGUI.this.nextResultsAction.setEnabled(false);
                        }
                        LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    LuceneDataStoreSearchGUI.this.pageOfResults++;
                    LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                    if (LuceneDataStoreSearchGUI.this.searcher.getHits().length < LuceneDataStoreSearchGUI.this.noOfResults) {
                        LuceneDataStoreSearchGUI.this.nextResultsAction.setEnabled(false);
                    }
                    LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
        }
    }

    protected class ExecuteQueryAction
    extends AbstractAction {
        public ExecuteQueryAction() {
            super("Search", MainFrame.getIcon("crystal-clear-app-xmag"));
            super.putValue("ShortDescription", "Execute the query.");
            super.putValue("MnemonicKey", 10);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final BlockingGlassPane blockingGlassPane = new BlockingGlassPane();
            LuceneDataStoreSearchGUI.this.getRootPane().setGlassPane(blockingGlassPane);
            blockingGlassPane.block(true);
            if (LuceneDataStoreSearchGUI.this.results.size() > 0) {
                LuceneDataStoreSearchGUI.this.results.clear();
                LuceneDataStoreSearchGUI.this.resultTableModel.fireTableDataChanged();
            } else {
                LuceneDataStoreSearchGUI.this.updateStackView();
            }
            Map<String, Object> map = LuceneDataStoreSearchGUI.this.searcher.getParameters();
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            if (LuceneDataStoreSearchGUI.this.target instanceof LuceneDataStoreImpl) {
                String string = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
                map.put("CORPUS_ID", string);
            }
            LuceneDataStoreSearchGUI.this.noOfResults = LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue() > LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getMaximum() - 100 ? -1 : Integer.valueOf(LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue());
            int n = LuceneDataStoreSearchGUI.this.contextSizeSlider.getValue();
            String string = LuceneDataStoreSearchGUI.this.queryTextArea.getText().trim();
            Pattern pattern = Pattern.compile("[\\{, ]([^\\{=]+)==");
            Matcher matcher = pattern.matcher(string);
            int n2 = 0;
            while (matcher.find(n2)) {
                n2 = matcher.end(1);
                int n3 = LuceneDataStoreSearchGUI.this.findStackRow(1, matcher.group(1));
                if (n3 < 0) continue;
                string = string.substring(0, matcher.start(1)) + LuceneDataStoreSearchGUI.this.stackRows[n3][2] + "." + LuceneDataStoreSearchGUI.this.stackRows[n3][3] + string.substring(matcher.end(1));
                matcher = pattern.matcher(string);
            }
            map.put("CONTEXT_WINDOW", n);
            if (LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets")) {
                map.remove("ANNOTATION_SET_ID");
            } else {
                String string2 = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
                map.put("ANNOTATION_SET_ID", string2);
            }
            final String string3 = string;
            final Map<String, Object> map2 = map;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        block7: {
                            try {
                                if (!LuceneDataStoreSearchGUI.this.searcher.search(string3, map2)) break block7;
                                LuceneDataStoreSearchGUI.this.searcher.next(LuceneDataStoreSearchGUI.this.noOfResults);
                            }
                            catch (SearchException searchException) {
                                LuceneDataStoreSearchGUI.this.errorOnLastQuery = true;
                                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                                gridBagConstraints.gridwidth = 0;
                                LuceneDataStoreSearchGUI.this.centerPanel.removeAll();
                                String[] stringArray = searchException.getMessage().split("\\n");
                                if (stringArray.length == 1) {
                                    searchException.printStackTrace();
                                    Object var6_2 = null;
                                    LuceneDataStoreSearchGUI.this.updateViews();
                                    LuceneDataStoreSearchGUI.this.pageOfResults = 1;
                                    LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                                    LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            blockingGlassPane.block(false);
                                        }
                                    });
                                    return;
                                }
                                JTextArea jTextArea = new JTextArea(stringArray[1]);
                                jTextArea.setForeground(Color.RED);
                                LuceneDataStoreSearchGUI.this.centerPanel.add((Component)jTextArea, gridBagConstraints);
                                jTextArea = new JTextArea(stringArray[2]);
                                if (stringArray.length > 3) {
                                    jTextArea.setText(stringArray[2] + "\n" + stringArray[3]);
                                }
                                jTextArea.setFont(new Font("Monospaced", 0, 12));
                                LuceneDataStoreSearchGUI.this.centerPanel.add((Component)jTextArea, gridBagConstraints);
                                Object var6_3 = null;
                                LuceneDataStoreSearchGUI.this.updateViews();
                                LuceneDataStoreSearchGUI.this.pageOfResults = 1;
                                LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                                LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Object var6_4 = null;
                                LuceneDataStoreSearchGUI.this.updateViews();
                                LuceneDataStoreSearchGUI.this.pageOfResults = 1;
                                LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                                LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                        }
                        Object var6_1 = null;
                        LuceneDataStoreSearchGUI.this.updateViews();
                        LuceneDataStoreSearchGUI.this.pageOfResults = 1;
                        LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                        LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        LuceneDataStoreSearchGUI.this.updateViews();
                        LuceneDataStoreSearchGUI.this.pageOfResults = 1;
                        LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                        LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
            });
        }
    }

    protected class ClearQueryAction
    extends AbstractAction {
        public ClearQueryAction() {
            super("Clear", MainFrame.getIcon("crystal-clear-action-button-cancel"));
            super.putValue("ShortDescription", "Clear the query text box.");
            super.putValue("MnemonicKey", 8);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LuceneDataStoreSearchGUI.this.queryTextArea.setText("");
            LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
        }
    }

    protected class ExportResultsAction
    extends AbstractAction {
        public ExportResultsAction() {
            super("Export", MainFrame.getIcon("crystal-clear-app-download-manager"));
            super.putValue("ShortDescription", "Export results and statistics to a HTML file.");
            super.putValue("MnemonicKey", 69);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void actionPerformed(ActionEvent actionEvent) {
            block21: {
                int n;
                int n2;
                XJFileChooser xJFileChooser = MainFrame.getFileChooser() != null ? MainFrame.getFileChooser() : new XJFileChooser();
                xJFileChooser.setAcceptAllFileFilterUsed(true);
                xJFileChooser.setDialogTitle("Choose a file to export the results");
                xJFileChooser.setFileSelectionMode(0);
                ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("HTML files", "html");
                xJFileChooser.addChoosableFileFilter(extensionFileFilter);
                String string = LuceneDataStoreSearchGUI.this.target instanceof SerialDataStore ? '-' + ((SerialDataStore)LuceneDataStoreSearchGUI.this.target).getStorageDir().getName() : "";
                String string2 = "Datastore" + string + ".html";
                xJFileChooser.setFileName(string2);
                xJFileChooser.setResource(LuceneDataStoreSearchGUI.class.getName());
                int n3 = xJFileChooser.showSaveDialog(LuceneDataStoreSearchGUI.this);
                if (n3 != 0) {
                    return;
                }
                File file = xJFileChooser.getSelectedFile();
                BufferedWriter bufferedWriter = null;
                String string3 = Strings.getNl();
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"" + string3);
                bufferedWriter.write("\"http://www.w3.org/TR/html4/loose.dtd\">" + string3);
                bufferedWriter.write("<HTML><HEAD><TITLE>Annic Results and Statistics</TITLE>" + string3);
                bufferedWriter.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">" + string3);
                bufferedWriter.write("</HEAD><BODY>" + string3 + string3);
                bufferedWriter.write("<H1 align=\"center\">Annic Results and Statistics</H1>" + string3);
                bufferedWriter.write("<H2>Parameters</H2>" + string3);
                bufferedWriter.write("<UL><LI>Corpus: <B>" + LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem() + "</B></LI>" + string3);
                bufferedWriter.write("<LI>Annotation set: <B>" + LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem() + "</B></LI>" + string3);
                bufferedWriter.write("<LI>Query Issued: <B>" + LuceneDataStoreSearchGUI.this.searcher.getQuery() + "</B></LI>");
                bufferedWriter.write("<LI>Context Window: <B>" + LuceneDataStoreSearchGUI.this.searcher.getParameters().get("CONTEXT_WINDOW") + "</B></LI>" + string3);
                bufferedWriter.write("</UL>" + string3 + string3);
                bufferedWriter.write("<H2>Results</H2>" + string3);
                bufferedWriter.write("<TABLE border=\"1\"><TBODY>" + string3);
                bufferedWriter.write("<TR>");
                for (n2 = 0; n2 < LuceneDataStoreSearchGUI.this.resultTable.getColumnCount(); ++n2) {
                    bufferedWriter.write("<TH>" + LuceneDataStoreSearchGUI.this.resultTable.getColumnName(n2) + "</TH>" + string3);
                }
                bufferedWriter.write("</TR>" + string3);
                for (n2 = 0; n2 < LuceneDataStoreSearchGUI.this.resultTable.getRowCount(); ++n2) {
                    bufferedWriter.write("<TR>");
                    for (n = 0; n < LuceneDataStoreSearchGUI.this.resultTable.getColumnCount(); ++n) {
                        bufferedWriter.write("<TD>" + ((String)LuceneDataStoreSearchGUI.this.resultTable.getValueAt(n2, n)).replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;") + "</TD>" + string3);
                    }
                    bufferedWriter.write("</TR>" + string3);
                }
                bufferedWriter.write("</TBODY></TABLE>" + string3 + string3);
                bufferedWriter.write("<H2>Global Statistics</H2>");
                bufferedWriter.write("<TABLE border=\"1\"><TBODY>" + string3);
                bufferedWriter.write("<TR>");
                for (n2 = 0; n2 < LuceneDataStoreSearchGUI.this.globalStatisticsTable.getColumnCount(); ++n2) {
                    bufferedWriter.write("<TH>" + LuceneDataStoreSearchGUI.this.globalStatisticsTable.getColumnName(n2) + "</TH>" + string3);
                }
                bufferedWriter.write("</TR>" + string3);
                for (n2 = 0; n2 < LuceneDataStoreSearchGUI.this.globalStatisticsTable.getRowCount(); ++n2) {
                    bufferedWriter.write("<TR>");
                    for (n = 0; n < LuceneDataStoreSearchGUI.this.globalStatisticsTable.getColumnCount(); ++n) {
                        bufferedWriter.write("<TD>" + LuceneDataStoreSearchGUI.this.globalStatisticsTable.getValueAt(n2, n) + "</TD>" + string3);
                    }
                    bufferedWriter.write("</TR>" + string3);
                }
                bufferedWriter.write("</TBODY></TABLE>" + string3 + string3);
                bufferedWriter.write("<H2>One item Statistics</H2>" + string3);
                bufferedWriter.write("<TABLE border=\"1\"><TBODY>" + string3);
                bufferedWriter.write("<TR>");
                for (n2 = 0; n2 < LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getColumnCount() - 1; ++n2) {
                    bufferedWriter.write("<TH>" + LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getColumnName(n2) + "</TH>" + string3);
                }
                bufferedWriter.write("</TR>" + string3);
                for (n2 = 0; n2 < LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount(); ++n2) {
                    bufferedWriter.write("<TR>");
                    for (n = 0; n < LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getColumnCount() - 1; ++n) {
                        bufferedWriter.write("<TD>" + LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(n2, n) + "</TD>" + string3);
                    }
                    bufferedWriter.write("</TR>" + string3);
                }
                bufferedWriter.write("</TBODY></TABLE>" + string3 + string3);
                bufferedWriter.write("<P><BR></P><HR>" + string3);
                bufferedWriter.write("</BODY>" + string3);
                bufferedWriter.write("</HTML>");
                bufferedWriter.flush();
                Object var13_13 = null;
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    break block21;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break block21;
                {
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Object var13_14 = null;
                        try {
                            if (bufferedWriter != null) {
                                bufferedWriter.close();
                            }
                            break block21;
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
    }
}

