/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.MainFrame;
import gate.swing.XJPopupMenu;
import gate.swing.XJTable;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

@CreoleResource(name="Corpus editor", guiType=GuiType.LARGE, resourceDisplayed="gate.Corpus", mainViewer=true)
public class CorpusEditor
extends AbstractVisualResource
implements CorpusListener {
    protected XJTable docTable;
    protected DocumentTableModel docTableModel;
    protected DocumentNameRenderer renderer;
    protected JToolBar toolbar;
    protected Corpus corpus;
    protected NewDocumentAction newDocumentAction;
    protected RemoveDocumentsAction removeDocumentsAction;
    protected MoveUpAction moveUpAction;
    protected MoveDownAction moveDownAction;
    protected OpenDocumentsAction openDocumentsAction;
    protected JLabel messageLabel;
    protected int documentsLoadedCount;

    public Resource init() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        return this;
    }

    protected void initLocalData() {
        this.docTableModel = new DocumentTableModel();
        try {
            this.documentsLoadedCount = Gate.getCreoleRegister().getAllInstances("gate.Document").size();
        }
        catch (GateException gateException) {
            gateException.printStackTrace();
        }
    }

    protected void initGuiComponents() {
        this.setLayout(new BorderLayout());
        this.renderer = new DocumentNameRenderer();
        this.docTable = new XJTable(this.docTableModel);
        this.docTable.setSortable(true);
        this.docTable.setSortedColumn(0);
        this.docTable.setAutoResizeMode(3);
        this.docTable.getColumnModel().getColumn(1).setCellRenderer(this.renderer);
        this.docTable.setDragEnabled(true);
        this.docTable.setTransferHandler(new TransferHandler(){
            String source = "";

            public int getSourceActions(JComponent jComponent) {
                return 2;
            }

            protected Transferable createTransferable(JComponent jComponent) {
                int[] nArray = CorpusEditor.this.docTable.getSelectedRows();
                Arrays.sort(nArray);
                return new StringSelection("CorpusEditor" + Arrays.toString(nArray));
            }

            protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            }

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!DataFlavor.stringFlavor.equals(dataFlavor)) continue;
                    return true;
                }
                return false;
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                    return false;
                }
                try {
                    this.source = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (this.source.startsWith("ResourcesTree")) {
                        List<Resource> list;
                        int n = CorpusEditor.this.docTable.getSelectedRow();
                        ArrayList<Document> arrayList = new ArrayList<Document>();
                        this.source = this.source.replaceFirst("^ResourcesTree\\[", "");
                        this.source = this.source.replaceFirst("\\]$", "");
                        final String[] stringArray = this.source.split(", ");
                        try {
                            list = Gate.getCreoleRegister().getAllInstances("gate.Document");
                        }
                        catch (GateException gateException) {
                            gateException.printStackTrace();
                            return false;
                        }
                        for (String string : stringArray) {
                            for (Resource resource : list) {
                                if (!resource.getName().equals(string) || CorpusEditor.this.corpus.contains(resource)) continue;
                                arrayList.add((Document)resource);
                            }
                        }
                        for (Document document : arrayList) {
                            if (n != -1) {
                                CorpusEditor.this.corpus.add(CorpusEditor.this.docTable.rowViewToModel(n), document);
                                if (n != CorpusEditor.this.docTable.getRowCount()) continue;
                                ++n;
                                continue;
                            }
                            CorpusEditor.this.corpus.add(document);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                CorpusEditor.this.docTable.clearSelection();
                                for (String string : stringArray) {
                                    for (int i = 0; i < CorpusEditor.this.docTable.getRowCount(); ++i) {
                                        if (!CorpusEditor.this.docTable.getValueAt(i, CorpusEditor.this.docTable.convertColumnIndexToView(1)).equals(string)) continue;
                                        CorpusEditor.this.docTable.addRowSelectionInterval(i, i);
                                    }
                                }
                            }
                        });
                        CorpusEditor.this.changeMessage();
                        return true;
                    }
                    if (this.source.startsWith("CorpusEditor")) {
                        int n;
                        int n2 = n = CorpusEditor.this.docTable.getSelectedRow();
                        ArrayList<Document> arrayList = new ArrayList<Document>();
                        this.source = this.source.replaceFirst("^CorpusEditor\\[", "");
                        this.source = this.source.replaceFirst("\\]$", "");
                        String[] stringArray = this.source.split(", ");
                        if (Integer.valueOf(stringArray[0]) < n) {
                            ++n;
                        }
                        for (String string : stringArray) {
                            if (Integer.valueOf(string) == n2) {
                                return false;
                            }
                            arrayList.add((Document)CorpusEditor.this.corpus.get(CorpusEditor.this.docTable.rowViewToModel(Integer.valueOf(string))));
                            if (Integer.valueOf(string) >= n2) continue;
                            --n;
                        }
                        for (Document document : arrayList) {
                            CorpusEditor.this.corpus.remove(document);
                        }
                        for (Document document : arrayList) {
                            CorpusEditor.this.corpus.add(CorpusEditor.this.docTable.rowViewToModel(n), document);
                            ++n;
                        }
                        CorpusEditor.this.docTable.addRowSelectionInterval(n - stringArray.length, n - 1);
                        return true;
                    }
                    return false;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.docTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.getViewport().setBackground(this.docTable.getBackground());
        this.add((Component)jScrollPane, "Center");
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.newDocumentAction = new NewDocumentAction();
        this.toolbar.add(this.newDocumentAction);
        this.removeDocumentsAction = new RemoveDocumentsAction();
        this.toolbar.add(this.removeDocumentsAction);
        this.toolbar.addSeparator();
        this.moveUpAction = new MoveUpAction();
        this.toolbar.add(this.moveUpAction);
        this.moveDownAction = new MoveDownAction();
        this.toolbar.add(this.moveDownAction);
        this.toolbar.addSeparator();
        this.openDocumentsAction = new OpenDocumentsAction();
        this.toolbar.add(this.openDocumentsAction);
        this.removeDocumentsAction.setEnabled(false);
        this.moveUpAction.setEnabled(false);
        this.moveDownAction.setEnabled(false);
        this.openDocumentsAction.setEnabled(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.toolbar, "North");
        this.messageLabel = new JLabel();
        this.changeMessage();
        jPanel.add((Component)this.messageLabel, "South");
        this.add((Component)jPanel, "North");
    }

    protected void initListeners() {
        this.docTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.processMouseEvent(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.processMouseEvent(mouseEvent);
                }
            }

            private void processMouseEvent(MouseEvent mouseEvent) {
                int n = CorpusEditor.this.docTable.rowAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    if (!CorpusEditor.this.docTable.isRowSelected(n)) {
                        CorpusEditor.this.docTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    XJPopupMenu xJPopupMenu = new XJPopupMenu();
                    xJPopupMenu.add(CorpusEditor.this.openDocumentsAction);
                    xJPopupMenu.add(CorpusEditor.this.removeDocumentsAction);
                    xJPopupMenu.show(CorpusEditor.this.docTable, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                } else if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2) {
                    CorpusEditor.this.openDocumentsAction.actionPerformed(null);
                }
            }
        });
        this.docTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    CorpusEditor.this.openDocumentsAction.actionPerformed(null);
                }
            }
        });
        this.docTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CorpusEditor.this.removeDocumentsAction.setEnabled(CorpusEditor.this.docTable.getSelectedRowCount() > 0);
                CorpusEditor.this.openDocumentsAction.setEnabled(CorpusEditor.this.docTable.getSelectedRowCount() > 0);
                CorpusEditor.this.moveUpAction.setEnabled(CorpusEditor.this.docTable.getSelectedRowCount() > 0 && !CorpusEditor.this.docTable.isRowSelected(0));
                CorpusEditor.this.moveDownAction.setEnabled(CorpusEditor.this.docTable.getSelectedRowCount() > 0 && !CorpusEditor.this.docTable.isRowSelected(CorpusEditor.this.docTable.getRowCount() - 1));
            }
        });
        Gate.getCreoleRegister().addCreoleListener(new CreoleListener(){

            public void resourceLoaded(CreoleEvent creoleEvent) {
                if (creoleEvent.getResource() instanceof Document) {
                    ++CorpusEditor.this.documentsLoadedCount;
                    CorpusEditor.this.changeMessage();
                }
            }

            public void resourceUnloaded(CreoleEvent creoleEvent) {
                if (creoleEvent.getResource() instanceof Document) {
                    --CorpusEditor.this.documentsLoadedCount;
                    CorpusEditor.this.changeMessage();
                }
            }

            public void datastoreOpened(CreoleEvent creoleEvent) {
            }

            public void datastoreCreated(CreoleEvent creoleEvent) {
            }

            public void datastoreClosed(CreoleEvent creoleEvent) {
            }

            public void resourceRenamed(Resource resource, String string, String string2) {
            }
        });
    }

    public void cleanup() {
        super.cleanup();
        this.corpus = null;
    }

    public void setTarget(Object object) {
        if (this.corpus != null && this.corpus != object) {
            this.corpus.removeCorpusListener(this);
        }
        if (!(object instanceof Corpus)) {
            throw new IllegalArgumentException("The GATE corpus editor can only be used with a GATE corpus!\n" + object.getClass().toString() + " is not a GATE corpus!");
        }
        this.corpus = (Corpus)object;
        this.corpus.addCorpusListener(this);
        this.docTableModel.dataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CorpusEditor.this.docTableModel.fireTableDataChanged();
            }
        });
    }

    public void documentAdded(final CorpusEvent corpusEvent) {
        this.docTableModel.dataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CorpusEditor.this.changeMessage();
                CorpusEditor.this.docTableModel.fireTableRowsInserted(corpusEvent.getDocumentIndex(), corpusEvent.getDocumentIndex());
            }
        });
    }

    public void documentRemoved(final CorpusEvent corpusEvent) {
        this.docTableModel.dataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CorpusEditor.this.changeMessage();
                CorpusEditor.this.docTableModel.fireTableRowsDeleted(corpusEvent.getDocumentIndex(), corpusEvent.getDocumentIndex());
            }
        });
    }

    protected void changeMessage() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CorpusEditor.this.corpus == null || CorpusEditor.this.corpus.size() == 0) {
                    CorpusEditor.this.newDocumentAction.setEnabled(true);
                    CorpusEditor.this.messageLabel.setText("<html>To add or remove documents to this corpus:<ul><li>use the toolbar buttons at the top of this view<li>drag documents from the left resources tree and drop them below<li>right click on the corpus in the resources tree and choose 'Populate'</ul></html>");
                    CorpusEditor.this.messageLabel.setVisible(true);
                } else if (CorpusEditor.this.documentsLoadedCount > 0 && CorpusEditor.this.documentsLoadedCount == CorpusEditor.this.corpus.size()) {
                    CorpusEditor.this.newDocumentAction.setEnabled(false);
                    CorpusEditor.this.messageLabel.setText("All the documents loaded in the system are in this corpus.");
                    CorpusEditor.this.messageLabel.setVisible(true);
                } else if (CorpusEditor.this.documentsLoadedCount == 0) {
                    CorpusEditor.this.newDocumentAction.setEnabled(false);
                    if (CorpusEditor.this.corpus.getDataStore() == null) {
                        CorpusEditor.this.messageLabel.setText("There are no documents loaded in the system. Press F1 for help.");
                    } else {
                        CorpusEditor.this.messageLabel.setText("Open a document to load it from the datastore.");
                    }
                    CorpusEditor.this.messageLabel.setVisible(true);
                } else {
                    CorpusEditor.this.newDocumentAction.setEnabled(true);
                    CorpusEditor.this.messageLabel.setVisible(false);
                }
            }
        });
    }

    class OpenDocumentsAction
    extends AbstractAction {
        public OpenDocumentsAction() {
            super("Open documents", MainFrame.getIcon("document"));
            this.putValue("ShortDescription", "Opens selected document(s) in a document editor");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = SwingUtilities.getRoot(CorpusEditor.this);
            if (!(component instanceof MainFrame)) {
                return;
            }
            final MainFrame mainFrame = (MainFrame)component;
            final int[] nArray = CorpusEditor.this.docTable.getSelectedRows();
            if (nArray.length > 10) {
                Object[] objectArray = new Object[]{"Open the " + nArray.length + " documents", "Don't open"};
                int n = JOptionPane.showOptionDialog(CorpusEditor.this.docTable, "Do you want to open " + nArray.length + " documents in the central tabbed pane ?", "Warning", -1, 3, null, objectArray, objectArray[1]);
                if (n == 1 || n == -1) {
                    return;
                }
            }
            for (int n : nArray) {
                CorpusEditor.this.corpus.get(CorpusEditor.this.docTable.rowViewToModel(n));
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int n : nArray) {
                        Document document = (Document)CorpusEditor.this.corpus.get(CorpusEditor.this.docTable.rowViewToModel(n));
                        mainFrame.select(document);
                    }
                }
            });
        }
    }

    class RemoveDocumentsAction
    extends AbstractAction {
        public RemoveDocumentsAction() {
            super("Remove documents", MainFrame.getIcon("remove-document"));
            this.putValue("ShortDescription", "Removes selected document(s) from this corpus");
            this.putValue("MnemonicKey", 127);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = CorpusEditor.this.docTable.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray2[n] = CorpusEditor.this.docTable.rowViewToModel(nArray[n]);
            }
            Arrays.sort(nArray2);
            for (n = nArray2.length - 1; n >= 0; --n) {
                CorpusEditor.this.corpus.remove(nArray2[n]);
            }
            CorpusEditor.this.docTable.clearSelection();
            CorpusEditor.this.changeMessage();
        }
    }

    class NewDocumentAction
    extends AbstractAction {
        public NewDocumentAction() {
            super("Add document", MainFrame.getIcon("add-document"));
            this.putValue("ShortDescription", "Add new document(s) to this corpus");
            this.putValue("MnemonicKey", 10);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List<Resource> list;
            try {
                list = Gate.getCreoleRegister().getAllInstances("gate.Document");
            }
            catch (GateException gateException) {
                throw new GateRuntimeException("gate.Document is not registered in the creole register!\nSomething must be terribly wrong...take a vacation!");
            }
            Vector<String> vector = new Vector<String>();
            for (Resource serializable2 : new ArrayList<Resource>(list)) {
                if (CorpusEditor.this.corpus.contains(serializable2)) {
                    list.remove(serializable2);
                    continue;
                }
                vector.add(serializable2.getName());
            }
            JList jList = new JList(vector);
            jList.getSelectionModel().setSelectionInterval(0, vector.size() - 1);
            jList.setCellRenderer(CorpusEditor.this.renderer);
            final JOptionPane jOptionPane = new JOptionPane(new JScrollPane(jList), 3, 2);
            final JDialog jDialog = jOptionPane.createDialog(CorpusEditor.this, "Add document(s) to this corpus");
            jList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        jOptionPane.setValue(0);
                        jDialog.dispose();
                    }
                }
            });
            jDialog.setVisible(true);
            if (jOptionPane.getValue().equals(0)) {
                int[] nArray;
                for (int n : nArray = jList.getSelectedIndices()) {
                    CorpusEditor.this.corpus.add(list.get(n));
                }
            }
            CorpusEditor.this.changeMessage();
        }
    }

    class MoveDownAction
    extends AbstractAction {
        public MoveDownAction() {
            super("Move down", MainFrame.getIcon("down"));
            this.putValue("ShortDescription", "Moves selected document(s) down");
            this.putValue("MnemonicKey", 40);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = CorpusEditor.this.docTable.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray2[n] = CorpusEditor.this.docTable.rowViewToModel(nArray[n]);
            }
            Arrays.sort(nArray2);
            for (n = nArray2.length - 1; n >= 0; --n) {
                if (nArray2[n] >= CorpusEditor.this.corpus.size() - 1) continue;
                boolean bl = CorpusEditor.this.corpus.isDocumentLoaded(nArray2[n]);
                Document document = (Document)CorpusEditor.this.corpus.get(nArray2[n]);
                CorpusEditor.this.corpus.remove(nArray2[n]);
                int n2 = n;
                nArray2[n2] = nArray2[n2] + 1;
                CorpusEditor.this.corpus.add(nArray2[n], document);
                if (bl) continue;
                CorpusEditor.this.corpus.unloadDocument(document);
                Factory.deleteResource(document);
            }
            final int[] nArray3 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CorpusEditor.this.docTable.clearSelection();
                    for (int i = 0; i < nArray3.length; ++i) {
                        int n = CorpusEditor.this.docTable.rowModelToView(nArray3[i]);
                        CorpusEditor.this.docTable.getSelectionModel().addSelectionInterval(n, n);
                    }
                }
            });
        }
    }

    class MoveUpAction
    extends AbstractAction {
        public MoveUpAction() {
            super("Move up", MainFrame.getIcon("up"));
            this.putValue("ShortDescription", "Moves selected document(s) up");
            this.putValue("MnemonicKey", 38);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = CorpusEditor.this.docTable.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray2[n] = CorpusEditor.this.docTable.rowViewToModel(nArray[n]);
            }
            Arrays.sort(nArray2);
            for (n = 0; n < nArray2.length; ++n) {
                if (nArray2[n] <= 0) continue;
                boolean bl = CorpusEditor.this.corpus.isDocumentLoaded(nArray2[n]);
                Document document = (Document)CorpusEditor.this.corpus.get(nArray2[n]);
                CorpusEditor.this.corpus.remove(nArray2[n]);
                nArray2[n] = nArray2[n] - 1;
                CorpusEditor.this.corpus.add(nArray2[n], document);
                if (bl) continue;
                CorpusEditor.this.corpus.unloadDocument(document);
                Factory.deleteResource(document);
            }
            final int[] nArray3 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CorpusEditor.this.docTable.clearSelection();
                    for (int i = 0; i < nArray3.length; ++i) {
                        int n = CorpusEditor.this.docTable.rowModelToView(nArray3[i]);
                        CorpusEditor.this.docTable.getSelectionModel().addSelectionInterval(n, n);
                    }
                }
            });
        }
    }

    class DocumentNameRenderer
    extends DefaultTableCellRenderer
    implements ListCellRenderer {
        public DocumentNameRenderer() {
            this.setIcon(MainFrame.getIcon("document"));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return this.getTableCellRendererComponent(CorpusEditor.this.docTable, object, bl, bl2, n, 1);
        }

        public Dimension getMaximumSize() {
            Dimension dimension = super.getMaximumSize();
            if (dimension != null) {
                dimension.width = Integer.MAX_VALUE;
                this.setMaximumSize(dimension);
            }
            return dimension;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DocumentTableModel
    extends AbstractTableModel {
        private List<String> documentNames;
        private final String[] COLUMN_NAMES = new String[]{"Index", "Document name"};
        private static final int COL_INDEX = 0;
        private static final int COL_NAME = 1;
        private static final int COLUMN_COUNT = 2;

        public DocumentTableModel() {
            this.documentNames = new ArrayList<String>();
        }

        private void dataChanged() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (CorpusEditor.this.corpus != null) {
                arrayList.addAll(CorpusEditor.this.corpus.getDocumentNames());
            }
            List<String> list = this.documentNames;
            this.documentNames = arrayList;
            list.clear();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.documentNames.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < 0 || n >= this.documentNames.size() || n2 < 0 || n2 > 2) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return n;
                }
                case 1: {
                    return this.documentNames.get(n);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

