/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.gui.MainFrame;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.AnnotationDiffer;
import gate.util.ExtensionFileFilter;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.SimpleFeatureMapImpl;
import gate.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDiffGUI
extends JFrame {
    protected AnnotationDiffer differ;
    protected List<AnnotationDiffer.Pairing> pairings;
    protected List<Boolean> keyCopyValueRows;
    protected List<Boolean> resCopyValueRows;
    protected Document keyDoc;
    protected Document resDoc;
    protected Set<String> significantFeatures;
    protected List<Resource> documents;
    protected List<AnnotationSet> keySets;
    protected List<AnnotationSet> resSets;
    protected AnnotationSet keySet;
    protected AnnotationSet resSet;
    protected HTMLExportAction htmlExportAction;
    protected DiffAction diffAction;
    protected CopyToTargetSetAction copyToTargetSetAction;
    protected ShowDocumentAction showDocumentAction;
    protected JList featuresList;
    protected DefaultListModel featureslistModel;
    protected DiffTableModel diffTableModel;
    protected XJTable diffTable;
    protected JScrollPane scroller;
    protected JComboBox keyDocCombo;
    protected JComboBox keySetCombo;
    protected JComboBox annTypeCombo;
    protected JComboBox resDocCombo;
    protected JComboBox resSetCombo;
    protected JLabel statusLabel;
    protected JProgressBar progressBar;
    protected JRadioButton allFeaturesBtn;
    protected JRadioButton someFeaturesBtn;
    protected JRadioButton noFeaturesBtn;
    protected JTextField weightTxt;
    protected JButton doDiffBtn;
    protected JTextField consensusASTextField;
    protected JButton copyToConsensusBtn;
    protected JButton htmlExportBtn;
    protected JButton showDocumentBtn;
    protected JTabbedPane bottomTabbedPane;
    protected JPanel statisticsPane;
    protected JLabel correctLbl;
    protected JLabel partiallyCorrectLbl;
    protected JLabel missingLbl;
    protected JLabel falsePozLbl;
    protected JLabel recallStrictLbl;
    protected JLabel precisionStrictLbl;
    protected JLabel fmeasureStrictLbl;
    protected JLabel recallLenientLbl;
    protected JLabel precisionLenientLbl;
    protected JLabel fmeasureLenientLbl;
    protected JLabel recallAveLbl;
    protected JLabel precisionAveLbl;
    protected JLabel fmeasureAveLbl;
    protected static final Color PARTIALLY_CORRECT_BG = new Color(173, 215, 255);
    protected static final Color MISSING_BG = new Color(255, 173, 181);
    protected static final Color FALSE_POSITIVE_BG = new Color(255, 231, 173);
    protected static final String[] matchLabel = new String[5];
    protected final int maxCellLength = 40;
    protected boolean isStandalone;

    public AnnotationDiffGUI(String string) {
        super(string);
        this.setIconImage(((ImageIcon)MainFrame.getIcon("annotation-diff")).getImage());
        MainFrame.getGuiRoots().add(this);
        this.setDefaultCloseOperation(2);
        this.initLocalData();
        this.initGUI();
        this.initListeners();
        this.populateGUI();
    }

    public AnnotationDiffGUI(String string, final String string2, final String string3, final String string4, final String string5, final String string6, final Set<String> set) {
        super(string);
        this.setIconImage(((ImageIcon)MainFrame.getIcon("annotation-diff")).getImage());
        MainFrame.getGuiRoots().add(this);
        this.setDefaultCloseOperation(2);
        this.initLocalData();
        this.initGUI();
        this.initListeners();
        this.populateGUI();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnnotationDiffGUI.this.keyDocCombo.setSelectedItem(string2);
                AnnotationDiffGUI.this.resDocCombo.setSelectedItem(string3);
                if (string4 != null) {
                    AnnotationDiffGUI.this.keySetCombo.setSelectedItem(string4);
                }
                if (string5 != null) {
                    AnnotationDiffGUI.this.resSetCombo.setSelectedItem(string5);
                }
                if (string6 != null) {
                    AnnotationDiffGUI.this.annTypeCombo.setSelectedItem(string6);
                }
                AnnotationDiffGUI.this.significantFeatures.clear();
                if (set == null || set.isEmpty()) {
                    AnnotationDiffGUI.this.noFeaturesBtn.setSelected(true);
                } else {
                    AnnotationDiffGUI.this.significantFeatures.addAll(set);
                    AnnotationDiffGUI.this.someFeaturesBtn.setSelected(true);
                }
                if (string4 != null && string5 != null && string6 != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Date date = new Date(System.currentTimeMillis() + 1000L);
                            Timer timer = new Timer("Annotation diff init timer", true);
                            timer.schedule(new TimerTask(){

                                public void run() {
                                    AnnotationDiffGUI.this.diffAction.actionPerformed(new ActionEvent(this, -1, "corpus quality"));
                                }
                            }, date);
                        }
                    });
                }
            }
        });
    }

    protected void initLocalData() {
        this.differ = new AnnotationDiffer();
        this.pairings = new ArrayList<AnnotationDiffer.Pairing>();
        this.keyCopyValueRows = new ArrayList<Boolean>();
        this.resCopyValueRows = new ArrayList<Boolean>();
        this.significantFeatures = new HashSet<String>();
        this.keyDoc = null;
        this.resDoc = null;
        Component component = SwingUtilities.getRoot(this);
        this.isStandalone = component instanceof MainFrame;
    }

    protected void initGUI() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel("Key doc:");
        jLabel.setToolTipText("Key document");
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this.keyDocCombo = new JComboBox();
        this.keyDocCombo.setPrototypeDisplayValue("long_document_name");
        this.keyDocCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null) {
                    Rectangle rectangle = new Rectangle(AnnotationDiffGUI.this.keyDocCombo.getSize().width, this.getPreferredSize().height);
                    String string = SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), object.toString(), null, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getHorizontalTextPosition(), this.getVerticalTextPosition(), rectangle, new Rectangle(), rectangle, this.getIconTextGap());
                    if (string.equals(object)) {
                        if (n == -1) {
                            AnnotationDiffGUI.this.keyDocCombo.setToolTipText(null);
                        } else {
                            this.setToolTipText(null);
                        }
                    } else if (n == -1) {
                        AnnotationDiffGUI.this.keyDocCombo.setToolTipText(object.toString());
                    } else {
                        this.setToolTipText(object.toString());
                    }
                }
                return this;
            }
        });
        this.getContentPane().add((Component)this.keyDocCombo, gridBagConstraints);
        JLabel jLabel2 = new JLabel("Key set:");
        jLabel2.setToolTipText("Key annotation set");
        this.getContentPane().add((Component)jLabel2, gridBagConstraints);
        this.keySetCombo = new JComboBox();
        this.keySetCombo.setPrototypeDisplayValue("long_set_name");
        this.getContentPane().add((Component)this.keySetCombo, gridBagConstraints);
        JLabel jLabel3 = new JLabel("Type:");
        jLabel3.setToolTipText("Annotation type");
        this.getContentPane().add((Component)jLabel3, gridBagConstraints);
        this.annTypeCombo = new JComboBox();
        this.annTypeCombo.setPrototypeDisplayValue("very_long_type");
        gridBagConstraints.gridwidth = 3;
        this.getContentPane().add((Component)this.annTypeCombo, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        JLabel jLabel4 = new JLabel("Weight");
        jLabel4.setToolTipText("F-measure weight");
        this.getContentPane().add((Component)jLabel4, gridBagConstraints);
        this.diffAction = new DiffAction();
        this.diffAction.setEnabled(false);
        this.doDiffBtn = new JButton(this.diffAction);
        this.doDiffBtn.setForeground((Color)UIManager.getDefaults().get("Button.disabledText"));
        this.doDiffBtn.setToolTipText("Choose two annotation sets that have at least one annotation type in common.");
        gridBagConstraints.gridheight = 2;
        this.getContentPane().add((Component)this.doDiffBtn, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        JLabel jLabel5 = new JLabel("Resp. doc:");
        jLabel5.setToolTipText("Response document");
        this.getContentPane().add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        this.resDocCombo = new JComboBox();
        this.resDocCombo.setPrototypeDisplayValue("long_document_name");
        this.resDocCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null) {
                    Rectangle rectangle = new Rectangle(AnnotationDiffGUI.this.resDocCombo.getSize().width, this.getPreferredSize().height);
                    String string = SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), object.toString(), null, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getHorizontalTextPosition(), this.getVerticalTextPosition(), rectangle, new Rectangle(), rectangle, this.getIconTextGap());
                    if (string.equals(object)) {
                        if (n == -1) {
                            AnnotationDiffGUI.this.resDocCombo.setToolTipText(null);
                        } else {
                            this.setToolTipText(null);
                        }
                    } else if (n == -1) {
                        AnnotationDiffGUI.this.resDocCombo.setToolTipText(object.toString());
                    } else {
                        this.setToolTipText(object.toString());
                    }
                }
                return this;
            }
        });
        this.getContentPane().add((Component)this.resDocCombo, gridBagConstraints);
        JLabel jLabel6 = new JLabel("Resp. set:");
        jLabel6.setToolTipText("Response annotation set");
        this.getContentPane().add((Component)jLabel6, gridBagConstraints);
        this.resSetCombo = new JComboBox();
        this.resSetCombo.setPrototypeDisplayValue("long_set_name");
        this.getContentPane().add((Component)this.resSetCombo, gridBagConstraints);
        this.getContentPane().add((Component)new JLabel("Features:"), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.allFeaturesBtn = new JRadioButton("all");
        this.allFeaturesBtn.setOpaque(false);
        this.allFeaturesBtn.setMargin(new Insets(0, 0, 0, 1));
        this.allFeaturesBtn.setIconTextGap(1);
        buttonGroup.add(this.allFeaturesBtn);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.allFeaturesBtn, gridBagConstraints);
        this.someFeaturesBtn = new JRadioButton("some");
        this.someFeaturesBtn.setOpaque(false);
        this.someFeaturesBtn.setMargin(new Insets(0, 0, 0, 1));
        this.someFeaturesBtn.setIconTextGap(1);
        buttonGroup.add(this.someFeaturesBtn);
        this.getContentPane().add((Component)this.someFeaturesBtn, gridBagConstraints);
        this.noFeaturesBtn = new JRadioButton("none");
        this.noFeaturesBtn.setOpaque(false);
        this.noFeaturesBtn.setMargin(new Insets(0, 0, 0, 1));
        this.noFeaturesBtn.setIconTextGap(1);
        buttonGroup.add(this.noFeaturesBtn);
        this.getContentPane().add((Component)this.noFeaturesBtn, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.noFeaturesBtn.setSelected(true);
        this.weightTxt = new JTextField("1.0");
        this.weightTxt.setToolTipText("<html>Relative weight of precision and recall aka beta.<ul><li>1 weights equally precision and recall<li>0.5 weights precision twice as much as recall<li>2 weights recall twice as much as precision</ul></html>");
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.weightTxt, gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.diffTableModel = new DiffTableModel();
        this.diffTable = new XJTable(this.diffTableModel);
        this.diffTable.setDefaultRenderer(String.class, new DiffTableCellRenderer());
        this.diffTable.setDefaultRenderer(Boolean.class, new DiffTableCellRenderer());
        this.diffTable.setAutoResizeMode(0);
        this.diffTable.setComparator(5, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)object;
                String string2 = (String)object2;
                int n = 0;
                while (!string.equals(matchLabel[n])) {
                    ++n;
                }
                int n2 = 0;
                while (!string2.equals(matchLabel[n2])) {
                    ++n2;
                }
                return n - n2;
            }
        });
        this.diffTable.setSelectionMode(2);
        this.diffTable.setRowSelectionAllowed(true);
        this.diffTable.setColumnSelectionAllowed(true);
        this.diffTable.setEnableHidingColumns(true);
        this.diffTable.hideColumn(4);
        this.diffTable.hideColumn(6);
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                String string = (String)object;
                String string2 = (String)object2;
                if (string.trim().equals("") && string2.trim().equals("")) {
                    return 0;
                }
                if (string.trim().equals("")) {
                    return -1;
                }
                if (string2.trim().equals("")) {
                    return 1;
                }
                int n2 = Integer.parseInt(string);
                if (n2 == (n = Integer.parseInt(string2))) {
                    return 0;
                }
                if (n2 > n) {
                    return 1;
                }
                return -1;
            }
        };
        this.diffTable.setComparator(0, comparator);
        this.diffTable.setComparator(1, comparator);
        this.diffTable.setComparator(7, comparator);
        this.diffTable.setComparator(8, comparator);
        this.diffTable.setSortable(true);
        this.diffTable.setSortedColumn(5);
        this.diffTable.setAscending(true);
        this.scroller = new JScrollPane(this.diffTable);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.scroller, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.bottomTabbedPane = new JTabbedPane(3, 0);
        this.statisticsPane = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 17;
        JLabel jLabel7 = new JLabel("Correct:");
        jLabel7.setToolTipText("Correct:");
        jLabel7.setBackground(this.diffTable.getBackground());
        this.statisticsPane.add((Component)jLabel7, gridBagConstraints2);
        jLabel7 = new JLabel("Partially correct:");
        jLabel7.setToolTipText("Partially correct:");
        jLabel7.setBackground(PARTIALLY_CORRECT_BG);
        jLabel7.setOpaque(true);
        this.statisticsPane.add((Component)jLabel7, gridBagConstraints2);
        jLabel7 = new JLabel("Missing:");
        jLabel7.setToolTipText("Missing:");
        jLabel7.setBackground(MISSING_BG);
        jLabel7.setOpaque(true);
        this.statisticsPane.add((Component)jLabel7, gridBagConstraints2);
        jLabel7 = new JLabel("False positives:");
        jLabel7.setToolTipText("False positives:");
        jLabel7.setBackground(FALSE_POSITIVE_BG);
        jLabel7.setOpaque(true);
        this.statisticsPane.add((Component)jLabel7, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        this.correctLbl = new JLabel("0");
        this.statisticsPane.add((Component)this.correctLbl, gridBagConstraints2);
        this.partiallyCorrectLbl = new JLabel("0");
        this.statisticsPane.add((Component)this.partiallyCorrectLbl, gridBagConstraints2);
        this.missingLbl = new JLabel("0");
        this.statisticsPane.add((Component)this.missingLbl, gridBagConstraints2);
        this.falsePozLbl = new JLabel("0");
        this.statisticsPane.add((Component)this.falsePozLbl, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.insets = new Insets(4, 30, 4, 4);
        this.statisticsPane.add(Box.createGlue());
        jLabel7 = new JLabel("Strict:");
        this.statisticsPane.add((Component)jLabel7, gridBagConstraints2);
        jLabel7 = new JLabel("Lenient:");
        this.statisticsPane.add((Component)jLabel7, gridBagConstraints2);
        jLabel7 = new JLabel("Average:");
        this.statisticsPane.add((Component)jLabel7, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
        jLabel7 = new JLabel("Recall");
        this.statisticsPane.add((Component)jLabel7, gridBagConstraints2);
        this.recallStrictLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.recallStrictLbl, gridBagConstraints2);
        this.recallLenientLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.recallLenientLbl, gridBagConstraints2);
        this.recallAveLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.recallAveLbl, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jLabel7 = new JLabel("Precision");
        this.statisticsPane.add((Component)jLabel7, gridBagConstraints2);
        this.precisionStrictLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.precisionStrictLbl, gridBagConstraints2);
        this.precisionLenientLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.precisionLenientLbl, gridBagConstraints2);
        this.precisionAveLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.precisionAveLbl, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jLabel7 = new JLabel("F-measure");
        jLabel7.setToolTipText("<html>F-measure =<br>   ((weight\u00b2 + 1) * precision * recall)<br> / (weight\u00b2 * precision + recall))</html>");
        this.statisticsPane.add((Component)jLabel7, gridBagConstraints2);
        this.fmeasureStrictLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.fmeasureStrictLbl, gridBagConstraints2);
        this.fmeasureLenientLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.fmeasureLenientLbl, gridBagConstraints2);
        this.fmeasureAveLbl = new JLabel("0.00");
        this.statisticsPane.add((Component)this.fmeasureAveLbl, gridBagConstraints2);
        this.bottomTabbedPane.add("Statistics", this.statisticsPane);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.gridy = 0;
        jPanel.add((Component)new JLabel("Target set:"), gridBagConstraints2);
        this.consensusASTextField = new JTextField("consensus", 15);
        this.consensusASTextField.setToolTipText("Annotation set name where to copy the selected annotations");
        jPanel.add((Component)this.consensusASTextField, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        this.copyToTargetSetAction = new CopyToTargetSetAction();
        this.copyToTargetSetAction.setEnabled(false);
        this.copyToConsensusBtn = new JButton(this.copyToTargetSetAction);
        gridBagConstraints2.gridwidth = 2;
        jPanel.add((Component)this.copyToConsensusBtn, gridBagConstraints2);
        this.bottomTabbedPane.add("Adjudication", jPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridheight = 3;
        gridBagConstraints2.anchor = 17;
        jPanel2.add((Component)this.bottomTabbedPane, gridBagConstraints2);
        gridBagConstraints2.gridheight = 1;
        ++gridBagConstraints2.gridx;
        this.statusLabel = new JLabel();
        this.statusLabel.setBackground(this.diffTable.getBackground());
        gridBagConstraints2.insets = new Insets(2, 6, 6, 2);
        jPanel2.add((Component)this.statusLabel, gridBagConstraints2);
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimumSize(new Dimension(5, 5));
        this.progressBar.setBackground(this.diffTable.getBackground());
        this.progressBar.setOpaque(true);
        this.progressBar.setVisible(false);
        jPanel2.add((Component)this.progressBar, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = 0;
        if (!this.isStandalone) {
            this.showDocumentAction = new ShowDocumentAction();
            this.showDocumentAction.setEnabled(false);
            this.showDocumentBtn = new JButton(this.showDocumentAction);
            this.showDocumentBtn.setToolTipText("Use first the \"Compare\" button then select an annotation in the table.");
            jPanel2.add((Component)this.showDocumentBtn, gridBagConstraints2);
        }
        ++gridBagConstraints2.gridy;
        this.htmlExportAction = new HTMLExportAction();
        this.htmlExportAction.setEnabled(false);
        this.htmlExportBtn = new JButton(this.htmlExportAction);
        this.htmlExportBtn.setToolTipText("Use first the \"Compare\" button.");
        jPanel2.add((Component)this.htmlExportBtn, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        Color color = this.diffTable.getBackground();
        this.getContentPane().setBackground(color);
        this.scroller.setBackground(color);
        this.scroller.getViewport().setBackground(color);
        this.statisticsPane.setBackground(color);
        jPanel.setBackground(color);
        jPanel2.setBackground(color);
        this.bottomTabbedPane.setBackground(color);
        this.featureslistModel = new DefaultListModel();
        this.featuresList = new JList(this.featureslistModel);
        this.featuresList.setSelectionMode(2);
        this.keySetCombo.requestFocusInWindow();
    }

    protected void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                new CloseAction().actionPerformed(null);
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                AnnotationDiffGUI.this.populateGUI();
            }
        });
        this.keyDocCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AnnotationDiffGUI.this.keyDocCombo.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                Document document = (Document)AnnotationDiffGUI.this.documents.get(n);
                if (AnnotationDiffGUI.this.keyDoc == document) {
                    return;
                }
                AnnotationDiffGUI.this.pairings.clear();
                AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                AnnotationDiffGUI.this.copyToTargetSetAction.setEnabled(false);
                AnnotationDiffGUI.this.keyDoc = document;
                AnnotationDiffGUI.this.keySets = new ArrayList<AnnotationSet>();
                ArrayList<String> arrayList = new ArrayList<String>();
                AnnotationDiffGUI.this.keySets.add(AnnotationDiffGUI.this.keyDoc.getAnnotations());
                arrayList.add("[Default set]");
                if (AnnotationDiffGUI.this.keyDoc.getNamedAnnotationSets() != null) {
                    Iterator<String> iterator = AnnotationDiffGUI.this.keyDoc.getNamedAnnotationSets().keySet().iterator();
                    while (iterator.hasNext()) {
                        String string;
                        String string2 = string = iterator.next();
                        arrayList.add(string2);
                        AnnotationDiffGUI.this.keySets.add(AnnotationDiffGUI.this.keyDoc.getAnnotations(string2));
                    }
                }
                AnnotationDiffGUI.this.keySetCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                if (!arrayList.isEmpty()) {
                    AnnotationDiffGUI.this.keySetCombo.setSelectedIndex(0);
                    if (AnnotationDiffGUI.this.resSetCombo.getItemCount() > 0) {
                        for (int i = 0; i < AnnotationDiffGUI.this.resSetCombo.getItemCount(); ++i) {
                            AnnotationDiffGUI.this.resSetCombo.setSelectedIndex(i);
                            for (int j = 0; j < AnnotationDiffGUI.this.keySetCombo.getItemCount(); ++j) {
                                if (AnnotationDiffGUI.this.keyDoc.equals(AnnotationDiffGUI.this.resDoc) && AnnotationDiffGUI.this.resSetCombo.getItemAt(i).equals(AnnotationDiffGUI.this.keySetCombo.getItemAt(j))) continue;
                                AnnotationDiffGUI.this.keySetCombo.setSelectedIndex(j);
                                if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() != null) break;
                            }
                            if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() != null) break;
                        }
                        if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() == null) {
                            AnnotationDiffGUI.this.statusLabel.setText("There is no annotations in common.");
                            AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
                        } else if (AnnotationDiffGUI.this.statusLabel.getText().equals("There is no annotations in common.")) {
                            AnnotationDiffGUI.this.statusLabel.setText("The first annotation sets with annotations in common have been automatically selected.");
                            AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        }
                    }
                }
            }
        });
        this.resDocCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AnnotationDiffGUI.this.resDocCombo.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                Document document = (Document)AnnotationDiffGUI.this.documents.get(n);
                if (AnnotationDiffGUI.this.resDoc == document) {
                    return;
                }
                AnnotationDiffGUI.this.resDoc = document;
                AnnotationDiffGUI.this.pairings.clear();
                AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                AnnotationDiffGUI.this.copyToTargetSetAction.setEnabled(false);
                AnnotationDiffGUI.this.resSets = new ArrayList<AnnotationSet>();
                ArrayList<String> arrayList = new ArrayList<String>();
                AnnotationDiffGUI.this.resSets.add(AnnotationDiffGUI.this.resDoc.getAnnotations());
                arrayList.add("[Default set]");
                if (AnnotationDiffGUI.this.resDoc.getNamedAnnotationSets() != null) {
                    Iterator<String> iterator = AnnotationDiffGUI.this.resDoc.getNamedAnnotationSets().keySet().iterator();
                    while (iterator.hasNext()) {
                        String string;
                        String string2 = string = iterator.next();
                        arrayList.add(string2);
                        AnnotationDiffGUI.this.resSets.add(AnnotationDiffGUI.this.resDoc.getAnnotations(string2));
                    }
                }
                AnnotationDiffGUI.this.resSetCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                if (!arrayList.isEmpty()) {
                    AnnotationDiffGUI.this.resSetCombo.setSelectedIndex(0);
                    if (AnnotationDiffGUI.this.keySetCombo.getItemCount() > 0) {
                        for (int i = 0; i < AnnotationDiffGUI.this.resSetCombo.getItemCount(); ++i) {
                            AnnotationDiffGUI.this.resSetCombo.setSelectedIndex(i);
                            for (int j = 0; j < AnnotationDiffGUI.this.keySetCombo.getItemCount(); ++j) {
                                if (AnnotationDiffGUI.this.keyDoc.equals(AnnotationDiffGUI.this.resDoc) && AnnotationDiffGUI.this.resSetCombo.getItemAt(i).equals(AnnotationDiffGUI.this.keySetCombo.getItemAt(j))) continue;
                                AnnotationDiffGUI.this.keySetCombo.setSelectedIndex(j);
                                if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() != null) break;
                            }
                            if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() != null) break;
                        }
                        if (AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() == null) {
                            AnnotationDiffGUI.this.statusLabel.setText("There is no annotations in common.");
                            AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
                        } else if (AnnotationDiffGUI.this.statusLabel.getText().equals("There is no annotations in common.")) {
                            AnnotationDiffGUI.this.statusLabel.setText("The first annotation sets with annotations in common have been selected.");
                            AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        }
                    }
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationDiffGUI.this.keySet = AnnotationDiffGUI.this.keySets == null || AnnotationDiffGUI.this.keySets.isEmpty() ? null : AnnotationDiffGUI.this.keySets.get(AnnotationDiffGUI.this.keySetCombo.getSelectedIndex());
                AnnotationDiffGUI.this.resSet = AnnotationDiffGUI.this.resSets == null || AnnotationDiffGUI.this.resSets.isEmpty() ? null : AnnotationDiffGUI.this.resSets.get(AnnotationDiffGUI.this.resSetCombo.getSelectedIndex());
                HashSet hashSet = AnnotationDiffGUI.this.keySet == null || AnnotationDiffGUI.this.keySet.isEmpty() ? new HashSet() : AnnotationDiffGUI.this.keySet.getAllTypes();
                HashSet hashSet2 = AnnotationDiffGUI.this.resSet == null || AnnotationDiffGUI.this.resSet.isEmpty() ? new HashSet() : AnnotationDiffGUI.this.resSet.getAllTypes();
                HashSet hashSet3 = new HashSet(hashSet);
                hashSet3.retainAll(hashSet2);
                ArrayList arrayList = new ArrayList(hashSet3);
                Collections.sort(arrayList);
                AnnotationDiffGUI.this.annTypeCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                if (arrayList.size() > 0) {
                    AnnotationDiffGUI.this.annTypeCombo.setSelectedIndex(0);
                    AnnotationDiffGUI.this.diffAction.setEnabled(true);
                    AnnotationDiffGUI.this.doDiffBtn.setForeground((Color)UIManager.getDefaults().get("Button.foreground"));
                    AnnotationDiffGUI.this.doDiffBtn.setToolTipText((String)AnnotationDiffGUI.this.diffAction.getValue("ShortDescription"));
                } else {
                    AnnotationDiffGUI.this.diffAction.setEnabled(false);
                    AnnotationDiffGUI.this.doDiffBtn.setForeground((Color)UIManager.getDefaults().get("Button.disabledText"));
                    AnnotationDiffGUI.this.doDiffBtn.setToolTipText("Choose two annotation sets that have at least one annotation type in common.");
                }
            }
        };
        this.keySetCombo.addActionListener(actionListener);
        this.resSetCombo.addActionListener(actionListener);
        this.someFeaturesBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AnnotationDiffGUI.this.someFeaturesBtn.isSelected()) {
                    Object object;
                    Serializable serializable;
                    if (AnnotationDiffGUI.this.keySet == null || AnnotationDiffGUI.this.keySet.isEmpty() || AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() == null) {
                        return;
                    }
                    Iterator<Annotation> iterator = AnnotationDiffGUI.this.keySet.get((String)AnnotationDiffGUI.this.annTypeCombo.getSelectedItem()).iterator();
                    HashSet<String> hashSet = new HashSet<String>();
                    while (iterator.hasNext()) {
                        serializable = iterator.next();
                        object = serializable.getFeatures();
                        if (object == null) continue;
                        for (Object object2 : object.keySet()) {
                            hashSet.add((String)object2);
                        }
                    }
                    serializable = new ArrayList(hashSet);
                    Collections.sort(serializable);
                    AnnotationDiffGUI.this.featureslistModel.clear();
                    object = serializable.iterator();
                    int n = 0;
                    while (object.hasNext()) {
                        Object object2;
                        object2 = (String)object.next();
                        AnnotationDiffGUI.this.featureslistModel.addElement(object2);
                        if (AnnotationDiffGUI.this.significantFeatures.contains(object2)) {
                            AnnotationDiffGUI.this.featuresList.addSelectionInterval(n, n);
                        }
                        ++n;
                    }
                    int n2 = JOptionPane.showConfirmDialog(AnnotationDiffGUI.this, new JScrollPane(AnnotationDiffGUI.this.featuresList), "Select features", 2, 3);
                    if (n2 == 0) {
                        int[] nArray;
                        AnnotationDiffGUI.this.significantFeatures.clear();
                        for (int n3 : nArray = AnnotationDiffGUI.this.featuresList.getSelectedIndices()) {
                            AnnotationDiffGUI.this.significantFeatures.add((String)AnnotationDiffGUI.this.featureslistModel.get(n3));
                        }
                    }
                }
            }
        });
        this.diffTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (AnnotationDiffGUI.this.diffTableModel.getRowCount() > 0) {
                    AnnotationDiffGUI.this.htmlExportAction.setEnabled(true);
                    AnnotationDiffGUI.this.htmlExportBtn.setToolTipText((String)AnnotationDiffGUI.this.htmlExportAction.getValue("ShortDescription"));
                    AnnotationDiffGUI.this.showDocumentAction.setEnabled(true);
                    AnnotationDiffGUI.this.showDocumentBtn.setToolTipText((String)AnnotationDiffGUI.this.showDocumentAction.getValue("ShortDescription"));
                } else {
                    AnnotationDiffGUI.this.htmlExportAction.setEnabled(false);
                    AnnotationDiffGUI.this.htmlExportBtn.setToolTipText("Use first the \"Compare\" button.");
                    AnnotationDiffGUI.this.showDocumentAction.setEnabled(false);
                    AnnotationDiffGUI.this.showDocumentBtn.setToolTipText("Use first the \"Compare\" button then select an annotation in the table.");
                }
            }
        });
        this.diffTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl;
                int n = AnnotationDiffGUI.this.diffTable.rowViewToModel(AnnotationDiffGUI.this.diffTable.getSelectedRow());
                if (n == -1) {
                    AnnotationDiffGUI.this.showDocumentAction.setEnabled(false);
                    return;
                }
                AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(n);
                Annotation annotation = pairing.getKey();
                Annotation annotation2 = pairing.getResponse();
                int n2 = AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(AnnotationDiffGUI.this.diffTable.getSelectedColumn());
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        bl = annotation != null;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        bl = annotation2 != null;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                AnnotationDiffGUI.this.showDocumentAction.setEnabled(bl);
            }
        });
        this.diffTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl;
                int n = AnnotationDiffGUI.this.diffTable.rowViewToModel(AnnotationDiffGUI.this.diffTable.getSelectedRow());
                if (n == -1) {
                    AnnotationDiffGUI.this.showDocumentAction.setEnabled(false);
                    return;
                }
                AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(n);
                Annotation annotation = pairing.getKey();
                Annotation annotation2 = pairing.getResponse();
                int n2 = AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(AnnotationDiffGUI.this.diffTable.getSelectedColumn());
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        bl = annotation != null;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        bl = annotation2 != null;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                AnnotationDiffGUI.this.showDocumentAction.setEnabled(bl);
            }
        });
        this.diffTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int[] nArray;
                if (keyEvent.getKeyCode() != 32 || !AnnotationDiffGUI.this.diffTable.isColumnSelected(4) && !AnnotationDiffGUI.this.diffTable.isColumnSelected(6)) {
                    return;
                }
                keyEvent.consume();
                for (int n : nArray = new int[]{4, 6}) {
                    for (int n2 : AnnotationDiffGUI.this.diffTable.getSelectedRows()) {
                        if (!AnnotationDiffGUI.this.diffTable.isCellSelected(n2, n) || !AnnotationDiffGUI.this.diffTable.isCellEditable(n2, n)) continue;
                        AnnotationDiffGUI.this.diffTable.setValueAt((Boolean)AnnotationDiffGUI.this.diffTable.getValueAt(n2, n) == false, n2, n);
                        AnnotationDiffGUI.this.diffTableModel.fireTableCellUpdated(n2, n);
                    }
                }
            }
        });
        this.diffTable.addMouseListener(new MouseAdapter(){
            private JPopupMenu mousePopup;
            JMenuItem menuItem;

            public void mousePressed(MouseEvent mouseEvent) {
                this.showContextMenu(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showContextMenu(mouseEvent);
            }

            private void showContextMenu(MouseEvent mouseEvent) {
                int n = AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(AnnotationDiffGUI.this.diffTable.columnAtPoint(mouseEvent.getPoint()));
                if (!mouseEvent.isPopupTrigger() || n != 4 && n != 6) {
                    return;
                }
                this.mousePopup = new JPopupMenu();
                for (final String string : new String[]{"Tick", "Untick"}) {
                    this.menuItem = new JMenuItem(string + " selected check boxes");
                    this.menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = AnnotationDiffGUI.this.diffTable.convertColumnIndexToView(4);
                            int n2 = AnnotationDiffGUI.this.diffTable.convertColumnIndexToView(6);
                            for (int i = 0; i < AnnotationDiffGUI.this.diffTable.getRowCount(); ++i) {
                                int n3 = AnnotationDiffGUI.this.diffTable.rowViewToModel(i);
                                AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(n3);
                                if (AnnotationDiffGUI.this.diffTable.isCellSelected(i, n) && pairing.getKey() != null) {
                                    AnnotationDiffGUI.this.diffTable.setValueAt(string.equals("Tick"), i, n);
                                }
                                if (!AnnotationDiffGUI.this.diffTable.isCellSelected(i, n2) || pairing.getResponse() == null) continue;
                                AnnotationDiffGUI.this.diffTable.setValueAt(string.equals("Tick"), i, n2);
                            }
                            AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                        }
                    });
                    this.mousePopup.add(this.menuItem);
                }
                this.mousePopup.addSeparator();
                String[] stringArray = new String[]{"correct", "partially correct", "missing", "false positives", "mismatch"};
                String[] stringArray2 = new String[]{"=", "~", "-?", "?-", "<>"};
                for (int i = 0; i < stringArray.length; ++i) {
                    String string;
                    this.menuItem = new JMenuItem("Tick " + stringArray[i] + " annotations");
                    string = stringArray2[i];
                    this.menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = AnnotationDiffGUI.this.diffTable.convertColumnIndexToView(5);
                            for (int i = 0; i < AnnotationDiffGUI.this.diffTable.getRowCount(); ++i) {
                                int n2 = AnnotationDiffGUI.this.diffTable.rowViewToModel(i);
                                AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(n2);
                                if (AnnotationDiffGUI.this.diffTable.getValueAt(i, n).equals(string) && pairing.getKey() != null) {
                                    AnnotationDiffGUI.this.keyCopyValueRows.set(AnnotationDiffGUI.this.diffTable.rowViewToModel(i), true);
                                    continue;
                                }
                                if (!AnnotationDiffGUI.this.diffTable.getValueAt(i, n).equals(string) || pairing.getResponse() == null) continue;
                                AnnotationDiffGUI.this.resCopyValueRows.set(AnnotationDiffGUI.this.diffTable.rowViewToModel(i), true);
                            }
                            AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                        }
                    });
                    this.mousePopup.add(this.menuItem);
                }
                this.mousePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.consensusASTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                String string = AnnotationDiffGUI.this.consensusASTextField.getText().trim();
                if (string.length() == 0) {
                    AnnotationDiffGUI.this.consensusASTextField.setText("consensus");
                }
                if (AnnotationDiffGUI.this.keyDoc != null && AnnotationDiffGUI.this.keyDoc.getAnnotationSetNames().contains(string)) {
                    AnnotationDiffGUI.this.statusLabel.setText("Be careful, the annotation set " + string + " already exists.");
                    AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
                }
            }
        });
        this.bottomTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (AnnotationDiffGUI.this.bottomTabbedPane.getSelectedIndex() == 0) {
                    AnnotationDiffGUI.this.diffTable.hideColumn(4);
                    AnnotationDiffGUI.this.diffTable.hideColumn(6);
                } else {
                    int n = Math.round(AnnotationDiffGUI.this.diffTable.getColumnCount() / 2);
                    AnnotationDiffGUI.this.diffTable.showColumn(4, n);
                    AnnotationDiffGUI.this.diffTable.showColumn(6, n + 2);
                    AnnotationDiffGUI.this.diffTable.getColumnModel().getColumn(4).setPreferredWidth(10);
                    AnnotationDiffGUI.this.diffTable.getColumnModel().getColumn(6).setPreferredWidth(10);
                    AnnotationDiffGUI.this.diffTable.doLayout();
                }
            }
        });
    }

    @Override
    public void pack() {
        super.pack();
        this.setSize(this.getWidth(), this.getHeight() + 300);
    }

    protected void populateGUI() {
        try {
            this.documents = Gate.getCreoleRegister().getAllInstances("gate.Document");
        }
        catch (GateException gateException) {
            throw new GateRuntimeException(gateException);
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.documents.size());
        for (Resource object2 : this.documents) {
            arrayList.add(object2.getName());
        }
        Object object3 = this.keyDocCombo.getSelectedItem();
        Object object = this.resDocCombo.getSelectedItem();
        this.keyDocCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.resDocCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        if (!this.documents.isEmpty()) {
            this.keyDocCombo.setSelectedItem(object3);
            if (this.keyDocCombo.getSelectedIndex() == -1) {
                this.keyDocCombo.setSelectedIndex(0);
            }
            this.resDocCombo.setSelectedItem(object);
            if (this.resDocCombo.getSelectedIndex() == -1) {
                this.resDocCombo.setSelectedIndex(0);
            }
            this.statusLabel.setText(this.documents.size() + " documents loaded");
            if (this.annTypeCombo.getSelectedItem() == null) {
                this.statusLabel.setText(this.statusLabel.getText() + ". Choose two annotation sets to compare.");
            }
            this.statusLabel.setForeground(Color.BLACK);
        } else {
            this.statusLabel.setText("You must load at least one document.");
            this.statusLabel.setForeground(Color.RED);
        }
    }

    static {
        AnnotationDiffGUI.matchLabel[0] = "=";
        AnnotationDiffGUI.matchLabel[1] = "~";
        AnnotationDiffGUI.matchLabel[2] = "-?";
        AnnotationDiffGUI.matchLabel[3] = "?-";
        AnnotationDiffGUI.matchLabel[4] = "<>";
    }

    protected class DiffTableModel
    extends AbstractTableModel {
        protected static final int COL_COUNT = 11;
        protected static final int COL_KEY_START = 0;
        protected static final int COL_KEY_END = 1;
        protected static final int COL_KEY_STRING = 2;
        protected static final int COL_KEY_FEATURES = 3;
        protected static final int COL_KEY_COPY = 4;
        protected static final int COL_MATCH = 5;
        protected static final int COL_RES_COPY = 6;
        protected static final int COL_RES_START = 7;
        protected static final int COL_RES_END = 8;
        protected static final int COL_RES_STRING = 9;
        protected static final int COL_RES_FEATURES = 10;

        protected DiffTableModel() {
        }

        public int getRowCount() {
            return AnnotationDiffGUI.this.pairings.size();
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 4: {
                    return Boolean.class;
                }
                case 6: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        public int getColumnCount() {
            return 11;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Start";
                }
                case 1: {
                    return "End";
                }
                case 2: {
                    return "Key";
                }
                case 3: {
                    return "Features";
                }
                case 4: {
                    return "K";
                }
                case 5: {
                    return "=?";
                }
                case 6: {
                    return "R";
                }
                case 7: {
                    return "Start";
                }
                case 8: {
                    return "End";
                }
                case 9: {
                    return "Response";
                }
                case 10: {
                    return "Features";
                }
            }
            return "?";
        }

        public Color getBackgroundAt(int n, int n2) {
            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(n);
            switch (pairing.getType()) {
                case 0: {
                    return AnnotationDiffGUI.this.diffTable.getBackground();
                }
                case 1: {
                    return PARTIALLY_CORRECT_BG;
                }
                case 4: {
                    if (n2 < 5) {
                        return MISSING_BG;
                    }
                    if (n2 > 5) {
                        return FALSE_POSITIVE_BG;
                    }
                    return AnnotationDiffGUI.this.diffTable.getBackground();
                }
                case 2: {
                    return MISSING_BG;
                }
                case 3: {
                    return FALSE_POSITIVE_BG;
                }
            }
            return AnnotationDiffGUI.this.diffTable.getBackground();
        }

        public Object getValueAt(int n, int n2) {
            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(n);
            Annotation annotation = pairing.getKey();
            Annotation annotation2 = pairing.getResponse();
            switch (n2) {
                case 0: {
                    return annotation == null ? "" : annotation.getStartNode().getOffset().toString();
                }
                case 1: {
                    return annotation == null ? "" : annotation.getEndNode().getOffset().toString();
                }
                case 2: {
                    String string = "";
                    try {
                        if (annotation != null && AnnotationDiffGUI.this.keyDoc != null) {
                            string = AnnotationDiffGUI.this.keyDoc.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                        }
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        throw new GateRuntimeException(invalidOffsetException);
                    }
                    if (string.length() > 40) {
                        string = string.substring(0, 20) + "..." + string.substring(string.length() - 20);
                    }
                    string = string.replaceAll("(?:\r?\n)|\r", "\u2193");
                    string = string.replaceAll("\t", "\u2192");
                    string = string.replaceAll(" ", "\u00b7");
                    return string;
                }
                case 3: {
                    return annotation == null ? "" : annotation.getFeatures().toString();
                }
                case 4: {
                    return AnnotationDiffGUI.this.keyCopyValueRows.get(n);
                }
                case 5: {
                    return matchLabel[pairing.getType()];
                }
                case 6: {
                    return AnnotationDiffGUI.this.resCopyValueRows.get(n);
                }
                case 7: {
                    return annotation2 == null ? "" : annotation2.getStartNode().getOffset().toString();
                }
                case 8: {
                    return annotation2 == null ? "" : annotation2.getEndNode().getOffset().toString();
                }
                case 9: {
                    String string = "";
                    try {
                        if (annotation2 != null && AnnotationDiffGUI.this.resDoc != null) {
                            string = AnnotationDiffGUI.this.resDoc.getContent().getContent(annotation2.getStartNode().getOffset(), annotation2.getEndNode().getOffset()).toString();
                        }
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        throw new GateRuntimeException(invalidOffsetException);
                    }
                    if (string.length() > 40) {
                        string = string.substring(0, 20) + "..." + string.substring(string.length() - 20);
                    }
                    string = string.replaceAll("(?:\r?\n)|\r", "\u2193");
                    string = string.replaceAll("\t", "\u2192");
                    string = string.replaceAll(" ", "\u00b7");
                    return string;
                }
                case 10: {
                    return annotation2 == null ? "" : annotation2.getFeatures().toString();
                }
            }
            return "?";
        }

        public boolean isCellEditable(int n, int n2) {
            if (AnnotationDiffGUI.this.pairings.size() == 0) {
                return false;
            }
            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(n);
            switch (n2) {
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    return pairing.getKey() != null;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    return pairing.getResponse() != null;
                }
            }
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(n);
            AnnotationSet annotationSet = AnnotationDiffGUI.this.keyDoc.getAnnotations((String)AnnotationDiffGUI.this.keySetCombo.getSelectedItem());
            AnnotationSet annotationSet2 = AnnotationDiffGUI.this.resDoc.getAnnotations((String)AnnotationDiffGUI.this.resSetCombo.getSelectedItem());
            Annotation annotation = pairing.getKey();
            Annotation annotation2 = pairing.getResponse();
            String string = (String)AnnotationDiffGUI.this.keyDoc.getFeatures().get("anndiffsteps");
            if (string == null) {
                string = "0";
            }
            int n3 = -1;
            try {
                switch (n2) {
                    case 0: {
                        if (Long.valueOf((String)object).equals(annotation.getStartNode().getOffset())) break;
                        n3 = annotationSet.add(Long.valueOf((String)object), annotation.getEndNode().getOffset(), annotation.getType(), (FeatureMap)((SimpleFeatureMapImpl)annotation.getFeatures()).clone());
                        annotationSet.get(n3).getFeatures().put("anndiffmodified", "true");
                        if (annotation.getFeatures().containsKey("anndiffmodified")) {
                            annotationSet.remove(annotation);
                        } else {
                            annotation.getFeatures().put("anndiffstep", string);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("Start offset changed: " + annotation.getStartNode().getOffset() + " -> " + object + ".");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        break;
                    }
                    case 1: {
                        if (Long.valueOf((String)object).equals(annotation.getEndNode().getOffset())) break;
                        n3 = annotationSet.add(annotation.getStartNode().getOffset(), Long.valueOf((String)object), annotation.getType(), (FeatureMap)((SimpleFeatureMapImpl)annotation.getFeatures()).clone());
                        annotationSet.get(n3).getFeatures().put("anndiffmodified", "true");
                        if (annotation.getFeatures().containsKey("anndiffmodified")) {
                            annotationSet.remove(annotation);
                        } else {
                            annotation.getFeatures().put("anndiffstep", string);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("End offset changed: " + annotation.getEndNode().getOffset() + " -> " + object + ".");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        break;
                    }
                    case 3: {
                        String string2 = (String)object;
                        string2 = string2.replaceAll("\\s+", " ").replaceAll("[}{]", "");
                        FeatureMap featureMap = Factory.newFeatureMap();
                        if (string2.length() != 0) {
                            for (String string3 : string2.split(",")) {
                                String[] stringArray = string3.split("=");
                                if (stringArray.length != 2) {
                                    throw new NumberFormatException();
                                }
                                featureMap.put(stringArray[0].trim(), stringArray[1].trim());
                            }
                        }
                        if (featureMap.equals(annotation.getFeatures())) break;
                        n3 = annotationSet.add(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), annotation.getType(), featureMap);
                        annotationSet.get(n3).getFeatures().put("anndiffmodified", "true");
                        if (annotation.getFeatures().containsKey("anndiffmodified")) {
                            annotationSet.remove(annotation);
                        } else {
                            annotation.getFeatures().put("anndiffstep", string);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("Features changed.");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        break;
                    }
                    case 4: {
                        AnnotationDiffGUI.this.keyCopyValueRows.set(n, (Boolean)object);
                        break;
                    }
                    case 6: {
                        AnnotationDiffGUI.this.resCopyValueRows.set(n, (Boolean)object);
                        break;
                    }
                    case 7: {
                        if (Long.valueOf((String)object).equals(annotation2.getStartNode().getOffset())) break;
                        n3 = annotationSet2.add(Long.valueOf((String)object), annotation2.getEndNode().getOffset(), annotation2.getType(), (FeatureMap)((SimpleFeatureMapImpl)annotation2.getFeatures()).clone());
                        annotationSet2.get(n3).getFeatures().put("anndiffmodified", "true");
                        if (annotation2.getFeatures().containsKey("anndiffmodified")) {
                            annotationSet2.remove(annotation2);
                        } else {
                            annotation2.getFeatures().put("anndiffstep", string);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("Start offset changed: " + annotation2.getStartNode().getOffset() + " -> " + object + ".");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        break;
                    }
                    case 8: {
                        if (Long.valueOf((String)object).equals(annotation2.getEndNode().getOffset())) break;
                        n3 = annotationSet2.add(annotation2.getStartNode().getOffset(), Long.valueOf((String)object), annotation2.getType(), (FeatureMap)((SimpleFeatureMapImpl)annotation2.getFeatures()).clone());
                        annotationSet2.get(n3).getFeatures().put("anndiffmodified", "true");
                        if (annotation2.getFeatures().containsKey("anndiffmodified")) {
                            annotationSet2.remove(annotation2);
                        } else {
                            annotation2.getFeatures().put("anndiffstep", string);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("End offset changed: " + annotation2.getEndNode().getOffset() + " -> " + object + ".");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                        break;
                    }
                    case 10: {
                        String string4 = (String)object;
                        string4 = string4.replaceAll("\\s+", " ").replaceAll("[}{]", "");
                        FeatureMap featureMap = Factory.newFeatureMap();
                        if (string4.length() != 0) {
                            for (String string5 : string4.split(",")) {
                                String[] stringArray = string5.split("=");
                                if (stringArray.length != 2) {
                                    throw new NumberFormatException();
                                }
                                featureMap.put(stringArray[0].trim(), stringArray[1].trim());
                            }
                        }
                        if (featureMap.equals(annotation2.getFeatures())) break;
                        n3 = annotationSet2.add(annotation2.getStartNode().getOffset(), annotation2.getEndNode().getOffset(), annotation2.getType(), featureMap);
                        annotationSet2.get(n3).getFeatures().put("anndiffmodified", "true");
                        if (annotation2.getFeatures().containsKey("anndiffmodified")) {
                            annotationSet2.remove(annotation2);
                        } else {
                            annotation2.getFeatures().put("anndiffstep", string);
                        }
                        AnnotationDiffGUI.this.statusLabel.setText("Features changed.");
                        AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                    }
                }
            }
            catch (InvalidOffsetException invalidOffsetException) {
                AnnotationDiffGUI.this.statusLabel.setText("This offset is incorrect. No changes have been made.");
                AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                AnnotationDiffGUI.this.statusLabel.setText("The format is incorrect. No changes have been made.");
                AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
                return;
            }
            if (n3 != -1) {
                AnnotationDiffGUI.this.diffAction.actionPerformed(new ActionEvent(this, n3, "setvalue"));
            }
        }
    }

    protected class DiffTableCellRenderer
    extends DefaultTableCellRenderer {
        protected DiffTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            int n3 = AnnotationDiffGUI.this.diffTable.rowViewToModel(n);
            int n4 = AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(n2);
            Component component = object instanceof Boolean ? new JCheckBox() : super.getTableCellRendererComponent(jTable, object, false, bl2, n, n2);
            if (AnnotationDiffGUI.this.pairings.size() == 0 || n3 >= AnnotationDiffGUI.this.pairings.size()) {
                return component;
            }
            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(n3);
            component.setBackground(bl ? jTable.getSelectionBackground() : AnnotationDiffGUI.this.diffTableModel.getBackgroundAt(n3, n2));
            component.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            if (!(component instanceof JComponent)) {
                return component;
            }
            try {
                switch (n4) {
                    case 2: {
                        Annotation annotation = pairing.getKey();
                        if (annotation == null) {
                            string = null;
                            break;
                        }
                        string = AnnotationDiffGUI.this.keyDoc.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                        if (string.length() > 1000) {
                            string = string.substring(0, 500) + "<br>...<br>" + string.substring(string.length() - 500);
                        }
                        string = AnnotationDiffGUI.this.keyDoc.getContent().getContent(Math.max(0L, annotation.getStartNode().getOffset() - 40L), Math.max(0L, annotation.getStartNode().getOffset())).toString() + "<strong>" + string + "</strong>" + AnnotationDiffGUI.this.keyDoc.getContent().getContent(Math.min(AnnotationDiffGUI.this.keyDoc.getContent().size(), annotation.getEndNode().getOffset()), Math.min(AnnotationDiffGUI.this.keyDoc.getContent().size(), annotation.getEndNode().getOffset() + 40L)).toString();
                        string = string.replaceAll("\\s*\n\\s*", "<br>");
                        string = string.replaceAll("\\s+", " ");
                        string = "<html><table width=\"" + (string.length() > 150 ? "500" : "100%") + "\" border=\"0\" cellspacing=\"0\">" + "<tr><td>" + string + "</td></tr><tr><td>";
                        string = string + "<small><i>\u2193 = new line, \u2192 = tab, \u00b7 = space</i></small>";
                        string = string + "</td></tr></table></html>";
                        break;
                    }
                    case 3: {
                        if (pairing.getKey() == null) {
                            string = null;
                            break;
                        }
                        String string2 = pairing.getKey().getFeatures().toString();
                        string = string2 + "<br><small><i>To edit, double-click or press F2.</i></small>";
                        string = "<html><table width=\"" + (string.length() > 150 ? "500" : "100%") + "\" border=\"0\" cellspacing=\"0\">" + "<tr><td>" + string + "</td></tr></table></html>";
                        if (string2.length() > 40) {
                            string2 = string2.substring(0, 20) + "..." + string2.substring(string2.length() - 20);
                        }
                        ((JLabel)component).setText(string2);
                        break;
                    }
                    case 4: {
                        string = pairing.getKey() == null ? "<html>There is no key annotation." : "<html>Select this key annotation to copy.";
                        string = string + "<br><small><i>Space key invert the selected check boxes state.<br>Right-click for context menu.</i></small></html>";
                        component.setEnabled(pairing.getKey() != null);
                        ((JCheckBox)component).setSelected(AnnotationDiffGUI.this.keyCopyValueRows.get(n3));
                        break;
                    }
                    case 5: {
                        string = "correct =, partially correct ~, missing -?, false positives ?-, mismatch <>";
                        break;
                    }
                    case 6: {
                        string = pairing.getResponse() == null ? "<html>There is no response annotation." : "<html>Select this response annotation to copy.";
                        string = string + "<br><small><i>Space key invert the selected check boxes state.<br>Right-click for context menu.</i></small></html>";
                        component.setEnabled(pairing.getResponse() != null);
                        ((JCheckBox)component).setSelected(AnnotationDiffGUI.this.resCopyValueRows.get(n3));
                        break;
                    }
                    case 9: {
                        Annotation annotation = pairing.getResponse();
                        if (annotation == null) {
                            string = null;
                            break;
                        }
                        string = AnnotationDiffGUI.this.resDoc.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                        if (string.length() > 1000) {
                            string = string.substring(0, 500) + "<br>...<br>" + string.substring(string.length() - 500);
                        }
                        string = AnnotationDiffGUI.this.resDoc.getContent().getContent(Math.max(0L, annotation.getStartNode().getOffset() - 40L), Math.max(0L, annotation.getStartNode().getOffset())).toString() + "<strong>" + string + "</strong>" + AnnotationDiffGUI.this.resDoc.getContent().getContent(Math.min(AnnotationDiffGUI.this.resDoc.getContent().size(), annotation.getEndNode().getOffset()), Math.min(AnnotationDiffGUI.this.resDoc.getContent().size(), annotation.getEndNode().getOffset() + 40L)).toString();
                        string = string.replaceAll("\\s*\n\\s*", "<br>");
                        string = string.replaceAll("\\s+", " ");
                        string = "<html><table width=\"" + (string.length() > 150 ? "500" : "100%") + "\" border=\"0\" cellspacing=\"0\">" + "<tr><td>" + string + "</td></tr><tr><td>";
                        string = string + "<small><i>\u2193 = new line, \u2192 = tab, \u00b7 = space</i></small>";
                        string = string + "</td></tr></table></html>";
                        break;
                    }
                    case 10: {
                        if (pairing.getResponse() == null) {
                            string = null;
                            break;
                        }
                        String string3 = pairing.getResponse().getFeatures().toString();
                        string = string3 + "<br><small><i>To edit, double-click or press F2.</i></small>";
                        string = "<html><table width=\"" + (string.length() > 150 ? "500" : "100%") + "\" border=\"0\" cellspacing=\"0\">" + "<tr><td>" + string + "</td></tr></table></html>";
                        if (string3.length() > 40) {
                            string3 = string3.substring(0, 20) + "..." + string3.substring(string3.length() - 20);
                        }
                        ((JLabel)component).setText(string3);
                        break;
                    }
                    default: {
                        Annotation annotation;
                        Annotation annotation2 = annotation = n4 < 5 ? pairing.getKey() : pairing.getResponse();
                        if (annotation == null) {
                            string = null;
                            break;
                        }
                        string = "<html><small><i>To edit, double-click or press F2.</i></small></html>";
                        break;
                    }
                }
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
            ((JComponent)component).setToolTipText(string);
            return component;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.getGuiRoots().remove(AnnotationDiffGUI.this);
            AnnotationDiffGUI.this.dispose();
        }
    }

    protected class ShowDocumentAction
    extends AbstractAction {
        public ShowDocumentAction() {
            super("Show document");
            this.putValue("ShortDescription", "Show the selected annotation in the document editor.");
            this.putValue("SmallIcon", MainFrame.getIcon("document"));
            this.putValue("MnemonicKey", 38);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = AnnotationDiffGUI.this.diffTable.rowViewToModel(AnnotationDiffGUI.this.diffTable.getSelectedRow());
            boolean bl = AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(AnnotationDiffGUI.this.diffTable.getSelectedColumn()) < 5;
            final Document document = bl ? AnnotationDiffGUI.this.keyDoc : AnnotationDiffGUI.this.resDoc;
            final Annotation annotation = bl ? AnnotationDiffGUI.this.pairings.get(n).getKey() : AnnotationDiffGUI.this.pairings.get(n).getResponse();
            final String string = bl ? AnnotationDiffGUI.this.keySet.getName() : AnnotationDiffGUI.this.resSet.getName();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.getInstance().select(document);
                    Date date = new Date(System.currentTimeMillis() + 1000L);
                    Timer timer = new Timer("Annotation diff show document timer", true);
                    timer.schedule(new TimerTask(){

                        public void run() {
                            ShowDocumentAction.this.showExpressionInDocument(document, annotation, string);
                        }
                    }, date);
                }
            });
        }

        private void showExpressionInDocument(Document document, Annotation annotation, String string) {
            try {
                AbstractDocumentView abstractDocumentView = null;
                for (Resource resource : Gate.getCreoleRegister().getAllInstances("gate.gui.docview.TextualDocumentView")) {
                    if (!((TextualDocumentView)resource).getDocument().getName().equals(document.getName())) continue;
                    abstractDocumentView = (TextualDocumentView)resource;
                    break;
                }
                if (abstractDocumentView != null && abstractDocumentView.getOwner() != null) {
                    abstractDocumentView.getOwner().setRightView(0);
                    try {
                        ((TextualDocumentView)abstractDocumentView).getTextView().scrollRectToVisible(((TextualDocumentView)abstractDocumentView).getTextView().modelToView(annotation.getStartNode().getOffset().intValue()));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                        return;
                    }
                    ((TextualDocumentView)abstractDocumentView).getTextView().select(annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue());
                }
                for (Resource resource : Gate.getCreoleRegister().getAllInstances("gate.gui.docview.AnnotationSetsView")) {
                    AnnotationSetsView annotationSetsView = (AnnotationSetsView)resource;
                    if (annotationSetsView.getDocument() == null || !annotationSetsView.isActive() || !annotationSetsView.getDocument().getName().equals(document.getName())) continue;
                    String string2 = annotation.getType();
                    if (string == null && document.getAnnotations().getAllTypes().contains(string2)) {
                        annotationSetsView.setTypeSelected(null, string2, true);
                        continue;
                    }
                    if (!document.getAnnotationSetNames().contains(string) || !document.getAnnotations(string).getAllTypes().contains(string2)) continue;
                    annotationSetsView.setTypeSelected(string, string2, true);
                }
                AnnotationDiffGUI.this.diffTable.requestFocusInWindow();
            }
            catch (GateException gateException) {
                gateException.printStackTrace();
            }
        }
    }

    protected class HTMLExportAction
    extends AbstractAction {
        static final String HEADER_1 = "<html><head><title>";
        static final String HEADER_2 = "</title></head><body>";
        static final String HEADER_3 = "<table cellpadding=\"0\" border=\"1\">";
        static final String FOOTER = "</table></body></html>";

        public HTMLExportAction() {
            super("Export to HTML");
            this.putValue("ShortDescription", "Export the results to HTML");
            this.putValue("SmallIcon", MainFrame.getIcon("crystal-clear-app-download-manager"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser() != null ? MainFrame.getFileChooser() : new XJFileChooser();
            xJFileChooser.setAcceptAllFileFilterUsed(true);
            xJFileChooser.setDialogTitle("Choose a file to export the results");
            xJFileChooser.setFileSelectionMode(0);
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("HTML files", "html");
            xJFileChooser.addChoosableFileFilter(extensionFileFilter);
            String string = AnnotationDiffGUI.this.resDoc.getSourceUrl() != null ? new File(AnnotationDiffGUI.this.resDoc.getSourceUrl().getFile()).getName() : AnnotationDiffGUI.this.resDoc.getName();
            string = string + "_" + AnnotationDiffGUI.this.annTypeCombo.getSelectedItem().toString() + ".html";
            xJFileChooser.setFileName(string);
            xJFileChooser.setResource(AnnotationDiffGUI.class.getName());
            int n = xJFileChooser.showSaveDialog(AnnotationDiffGUI.this);
            if (n != 0) {
                return;
            }
            File file = xJFileChooser.getSelectedFile();
            try {
                int n2;
                String string2 = Strings.getNl();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write(HEADER_1);
                bufferedWriter.write(AnnotationDiffGUI.this.resDoc.getName() + " " + AnnotationDiffGUI.this.annTypeCombo.getSelectedItem().toString() + " annotations");
                bufferedWriter.write(HEADER_2 + string2);
                bufferedWriter.write("<H2>Annotation Diff - comparing " + AnnotationDiffGUI.this.annTypeCombo.getSelectedItem().toString() + " annotations" + "</H2>");
                bufferedWriter.write("<TABLE cellpadding=\"5\" border=\"0\"");
                bufferedWriter.write(string2);
                bufferedWriter.write("<TR>" + string2);
                bufferedWriter.write("\t<TH align=\"left\">&nbsp;</TH>" + string2);
                bufferedWriter.write("\t<TH align=\"left\">Document</TH>" + string2);
                bufferedWriter.write("\t<TH align=\"left\">Annotation Set</TH>" + string2);
                bufferedWriter.write("</TR>" + string2);
                bufferedWriter.write("<TR>" + string2);
                bufferedWriter.write("\t<TH align=\"left\">Key</TH>" + string2);
                bufferedWriter.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.keyDoc.getName() + "</TD>" + string2);
                bufferedWriter.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.keySet.getName() + "</TD>" + string2);
                bufferedWriter.write("</TR>" + string2);
                bufferedWriter.write("<TR>" + string2);
                bufferedWriter.write("\t<TH align=\"left\">Response</TH>" + string2);
                bufferedWriter.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.resDoc.getName() + "</TD>" + string2);
                bufferedWriter.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.resSet.getName() + "</TD>" + string2);
                bufferedWriter.write("</TR>" + string2);
                bufferedWriter.write("</TABLE>" + string2);
                bufferedWriter.write("<BR><BR><BR>" + string2);
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(4);
                bufferedWriter.write("Recall: " + numberFormat.format(AnnotationDiffGUI.this.differ.getRecallStrict()) + "<br>" + string2);
                bufferedWriter.write("Precision: " + numberFormat.format(AnnotationDiffGUI.this.differ.getPrecisionStrict()) + "<br>" + string2);
                bufferedWriter.write("F-measure: " + numberFormat.format(AnnotationDiffGUI.this.differ.getFMeasureStrict(1.0)) + "<br>" + string2);
                bufferedWriter.write("<br>");
                bufferedWriter.write("Correct: " + AnnotationDiffGUI.this.differ.getCorrectMatches() + "<br>" + string2);
                bufferedWriter.write("Partially correct: " + AnnotationDiffGUI.this.differ.getPartiallyCorrectMatches() + "<br>" + string2);
                bufferedWriter.write("Missing: " + AnnotationDiffGUI.this.differ.getMissing() + "<br>" + string2);
                bufferedWriter.write("False positives: " + AnnotationDiffGUI.this.differ.getSpurious() + "<br>" + string2);
                bufferedWriter.write(HEADER_3 + string2 + "<TR>" + string2);
                int n3 = AnnotationDiffGUI.this.diffTable.getColumnCount() - 1;
                for (n2 = 0; n2 <= n3; ++n2) {
                    bufferedWriter.write("\t<TH align=\"left\">" + AnnotationDiffGUI.this.diffTable.getColumnName(n2) + "</TH>" + string2);
                }
                bufferedWriter.write("</TR>");
                n2 = AnnotationDiffGUI.this.diffTableModel.getRowCount();
                for (int i = 0; i < n2; ++i) {
                    bufferedWriter.write("<TR>");
                    for (int j = 0; j <= n3; ++j) {
                        Color color = AnnotationDiffGUI.this.diffTableModel.getBackgroundAt(AnnotationDiffGUI.this.diffTable.rowViewToModel(i), AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(j));
                        bufferedWriter.write("\t<TD bgcolor=\"#" + Integer.toHexString(color.getRGB()).substring(2) + "\">" + AnnotationDiffGUI.this.diffTable.getValueAt(i, j) + "</TD>" + string2);
                    }
                    bufferedWriter.write("</TR>");
                }
                bufferedWriter.write(FOOTER);
                ((Writer)bufferedWriter).flush();
                ((Writer)bufferedWriter).close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(AnnotationDiffGUI.this, iOException.toString(), "GATE", 0);
                iOException.printStackTrace();
            }
        }
    }

    protected class CopyToTargetSetAction
    extends AbstractAction {
        public CopyToTargetSetAction() {
            super("Copy selection to target set");
            this.putValue("ShortDescription", "<html>Move selected annotations to the target annotation set<br>and hide their paired annotations if not moved.&nbsp;&nbsp;<font color=\"#667799\"><small>Alt-Right</small></font></html>");
            this.putValue("MnemonicKey", 39);
            this.putValue("SmallIcon", MainFrame.getIcon("crystal-clear-action-loopnone"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)AnnotationDiffGUI.this.keyDoc.getFeatures().get("anndiffsteps");
            if (string == null) {
                string = "0";
            }
            AnnotationSet annotationSet = AnnotationDiffGUI.this.keyDoc.getAnnotations(AnnotationDiffGUI.this.consensusASTextField.getText().trim());
            AnnotationSet annotationSet2 = AnnotationDiffGUI.this.keyDoc.getAnnotations((String)AnnotationDiffGUI.this.keySetCombo.getSelectedItem());
            AnnotationSet annotationSet3 = AnnotationDiffGUI.this.resDoc.getAnnotations((String)AnnotationDiffGUI.this.resSetCombo.getSelectedItem());
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < AnnotationDiffGUI.this.pairings.size(); ++i) {
                FeatureMap featureMap;
                Annotation annotation;
                if (AnnotationDiffGUI.this.keyCopyValueRows.get(i).booleanValue()) {
                    annotation = AnnotationDiffGUI.this.pairings.get(i).getKey();
                    annotation.getFeatures().put("anndiffstep", string);
                    featureMap = (FeatureMap)((SimpleFeatureMapImpl)annotation.getFeatures()).clone();
                    featureMap.put("anndiffsource", AnnotationDiffGUI.this.keySetCombo.getSelectedItem());
                    try {
                        annotationSet.add(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), annotation.getType(), featureMap);
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        invalidOffsetException.printStackTrace();
                    }
                    if (annotation.getFeatures().containsKey("anndiffmodified")) {
                        annotationSet2.remove(annotation);
                    }
                    ++n;
                    if (AnnotationDiffGUI.this.pairings.get(i).getResponse() != null && !AnnotationDiffGUI.this.resCopyValueRows.get(i).booleanValue()) {
                        AnnotationDiffGUI.this.pairings.get(i).getResponse().getFeatures().put("anndiffstep", string);
                        ++n2;
                    }
                }
                if (!AnnotationDiffGUI.this.resCopyValueRows.get(i).booleanValue()) continue;
                annotation = AnnotationDiffGUI.this.pairings.get(i).getResponse();
                annotation.getFeatures().put("anndiffstep", string);
                featureMap = (FeatureMap)((SimpleFeatureMapImpl)annotation.getFeatures()).clone();
                featureMap.put("anndiffsource", AnnotationDiffGUI.this.resSetCombo.getSelectedItem());
                try {
                    annotationSet.add(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), annotation.getType(), featureMap);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    invalidOffsetException.printStackTrace();
                }
                if (annotation.getFeatures().containsKey("anndiffmodified")) {
                    annotationSet3.remove(annotation);
                }
                ++n;
                if (AnnotationDiffGUI.this.pairings.get(i).getKey() == null || AnnotationDiffGUI.this.keyCopyValueRows.get(i).booleanValue()) continue;
                AnnotationDiffGUI.this.pairings.get(i).getKey().getFeatures().put("anndiffstep", string);
                ++n2;
            }
            if (n > 0) {
                string = String.valueOf(Integer.valueOf(string) + 1);
                AnnotationDiffGUI.this.keyDoc.getFeatures().put("anndiffsteps", string);
                AnnotationDiffGUI.this.diffAction.actionPerformed(new ActionEvent(this, -1, "copy"));
                AnnotationDiffGUI.this.statusLabel.setText(n + " annotations copied to " + AnnotationDiffGUI.this.consensusASTextField.getText().trim() + " and " + n2 + " hidden");
                AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
            } else {
                AnnotationDiffGUI.this.diffTable.requestFocusInWindow();
                AnnotationDiffGUI.this.statusLabel.setText("Tick checkboxes in the columns K(ey) and R(esponse)");
                AnnotationDiffGUI.this.statusLabel.setForeground(Color.RED);
            }
        }
    }

    protected class DiffAction
    extends AbstractAction {
        public DiffAction() {
            super("Compare");
            this.putValue("ShortDescription", "Compare annotations between key and response sets");
            this.putValue("MnemonicKey", 10);
            this.putValue("SmallIcon", MainFrame.getIcon("crystal-clear-action-run"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final int n = AnnotationDiffGUI.this.diffTable.getSelectedRow();
            final int n2 = AnnotationDiffGUI.this.diffTable.getSelectedColumn();
            final int n3 = actionEvent.getID();
            final String string = actionEvent.getActionCommand();
            AnnotationDiffGUI.this.progressBar.setIndeterminate(true);
            AnnotationDiffGUI.this.statusLabel.setVisible(false);
            AnnotationDiffGUI.this.progressBar.setVisible(true);
            AnnotationDiffGUI.this.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
            Runnable runnable = new Runnable(){

                public void run() {
                    HashSet<Annotation> hashSet = new HashSet<Annotation>(AnnotationDiffGUI.this.keySet.get((String)AnnotationDiffGUI.this.annTypeCombo.getSelectedItem()));
                    HashSet<Annotation> hashSet2 = new HashSet<Annotation>(AnnotationDiffGUI.this.resSet.get((String)AnnotationDiffGUI.this.annTypeCombo.getSelectedItem()));
                    int n4 = 0;
                    for (Annotation object : new ArrayList<Annotation>(hashSet)) {
                        if (!object.getFeatures().containsKey("anndiffstep")) continue;
                        hashSet.remove(object);
                        ++n4;
                    }
                    for (Annotation annotation : new ArrayList<Annotation>(hashSet2)) {
                        if (!annotation.getFeatures().containsKey("anndiffstep")) continue;
                        hashSet2.remove(annotation);
                        ++n4;
                    }
                    if (AnnotationDiffGUI.this.someFeaturesBtn.isSelected()) {
                        AnnotationDiffGUI.this.differ.setSignificantFeaturesSet(AnnotationDiffGUI.this.significantFeatures);
                    } else if (AnnotationDiffGUI.this.allFeaturesBtn.isSelected()) {
                        AnnotationDiffGUI.this.differ.setSignificantFeaturesSet(null);
                    } else {
                        AnnotationDiffGUI.this.differ.setSignificantFeaturesSet(new HashSet());
                    }
                    AnnotationDiffGUI.this.pairings.clear();
                    AnnotationDiffGUI.this.pairings.addAll(AnnotationDiffGUI.this.differ.calculateDiff(hashSet, hashSet2));
                    AnnotationDiffGUI.this.keyCopyValueRows.clear();
                    AnnotationDiffGUI.this.keyCopyValueRows.addAll(Collections.nCopies(AnnotationDiffGUI.this.pairings.size(), false));
                    AnnotationDiffGUI.this.resCopyValueRows.clear();
                    AnnotationDiffGUI.this.resCopyValueRows.addAll(Collections.nCopies(AnnotationDiffGUI.this.pairings.size(), false));
                    if (string.equals("setvalue")) {
                        int n22 = 0;
                        for (AnnotationDiffer.Pairing pairing : AnnotationDiffGUI.this.pairings) {
                            if (pairing.getKey() != null && pairing.getKey().getFeatures().containsKey("anndiffmodified")) {
                                AnnotationDiffGUI.this.keyCopyValueRows.set(n22, true);
                            }
                            if (pairing.getResponse() != null && pairing.getResponse().getFeatures().containsKey("anndiffmodified")) {
                                AnnotationDiffGUI.this.resCopyValueRows.set(n22, true);
                            }
                            ++n22;
                        }
                    }
                    final int n32 = n4;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                            AnnotationDiffGUI.this.correctLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getCorrectMatches()));
                            AnnotationDiffGUI.this.partiallyCorrectLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getPartiallyCorrectMatches()));
                            AnnotationDiffGUI.this.missingLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getMissing()));
                            AnnotationDiffGUI.this.falsePozLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getSpurious()));
                            NumberFormat numberFormat = NumberFormat.getInstance();
                            numberFormat.setMaximumFractionDigits(2);
                            numberFormat.setMinimumFractionDigits(2);
                            AnnotationDiffGUI.this.recallStrictLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getRecallStrict()));
                            AnnotationDiffGUI.this.recallLenientLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getRecallLenient()));
                            AnnotationDiffGUI.this.recallAveLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getRecallAverage()));
                            AnnotationDiffGUI.this.precisionStrictLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getPrecisionStrict()));
                            AnnotationDiffGUI.this.precisionLenientLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getPrecisionLenient()));
                            AnnotationDiffGUI.this.precisionAveLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getPrecisionAverage()));
                            double d = Double.parseDouble(AnnotationDiffGUI.this.weightTxt.getText());
                            AnnotationDiffGUI.this.fmeasureStrictLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getFMeasureStrict(d)));
                            AnnotationDiffGUI.this.fmeasureLenientLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getFMeasureLenient(d)));
                            AnnotationDiffGUI.this.fmeasureAveLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getFMeasureAverage(d)));
                            AnnotationDiffGUI.this.copyToTargetSetAction.setEnabled(AnnotationDiffGUI.this.keyDoc.equals(AnnotationDiffGUI.this.resDoc));
                            if (AnnotationDiffGUI.this.keyDoc.equals(AnnotationDiffGUI.this.resDoc)) {
                                AnnotationDiffGUI.this.copyToConsensusBtn.setToolTipText((String)AnnotationDiffGUI.this.copyToTargetSetAction.getValue("ShortDescription"));
                            } else {
                                AnnotationDiffGUI.this.copyToConsensusBtn.setToolTipText("Key and response document must be the same");
                            }
                            if (!string.equals("setvalue") && !string.equals("copy")) {
                                AnnotationDiffGUI.this.statusLabel.setText(AnnotationDiffGUI.this.pairings.size() + " pairings have been found " + "(" + n32 + " annotations are hidden)");
                                AnnotationDiffGUI.this.statusLabel.setForeground(Color.BLACK);
                            }
                            AnnotationDiffGUI.this.diffTable.requestFocusInWindow();
                            AnnotationDiffGUI.this.progressBar.setIndeterminate(false);
                            AnnotationDiffGUI.this.progressBar.setVisible(false);
                            AnnotationDiffGUI.this.statusLabel.setVisible(true);
                            AnnotationDiffGUI.this.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
                            AnnotationDiffGUI.this.showDocumentAction.setEnabled(false);
                            if (!string.equals("setvalue") && !string.equals("copy")) {
                                return;
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    if (string.equals("setvalue")) {
                                        for (int i = 0; i < AnnotationDiffGUI.this.diffTable.getRowCount(); ++i) {
                                            AnnotationDiffer.Pairing pairing = AnnotationDiffGUI.this.pairings.get(AnnotationDiffGUI.this.diffTable.rowViewToModel(i));
                                            if ((pairing.getKey() == null || pairing.getKey().getId() != n3) && (pairing.getResponse() == null || pairing.getResponse().getId() != n3)) continue;
                                            AnnotationDiffGUI.this.diffTable.changeSelection(i, n2, false, false);
                                            break;
                                        }
                                    } else if (string.equals("copy")) {
                                        AnnotationDiffGUI.this.diffTable.changeSelection(n, n2, false, false);
                                    }
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            AnnotationDiffGUI.this.diffTable.scrollRectToVisible(AnnotationDiffGUI.this.diffTable.getCellRect(AnnotationDiffGUI.this.diffTable.getSelectedRow(), AnnotationDiffGUI.this.diffTable.getSelectedColumn(), true));
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            };
            Thread thread = new Thread(runnable, "DiffAction");
            thread.setPriority(1);
            thread.start();
        }
    }
}

