/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology;

import gate.creole.ontology.DataType;
import gate.creole.ontology.InvalidValueException;
import gate.creole.ontology.OConstants;
import java.util.Locale;

public class Literal {
    private String value;
    private Locale language;
    private DataType dataType;

    public Literal(String string) {
        this.value = string;
        this.language = OConstants.ENGLISH;
        this.dataType = DataType.getStringDataType();
    }

    public Literal(String string, Locale locale) {
        this.value = string;
        this.language = locale;
        this.dataType = DataType.getStringDataType();
    }

    public Literal(String string, DataType dataType) throws InvalidValueException {
        this.value = string;
        this.language = OConstants.ENGLISH;
        this.dataType = dataType;
        if (!dataType.isValidValue(this.value)) {
            throw new InvalidValueException("The value :\"" + this.value + "\" is not compatible with the dataType \"" + dataType.getXmlSchemaURIString() + "\"");
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getValue() {
        return this.value;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public String toString() {
        return this.value;
    }

    public String toTurtle() {
        String string = this.value;
        string = string.replace("\"", "\\\"");
        string = "\"" + string + "\"";
        string = this.dataType.isStringDataType() ? (this.language != null ? string + "@" + this.language : string + "^^<" + this.dataType.getXmlSchemaURIString() + ">") : string + "^^<" + this.dataType.getXmlSchemaURIString() + ">";
        return string;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Literal literal = (Literal)object;
        if (this.value == null && literal.value == null) {
            return true;
        }
        return this.dataType.equals(literal.dataType) && this.language.equals(literal.language) && this.value.equals(literal.value);
    }
}

