/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.morph;

import gate.creole.morph.FSMState;
import gate.creole.morph.Interpret;
import gate.creole.morph.PatternParser;
import gate.creole.morph.PatternPart;
import gate.creole.morph.Storage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;

public class ParsingFunctions {
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int OR_PLUS = 2;
    public static final int AND_PLUS = 3;
    public static final int OR_STAR = 4;
    public static final int AND_STAR = 5;
    public static final short IRREG_STEM = 0;
    public static final short NULL_STEM = 1;
    public static final short SEMIREG_STEM = 2;
    public static final short STEM = 3;

    public static int findVariableType(String string) {
        if (string == null) {
            return -4;
        }
        if (string.length() >= 3 && string.charAt(0) == '\"' && string.lastIndexOf(34) == string.length() - 1) {
            return 0;
        }
        if (string.length() >= 6 && (string.length() - 3) % 3 == 0 && string.substring(0, 2).equals("[-") && string.charAt(string.length() - 1) == ']') {
            return 1;
        }
        if (string.length() >= 3 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            if (string.charAt(1) == '-') {
                return -4;
            }
            return 2;
        }
        return -4;
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isBoolean(String string) {
        return string.equals("false") || string.equals("true");
    }

    public static String[] normlizePattern(String string) {
        ArrayList arrayList = PatternParser.parsePattern(string);
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static PatternPart[] getPatternParts(String string) {
        int n;
        ArrayList<PatternPart> arrayList = new ArrayList<PatternPart>();
        string = string.replaceAll("[\\(]+", "(");
        string = string.replaceAll("[\\)]+", ")");
        string = string.replaceAll("[\\[]+", "[");
        string = string.replaceAll("[\\]]+", "]");
        string = string.replaceAll("(\\()[\\[]+", "[");
        string = string.replaceAll("(\\])[\\)]+", "]");
        while (string.trim().length() != 0) {
            PatternPart patternPart;
            int n2;
            int n3;
            if (string.charAt(0) != '(' && string.charAt(0) != '[') {
                n3 = string.indexOf("(");
                n = string.indexOf("[");
                if (n3 < 0 && n > 0) {
                    n3 = n;
                } else if ((n3 <= 0 || n >= 0) && n3 > n) {
                    n3 = n;
                }
                string = n3 < 0 ? "(" + string + ")" : '(' + string.substring(0, n3) + ")" + string.substring(n3, string.length());
            }
            n3 = 0;
            n = 0;
            int n4 = string.indexOf(40);
            if (n4 >= 0) {
                n3 = 1;
            }
            if ((n2 = string.indexOf(91)) >= 0) {
                if (n3 != 0) {
                    if (n4 < n2) {
                        n = 0;
                    } else {
                        n = 1;
                        n3 = 0;
                        n4 = n2;
                    }
                } else {
                    n4 = n2;
                    n = 1;
                }
            }
            if (n3 == 0 && n == 0) break;
            int n5 = -1;
            if (n3 != 0 && (n5 = string.indexOf(41)) < 0 || n != 0 && (n5 = string.indexOf(93)) < 0) break;
            boolean bl = false;
            boolean bl2 = false;
            if (n5 + 1 < string.length()) {
                boolean bl3 = bl = string.charAt(n5 + 1) == '+';
                if (!bl) {
                    bl2 = string.charAt(n5 + 1) == '*';
                }
            }
            String string2 = string.substring(n4 + 1, n5);
            string2 = string2.replaceAll("\\(", "");
            string2 = string2.replaceAll("\\)", "");
            if (!bl && !bl2 && n != 0) {
                patternPart = new PatternPart(string2, 0);
                arrayList.add(patternPart);
            } else if (!bl && !bl2 && n3 != 0) {
                patternPart = new PatternPart(string2, 1);
                arrayList.add(patternPart);
            } else if (bl && n3 != 0) {
                patternPart = new PatternPart(string2, 3);
                arrayList.add(patternPart);
            } else if (bl && n != 0) {
                patternPart = new PatternPart(string2, 2);
                arrayList.add(patternPart);
            } else if (bl2 && n != 0) {
                patternPart = new PatternPart(string2, 4);
                arrayList.add(patternPart);
            } else {
                patternPart = new PatternPart(string2, 5);
                arrayList.add(patternPart);
            }
            if (bl || bl2) {
                ++n5;
            }
            if (n5 + 1 < string.length()) {
                string = string.substring(n5 + 1, string.length());
                continue;
            }
            string = "";
        }
        PatternPart[] patternPartArray = new PatternPart[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            patternPartArray[n] = (PatternPart)arrayList.get(n);
        }
        return patternPartArray;
    }

    public static String getMethodName(String string) {
        int n = string.indexOf(40);
        String string2 = string.substring(0, n) + "(";
        String[] stringArray = string.substring(n + 1, string.length() - 1).split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("\"") && stringArray[i].endsWith("\"")) {
                string2 = string2 + "java.lang.String";
            } else if (ParsingFunctions.isBoolean(stringArray[i])) {
                string2 = string2 + "boolean";
            } else if (ParsingFunctions.isInteger(stringArray[i])) {
                string2 = string2 + "int";
            }
            if (i + 1 >= stringArray.length) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        return string2;
    }

    public static short getMethodIndex(String string) {
        int n = string.indexOf(40);
        String string2 = string.substring(0, n) + "(";
        String[] stringArray = string.substring(n + 1, string.length() - 1).split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("\"") && stringArray[i].endsWith("\"")) {
                string2 = string2 + "java.lang.String";
            } else if (ParsingFunctions.isBoolean(stringArray[i])) {
                string2 = string2 + "boolean";
            } else if (ParsingFunctions.isInteger(stringArray[i])) {
                string2 = string2 + "int";
            }
            if (i + 1 >= stringArray.length) continue;
            string2 = string2 + ",";
        }
        if ((string2 = string2 + ")").startsWith("irreg_stem")) {
            return 0;
        }
        if (string2.startsWith("null_stem")) {
            return 1;
        }
        if (string2.startsWith("semi_reg_stem")) {
            return 2;
        }
        if (string2.startsWith("stem")) {
            return 3;
        }
        return -1;
    }

    public static String[] getParameterValues(String string) {
        int n = string.indexOf("(");
        String[] stringArray = string.substring(n + 1, string.length() - 1).split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("\"") || !stringArray[i].endsWith("\"")) continue;
            stringArray[i] = stringArray[i].substring(1, stringArray[i].length() - 1).intern();
        }
        return stringArray;
    }

    public static HashSet createFSMs(String string, int n, HashSet hashSet, Interpret interpret) {
        HashSet hashSet2 = new HashSet();
        block7: for (HashSet hashSet3 : hashSet) {
            switch (n) {
                case 0: {
                    hashSet2.addAll(ParsingFunctions.orFSMs(string, hashSet3, interpret));
                    continue block7;
                }
                case 2: {
                    hashSet2.addAll(ParsingFunctions.orPlusFSMs(string, hashSet3, interpret));
                    continue block7;
                }
                case 3: {
                    hashSet2.addAll(ParsingFunctions.andPlusFSMs(string, hashSet3, interpret));
                    continue block7;
                }
                case 4: {
                    hashSet2.addAll(ParsingFunctions.orStarFSMs(string, hashSet3, interpret));
                    continue block7;
                }
                case 5: {
                    hashSet2.addAll(ParsingFunctions.andStarFSMs(string, hashSet3, interpret));
                    continue block7;
                }
            }
            if (string.length() <= 0) continue;
            hashSet2.addAll(ParsingFunctions.andFSMs(string, hashSet3, interpret));
        }
        return hashSet2;
    }

    private static FSMState next(char c, HashSet hashSet) {
        for (FSMState fSMState : hashSet) {
            FSMState fSMState2 = fSMState.next(c, (byte)0);
            if (fSMState2 == null) continue;
            return fSMState2;
        }
        return null;
    }

    private static int getIndex(HashSet hashSet) {
        Iterator iterator = hashSet.iterator();
        if (iterator.hasNext()) {
            FSMState fSMState = (FSMState)iterator.next();
            return fSMState.getIndex();
        }
        return -1;
    }

    public static ArrayList andFSMs(String string, HashSet hashSet, Interpret interpret) {
        FSMState fSMState3;
        int n;
        char c = string.charAt(0);
        FSMState fSMState2 = interpret.getState(c, (n = ParsingFunctions.getIndex(hashSet)) + 1);
        if (fSMState2 == null) {
            fSMState2 = new FSMState(n + 1);
            interpret.addState(c, fSMState2, n + 1);
        }
        for (FSMState fSMState3 : hashSet) {
            fSMState3.put(c, fSMState2, (byte)0);
        }
        fSMState3 = fSMState2;
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            fSMState3 = fSMState2.next(c, (byte)0);
            if (fSMState3 == null) {
                fSMState3 = interpret.getState(c, fSMState2.getIndex() + 1);
                if (fSMState3 == null) {
                    fSMState3 = new FSMState(fSMState2.getIndex() + 1);
                    interpret.addState(c, fSMState3, fSMState2.getIndex() + 1);
                }
                fSMState2.put(c, fSMState3, (byte)0);
            }
            fSMState2 = fSMState3;
        }
        ArrayList arrayList = new ArrayList();
        HashSet<FSMState> hashSet2 = new HashSet<FSMState>();
        hashSet2.add(fSMState3);
        arrayList.add(hashSet2);
        return arrayList;
    }

    public static ArrayList orFSMs(String string, HashSet hashSet, Interpret interpret) {
        HashSet<FSMState> hashSet2 = new HashSet<FSMState>();
        for (int i = 0; i < string.length(); ++i) {
            int n;
            char c = string.charAt(i);
            FSMState fSMState = interpret.getState(c, (n = ParsingFunctions.getIndex(hashSet)) + 1);
            if (fSMState == null) {
                fSMState = new FSMState(n + 1);
                interpret.addState(c, fSMState, n + 1);
            }
            hashSet2.add(fSMState);
            for (FSMState fSMState2 : hashSet) {
                fSMState2.put(c, fSMState, (byte)0);
            }
        }
        ArrayList<HashSet<FSMState>> arrayList = new ArrayList<HashSet<FSMState>>();
        arrayList.add(hashSet2);
        return arrayList;
    }

    public static ArrayList orPlusFSMs(String string, HashSet hashSet, Interpret interpret) {
        FSMState fSMState;
        int n;
        int n2;
        ArrayList<FSMState> arrayList = new ArrayList<FSMState>();
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            fSMState = interpret.getState(c, (n = ParsingFunctions.getIndex(hashSet)) + 1);
            if (fSMState == null) {
                fSMState = new FSMState(n + 1);
                interpret.addState(c, fSMState, n + 1);
            }
            arrayList.add(fSMState);
            for (FSMState fSMState2 : hashSet) {
                fSMState2.put(c, fSMState, (byte)0);
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            FSMState fSMState3 = (FSMState)arrayList.get(n2);
            for (n = 0; n < arrayList.size(); ++n) {
                fSMState = (FSMState)arrayList.get(n);
                char c = string.charAt(n);
                fSMState3.put(c, fSMState, (byte)1);
            }
        }
        HashSet<FSMState> hashSet2 = new HashSet<FSMState>();
        hashSet2.addAll(arrayList);
        ArrayList<HashSet<FSMState>> arrayList2 = new ArrayList<HashSet<FSMState>>();
        arrayList2.add(hashSet2);
        return arrayList2;
    }

    public static ArrayList andPlusFSMs(String string, HashSet hashSet, Interpret interpret) {
        FSMState fSMState4;
        int n;
        char c = string.charAt(0);
        FSMState fSMState2 = interpret.getState(c, (n = ParsingFunctions.getIndex(hashSet)) + 1);
        if (fSMState2 == null) {
            fSMState2 = new FSMState(n + 1);
            interpret.addState(c, fSMState2, n + 1);
        }
        FSMState fSMState3 = fSMState2;
        for (FSMState fSMState4 : hashSet) {
            fSMState4.put(c, fSMState2, (byte)0);
        }
        fSMState4 = fSMState2;
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            fSMState4 = fSMState2.next(c, (byte)0);
            if (fSMState4 == null) {
                fSMState4 = interpret.getState(c, fSMState2.getIndex() + 1);
                if (fSMState4 == null) {
                    fSMState4 = new FSMState(fSMState2.getIndex() + 1);
                    interpret.addState(c, fSMState4, fSMState2.getIndex() + 1);
                }
                fSMState2.put(c, fSMState4, (byte)0);
            }
            fSMState2 = fSMState4;
        }
        fSMState4.put(string.charAt(0), fSMState3, (byte)1);
        ArrayList arrayList = new ArrayList();
        HashSet<FSMState> hashSet2 = new HashSet<FSMState>();
        hashSet2.add(fSMState4);
        arrayList.add(hashSet2);
        return arrayList;
    }

    public static ArrayList orStarFSMs(String string, HashSet hashSet, Interpret interpret) {
        FSMState fSMState;
        int n;
        int n2;
        ArrayList<FSMState> arrayList = new ArrayList<FSMState>();
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            fSMState = interpret.getState(c, (n = ParsingFunctions.getIndex(hashSet)) + 1);
            if (fSMState == null) {
                fSMState = new FSMState(n + 1);
                interpret.addState(c, fSMState, n + 1);
            }
            arrayList.add(fSMState);
            for (FSMState fSMState2 : hashSet) {
                fSMState2.put(c, fSMState, (byte)0);
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            FSMState fSMState3 = (FSMState)arrayList.get(n2);
            for (n = 0; n < arrayList.size(); ++n) {
                fSMState = (FSMState)arrayList.get(n);
                char c = string.charAt(n);
                fSMState3.put(c, fSMState, (byte)1);
            }
        }
        HashSet<FSMState> hashSet2 = new HashSet<FSMState>();
        hashSet2.addAll(arrayList);
        ArrayList<HashSet> arrayList2 = new ArrayList<HashSet>();
        arrayList2.add(hashSet2);
        arrayList2.add(hashSet);
        return arrayList2;
    }

    public static ArrayList andStarFSMs(String string, HashSet hashSet, Interpret interpret) {
        FSMState fSMState4;
        int n;
        char c = string.charAt(0);
        FSMState fSMState2 = interpret.getState(c, (n = ParsingFunctions.getIndex(hashSet)) + 1);
        if (fSMState2 == null) {
            fSMState2 = new FSMState(n + 1);
            interpret.addState(c, fSMState2, n + 1);
        }
        FSMState fSMState3 = fSMState2;
        for (FSMState fSMState4 : hashSet) {
            fSMState4.put(c, fSMState2, (byte)0);
        }
        fSMState4 = fSMState2;
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            fSMState4 = fSMState2.next(c, (byte)0);
            if (fSMState4 == null) {
                fSMState4 = interpret.getState(c, fSMState2.getIndex() + 1);
                if (fSMState4 == null) {
                    fSMState4 = new FSMState(fSMState2.getIndex() + 1);
                    interpret.addState(c, fSMState4, fSMState2.getIndex() + 1);
                }
                fSMState2.put(c, fSMState4, (byte)0);
            }
            fSMState2 = fSMState4;
        }
        fSMState4.put(string.charAt(0), fSMState3, (byte)1);
        ArrayList<HashSet> arrayList = new ArrayList<HashSet>();
        HashSet<FSMState> hashSet2 = new HashSet<FSMState>();
        hashSet2.add(fSMState4);
        arrayList.add(hashSet2);
        arrayList.add(hashSet);
        return arrayList;
    }

    public static String convertToRegExp(String string, Storage storage) {
        int n;
        int n2;
        string = string.replaceAll("( OR )", "|");
        string = string.replaceAll("(\\[\\-)", "[");
        StringBuffer stringBuffer = new StringBuffer(string);
        Stack<String> stack = new Stack<String>();
        Stack<Integer> stack2 = new Stack<Integer>();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '{') {
                stack.add("{");
                stack2.add(new Integer(i));
                continue;
            }
            if (stringBuffer.charAt(i) == '(') {
                stack.add("(");
                stack2.add(new Integer(i));
                continue;
            }
            if (stringBuffer.charAt(i) == '[') {
                stack.add("[");
                stack2.add(new Integer(i));
                continue;
            }
            if (stringBuffer.charAt(i) == '\"') {
                if (stack.isEmpty() || !((String)stack.get(stack.size() - 1)).equals("\"")) {
                    stack.add("\"");
                    stack2.add(new Integer(i));
                    continue;
                }
                stack.pop();
                n2 = (Integer)stack2.pop();
                stringBuffer.setCharAt(n2, '(');
                stringBuffer.setCharAt(i, ')');
                continue;
            }
            if (stringBuffer.charAt(i) == '}') {
                String string2 = (String)stack.pop();
                n = (Integer)stack2.pop();
                if (!string2.equals("{")) {
                    return null;
                }
                if (ParsingFunctions.isInteger(stringBuffer.substring(n + 1, i))) continue;
                stringBuffer.setCharAt(n, '(');
                stringBuffer.setCharAt(i, ')');
                continue;
            }
            if (stringBuffer.charAt(i) == ')') {
                String string3 = (String)stack.pop();
                stack2.pop();
                if (string3.equals("(")) continue;
                return null;
            }
            if (stringBuffer.charAt(i) != ']') continue;
            String string4 = (String)stack.pop();
            stack2.pop();
            if (string4.equals("[")) continue;
            return null;
        }
        if (!stack.empty() || !stack2.empty()) {
            return null;
        }
        String[] stringArray = storage.getVarNames();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            n = -1;
            String string5 = "{[()]} ";
            while ((n = stringBuffer.indexOf(stringArray[n2], n + 1)) != -1) {
                if (n > 0 && string5.indexOf(stringBuffer.charAt(n - 1)) == -1) {
                    n = n + stringArray[n2].length() - 1;
                    continue;
                }
                if (stringArray[n2].length() + n < stringBuffer.length() && string5.indexOf(stringBuffer.charAt(stringArray[n2].length() + n)) == -1) {
                    n = n + stringArray[n2].length() - 1;
                    continue;
                }
                String string6 = "(" + storage.get(stringArray[n2]) + ")";
                stringBuffer.replace(n, stringArray[n2].length() + n, string6);
                n += string6.length();
            }
        }
        return new String(stringBuffer);
    }
}

