/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.ProcessingResource;
import gate.Resource;
import gate.corpora.DocumentImpl;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.gazetteer.NodePosition;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FlexibleGazetteer
extends AbstractLanguageAnalyser
implements ProcessingResource {
    private Document document;
    private String outputAnnotationSetName;
    private String inputAnnotationSetName;
    private Gazetteer gazetteerInst;
    private List inputFeatureNames;
    private ArrayList changedNodes = new ArrayList();

    public Resource init() throws ResourceInstantiationException {
        if (this.gazetteerInst == null) {
            throw new ResourceInstantiationException("No Gazetteer Provided!");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws ExecutionException {
        Object object;
        long l;
        long l2;
        Object object2;
        Object object3;
        long l3;
        Object object4;
        this.changedNodes = new ArrayList();
        this.fireProgressChanged(0);
        this.fireStatusChanged("Checking Document...");
        if (this.document == null) {
            throw new ExecutionException("No document to process!");
        }
        this.fireStatusChanged("Creating temporary Document...");
        StringBuffer stringBuffer = new StringBuffer(this.document.getContent().toString());
        Document document = null;
        boolean bl = false;
        if (this.inputFeatureNames == null || this.inputFeatureNames.size() == 0) {
            this.inputFeatureNames = new ArrayList();
        }
        Iterator iterator = this.getSortedAnnotationIterator(this.document, this.inputAnnotationSetName);
        long l4 = 0L;
        this.fireStatusChanged("Replacing contents with the feature value...");
        block6: while (iterator != null && iterator.hasNext()) {
            object4 = (Annotation)iterator.next();
            if (object4.getType().equals("SpaceToken") && ((String)object4.getFeatures().get("kind")).equals("ChineseSplit")) {
                long l5 = object4.getStartNode().getOffset();
                long l6 = l5 - l4;
                l3 = l6 + 1L;
                NodePosition nodePosition = new NodePosition(l5, l5, l6, l3, l4);
                bl = true;
                --l4;
                this.changedNodes.add(nodePosition);
                stringBuffer = stringBuffer.insert((int)l6, ' ');
                continue;
            }
            for (int i = 0; i < this.inputFeatureNames.size(); ++i) {
                FeatureMap featureMap;
                object3 = ((String)this.inputFeatureNames.get(i)).split("[.]");
                if (((String[])object3).length != 2 || !object4.getType().equals(object3[0]) || (object2 = (String)(featureMap = object4.getFeatures()).get(object3[1])) == null) continue;
                l3 = object4.getStartNode().getOffset();
                long l7 = object4.getEndNode().getOffset();
                long l8 = l7 - l3;
                l2 = l8 - (long)((String)object2).length();
                l = l3 - l4;
                long l9 = l + (long)((String)object2).length();
                NodePosition nodePosition = new NodePosition(l3, l7, l, l9, l4 += l2);
                this.changedNodes.add(nodePosition);
                stringBuffer = stringBuffer.replace((int)l, (int)l + (int)l8, (String)object2);
                continue block6;
            }
        }
        this.fireStatusChanged("New Document to be processed with Gazetteer...");
        try {
            object4 = Factory.newFeatureMap();
            object4.put("stringContent", stringBuffer.toString());
            if (this.document instanceof DocumentImpl) {
                object4.put("encoding", ((DocumentImpl)this.document).getEncoding());
                object4.put("markupAware", ((DocumentImpl)this.document).getMarkupAware());
            }
            object = Factory.newFeatureMap();
            document = (Document)Factory.createResource("gate.corpora.DocumentImpl", (FeatureMap)object4, (FeatureMap)object);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new ExecutionException("Temporary document cannot be created");
        }
        object4 = Factory.newFeatureMap();
        this.gazetteerInst.setDocument(document);
        this.gazetteerInst.setAnnotationSetName(this.outputAnnotationSetName);
        this.fireStatusChanged("Executing Gazetteer...");
        try {
            this.gazetteerInst.execute();
            Object var26_29 = null;
        }
        catch (Throwable throwable) {
            Object var26_30 = null;
            this.gazetteerInst.setDocument(null);
            throw throwable;
        }
        this.gazetteerInst.setDocument(null);
        this.fireStatusChanged("Transfering new tags to the original one...");
        object = this.getSortedAnnotationIterator(document, this.outputAnnotationSetName);
        object3 = this.outputAnnotationSetName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.outputAnnotationSetName);
        int n = 0;
        while (object != null && object.hasNext()) {
            NodePosition nodePosition;
            NodePosition nodePosition2;
            object2 = (Annotation)object.next();
            l3 = object2.getStartNode().getOffset();
            long l10 = object2.getEndNode().getOffset();
            NodePosition nodePosition3 = null;
            int n2 = n;
            while (n2 < this.changedNodes.size() && (nodePosition2 = (NodePosition)this.changedNodes.get(n2)).getNewStartNode() < l3) {
                n = n2++;
                nodePosition3 = nodePosition2;
            }
            l2 = nodePosition3 != null ? nodePosition3.getDeductedSpaces() : 0L;
            nodePosition3 = null;
            while (n2 < this.changedNodes.size() && (nodePosition = (NodePosition)this.changedNodes.get(n2)).getNewStartNode() <= l10) {
                nodePosition3 = nodePosition;
                ++n2;
            }
            l = nodePosition3 != null ? nodePosition3.getDeductedSpaces() : l2;
            try {
                object3.add(new Long(l3 + l2), new Long(l10 + l), object2.getType(), object2.getFeatures());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new ExecutionException(invalidOffsetException);
            }
        }
        Factory.deleteResource(document);
        this.fireProcessFinished();
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setOutputAnnotationSetName(String string) {
        this.outputAnnotationSetName = string;
    }

    public String getOutputAnnotationSetName() {
        return this.outputAnnotationSetName;
    }

    public void setInputAnnotationSetName(String string) {
        this.inputAnnotationSetName = string;
    }

    public String getInputAnnotationSetName() {
        return this.inputAnnotationSetName;
    }

    public void setInputFeatureNames(List list) {
        this.inputFeatureNames = list;
    }

    public List getInputFeatureNames() {
        return this.inputFeatureNames;
    }

    public Gazetteer getGazetteerInst() {
        return this.gazetteerInst;
    }

    public void setGazetteerInst(Gazetteer gazetteer) {
        this.gazetteerInst = gazetteer;
    }

    public Iterator getSortedAnnotationIterator(Document document, String string) {
        AnnotationSet annotationSet = string == null ? document.getAnnotations() : document.getAnnotations(string);
        AnnotationSet annotationSet2 = annotationSet.get();
        if (annotationSet2 == null) {
            return null;
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet.get());
        if (arrayList == null) {
            return null;
        }
        OffsetComparator offsetComparator = new OffsetComparator();
        Collections.sort(arrayList, offsetComparator);
        ListIterator listIterator = arrayList.listIterator();
        return listIterator;
    }
}

