/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.dumpingPR;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.corpora.DocumentImpl;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DumpingPR
extends AbstractLanguageAnalyser
implements ProcessingResource {
    public static final String DPR_DOCUMENT_PARAMETER_NAME = "document";
    public static final String DPR_ANN_SET_PARAMETER_NAME = "annotationSetName";
    public static final String DPR_ANN_TYPES_PARAMETER_NAME = "annotationTypes";
    public static final String DPR_DUMP_TYPES_PARAMETER_NAME = "dumpTypes";
    public static final String DPR_OUTPUT_URL_PARAMETER_NAME = "outputDirectoryUrl";
    public static final String DPR_INCLUDE_FEAT_PARAMETER_NAME = "includeFeatures";
    public static final String DPR_USE_SUFFIX_PARAMETER_NAME = "useSuffixForDumpFiles";
    public static final String DPR_FILE_SUFFIX_PARAMETER_NAME = "suffixForDumpFiles";
    private static final boolean DEBUG = true;
    protected List annotationTypes;
    protected List dumpTypes;
    protected String annotationSetName;
    protected boolean includeFeatures = false;
    protected boolean useStandOffXML = false;
    protected String suffixForDumpFiles = ".gate";
    protected boolean useSuffixForDumpFiles = true;
    protected URL outputDirectoryUrl;
    private static final String DUMPING_PR_SET = "DumpingPRTempSet";

    public Resource init() throws ResourceInstantiationException {
        return super.init();
    }

    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    public void execute() throws ExecutionException {
        if (this.document == null) {
            throw new GateRuntimeException("No document to process!");
        }
        if (this.useStandOffXML) {
            this.write2File();
            return;
        }
        AnnotationSet annotationSet = this.annotationSetName == null || this.annotationSetName.equals("") ? this.document.getAnnotations() : this.document.getAnnotations(this.annotationSetName);
        if (annotationSet == null || annotationSet.isEmpty()) {
            Out.prln("DumpingPR Warning: No annotations found for export. Including only those from the Original markups set.");
            this.write2File(null);
            return;
        }
        if (this.useStandOffXML) {
            this.write2File();
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(this.annotationTypes);
        AnnotationSet annotationSet2 = annotationSet.get(hashSet);
        if (this.dumpTypes != null && !this.dumpTypes.isEmpty()) {
            HashMap hashMap = new HashMap();
            for (int i = 0; i < this.dumpTypes.size() && i < this.annotationTypes.size(); ++i) {
                hashMap.put(this.annotationTypes.get(i), this.dumpTypes.get(i));
            }
            if (!hashMap.isEmpty() && annotationSet2 != null) {
                annotationSet2 = this.renameAnnotations(annotationSet2, hashMap);
            }
        }
        this.write2File(annotationSet2);
        this.document.removeAnnotationSet(DUMPING_PR_SET);
    }

    protected void write2File(AnnotationSet annotationSet) {
        String string = null;
        string = this.document.getSourceUrl() == null ? this.document.getName() + "_" + Gate.genSym() : this.getFileName(this.document.getSourceUrl());
        string = this.getNewFileName(this.outputDirectoryUrl, string);
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.useSuffixForDumpFiles) {
            stringBuffer.append(this.suffixForDumpFiles);
        }
        String string2 = stringBuffer.toString();
        Out.prln(string2);
        File file = new File(string2);
        try {
            String string3;
            OutputStreamWriter outputStreamWriter = this.document instanceof DocumentImpl ? ((string3 = ((DocumentImpl)this.document).getEncoding()) == null || "".equals(string3) ? new OutputStreamWriter(new FileOutputStream(file)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), string3)) : new OutputStreamWriter(new FileOutputStream(file));
            outputStreamWriter.write(this.document.toXml(annotationSet, this.includeFeatures));
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new GateRuntimeException("Dumping PR: Error writing document " + this.document.getName() + ": " + iOException.getMessage());
        }
    }

    protected void write2File() {
        String string = null;
        string = this.document.getSourceUrl() == null ? this.document.getName() + "_" + Gate.genSym() : this.getFileName(this.document.getSourceUrl());
        string = this.getNewFileName(this.outputDirectoryUrl, string);
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.useSuffixForDumpFiles) {
            stringBuffer.append(this.suffixForDumpFiles);
        }
        String string2 = stringBuffer.toString();
        Out.prln(string2);
        File file = new File(string2);
        try {
            String string3;
            OutputStreamWriter outputStreamWriter = this.document instanceof DocumentImpl ? ((string3 = ((DocumentImpl)this.document).getEncoding()) == null || "".equals(string3) ? new OutputStreamWriter(new FileOutputStream(file)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), string3)) : new OutputStreamWriter(new FileOutputStream(file));
            outputStreamWriter.write(this.document.toXml());
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new GateRuntimeException("Dumping PR: Error writing document " + this.document.getName() + ": " + iOException.getMessage());
        }
    }

    protected String getFileName(URL uRL) {
        String string = uRL.getFile();
        int n = string.lastIndexOf("/");
        if (n == -1) {
            n = string.lastIndexOf("\\");
        }
        if (n == -1) {
            return string;
        }
        if (n + 1 == string.length()) {
            n = (string = string.substring(0, string.length() - 1)).lastIndexOf("/");
            if (n == -1) {
                n = string.lastIndexOf("\\");
            }
            if (n == -1) {
                return string;
            }
        }
        string = string.substring(n + 1, string.length());
        return string;
    }

    protected String getNewFileName(URL uRL, String string) {
        return new File(uRL == null ? new File(System.getProperty("java.io.tmpdir")) : Files.fileFromURL(uRL), string).getAbsolutePath();
    }

    protected AnnotationSet renameAnnotations(AnnotationSet annotationSet, HashMap hashMap) {
        Iterator<Annotation> iterator = annotationSet.iterator();
        AnnotationSet annotationSet2 = this.document.getAnnotations(DUMPING_PR_SET);
        if (!annotationSet2.isEmpty()) {
            annotationSet2.clear();
        }
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            if (!hashMap.containsKey(annotation.getType())) {
                hashMap.put(annotation.getType(), annotation.getType());
            }
            try {
                annotationSet2.add(annotation.getId(), annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), (String)hashMap.get(annotation.getType()), annotation.getFeatures());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException("DumpingPR: " + invalidOffsetException.getMessage());
            }
        }
        return annotationSet2;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public void setAnnotationSetName(String string) {
        this.annotationSetName = string;
    }

    public List getAnnotationTypes() {
        return this.annotationTypes;
    }

    public void setAnnotationTypes(List list) {
        this.annotationTypes = list;
    }

    public List getDumpTypes() {
        return this.dumpTypes;
    }

    public void setDumpTypes(List list) {
        this.dumpTypes = list;
    }

    public URL getOutputDirectoryUrl() {
        return this.outputDirectoryUrl;
    }

    public void setOutputDirectoryUrl(URL uRL) {
        this.outputDirectoryUrl = uRL;
    }

    public void setIncludeFeatures(Boolean bl) {
        if (bl != null) {
            this.includeFeatures = bl;
        }
    }

    public Boolean getIncludeFeatures() {
        return new Boolean(this.includeFeatures);
    }

    public void setUseStandOffXML(Boolean bl) {
        if (bl != null) {
            this.useStandOffXML = bl;
        }
    }

    public Boolean getUseStandOffXML() {
        return new Boolean(this.useStandOffXML);
    }

    public String getSuffixForDumpFiles() {
        return this.suffixForDumpFiles;
    }

    public void setSuffixForDumpFiles(String string) {
        this.suffixForDumpFiles = string;
    }

    public Boolean getUseSuffixForDumpFiles() {
        return new Boolean(this.useSuffixForDumpFiles);
    }

    public void setUseSuffixForDumpFiles(Boolean bl) {
        if (bl != null) {
            this.useSuffixForDumpFiles = bl;
        }
    }
}

