/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.test;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.annic.Hit;
import gate.creole.annic.Parser;
import gate.creole.annic.lucene.LuceneSearcher;
import gate.creole.annic.test.AnnicIndexing;
import gate.creole.splitter.SentenceSplitter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAnnic
extends TestCase {
    private Corpus testCorpus;
    private File annicHome;
    private File indexURL;

    public TestAnnic(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.indexURL = new File(File.createTempFile("abc", "abc").getParentFile(), "test-index");
        if (!this.indexURL.exists() || !this.indexURL.isDirectory()) {
            this.indexURL.mkdir();
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAnnicIndexing() throws Exception {
        Resource resource;
        this.testCorpus = Factory.newCorpus("TestAnnic");
        File file = new File(new File(new File(new File(new File(new File(Gate.getGateHome(), "src"), "gate"), "resources"), "gate.ac.uk"), "tests"), "annic");
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            resource = Factory.newDocument(fileArray[i].toURI().toURL(), "ISO-8859-1");
            this.testCorpus.add(resource);
        }
        AnnicIndexing annicIndexing = new AnnicIndexing();
        resource = (SentenceSplitter)Factory.createResource("gate.creole.splitter.SentenceSplitter");
        ((SentenceSplitter)resource).setInputASName("Key");
        ((SentenceSplitter)resource).setOutputASName("Key");
        for (int i = 0; i < this.testCorpus.size(); ++i) {
            ((AbstractLanguageAnalyser)resource).setDocument((Document)this.testCorpus.get(i));
            ((SentenceSplitter)resource).execute();
        }
        annicIndexing.setAnnotationSetName("Key");
        annicIndexing.setBaseTokenAnnotationType("Token");
        annicIndexing.setCorpus(this.testCorpus);
        annicIndexing.setIndexUnitAnnotationType("Sentence");
        annicIndexing.setIndexOutputDirectoryLocation(this.indexURL.toURI().toURL());
        annicIndexing.execute();
        Factory.deleteResource(this.testCorpus);
    }

    public void testSearcher() throws Exception {
        LuceneSearcher luceneSearcher = new LuceneSearcher();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.indexURL.getAbsolutePath());
        hashMap.put("INDEX_LOCATIONS", arrayList);
        hashMap.put("CONTEXT_WINDOW", new Integer(5));
        String string = "{Person}";
        boolean bl = luceneSearcher.search(string, hashMap);
        int n = luceneSearcher.next(-1).length;
        TestAnnic.assertEquals((int)12, (int)n);
        string = "{Organization}({Token})*3{Person}";
        bl = luceneSearcher.search(string, hashMap);
        n = luceneSearcher.next(-1).length;
        TestAnnic.assertEquals((int)n, (int)0);
        string = "{Organization}({Token})*3 (\"up\" | \"down\") ({Token})*3 ({Money} | {Percent})";
        bl = luceneSearcher.search(string, hashMap);
        Hit[] hitArray = luceneSearcher.next(-1);
        TestAnnic.assertEquals((int)hitArray.length, (int)0);
        String string2 = Parser.toXML(hitArray);
        hitArray = Parser.fromXML(string2);
        string2 = Parser.toXML(hitArray);
    }

    public static Test suite() {
        return new TestSuite(TestAnnic.class);
    }
}

