/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.BooleanQuery;
import gate.creole.annic.apache.lucene.search.PhraseQuery;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.TermQuery;
import gate.creole.annic.lucene.SubQueryParser;
import gate.creole.ir.SearchException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParser {
    private ArrayList queries = new ArrayList();
    private String field = "";
    private String baseTokenAnnotationType = "Token";
    private boolean needValidation = true;
    public int position = 0;
    boolean areAllTermsTokens = false;

    public static void main(String[] stringArray) {
        System.out.println(QueryParser.isValidQuery(stringArray[0]));
    }

    public static boolean isValidQuery(String string) {
        QueryParser queryParser = new QueryParser();
        try {
            queryParser.parse("contents", string, "Token", null, null);
        }
        catch (SearchException searchException) {
            return false;
        }
        return true;
    }

    public Query[] parse(String string, String string2, String string3, String string4, String string5) throws SearchException {
        this.field = string;
        this.baseTokenAnnotationType = string3;
        this.position = 0;
        this.queries = SubQueryParser.parseQuery(string2);
        Query[] queryArray = new Query[this.queries.size()];
        for (int i = 0; i < this.queries.size(); ++i) {
            TermQuery termQuery;
            Term term;
            BooleanQuery booleanQuery;
            Query query = this.createPhraseQuery((String)this.queries.get(i));
            if (string4 == null && string5 == null) {
                booleanQuery = new BooleanQuery();
                term = new Term("ANNOTATION_SET_ID", "Combined sets");
                termQuery = new TermQuery(term);
                booleanQuery.add(termQuery, false, true);
                booleanQuery.add(query, true, false);
                queryArray[i] = booleanQuery;
                continue;
            }
            booleanQuery = new BooleanQuery();
            booleanQuery.add(query, true, false);
            if (string4 != null) {
                term = new Term("CORPUS_ID", string4);
                termQuery = new TermQuery(term);
                booleanQuery.add(termQuery, true, false);
            }
            if (string5 != null) {
                term = new Term("ANNOTATION_SET_ID", string5);
                termQuery = new TermQuery(term);
                booleanQuery.add(termQuery, true, false);
            } else {
                term = new Term("ANNOTATION_SET_ID", "Combined sets");
                termQuery = new TermQuery(term);
                booleanQuery.add(termQuery, false, true);
            }
            queryArray[i] = booleanQuery;
        }
        return queryArray;
    }

    public String getQueryString(int n) {
        return (String)this.queries.get(n);
    }

    private Query createPhraseQuery(String string) throws SearchException {
        this.position = 0;
        PhraseQuery phraseQuery = new PhraseQuery();
        List<String> list = this.findTokens(string);
        if (list.size() == 1) {
            ArrayList[] arrayListArray = this.createTerms(list.get(0));
            ArrayList arrayList = arrayListArray[0];
            if (arrayList.size() == 1) {
                this.needValidation = !this.areAllTermsTokens;
                return new TermQuery((Term)arrayList.get(0));
            }
            this.position = 0;
        }
        int n = 0;
        boolean bl = true;
        this.needValidation = false;
        for (int i = 0; i < list.size(); ++i) {
            Term term;
            int n2;
            ArrayList[] arrayListArray = this.createTerms(list.get(i));
            ArrayList arrayList = arrayListArray[0];
            ArrayList arrayList2 = arrayListArray[1];
            ArrayList arrayList3 = arrayListArray[2];
            boolean bl2 = true;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                term = (Term)arrayList.get(n2);
                if (!bl2) continue;
                bl2 = this.isBaseTokenTerm(term);
            }
            if (!bl) {
                this.needValidation = true;
                break;
            }
            if (!bl2) {
                this.needValidation = true;
                if (i > 0) break;
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                term = (Term)arrayList.get(n2);
                boolean bl3 = (Boolean)arrayList3.get(n2);
                phraseQuery.add(term, (Integer)arrayList2.get(n2), bl3);
                if (!bl3) continue;
                ++n;
            }
            bl = bl2;
        }
        phraseQuery.setTotalTerms(n);
        return phraseQuery;
    }

    private boolean isBaseTokenTerm(Term term) {
        if (term.text().equals(this.baseTokenAnnotationType) && term.type().equals("*")) {
            return true;
        }
        return term.type().startsWith(this.baseTokenAnnotationType + ".");
    }

    public List<String> findTokens(String string) throws SearchException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        char c = ' ';
        char c2 = ' ';
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            c2 = c;
            c = string.charAt(i);
            if (this.isOpeneningBrace(c, c2)) {
                if (n != 0) {
                    throw new SearchException("unbalanced braces", "a closing brace (}) is missing before this opening brace", string, i);
                }
                if (!string2.trim().equals("")) {
                    arrayList.add(string2.trim());
                }
                ++n;
                string2 = "{";
                continue;
            }
            if (this.isClosingBrace(c, c2)) {
                if (--n != 0) {
                    throw new SearchException("unbalanced braces", "an opening brace ({) is missing before this closing brace", string, i);
                }
                string2 = string2 + "}";
                arrayList.add(string2.trim());
                string2 = "";
                continue;
            }
            string2 = string2 + c;
        }
        if (n != 0) {
            if (n > 0) {
                throw new SearchException("unbalanced braces", "One closing brace (}) is missing in this expression", string);
            }
            throw new SearchException("unbalanced braces", "One opening brace ({) is missing in this expression", string);
        }
        if (!string2.trim().equals("")) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private boolean isOpeneningBrace(char c, char c2) {
        return c == '{' && c2 != '\\';
    }

    private boolean isClosingBrace(char c, char c2) {
        return c == '}' && c2 != '\\';
    }

    private boolean isEscapeSequence(String string, int n) {
        if (n > 0) {
            return string.charAt(n - 1) == '\\';
        }
        return false;
    }

    private ArrayList splitString(String string, char c, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (i == 0) {
                stringBuffer.append(string.charAt(0));
                continue;
            }
            if (string.charAt(i) == c) {
                if (string.charAt(i - 1) == '\\') {
                    stringBuffer.append(c);
                    continue;
                }
                if (bl) {
                    arrayList.add(this.norm(stringBuffer.toString()));
                } else {
                    arrayList.add(stringBuffer.toString());
                }
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        if (stringBuffer.length() > 0) {
            if (bl) {
                arrayList.add(this.norm(stringBuffer.toString()).trim());
            } else {
                arrayList.add(stringBuffer.toString().trim());
            }
        }
        return arrayList;
    }

    private int findIndexOf(String string, char c) {
        int n = -1;
        int n2 = -1;
        while (this.isEscapeSequence(string, n = string.indexOf(c, n2))) {
            n2 = n + 1;
        }
        return n;
    }

    private String norm(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\' && i + 1 <= string.length() - 1) {
                char c = string.charAt(i + 1);
                if (c == ',' || c == '.' || c == '(' || c == ')' || c == '{' || c == '}' || c != '\"') continue;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public ArrayList[] createTerms(String string) throws SearchException {
        ArrayList<Boolean> arrayList;
        ArrayList<Integer> arrayList2;
        ArrayList<Term> arrayList3;
        block35: {
            block33: {
                int n;
                int n2;
                int n3;
                block36: {
                    block34: {
                        this.areAllTermsTokens = true;
                        arrayList3 = new ArrayList<Term>();
                        arrayList2 = new ArrayList<Integer>();
                        arrayList = new ArrayList<Boolean>();
                        if ((string = string.trim()).charAt(0) != '{' || string.charAt(string.length() - 1) != '}') break block33;
                        string = string.substring(1, string.length() - 1);
                        n3 = string.indexOf("==");
                        n2 = this.findIndexOf(string, '.');
                        if (n3 != -1 || n2 != -1) break block34;
                        ArrayList arrayList4 = this.splitString(string, ',', true);
                        for (int i = 0; i < arrayList4.size(); ++i) {
                            if (this.areAllTermsTokens && !((String)arrayList4.get(i)).equals(this.baseTokenAnnotationType)) {
                                this.areAllTermsTokens = false;
                            }
                            arrayList3.add(new Term(this.field, this.norm((String)arrayList4.get(i)), "*"));
                            arrayList2.add(new Integer(this.position));
                            if (i == 0) {
                                arrayList.add(new Boolean(true));
                                continue;
                            }
                            arrayList.add(new Boolean(false));
                        }
                        ++this.position;
                        break block35;
                    }
                    if (n3 == -1 || n2 != -1) break block36;
                    ArrayList arrayList5 = this.splitString(string, ',', false);
                    for (int i = 0; i < arrayList5.size(); ++i) {
                        n3 = ((String)arrayList5.get(i)).indexOf("==");
                        if (n3 != -1) {
                            String string2 = this.norm(((String)arrayList5.get(i)).substring(0, n3).trim());
                            String string3 = this.norm(((String)arrayList5.get(i)).substring(n3 + 2, ((String)arrayList5.get(i)).length()).trim());
                            if (string3.length() > 2 && string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                                string3 = string3.substring(1, string3.length() - 1);
                            }
                            if (!string2.trim().equals(this.baseTokenAnnotationType)) {
                                this.areAllTermsTokens = false;
                            }
                            arrayList3.add(new Term(this.field, string3, string2 + ".string"));
                            arrayList2.add(new Integer(this.position));
                            if (i == 0) {
                                arrayList.add(new Boolean(true));
                                continue;
                            }
                            arrayList.add(new Boolean(false));
                            continue;
                        }
                        if (!this.norm((String)arrayList5.get(i)).equals(this.baseTokenAnnotationType)) {
                            this.areAllTermsTokens = false;
                        }
                        arrayList3.add(new Term(this.field, this.norm((String)arrayList5.get(i)), "*"));
                        arrayList2.add(new Integer(this.position));
                        if (i == 0) {
                            arrayList.add(new Boolean(true));
                            continue;
                        }
                        arrayList.add(new Boolean(false));
                    }
                    ++this.position;
                    break block35;
                }
                if (n3 == -1 && n2 != -1) {
                    throw new SearchException("missing operator", "an equal operator (==) is missing", string, string.indexOf("=", n2) != -1 ? string.indexOf("=", n2) : string.length());
                }
                if (n3 == -1 || n2 == -1) break block35;
                int n4 = this.findIndexOf(string, ',');
                String[] stringArray = null;
                if (n4 == -1) {
                    stringArray = new String[]{string};
                } else {
                    ArrayList arrayList6 = this.splitString(string, ',', false);
                    stringArray = new String[arrayList6.size()];
                    for (n = 0; n < arrayList6.size(); ++n) {
                        stringArray[n] = (String)arrayList6.get(n);
                    }
                }
                int n5 = 0;
                for (n = 0; n < stringArray.length; ++n) {
                    String string4;
                    String string5;
                    n3 = stringArray[n].indexOf("==");
                    n2 = this.findIndexOf(stringArray[n], '.');
                    if (n3 == -1 && n2 == -1) {
                        if (!this.norm(stringArray[n].trim()).equals(this.baseTokenAnnotationType)) {
                            this.areAllTermsTokens = false;
                        }
                        arrayList3.add(new Term(this.field, this.norm(stringArray[n].trim()), "*"));
                        arrayList2.add(new Integer(this.position));
                        if (n == 0) {
                            arrayList.add(new Boolean(true));
                        } else {
                            arrayList.add(new Boolean(false));
                        }
                    } else if (n3 != -1 && n2 == -1) {
                        string5 = this.norm(stringArray[n].substring(0, n3).trim());
                        string4 = this.norm(stringArray[n].substring(n3 + 2, stringArray[n].length()).trim());
                        if (string4.charAt(0) == '\"' && string4.charAt(string4.length() - 1) == '\"') {
                            string4 = string4.substring(1, string4.length() - 1);
                        }
                        if (!string5.trim().equals(this.baseTokenAnnotationType)) {
                            this.areAllTermsTokens = false;
                        }
                        arrayList3.add(new Term(this.field, string4, string5 + ".string"));
                        arrayList2.add(new Integer(this.position));
                        if (n == 0) {
                            arrayList.add(new Boolean(true));
                        } else {
                            arrayList.add(new Boolean(false));
                        }
                    } else {
                        if (n3 == -1 && n2 != -1) {
                            throw new SearchException("missing operator", "an equal operator (==) is missing", string, string.indexOf("=", n5) != -1 ? string.indexOf("=", n5) : string.length());
                        }
                        string5 = this.norm(stringArray[n].substring(0, n2).trim());
                        string4 = this.norm(stringArray[n].substring(n2 + 1, n3).trim());
                        String string6 = this.norm(stringArray[n].substring(n3 + 2, stringArray[n].length()).trim());
                        if (string6.length() > 2 && string6.charAt(0) == '\"' && string6.charAt(string6.length() - 1) == '\"') {
                            string6 = string6.substring(1, string6.length() - 1);
                        }
                        if (!string5.trim().equals(this.baseTokenAnnotationType)) {
                            this.areAllTermsTokens = false;
                        }
                        arrayList3.add(new Term(this.field, string6, string5 + "." + string4));
                        arrayList2.add(new Integer(this.position));
                        if (n == 0) {
                            arrayList.add(new Boolean(true));
                        } else {
                            arrayList.add(new Boolean(false));
                        }
                    }
                    n5 += stringArray[n].length() + 1;
                }
                ++this.position;
                break block35;
            }
            String string7 = "";
            char c = ' ';
            char c2 = ' ';
            for (int i = 0; i < string.length(); ++i) {
                c = c2;
                c2 = string.charAt(i);
                if (c2 == '\"' && c != '\\') continue;
                string7 = string7 + c2;
            }
            String[] stringArray = this.norm(string7).split("( )+");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().length() <= 0) continue;
                arrayList3.add(new Term(this.field, this.norm(stringArray[i]), this.baseTokenAnnotationType + ".string"));
                arrayList2.add(new Integer(this.position));
                arrayList.add(new Boolean(true));
                ++this.position;
            }
        }
        return new ArrayList[]{arrayList3, arrayList2, arrayList};
    }

    public boolean needValidation() {
        return this.needValidation;
    }
}

