/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.annotation.AnnotationSetImpl;
import gate.creole.annic.apache.lucene.analysis.Token;
import gate.creole.annic.apache.lucene.document.Field;
import gate.creole.annic.lucene.LuceneReader;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneDocument {
    /*
     * WARNING - void declaration
     */
    public List<gate.creole.annic.apache.lucene.document.Document> createDocuments(String string, Document document, String string2, ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3, ArrayList<String> arrayList4, String string3, String string4, Boolean bl, String string5) {
        void var16_23;
        Object object4;
        Object object2;
        Set<Object> set;
        if (string4 != null) {
            string4 = string4.trim();
        }
        ArrayList<gate.creole.annic.apache.lucene.document.Document> arrayList5 = new ArrayList<gate.creole.annic.apache.lucene.document.Document>();
        ArrayList<Object> arrayList6 = new ArrayList();
        if (arrayList.size() > 0) {
            arrayList6 = arrayList;
        } else if (arrayList2.size() > 0) {
            set = new HashSet();
            if (document.getNamedAnnotationSets() != null && document.getNamedAnnotationSets().keySet() != null) {
                set = document.getNamedAnnotationSets().keySet();
            }
            for (String string6 : set) {
                if (arrayList2.contains(string6)) continue;
                arrayList6.add(string6);
            }
            if (!arrayList2.contains("<null>")) {
                arrayList6.add("<null>");
            }
        } else {
            set = new HashSet();
            if (document.getNamedAnnotationSets() != null && document.getNamedAnnotationSets().keySet() != null) {
                set = document.getNamedAnnotationSets().keySet();
            }
            for (String bl3 : set) {
                arrayList6.add(bl3);
            }
            arrayList6.add("<null>");
        }
        set = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = -1;
        if (string4 != null && string4.length() > 0) {
            n = string4.lastIndexOf(46);
        }
        if (n >= 0) {
            object2 = string4.substring(0, n);
            string4 = string4.substring(n + 1, string4.length());
            set = ((String)object2).equals("<null>") ? document.getAnnotations().get(string4) : document.getAnnotations((String)object2).get(string4);
            if (set == null || set.size() == 0) {
                System.err.println("Base Tokens " + string4 + " counldn't be found under the specified annotation set " + (String)object2 + "\n searching them in other annotation sets");
                bl2 = true;
            }
        } else {
            bl2 = true;
        }
        if (string4 != null && string4.length() > 0 && bl2) {
            bl4 = true;
            for (Object object3 : arrayList6) {
                if (((String)object3).equals("<null>")) {
                    object4 = document.getAnnotations().get(string4);
                    if (object4.size() <= 0) continue;
                    set = object4;
                    bl4 = false;
                    break;
                }
                object4 = document.getAnnotations((String)object3).get(string4);
                if (object4.size() <= 0) continue;
                set = object4;
                bl4 = false;
                break;
            }
        }
        if (string4 == null || string4.length() == 0) {
            bl4 = true;
        }
        if (bl4) {
            if (!bl.booleanValue()) {
                System.out.println("Tokens couldn't be found in the document - Ignoring the document " + document.getName());
                return null;
            }
            string4 = "Token";
            if (set == null) {
                set = new AnnotationSetImpl(document);
            }
            if (!this.createTokens(document, (AnnotationSet)set)) {
                System.out.println("Tokens couldn't be created manually - Ignoring the document " + document.getName());
                return null;
            }
        }
        object2 = null;
        n = -1;
        if (string5 != null && string5.trim().length() > 0) {
            n = string5.lastIndexOf(46);
        }
        if (n >= 0) {
            Object object3;
            object3 = string5.substring(0, n);
            string5 = string5.substring(n + 1, string5.length());
            object2 = ((String)object3).equals("<null>") ? document.getAnnotations().get(string5) : document.getAnnotations((String)object3).get(string5);
            if (object2 == null || object2.size() == 0) {
                System.err.println("Index Unit " + string5 + " counldn't be found under the specified annotation set " + (String)object3 + "\n searching them in other annotation sets");
                boolean bl5 = true;
            }
        } else {
            boolean bl6 = true;
        }
        if (string5 != null && string5.length() > 0 && var16_23 != false) {
            for (Object object4 : arrayList6) {
                Object object5;
                if (((String)object4).equals("<null>")) {
                    object5 = document.getAnnotations().get(string5);
                    if (object5.size() <= 0) continue;
                    object2 = object5;
                    break;
                }
                object5 = document.getAnnotations((String)object4).get(string5);
                if (object5.size() <= 0) continue;
                object2 = object5;
                break;
            }
        }
        if (object2 == null) {
            string5 = null;
        }
        int n2 = 0;
        object4 = null;
        for (String string6 : arrayList6) {
            HashSet<String> hashSet;
            AnnotationSet annotationSet = string6.equals("<null>") ? document.getAnnotations() : document.getAnnotations(string6);
            ArrayList<Token>[] arrayListArray = this.getTokens(document, annotationSet, arrayList3, arrayList4, string4, (AnnotationSet)set, string5, (AnnotationSet)object2, (Set<String>)(hashSet = new HashSet<String>()));
            if (arrayListArray == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (String string7 : hashSet) {
                stringBuffer.append(string7 + ";");
            }
            gate.creole.annic.apache.lucene.document.Document[] documentArray = new gate.creole.annic.apache.lucene.document.Document[arrayListArray.length];
            int n3 = 0;
            while (n3 < arrayListArray.length) {
                gate.creole.annic.apache.lucene.document.Document document2 = new gate.creole.annic.apache.lucene.document.Document();
                LuceneReader luceneReader = new LuceneReader(document, arrayListArray[n3]);
                document2.add(Field.Keyword("DOCUMENT_ID", string2));
                document2.add(Field.Keyword("DOCUMENT_ID_FOR_SERIALIZED_FILE", string2 + "-" + n2));
                document2.add(Field.Keyword("INDEXED_FEATURES", stringBuffer.substring(0, stringBuffer.length() - 1)));
                if (string != null) {
                    document2.add(Field.Keyword("CORPUS_ID", string));
                }
                document2.add(Field.Keyword("ANNOTATION_SET_ID", string6));
                document2.add(Field.Text("contents", luceneReader));
                try {
                    this.writeOnDisk(arrayListArray[n3], string2, string2 + "-" + n2, string3);
                }
                catch (Exception exception) {
                    Err.println("\nIgnoring the document : " + document.getName() + " since its token stream cannot be written on the disk");
                    Err.println("Reason: " + exception.getMessage());
                    return null;
                }
                documentArray[n3] = document2;
                ++n3;
                ++n2;
            }
            arrayList5.addAll(Arrays.asList(documentArray));
        }
        return arrayList5;
    }

    private boolean createTokens(Document document, AnnotationSet annotationSet) {
        String string = document.getContent().toString();
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (n == -1) continue;
                FeatureMap featureMap = Factory.newFeatureMap();
                String string2 = string.substring(n, i);
                if (string2.trim().length() > 0) {
                    featureMap.put("string", string2);
                    try {
                        annotationSet.add(new Long(n), new Long(i), "Token", featureMap);
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        invalidOffsetException.printStackTrace();
                        return false;
                    }
                }
                n = i + 1;
                continue;
            }
            if (n != -1) continue;
            n = i;
        }
        if (n == -1) {
            return false;
        }
        if (n < string.length()) {
            FeatureMap featureMap = Factory.newFeatureMap();
            String string3 = string.substring(n, string.length());
            if (string3.trim().length() > 0) {
                featureMap.put("string", string3);
                try {
                    annotationSet.add(new Long(n), new Long(string.length()), "Token", featureMap);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    invalidOffsetException.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    private String getCompatibleName(String string) {
        return string.replaceAll("[\\/:\\*\\?\"<>|]", "_");
    }

    private void writeOnDisk(ArrayList arrayList, String string, String string2, String string3) throws Exception {
        File file;
        File file2;
        string2 = this.getCompatibleName(string2);
        string = this.getCompatibleName(string);
        if (string3.startsWith("file:/")) {
            string3 = string3.substring(6, string3.length());
        }
        if (string3.charAt(1) != ':') {
            string3 = "/" + string3;
        }
        if (!(file2 = new File(file = new File(string3), "serialized-files")).exists()) {
            file2.mkdirs();
        }
        if (!file2.exists()) {
            throw new IOException("Directory could not be created :" + file2.getAbsolutePath());
        }
        if (!(file2 = new File(file2, string)).exists()) {
            file2.mkdirs();
        }
        if (!file2.exists()) {
            throw new IOException("Directory could not be created :" + file2.getAbsolutePath());
        }
        File file3 = new File(file2, string2 + ".annic");
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
        objectOutputStream.writeObject(arrayList);
        if (objectOutputStream != null) {
            objectOutputStream.close();
        }
    }

    private ArrayList<Token>[] getTokens(Document document, AnnotationSet annotationSet, ArrayList<String> arrayList, ArrayList<String> arrayList2, String string, AnnotationSet annotationSet2, String string2, AnnotationSet annotationSet3, Set<String> set) {
        Object object322;
        HashSet<String> hashSet;
        boolean bl = false;
        boolean bl2 = false;
        if (!arrayList.isEmpty()) {
            bl2 = true;
        } else if (!arrayList2.isEmpty()) {
            bl = true;
        }
        HashSet<Object> hashSet2 = new HashSet<Object>();
        if (string2 == null || string2.trim().length() == 0 || annotationSet3 == null || annotationSet3.size() == 0) {
            hashSet = new OffsetGroup();
            ((OffsetGroup)((Object)hashSet)).startOffset = new Long(0L);
            ((OffsetGroup)((Object)hashSet)).endOffset = document.getContent().size();
            hashSet2.add(hashSet);
        } else {
            for (Object object322 : annotationSet3) {
                OffsetGroup object22 = new OffsetGroup();
                object22.startOffset = object322.getStartNode().getOffset();
                object22.endOffset = object322.getEndNode().getOffset();
                hashSet2.add(object22);
            }
        }
        hashSet = new HashSet<String>();
        for (String string3 : annotationSet.getAllTypes()) {
            if (string3.indexOf(".") > -1 || string3.indexOf("=") > -1 || string3.indexOf(";") > -1 || string3.indexOf(",") > -1) {
                System.err.println("Annotations of type " + string3 + " cannot be indexed as the type name contains one of the ., =, or ; character");
                continue;
            }
            hashSet.add(string3);
        }
        if (annotationSet2 != null && annotationSet2.size() > 0) {
            hashSet.remove(string);
        }
        if (annotationSet3 != null && annotationSet3.size() > 0) {
            hashSet.remove(string2);
        }
        object322 = new AnnotationSetImpl(document);
        for (String string4 : hashSet) {
            for (Object object : annotationSet.get(string4)) {
                try {
                    object322.add(object.getStartNode().getOffset(), object.getEndNode().getOffset(), object.getType(), object.getFeatures());
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new GateRuntimeException(invalidOffsetException);
                }
            }
        }
        ArrayList[] arrayListArray = new ArrayList[hashSet2.size()];
        Iterator iterator = hashSet2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object;
            object = (OffsetGroup)iterator.next();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            ArrayList<Annotation> arrayList4 = new ArrayList<Annotation>(object322.getContained(((OffsetGroup)object).startOffset, ((OffsetGroup)object).endOffset));
            if (annotationSet2 != null && annotationSet2.size() != 0) {
                arrayList4.addAll(annotationSet2.getContained(((OffsetGroup)object).startOffset, ((OffsetGroup)object).endOffset));
            }
            if (arrayList4 == null || arrayList4.size() == 0) {
                return null;
            }
            Collections.sort(arrayList4, new OffsetComparator());
            int n2 = -1;
            for (int i = 0; i < arrayList4.size(); ++i) {
                Object object2;
                int n3 = 1;
                Annotation annotation = arrayList4.get(i);
                String string5 = annotation.getType();
                if (bl && arrayList2.contains(string5) || bl2 && !arrayList.contains(string5)) continue;
                int n4 = annotation.getStartNode().getOffset().intValue();
                int n5 = annotation.getEndNode().getOffset().intValue();
                String string6 = document.getContent().toString().substring(n4, n5);
                if (string6 == null) continue;
                Token token = new Token(string5, n4, n5, "*");
                if (i > 0 && annotation.getStartNode().getOffset().longValue() == arrayList4.get(i - 1).getStartNode().getOffset().longValue()) {
                    token.setPositionIncrement(0);
                    n3 = 0;
                }
                token.setPosition(n2 += n3);
                arrayList3.add(token);
                if (!string5.equals(string) || annotation.getFeatures().get("string") == null) {
                    object2 = new Token(string6, n4, n5, string5 + ".string");
                    set.add(string5 + ".string");
                    ((Token)object2).setPositionIncrement(0);
                    ((Token)object2).setPosition(n2);
                    arrayList3.add(object2);
                }
                object2 = annotation.getFeatures();
                for (String string7 : object2.keySet()) {
                    Object v;
                    if (bl && arrayList2.contains(string5 + "." + string7) || bl2 && !arrayList.contains(string5 + "." + string7) || (v = object2.get(string7)) == null) continue;
                    String string8 = v.toString();
                    Token token2 = new Token(string8, n4, n5, string5 + "." + string7);
                    set.add(string5 + "." + string7);
                    token2.setPositionIncrement(0);
                    token2.setPosition(n2);
                    arrayList3.add(token2);
                    Token token3 = new Token(string5 + "." + string7, n4, n5, "**");
                    token3.setPosition(n2);
                    token3.setPositionIncrement(0);
                    arrayList3.add(token3);
                }
            }
            arrayListArray[n] = arrayList3;
            ++n;
        }
        return arrayListArray;
    }

    private class OffsetGroup {
        Long startOffset;
        Long endOffset;

        private OffsetGroup() {
        }
    }
}

