/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.util;

public abstract class PriorityQueue {
    private Object[] heap;
    private int size;
    private int maxSize;

    protected abstract boolean lessThan(Object var1, Object var2);

    protected final void initialize(int n) {
        this.size = 0;
        int n2 = n + 1;
        this.heap = new Object[n2];
        this.maxSize = n;
    }

    public final void put(Object object) {
        ++this.size;
        this.heap[this.size] = object;
        this.upHeap();
    }

    public boolean insert(Object object) {
        if (this.size < this.maxSize) {
            this.put(object);
            return true;
        }
        if (this.size > 0 && !this.lessThan(object, this.top())) {
            this.heap[1] = object;
            this.adjustTop();
            return true;
        }
        return false;
    }

    public final Object top() {
        if (this.size > 0) {
            return this.heap[1];
        }
        return null;
    }

    public final Object pop() {
        if (this.size > 0) {
            Object object = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap();
            return object;
        }
        return null;
    }

    public final void adjustTop() {
        this.downHeap();
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        for (int i = 0; i <= this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    private final void upHeap() {
        int n = this.size;
        Object object = this.heap[n];
        for (int i = n >>> 1; i > 0 && this.lessThan(object, this.heap[i]); i >>>= 1) {
            this.heap[n] = this.heap[i];
            n = i;
        }
        this.heap[n] = object;
    }

    private final void downHeap() {
        int n = 1;
        Object object = this.heap[n];
        int n2 = n << 1;
        int n3 = n2 + 1;
        if (n3 <= this.size && this.lessThan(this.heap[n3], this.heap[n2])) {
            n2 = n3;
        }
        while (n2 <= this.size && this.lessThan(this.heap[n2], object)) {
            this.heap[n] = this.heap[n2];
            n = n2;
            n3 = (n2 = n << 1) + 1;
            if (n3 > this.size || !this.lessThan(this.heap[n3], this.heap[n2])) continue;
            n2 = n3;
        }
        this.heap[n] = object;
    }
}

