/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.search.ExactPhraseScorer;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.SloppyPhraseScorer;
import gate.creole.annic.apache.lucene.search.TermQuery;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class PhraseQuery
extends Query {
    private String field;
    private Vector terms = new Vector();
    private Vector positions = new Vector();
    private int slop = 0;
    int totalTerms = 0;

    public void setSlop(int n) {
        this.slop = n;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term, Integer n, boolean bl) {
        if (this.terms.size() == 0) {
            this.field = term.field();
        } else if (term.field() != this.field) {
            throw new IllegalArgumentException("All phrase terms must be in the same field: " + term);
        }
        this.terms.addElement(term);
        this.positions.addElement(n);
        if (bl) {
            ++this.totalTerms;
        }
    }

    public void setTotalTerms(int n) {
        this.totalTerms = n;
    }

    public void add(Term term) {
        if (this.terms.size() == 0) {
            this.field = term.field();
        } else if (term.field() != this.field) {
            throw new IllegalArgumentException("All phrase terms must be in the same field: " + term);
        }
        this.terms.addElement(term);
    }

    public Term[] getTerms() {
        return this.terms.toArray(new Term[0]);
    }

    protected Weight createWeight(Searcher searcher) {
        if (this.terms.size() == 1) {
            Term term = (Term)this.terms.elementAt(0);
            TermQuery termQuery = new TermQuery(term);
            termQuery.setBoost(this.getBoost());
            return ((Query)termQuery).createWeight(searcher);
        }
        return new PhraseWeight(searcher);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.field.equals(string)) {
            stringBuffer.append(this.field);
            stringBuffer.append(":");
        }
        stringBuffer.append("\"");
        for (int i = 0; i < this.terms.size(); ++i) {
            stringBuffer.append(((Term)this.terms.elementAt(i)).text());
            if (i == this.terms.size() - 1) continue;
            stringBuffer.append(" ");
        }
        stringBuffer.append("\"");
        if (this.slop != 0) {
            stringBuffer.append("~");
            stringBuffer.append(this.slop);
        }
        if (this.getBoost() != 1.0f) {
            stringBuffer.append("^");
            stringBuffer.append(Float.toString(this.getBoost()));
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PhraseQuery)) {
            return false;
        }
        PhraseQuery phraseQuery = (PhraseQuery)object;
        return this.getBoost() == phraseQuery.getBoost() && this.slop == phraseQuery.slop && this.terms.equals(phraseQuery.terms);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ Float.floatToIntBits(this.slop) ^ this.terms.hashCode();
    }

    private class PhraseWeight
    implements Weight {
        private Searcher searcher;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;

        public PhraseWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public String toString() {
            return "weight(" + PhraseQuery.this + ")";
        }

        public Query getQuery() {
            return PhraseQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.idf = PhraseQuery.this.getSimilarity(this.searcher).idf(PhraseQuery.this.terms, this.searcher);
            this.queryWeight = this.idf * PhraseQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float f) {
            this.queryNorm = f;
            this.queryWeight *= f;
            this.value = this.queryWeight * this.idf;
        }

        public Scorer scorer(IndexReader indexReader, Searcher searcher) throws IOException {
            if (PhraseQuery.this.terms.size() == 0) {
                return null;
            }
            TermPositions[] termPositionsArray = new TermPositions[PhraseQuery.this.terms.size()];
            for (int i = 0; i < PhraseQuery.this.terms.size(); ++i) {
                TermPositions termPositions = indexReader.termPositions((Term)PhraseQuery.this.terms.elementAt(i));
                if (termPositions == null) {
                    return null;
                }
                termPositionsArray[i] = termPositions;
            }
            if (PhraseQuery.this.slop == 0) {
                return new ExactPhraseScorer(this, termPositionsArray, PhraseQuery.this.positions, PhraseQuery.this.totalTerms, PhraseQuery.this.getSimilarity(searcher), indexReader.norms(PhraseQuery.this.field), searcher);
            }
            return new SloppyPhraseScorer(this, termPositionsArray, PhraseQuery.this.getSimilarity(searcher), PhraseQuery.this.slop, indexReader.norms(PhraseQuery.this.field));
        }

        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            Serializable serializable;
            Explanation explanation = new Explanation();
            explanation.setDescription("weight(" + this.getQuery() + " in " + n + "), product of:");
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append('\"');
            for (int i = 0; i < PhraseQuery.this.terms.size(); ++i) {
                if (i != 0) {
                    stringBuffer.append(" ");
                    stringBuffer2.append(" ");
                }
                serializable = (Term)PhraseQuery.this.terms.elementAt(i);
                stringBuffer.append(((Term)serializable).text());
                stringBuffer.append("=");
                stringBuffer.append(this.searcher.docFreq((Term)serializable));
                stringBuffer2.append(((Term)serializable).text());
            }
            stringBuffer2.append('\"');
            Explanation explanation2 = new Explanation(this.idf, "idf(" + PhraseQuery.this.field + ": " + stringBuffer + ")");
            serializable = new Explanation();
            ((Explanation)serializable).setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation explanation3 = new Explanation(PhraseQuery.this.getBoost(), "boost");
            if (PhraseQuery.this.getBoost() != 1.0f) {
                ((Explanation)serializable).addDetail(explanation3);
            }
            ((Explanation)serializable).addDetail(explanation2);
            Explanation explanation4 = new Explanation(this.queryNorm, "queryNorm");
            ((Explanation)serializable).addDetail(explanation4);
            ((Explanation)serializable).setValue(explanation3.getValue() * explanation2.getValue() * explanation4.getValue());
            explanation.addDetail((Explanation)serializable);
            Explanation explanation5 = new Explanation();
            explanation5.setDescription("fieldWeight(" + PhraseQuery.this.field + ":" + stringBuffer2 + " in " + n + "), product of:");
            Explanation explanation6 = this.scorer(indexReader, this.searcher).explain(n);
            explanation5.addDetail(explanation6);
            explanation5.addDetail(explanation2);
            Explanation explanation7 = new Explanation();
            byte[] byArray = indexReader.norms(PhraseQuery.this.field);
            float f = byArray != null ? Similarity.decodeNorm(byArray[n]) : 0.0f;
            explanation7.setValue(f);
            explanation7.setDescription("fieldNorm(field=" + PhraseQuery.this.field + ", doc=" + n + ")");
            explanation5.addDetail(explanation7);
            explanation5.setValue(explanation6.getValue() * explanation2.getValue() * explanation7.getValue());
            explanation.addDetail(explanation5);
            explanation.setValue(((Explanation)serializable).getValue() * explanation5.getValue());
            if (((Explanation)serializable).getValue() == 1.0f) {
                return explanation5;
            }
            return explanation;
        }
    }
}

