/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.HitCollector;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import java.io.IOException;

final class BooleanScorer
extends Scorer {
    private SubScorer scorers = null;
    private BucketTable bucketTable = new BucketTable(this);
    private int maxCoord = 1;
    private float[] coordFactors = null;
    private int requiredMask = 0;
    private int prohibitedMask = 0;
    private int nextMask = 1;
    private int end;
    private Bucket current;

    BooleanScorer(Similarity similarity) {
        super(similarity);
    }

    final void add(Scorer scorer, boolean bl, boolean bl2) throws IOException {
        int n = 0;
        if (bl || bl2) {
            if (this.nextMask == 0) {
                throw new IndexOutOfBoundsException("More than 32 required/prohibited clauses in query.");
            }
            n = this.nextMask;
            this.nextMask <<= 1;
        } else {
            n = 0;
        }
        if (!bl2) {
            ++this.maxCoord;
        }
        if (bl2) {
            this.prohibitedMask |= n;
        } else if (bl) {
            this.requiredMask |= n;
        }
        this.scorers = new SubScorer(scorer, bl, bl2, this.bucketTable.newCollector(n), this.scorers);
    }

    private final void computeCoordFactors() throws IOException {
        this.coordFactors = new float[this.maxCoord];
        for (int i = 0; i < this.maxCoord; ++i) {
            this.coordFactors[i] = this.getSimilarity().coord(i, this.maxCoord - 1);
        }
    }

    public int doc() {
        return this.current.doc;
    }

    public boolean next(Searcher searcher) throws IOException {
        this.searcher = searcher;
        while (true) {
            if (this.bucketTable.first != null) {
                this.current = this.bucketTable.first;
                this.bucketTable.first = this.current.next;
                if ((this.current.bits & this.prohibitedMask) != 0 || (this.current.bits & this.requiredMask) != this.requiredMask) continue;
                return true;
            }
            boolean bl = false;
            this.end += 1024;
            SubScorer subScorer = this.scorers;
            while (subScorer != null) {
                Scorer scorer = subScorer.scorer;
                while (!subScorer.done && scorer.doc() < this.end) {
                    subScorer.collector.collect(scorer.doc(), scorer.score(this.searcher));
                    subScorer.done = !scorer.next(this.searcher);
                }
                if (!subScorer.done) {
                    bl = true;
                }
                subScorer = subScorer.next;
            }
            if (!(this.bucketTable.first != null | bl)) break;
        }
        return false;
    }

    public float score(Searcher searcher) throws IOException {
        this.searcher = searcher;
        if (this.coordFactors == null) {
            this.computeCoordFactors();
        }
        return this.current.score * this.coordFactors[this.current.coord];
    }

    public boolean skipTo(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Explanation explain(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("boolean(");
        SubScorer subScorer = this.scorers;
        while (subScorer != null) {
            stringBuffer.append(subScorer.scorer.toString());
            stringBuffer.append(" ");
            subScorer = subScorer.next;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static final class Collector
    extends HitCollector {
        private BucketTable bucketTable;
        private int mask;

        public Collector(int n, BucketTable bucketTable) {
            this.mask = n;
            this.bucketTable = bucketTable;
        }

        public final void collect(int n, float f) {
            BucketTable bucketTable = this.bucketTable;
            int n2 = n & 0x3FF;
            Bucket bucket = bucketTable.buckets[n2];
            if (bucket == null) {
                bucketTable.buckets[n2] = bucket = new Bucket();
            }
            if (bucket.doc != n) {
                bucket.doc = n;
                bucket.score = f;
                bucket.bits = this.mask;
                bucket.coord = 1;
                bucket.next = bucketTable.first;
                bucketTable.first = bucket;
            } else {
                bucket.score += f;
                bucket.bits |= this.mask;
                ++bucket.coord;
            }
        }
    }

    static final class BucketTable {
        public static final int SIZE = 1024;
        public static final int MASK = 1023;
        final Bucket[] buckets = new Bucket[1024];
        Bucket first = null;
        private BooleanScorer scorer;

        public BucketTable(BooleanScorer booleanScorer) {
            this.scorer = booleanScorer;
        }

        public final int size() {
            return 1024;
        }

        public HitCollector newCollector(int n) {
            return new Collector(n, this);
        }
    }

    static final class Bucket {
        int doc = -1;
        float score;
        int bits;
        int coord;
        Bucket next;

        Bucket() {
        }
    }

    static final class SubScorer {
        public Scorer scorer;
        public boolean done;
        public boolean required = false;
        public boolean prohibited = false;
        public HitCollector collector;
        public SubScorer next;
        protected Searcher searcher;

        public SubScorer(Scorer scorer, boolean bl, boolean bl2, HitCollector hitCollector, SubScorer subScorer) throws IOException {
            this.searcher = scorer.searcher;
            this.scorer = scorer;
            this.done = !scorer.next(this.searcher);
            this.required = bl;
            this.prohibited = bl2;
            this.collector = hitCollector;
            this.next = subScorer;
        }
    }
}

