/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.OutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;

final class CompoundFileWriter {
    private Directory directory;
    private String fileName;
    private HashSet ids;
    private LinkedList entries;
    private boolean merged = false;

    public CompoundFileWriter(Directory directory, String string) {
        if (directory == null) {
            throw new IllegalArgumentException("Missing directory");
        }
        if (string == null) {
            throw new IllegalArgumentException("Missing name");
        }
        this.directory = directory;
        this.fileName = string;
        this.ids = new HashSet();
        this.entries = new LinkedList();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.fileName;
    }

    public void addFile(String string) {
        if (this.merged) {
            throw new IllegalStateException("Can't add extensions after merge has been called");
        }
        if (string == null) {
            throw new IllegalArgumentException("Missing source file");
        }
        if (!this.ids.add(string)) {
            throw new IllegalArgumentException("File " + string + " already added");
        }
        FileEntry fileEntry = new FileEntry();
        fileEntry.file = string;
        this.entries.add(fileEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        if (this.merged) {
            throw new IllegalStateException("Merge already performed");
        }
        if (this.entries.isEmpty()) {
            throw new IllegalStateException("No entries to merge have been defined");
        }
        this.merged = true;
        OutputStream outputStream = null;
        try {
            Object object2;
            outputStream = this.directory.createFile(this.fileName);
            outputStream.writeVInt(this.entries.size());
            for (FileEntry fileEntry : this.entries) {
                fileEntry.directoryOffset = outputStream.getFilePointer();
                outputStream.writeLong(0L);
                outputStream.writeString(fileEntry.file);
            }
            byte[] byArray = new byte[1024];
            for (Object object2 : this.entries) {
                ((FileEntry)object2).dataOffset = outputStream.getFilePointer();
                this.copyFile((FileEntry)object2, outputStream, byArray);
            }
            for (Object object2 : this.entries) {
                outputStream.seek(((FileEntry)object2).directoryOffset);
                outputStream.writeLong(((FileEntry)object2).dataOffset);
            }
            object2 = outputStream;
            outputStream = null;
            ((OutputStream)object2).close();
            Object var6_6 = null;
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFile(FileEntry fileEntry, OutputStream outputStream, byte[] byArray) throws IOException {
        InputStream inputStream = null;
        try {
            long l;
            long l2;
            int n;
            long l3 = outputStream.getFilePointer();
            inputStream = this.directory.openFile(fileEntry.file);
            int n2 = byArray.length;
            for (l2 = l = inputStream.length(); l2 > 0L; l2 -= (long)n) {
                n = (int)Math.min((long)n2, l2);
                inputStream.readBytes(byArray, 0, n);
                outputStream.writeBytes(byArray, n);
            }
            if (l2 != 0L) {
                throw new IOException("Non-zero remainder length after copying: " + l2 + " (id: " + fileEntry.file + ", length: " + l + ", buffer size: " + n2 + ")");
            }
            long l4 = outputStream.getFilePointer();
            long l5 = l4 - l3;
            if (l5 != l) {
                throw new IOException("Difference in the output file offsets " + l5 + " does not match the original file length " + l);
            }
            Object var17_12 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var17_13 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    private static final class FileEntry {
        String file;
        long directoryOffset;
        long dataOffset;

        private FileEntry() {
        }
    }
}

