/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic;

import gate.creole.annic.Pattern;
import gate.creole.annic.PatternAnnotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLGenerator {
    private static int noOfColumnsToDraw = 0;

    public static String generateHTMLTable(Pattern pattern) {
        Object object;
        int n;
        PatternAnnotation[] patternAnnotationArray = pattern.getPatternAnnotations();
        String string = "<table cellpadding=\"0\" cellspacing=\"0\" border=\"1\" width=\"100%\" style=\"border-collapse: collapse; border: medium none; background: #E6E6E6\">";
        List<String> list = HTMLGenerator.getRowData(patternAnnotationArray);
        Collections.sort(list);
        List<String> list2 = HTMLGenerator.getColsPositions(patternAnnotationArray);
        Collections.sort(list2, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n = Integer.parseInt(string);
                int n2 = Integer.parseInt(string2);
                return n - n2;
            }
        });
        patternAnnotationArray = HTMLGenerator.sort(patternAnnotationArray);
        string = string + "\n<tr> <td style=\"width: 85.25pt; border-left: medium none; border-right: 1.0pt dashed blue; border-top: 1.0pt dashed blue; border-bottom: 1.0pt dashed blue; padding-left: 5.4pt; padding-right: 5.4pt; padding-top: 0cm; padding-bottom: 0cm\"><p class=\"MsoNormal\" align=\"center\">Pattern Text : </td>";
        int n2 = patternAnnotationArray[0].getStartOffset();
        int n3 = 0;
        for (n = 1; n < list2.size(); ++n) {
            n3 = n2;
            n2 = Integer.parseInt(list2.get(n));
            object = pattern.getPatternText(n3, n2);
            string = string + "\n<td style=\"border: 1.0pt dashed blue;\" align=\"center\">" + (String)object + "</td>";
        }
        for (n = 0; n < list.size(); ++n) {
            int n4;
            string = string + "\n<tr width=\"100%\" height=\"19\"> <td>" + list.get(n) + "</td>";
            object = HTMLGenerator.findOutAnnotationsOfType(patternAnnotationArray, list.get(n));
            int n5 = 0;
            for (n4 = 0; n4 < object.size(); ++n4) {
                int n6;
                int n7;
                PatternAnnotation patternAnnotation = (PatternAnnotation)object.get(n4);
                string = string + "\n" + HTMLGenerator.columnsToDraw(patternAnnotationArray, (List<PatternAnnotation>)object, n4, list2);
                n5 += noOfColumnsToDraw;
                ArrayList<PatternAnnotation> arrayList = new ArrayList<PatternAnnotation>();
                arrayList.add(patternAnnotation);
                int n8 = patternAnnotation.getEndOffset();
                for (n7 = n4 + 1; n7 < object.size(); ++n7) {
                    PatternAnnotation patternAnnotation2 = (PatternAnnotation)object.get(n7);
                    if (patternAnnotation.getStartOffset() == patternAnnotation2.getStartOffset()) {
                        arrayList.add(patternAnnotation2);
                        if (patternAnnotation2.getEndOffset() <= n8) continue;
                        n8 = patternAnnotation2.getEndOffset();
                        continue;
                    }
                    --n7;
                    break;
                }
                if (n4 != n7) {
                    n4 = n7;
                }
                if ((n6 = HTMLGenerator.getColSpan(patternAnnotation.getStartOffset(), n8, list2)) > 0) {
                    string = string + "\n<td style=\"border: 1.0pt dashed blue;\" align=\"center\" colspan=\"" + n6 + "\" <p align=\"center\">";
                    n5 += n6;
                } else {
                    string = string + "\n<td style=\"border: 1.0pt dashed blue;\" align=\"center\"> <p align=\"center\">";
                    ++n5;
                }
                for (n7 = 0; n7 < arrayList.size(); ++n7) {
                    string = string + HTMLGenerator.addFeatures(((PatternAnnotation)arrayList.get(n7)).getFeatures()) + "<br>";
                }
                string = string + "</td>";
            }
            for (n4 = 0; n4 < list2.size() - n5; ++n4) {
                string = string + "\n<td style=\"border: 1.0pt dashed blue;\">&nbsp;</td>";
            }
            string = string + "\n</tr>";
        }
        string = string + "\n</table>";
        return string;
    }

    private static PatternAnnotation[] sort(PatternAnnotation[] patternAnnotationArray) {
        block0: for (int i = 0; i < patternAnnotationArray.length; ++i) {
            for (int j = 0; j < patternAnnotationArray.length - 1; ++j) {
                PatternAnnotation patternAnnotation;
                if (patternAnnotationArray[j].getStartOffset() > patternAnnotationArray[j + 1].getStartOffset()) {
                    patternAnnotation = patternAnnotationArray[j + 1];
                    patternAnnotationArray[j + 1] = patternAnnotationArray[j];
                    patternAnnotationArray[j] = patternAnnotation;
                    continue block0;
                }
                if (patternAnnotationArray[j].getEndOffset() <= patternAnnotationArray[j + 1].getEndOffset()) continue;
                patternAnnotation = patternAnnotationArray[j + 1];
                patternAnnotationArray[j + 1] = patternAnnotationArray[j];
                patternAnnotationArray[j] = patternAnnotation;
                continue block0;
            }
        }
        return patternAnnotationArray;
    }

    private static String columnsToDraw(PatternAnnotation[] patternAnnotationArray, List<PatternAnnotation> list, int n, List<String> list2) {
        int n2 = 0;
        n2 = n == 0 ? patternAnnotationArray[0].getStartOffset() : list.get(n - 1).getEndOffset();
        noOfColumnsToDraw = HTMLGenerator.noOfColumnsToDraw(n2, list.get(n).getStartOffset(), list2);
        String string = "";
        for (int i = 0; i < noOfColumnsToDraw; ++i) {
            string = string + "\n<td style=\"border: 1.0pt dashed blue;\">&nbsp;</td>";
        }
        return string;
    }

    private static int noOfColumnsToDraw(int n, int n2, List<String> list) {
        int n3;
        if (n == n2) {
            return 0;
        }
        int n4 = 0;
        for (n3 = 0; n3 < list.size(); ++n3) {
            if (Integer.parseInt(list.get(n3)) != n) continue;
            ++n3;
            break;
        }
        if (n3 == list.size() || n3 < 0) {
            n3 = 0;
        }
        while (n3 < list.size()) {
            if (n2 == Integer.parseInt(list.get(n3))) {
                ++n4;
                break;
            }
            ++n4;
            ++n3;
        }
        return n4;
    }

    private static List<PatternAnnotation> findOutAnnotationsOfType(PatternAnnotation[] patternAnnotationArray, String string) {
        ArrayList<PatternAnnotation> arrayList = new ArrayList<PatternAnnotation>();
        for (int i = 0; i < patternAnnotationArray.length; ++i) {
            if (!patternAnnotationArray[i].getType().equals(string)) continue;
            arrayList.add(patternAnnotationArray[i]);
        }
        return arrayList;
    }

    private static int getColSpan(int n, int n2, List<String> list) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < list.size(); ++n3) {
            if (Integer.parseInt(list.get(n3)) != n) continue;
            ++n3;
            break;
        }
        if (n3 == list.size() || n3 < 0) {
            n3 = 0;
        }
        while (n3 < list.size()) {
            if (n2 == Integer.parseInt(list.get(n3))) {
                ++n4;
                break;
            }
            ++n4;
            ++n3;
        }
        return n4;
    }

    private static List<String> getColsPositions(PatternAnnotation[] patternAnnotationArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < patternAnnotationArray.length; ++i) {
            int n = patternAnnotationArray[i].getEndOffset();
            int n2 = patternAnnotationArray[i].getStartOffset();
            if (!arrayList.contains("" + n)) {
                arrayList.add("" + n);
            }
            if (arrayList.contains("" + n2)) continue;
            arrayList.add("" + n2);
        }
        return arrayList;
    }

    private static List<String> getRowData(PatternAnnotation[] patternAnnotationArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < patternAnnotationArray.length; ++i) {
            String string = patternAnnotationArray[i].getType();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static String addFeatures(Map<String, String> map) {
        String string = "<select size=\"1\" >";
        for (String string2 : map.keySet()) {
            String string3 = map.get(string2).toString();
            string = string + "\n<option>" + string2 + " = \"" + string3 + "\"</option>";
        }
        string = string + "\n</select>";
        return string;
    }
}

