/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.LanguageAnalyser;
import gate.ProcessingResource;
import gate.creole.AbstractResource;
import gate.creole.ConditionalSerialController;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.event.CreoleEvent;
import gate.util.Benchmark;
import gate.util.GateRuntimeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@CreoleResource(name="Conditional Corpus Pipeline", comment="A serial controller for conditionally run PR pipelines over corpora.", helpURL="http://gate.ac.uk/userguide/sec:developer:cond")
public class ConditionalSerialAnalyserController
extends ConditionalSerialController
implements CorpusController,
LanguageAnalyser {
    private static final boolean DEBUG = false;
    protected Corpus corpus;
    protected Document document;

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeImpl() throws ExecutionException {
        block18: {
            block16: {
                this.interrupted = false;
                if (this.corpus == null) {
                    throw new ExecutionException("(ConditionalSerialAnalyserController) \"" + this.getName() + "\":\n" + "The corpus supplied for execution was null!");
                }
                this.benchmarkFeatures.put("corpusName", this.corpus.getName());
                if (this.document != null) break block16;
                for (int i = 0; i < this.corpus.size(); ++i) {
                    Object var12_11;
                    String string = this.getBenchmarkId();
                    try {
                        int n;
                        Object var9_9;
                        if (this.isInterrupted()) {
                            throw new ExecutionInterruptedException("The execution of the " + this.getName() + " application has been abruptly interrupted!");
                        }
                        boolean bl = this.corpus.isDocumentLoaded(i);
                        long l = Benchmark.startPoint();
                        Document document = (Document)this.corpus.get(i);
                        this.setBenchmarkId(Benchmark.createBenchmarkId("doc_" + document.getName(), this.getBenchmarkId()));
                        this.benchmarkFeatures.put("documentName", document.getName());
                        Benchmark.checkPoint(l, Benchmark.createBenchmarkId("documentLoaded", this.getBenchmarkId()), this, this.benchmarkFeatures);
                        for (int j = 0; j < this.prList.size(); ++j) {
                            ((LanguageAnalyser)this.prList.get(j)).setDocument(document);
                            ((LanguageAnalyser)this.prList.get(j)).setCorpus(this.corpus);
                        }
                        try {
                            super.executeImpl();
                            var9_9 = null;
                        }
                        catch (Throwable throwable) {
                            var9_9 = null;
                            for (n = 0; n < this.prList.size(); ++n) {
                                ((LanguageAnalyser)this.prList.get(n)).setDocument(null);
                                ((LanguageAnalyser)this.prList.get(n)).setCorpus(null);
                            }
                            throw throwable;
                        }
                        for (n = 0; n < this.prList.size(); ++n) {
                            ((LanguageAnalyser)this.prList.get(n)).setDocument(null);
                            ((LanguageAnalyser)this.prList.get(n)).setCorpus(null);
                        }
                        if (!bl) {
                            long l2 = Benchmark.startPoint();
                            this.corpus.unloadDocument(document);
                            Benchmark.checkPoint(l2, Benchmark.createBenchmarkId("documentSaved", this.getBenchmarkId()), this, this.benchmarkFeatures);
                            Factory.deleteResource(document);
                        }
                        var12_11 = null;
                    }
                    catch (Throwable throwable) {
                        var12_11 = null;
                        this.setBenchmarkId(string);
                        throw throwable;
                    }
                    this.setBenchmarkId(string);
                }
                break block18;
            }
            for (int i = 0; i < this.prList.size(); ++i) {
                ((LanguageAnalyser)this.prList.get(i)).setDocument(this.document);
                ((LanguageAnalyser)this.prList.get(i)).setCorpus(this.corpus);
            }
            try {
                super.executeImpl();
                Object var14_14 = null;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                for (int i = 0; i < this.prList.size(); ++i) {
                    ((LanguageAnalyser)this.prList.get(i)).setDocument(null);
                    ((LanguageAnalyser)this.prList.get(i)).setCorpus(null);
                }
                throw throwable;
            }
            for (int i = 0; i < this.prList.size(); ++i) {
                ((LanguageAnalyser)this.prList.get(i)).setDocument(null);
                ((LanguageAnalyser)this.prList.get(i)).setCorpus(null);
            }
        }
    }

    public void add(ProcessingResource processingResource) {
        this.checkLanguageAnalyser(processingResource);
        super.add(processingResource);
    }

    public void add(int n, ProcessingResource processingResource) {
        this.checkLanguageAnalyser(processingResource);
        super.add(n, processingResource);
    }

    protected void checkLanguageAnalyser(ProcessingResource processingResource) {
        if (!(processingResource instanceof LanguageAnalyser)) {
            throw new GateRuntimeException(this.getClass().getName() + " only accepts " + LanguageAnalyser.class.getName() + "s as components\n" + processingResource.getClass().getName() + " is not!");
        }
    }

    protected void setDocToPrs(Document document) {
        Iterator iterator = this.getPRs().iterator();
        while (iterator.hasNext()) {
            ((LanguageAnalyser)iterator.next()).setDocument(document);
        }
    }

    public List getOffendingPocessingResources() throws ResourceInstantiationException {
        ArrayList arrayList = new ArrayList(this.getPRs());
        for (ProcessingResource processingResource : this.getPRs()) {
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
            List<List<Parameter>> list = resourceData.getParameterList().getRuntimeParameters();
            ArrayList<ArrayList<Parameter>> arrayList2 = new ArrayList<ArrayList<Parameter>>();
            for (List<Parameter> list2 : list) {
                ArrayList<Parameter> arrayList3 = new ArrayList<Parameter>(list2);
                Iterator iterator = arrayList3.iterator();
                while (iterator.hasNext()) {
                    Parameter parameter = (Parameter)iterator.next();
                    if (!parameter.getName().equals("corpus") && !parameter.getName().equals("document")) continue;
                    iterator.remove();
                }
                if (arrayList3.isEmpty()) continue;
                arrayList2.add(arrayList3);
            }
            if (!AbstractResource.checkParameterValues(processingResource, arrayList2)) continue;
            arrayList.remove(processingResource);
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        super.resourceUnloaded(creoleEvent);
        if (creoleEvent.getResource() == this.corpus) {
            this.setCorpus(null);
        }
    }
}

