/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Document;
import gate.FeatureMap;
import gate.LanguageAnalyser;
import gate.ProcessingResource;
import gate.creole.RunningStrategy;
import gate.util.GateRuntimeException;

public class AnalyserRunningStrategy
implements RunningStrategy {
    protected LanguageAnalyser pr;
    protected int runMode = 1;
    protected String featureName;
    protected String featureValue;

    public AnalyserRunningStrategy(LanguageAnalyser languageAnalyser, int n, String string, String string2) {
        this.pr = languageAnalyser;
        this.runMode = n;
        this.featureName = string;
        this.featureValue = string2;
    }

    public boolean shouldRun() {
        if (this.runMode == 1) {
            return true;
        }
        if (this.runMode == 2) {
            return false;
        }
        if (this.runMode == 4) {
            if (this.featureName == null || this.featureName.length() == 0) {
                return true;
            }
            Document document = this.pr.getDocument();
            if (document != null) {
                FeatureMap featureMap = document.getFeatures();
                if (featureMap != null) {
                    Object v = featureMap.get(this.featureName);
                    return v == null && this.featureValue == null || v != null && v.equals(this.featureValue);
                }
                return this.featureName == null;
            }
            return false;
        }
        throw new GateRuntimeException("Unknown run mode!");
    }

    public int getRunMode() {
        return this.runMode;
    }

    public void setRunMode(int n) {
        this.runMode = n;
    }

    public void setFeatureName(String string) {
        this.featureName = string;
    }

    public void setFeatureValue(String string) {
        this.featureValue = string;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getFeatureValue() {
        return this.featureValue;
    }

    public ProcessingResource getPR() {
        return this.pr;
    }

    public void setProcessingResource(ProcessingResource processingResource) {
        if (!(processingResource instanceof LanguageAnalyser)) {
            throw new GateRuntimeException(this.getClass().getName() + " can only be used for " + LanguageAnalyser.class.getName() + "!\n" + processingResource.getClass().getName() + " is not a " + LanguageAnalyser.class.getName() + "!");
        }
        this.pr = (LanguageAnalyser)processingResource;
    }
}

