/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Controller;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractResource;
import gate.creole.ControllerAwarePR;
import gate.creole.ExecutionException;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.event.ControllerEvent;
import gate.event.ControllerListener;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.util.Benchmark;
import gate.util.Benchmarkable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CreoleResource(icon="application")
public abstract class AbstractController
extends AbstractResource
implements Controller,
ProcessingResource,
Benchmarkable {
    protected String benchmarkID;
    protected Map benchmarkFeatures = new HashMap();
    protected String name;
    private transient Vector statusListeners;
    private transient Vector progressListeners;
    private transient Vector controllerListeners;
    protected boolean interrupted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws ExecutionException {
        Object object;
        block24: {
            Iterator<ControllerAwarePR> iterator;
            for (ControllerAwarePR controllerAwarePR : this.getControllerAwarePRs()) {
                controllerAwarePR.controllerExecutionStarted(this);
            }
            object = null;
            try {
                try {
                    if (Benchmark.isBenchmarkingEnabled()) {
                        Benchmark.startPoint(this.getBenchmarkId());
                    }
                    this.executeImpl();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    Object var4_5 = null;
                    if (object == null) {
                        for (ControllerAwarePR controllerAwarePR : this.getControllerAwarePRs()) {
                            controllerAwarePR.controllerExecutionFinished(this);
                        }
                        return;
                    }
                    for (ControllerAwarePR controllerAwarePR : this.getControllerAwarePRs()) {
                        controllerAwarePR.controllerExecutionAborted(this, (Throwable)object);
                    }
                    if (object instanceof Error) {
                        throw (Error)object;
                    }
                    if (object instanceof RuntimeException) {
                        throw (RuntimeException)object;
                    }
                    if (!(object instanceof ExecutionException)) throw new UndeclaredThrowableException((Throwable)object);
                    throw (ExecutionException)object;
                }
                Object var4_4 = null;
                if (object != null) break block24;
                iterator = this.getControllerAwarePRs().iterator();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (object == null) {
                    Iterator<ControllerAwarePR> iterator2 = this.getControllerAwarePRs().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) {
                            throw throwable;
                        }
                        ControllerAwarePR controllerAwarePR = iterator2.next();
                        controllerAwarePR.controllerExecutionFinished(this);
                    }
                }
                for (ControllerAwarePR controllerAwarePR : this.getControllerAwarePRs()) {
                    controllerAwarePR.controllerExecutionAborted(this, (Throwable)object);
                }
                if (object instanceof Error) {
                    throw (Error)object;
                }
                if (object instanceof RuntimeException) {
                    throw (RuntimeException)object;
                }
                if (!(object instanceof ExecutionException)) throw new UndeclaredThrowableException((Throwable)object);
                throw (ExecutionException)object;
            }
            while (iterator.hasNext()) {
                ControllerAwarePR controllerAwarePR = iterator.next();
                controllerAwarePR.controllerExecutionFinished(this);
            }
            return;
        }
        for (ControllerAwarePR controllerAwarePR : this.getControllerAwarePRs()) {
            controllerAwarePR.controllerExecutionAborted(this, (Throwable)object);
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (!(object instanceof ExecutionException)) throw new UndeclaredThrowableException((Throwable)object);
        throw (ExecutionException)object;
    }

    protected Set<ControllerAwarePR> getControllerAwarePRs() {
        HashSet<ControllerAwarePR> hashSet = null;
        for (Object e : this.getPRs()) {
            if (!(e instanceof ControllerAwarePR)) continue;
            if (hashSet == null) {
                hashSet = new HashSet<ControllerAwarePR>();
            }
            hashSet.add((ControllerAwarePR)e);
        }
        if (hashSet == null) {
            return Collections.emptySet();
        }
        return hashSet;
    }

    protected void executeImpl() throws ExecutionException {
        throw new ExecutionException("Controller " + this.getClass() + " hasn't overriden the executeImpl() method");
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    @Override
    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void setPRs(Collection collection) {
    }

    @Override
    public synchronized void interrupt() {
        this.interrupted = true;
        Iterator iterator = this.getPRs().iterator();
        while (iterator.hasNext()) {
            ((ProcessingResource)iterator.next()).interrupt();
        }
    }

    @Override
    public synchronized boolean isInterrupted() {
        return this.interrupted;
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        if (this.statusListeners != null && this.statusListeners.contains(statusListener)) {
            Vector vector = (Vector)this.statusListeners.clone();
            vector.removeElement(statusListener);
            this.statusListeners = vector;
        }
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        Vector vector;
        Vector vector2 = vector = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!vector.contains(statusListener)) {
            vector.addElement(statusListener);
            this.statusListeners = vector;
        }
    }

    protected void fireStatusChanged(String string) {
        if (this.statusListeners != null) {
            Vector vector = this.statusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((StatusListener)vector.elementAt(i)).statusChanged(string);
            }
        }
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        Vector vector;
        Vector vector2 = vector = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!vector.contains(progressListener)) {
            vector.addElement(progressListener);
            this.progressListeners = vector;
        }
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners != null && this.progressListeners.contains(progressListener)) {
            Vector vector = (Vector)this.progressListeners.clone();
            vector.removeElement(progressListener);
            this.progressListeners = vector;
        }
    }

    protected void fireProgressChanged(int n) {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((ProgressListener)vector.elementAt(i)).progressChanged(n);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ProgressListener)vector.elementAt(i)).processFinished();
            }
        }
    }

    public List getOffendingPocessingResources() throws ResourceInstantiationException {
        ArrayList arrayList = new ArrayList(this.getPRs());
        for (ProcessingResource processingResource : this.getPRs()) {
            ResourceData resourceData;
            if (!AbstractResource.checkParameterValues(processingResource, (resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName())).getParameterList().getRuntimeParameters())) continue;
            arrayList.remove(processingResource);
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized void removeControllerListener(ControllerListener controllerListener) {
        if (this.controllerListeners != null && this.controllerListeners.contains(controllerListener)) {
            Vector vector = (Vector)this.controllerListeners.clone();
            vector.removeElement(controllerListener);
            this.controllerListeners = vector;
        }
    }

    public synchronized void addControllerListener(ControllerListener controllerListener) {
        Vector vector;
        Vector vector2 = vector = this.controllerListeners == null ? new Vector(2) : (Vector)this.controllerListeners.clone();
        if (!vector.contains(controllerListener)) {
            vector.addElement(controllerListener);
            this.controllerListeners = vector;
        }
    }

    protected void fireResourceAdded(ControllerEvent controllerEvent) {
        if (this.controllerListeners != null) {
            Vector vector = this.controllerListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ControllerListener)vector.elementAt(i)).resourceAdded(controllerEvent);
            }
        }
    }

    protected void fireResourceRemoved(ControllerEvent controllerEvent) {
        if (this.controllerListeners != null) {
            Vector vector = this.controllerListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ControllerListener)vector.elementAt(i)).resourceRemoved(controllerEvent);
            }
        }
    }

    @Override
    public void setBenchmarkId(String string) {
        this.benchmarkID = string;
    }

    @Override
    public String getBenchmarkId() {
        if (this.benchmarkID == null) {
            this.benchmarkID = this.getName().replaceAll("[ ]+", "_");
        }
        return this.benchmarkID;
    }

    protected class InternalStatusListener
    implements StatusListener {
        protected InternalStatusListener() {
        }

        public void statusChanged(String string) {
            AbstractController.this.fireStatusChanged(string);
        }
    }

    protected class IntervalProgressListener
    implements ProgressListener {
        int start;
        int end;

        public IntervalProgressListener(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public void progressChanged(int n) {
            AbstractController.this.fireProgressChanged(this.start + (this.end - this.start) * n / 100);
        }

        public void processFinished() {
            AbstractController.this.fireProgressChanged(this.end);
        }
    }
}

