/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.corpora.SerialCorpusImpl;
import gate.util.SimpleFeatureMapImpl;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSerialCorpus
extends TestCase {
    private static final boolean DEBUG = false;

    public TestSerialCorpus(String string) {
        super(string);
    }

    public void setUp() {
    }

    public void testCreation() throws Exception {
        SerialCorpusImpl serialCorpusImpl = new SerialCorpusImpl(Factory.newCorpus("test"));
        serialCorpusImpl.setName("test corpus");
        TestSerialCorpus.assertTrue((boolean)serialCorpusImpl.isEmpty());
        TestSerialCorpus.assertTrue((boolean)serialCorpusImpl.getName().equals("test corpus"));
        serialCorpusImpl.setFeatures(new SimpleFeatureMapImpl());
        serialCorpusImpl.getFeatures().put("author", "hamish");
        serialCorpusImpl.getFeatures().put("date", new Integer(180200));
        TestSerialCorpus.assertTrue((serialCorpusImpl.getFeatures().size() == 2 ? 1 : 0) != 0);
    }

    public void testDocumentAddition() throws Exception {
        Corpus corpus = Factory.newCorpus("test corpus");
        Document document = Factory.newDocument("a document");
        Document document2 = Factory.newDocument("another document");
        document2.setSourceUrl(new URL("http://localhost/1"));
        document2.setSourceUrl(new URL("http://localhost/2"));
        TestSerialCorpus.assertTrue((boolean)corpus.add(document));
        TestSerialCorpus.assertTrue((boolean)corpus.add(document2));
        TestSerialCorpus.assertEquals((int)2, (int)corpus.size());
        SerialCorpusImpl serialCorpusImpl = new SerialCorpusImpl(corpus);
        Document document3 = (Document)serialCorpusImpl.get(0);
        Document document4 = (Document)serialCorpusImpl.get(1);
        TestSerialCorpus.assertEquals((Object)document, (Object)document3);
        TestSerialCorpus.assertEquals((Object)document2, (Object)document4);
    }

    public static Test suite() {
        return new TestSuite(TestSerialCorpus.class);
    }

    public static void main(String[] stringArray) {
        try {
            Gate.setLocalWebServer(false);
            Gate.setNetConnected(false);
            Gate.init();
            TestSerialCorpus testSerialCorpus = new TestSerialCorpus("");
            testSerialCorpus.setUp();
            testSerialCorpus.testCreation();
            testSerialCorpus.tearDown();
            testSerialCorpus.setUp();
            testSerialCorpus.testDocumentAddition();
            testSerialCorpus.tearDown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

