/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Document;
import gate.Resource;
import gate.corpora.MimeType;
import gate.corpora.RepositioningInfo;
import gate.corpora.TextualDocumentFormat;
import gate.creole.ResourceInstantiationException;
import gate.event.StatusListener;
import gate.html.HtmlDocumentHandler;
import gate.util.DocumentFormatException;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class HtmlDocumentFormat
extends TextualDocumentFormat {
    private static final boolean DEBUG = false;

    public Boolean supportsRepositioning() {
        return new Boolean(true);
    }

    public void unpackMarkup(Document document) throws DocumentFormatException {
        this.unpackMarkup(document, null, null);
    }

    public void unpackMarkup(Document document, RepositioningInfo repositioningInfo, RepositioningInfo repositioningInfo2) throws DocumentFormatException {
        StringReader stringReader = null;
        Object var5_5 = null;
        Object var6_6 = null;
        ParserDelegator parserDelegator = new ParserDelegator();
        if (document == null || document.getContent() == null) {
            throw new DocumentFormatException("GATE document is null or no content found. Nothing to parse!");
        }
        stringReader = new StringReader(document.getContent().toString());
        HtmlDocumentHandler htmlDocumentHandler = new HtmlDocumentHandler(document, this.markupElementsMap);
        StatusListener statusListener = new StatusListener(){

            public void statusChanged(String string) {
                HtmlDocumentFormat.this.fireStatusChanged(string);
            }
        };
        htmlDocumentHandler.addStatusListener(statusListener);
        htmlDocumentHandler.setRepositioningInfo(repositioningInfo);
        htmlDocumentHandler.setAmpCodingInfo(repositioningInfo2);
        try {
            ((HTMLEditorKit.Parser)parserDelegator).parse(stringReader, htmlDocumentHandler, true);
        }
        catch (IOException iOException) {
            throw new DocumentFormatException(iOException);
        }
        finally {
            if (htmlDocumentHandler != null) {
                htmlDocumentHandler.removeStatusListener(statusListener);
            }
        }
    }

    public Resource init() throws ResourceInstantiationException {
        MimeType mimeType = new MimeType("text", "html");
        mimeString2ClassHandlerMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), this);
        mimeString2mimeTypeMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), mimeType);
        suffixes2mimeTypeMap.put("html", mimeType);
        suffixes2mimeTypeMap.put("htm", mimeType);
        magic2mimeTypeMap.put("<html", mimeType);
        this.setMimeType(mimeType);
        return this;
    }
}

