/*
 * Decompiled with CFR 0.152.
 */
package gate;

import com.ontotext.gate.gazetteer.TestHashGazetteer;
import gate.CookBook;
import gate.Gate;
import gate.annotation.TestAnnotation;
import gate.config.TestConfig;
import gate.corpora.TestCorpus;
import gate.corpora.TestDocument;
import gate.corpora.TestDocumentStaxUtils;
import gate.corpora.TestSerialCorpus;
import gate.creole.TestControllers;
import gate.creole.TestCreole;
import gate.creole.TestCreoleAnnotationHandler;
import gate.creole.TestPR;
import gate.creole.TestXSchema;
import gate.creole.annic.test.TestAnnic;
import gate.creole.gazetteer.TestFlexibleGazetteer;
import gate.creole.gazetteer.TestGazetteer;
import gate.creole.ir.TestIndex;
import gate.creole.morph.TestMorph;
import gate.creole.test.DynamicRegistrationTest;
import gate.email.TestEmail;
import gate.html.TestHtml;
import gate.jape.functest.TestJape;
import gate.persist.TestPersist;
import gate.sgml.TestSgml;
import gate.util.Err;
import gate.util.GateException;
import gate.util.Out;
import gate.util.TestAnnotationMerging;
import gate.util.TestClassificationMeasures;
import gate.util.TestDiffer;
import gate.util.TestFeatureMap;
import gate.util.TestFiles;
import gate.util.TestJavac;
import gate.util.TestRBTreeMap;
import gate.util.TestReload;
import gate.util.TestTemplate;
import gate.util.TestTools;
import gate.xml.TestRepositioningInfo;
import gate.xml.TestXml;
import gnu.getopt.Getopt;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestGate {
    private static final boolean DEBUG = false;
    private static final int STATUS_NORMAL = 0;
    private static final int STATUS_ERROR = 1;
    private static final String defOracleDriver = "jdbc:oracle:thin:@derwent:1521:dbgate";
    private static final String saiOracleDriver = "jdbc:oracle:thin:GATEUSER/gate@192.168.128.7:1521:GATE04";
    private static final String defPSQLDriver = "jdbc:postgresql://redmires/gate";
    private static final String saiPSQLDriver = "jdbc:postgresql://sirma/gate";
    public static String oracleDriver = "jdbc:oracle:thin:@derwent:1521:dbgate";
    public static String psqlDriver = "jdbc:postgresql://redmires/gate";

    public static void main(String[] stringArray) throws Exception {
        Serializable serializable;
        String[] stringArray2;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        Getopt getopt = new Getopt("GATE test suite", stringArray, "tnNasi:");
        block11: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 116: {
                    bl = true;
                    continue block11;
                }
                case 110: {
                    Gate.setNetConnected(false);
                    continue block11;
                }
                case 78: {
                    Gate.setNetConnected(false);
                    Gate.setLocalWebServer(false);
                    continue block11;
                }
                case 97: {
                    bl2 = true;
                    continue block11;
                }
                case 115: {
                    oracleDriver = saiOracleDriver;
                    psqlDriver = saiPSQLDriver;
                    continue block11;
                }
                case 105: {
                    stringArray2 = getopt.getOptarg();
                    serializable = null;
                    File file = new File((String)stringArray2);
                    try {
                        serializable = file.toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        Err.prln("Bad initialisation file: " + (String)stringArray2);
                        Err.prln(malformedURLException);
                        System.exit(1);
                    }
                    Gate.setSiteConfigFile(file);
                    Out.prln("Initialisation file " + (String)stringArray2 + " recorded for initialisation");
                    continue block11;
                }
                case 63: {
                    return;
                }
            }
            Err.prln("getopt() returned " + n + "\n");
        }
        stringArray2 = new String[]{"-noloading", "gate.TestGate"};
        if (bl) {
            TestRunner.main((String[])stringArray2);
        } else if (bl2) {
            stringArray2[0] = "gate.TestGate";
            stringArray2[1] = "";
            serializable = null;
            serializable = Class.forName("oracle.jdbc.driver.OracleDriver");
            serializable = null;
            junit.swingui.TestRunner.main((String[])stringArray2);
        } else {
            junit.swingui.TestRunner.main((String[])stringArray2);
        }
    }

    public static Test suite() throws Exception {
        Serializable serializable;
        Object object;
        String string;
        try {
            string = System.getProperty("gate.config");
            if (string != null && string.length() > 0) {
                object = new File(string);
                try {
                    serializable = ((File)object).toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    Err.prln("Bad initialisation file: " + string);
                    Err.prln(malformedURLException);
                    System.exit(1);
                }
                Gate.setSiteConfigFile((File)object);
            }
            Gate.init();
        }
        catch (GateException gateException) {
            Out.prln("can't initialise GATE library! exception = " + gateException);
            throw gateException;
        }
        string = new TestSuite();
        try {
            object = System.getProperty("gate.testcase");
            if (object != null) {
                serializable = Class.forName((String)object);
                Method method = ((Class)serializable).getMethod("suite", new Class[0]);
                Test test = (Test)method.invoke(null, new Object[0]);
                string.addTest(test);
            } else {
                string.addTest(TestAnnic.suite());
                string.addTest(TestIndex.suite());
                string.addTest(TestPersist.suite());
                string.addTest(TestControllers.suite());
                string.addTest(TestConfig.suite());
                string.addTest(TestAnnotation.suite());
                string.addTest(TestEmail.suite());
                string.addTest(TestXml.suite());
                string.addTest(TestHtml.suite());
                string.addTest(TestSgml.suite());
                string.addTest(TestXSchema.suite());
                string.addTest(TestCreole.suite());
                string.addTest(CookBook.suite());
                string.addTest(TestFiles.suite());
                string.addTest(TestJavac.suite());
                string.addTest(TestReload.suite());
                string.addTest(TestJape.suite());
                string.addTest(TestTemplate.suite());
                string.addTest(TestDocument.suite());
                string.addTest(TestDocumentStaxUtils.suite());
                string.addTest(TestRBTreeMap.suite());
                string.addTest(TestCorpus.suite());
                string.addTest(TestSerialCorpus.suite());
                string.addTest(TestDiffer.suite());
                string.addTest(TestAnnotationMerging.suite());
                string.addTest(TestClassificationMeasures.suite());
                string.addTest(TestGazetteer.suite());
                string.addTest(TestFeatureMap.suite());
                string.addTest(TestTools.suite());
                string.addTest(TestCreoleAnnotationHandler.suite());
                string.addTest(TestPR.suite());
                string.addTest(TestMorph.suite());
                string.addTest(TestHashGazetteer.suite());
                string.addTest(TestRepositioningInfo.suite());
                string.addTest(TestFlexibleGazetteer.suite());
                string.addTest(DynamicRegistrationTest.suite());
            }
        }
        catch (Exception exception) {
            Out.prln("can't add tests! exception = " + exception);
            throw exception;
        }
        return string;
    }
}

