/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.CreoleRegister;
import gate.Gate;
import gate.gui.MainFrame;
import gate.gui.OptionsDialog;
import gate.gui.ShellSlacFrame;
import gate.gui.Splash;
import gate.gui.UserGroupEditor;
import gate.util.BomStrippingInputStreamReader;
import gate.util.CorpusBenchmarkTool;
import gate.util.Err;
import gate.util.Files;
import gate.util.GateException;
import gate.util.OptionsMap;
import gate.util.Out;
import gate.util.Strings;
import gate.util.persistence.PersistenceManager;
import gnu.getopt.Getopt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Main {
    private static final boolean DEBUG = false;
    private static final int STATUS_NORMAL = 0;
    private static final int STATUS_ERROR = 1;
    private static MainFrame frame;
    private static Splash splash;
    private static String collName;
    private static String creolePath;
    private static List fileNames;
    private static List annotatorNames;
    private static Map annotatorArgsMap;
    private static List debugNames;
    public static boolean batchMode;
    public static boolean dbAdminMode;
    private static boolean destroyColl;
    private static boolean verbose;
    private static boolean runCorpusBenchmarkTool;
    public static String name;
    public static String version;
    public static String build;
    private static List<URL> pendingCreoleUrls;

    public static void main(String[] stringArray) throws GateException {
        annotatorArgsMap = null;
        if (System.getProperty("java.version").compareTo(Gate.getMinJdkVersion()) < 0) {
            throw new GateException("GATE requires JDK " + Gate.getMinJdkVersion() + " or newer");
        }
        Main.processArgs(stringArray);
        Gate.setNetConnected(false);
        Gate.setLocalWebServer(false);
        if (batchMode) {
            Main.batchProcess();
        } else if (dbAdminMode) {
            Main.dbAdmin();
        } else {
            Main.runGui();
        }
    }

    private static void registerCreoleUrls() {
        CreoleRegister creoleRegister = Gate.getCreoleRegister();
        for (URL uRL : pendingCreoleUrls) {
            try {
                creoleRegister.registerDirectories(uRL);
            }
            catch (GateException gateException) {
                Err.prln("Couldn't register CREOLE directory: " + uRL);
                Err.prln(gateException);
                System.exit(1);
            }
        }
    }

    public static MainFrame getMainFrame() throws GateException {
        if (frame == null) {
            Main.runGui();
        }
        return frame;
    }

    private static void runGui() throws GateException {
        block4: {
            try {
                Class<?> clazz = Gate.class.getClassLoader().loadClass("org.jdesktop.swinghelper.debug.CheckThreadViolationRepaintManager");
                RepaintManager.setCurrentManager((RepaintManager)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.currentThread().setPriority(1);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new GridBagLayout());
                    jPanel.setBackground(Color.white);
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.insets = new Insets(2, 2, 2, 2);
                    String string = System.getProperty("gate.slug.splash");
                    if (string == null) {
                        string = "splash";
                    }
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.anchor = 10;
                    gridBagConstraints.gridy = 1;
                    gridBagConstraints.gridwidth = 1;
                    JLabel jLabel = new JLabel(MainFrame.getIcon(string));
                    jPanel.add((Component)jLabel, gridBagConstraints);
                    GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                    Main.splash = new Splash(null, graphicsConfiguration, jPanel);
                    splash.showSplash();
                }
            });
            try {
                Gate.init();
            }
            catch (Throwable throwable) {
                int n = JOptionPane.showOptionDialog(null, "Error during initialisation:\n" + throwable.toString() + "\nDo you still want to start GATE?", "GATE", 0, 0, null, new String[]{"Cancel", "Start anyway"}, "Cancel");
                if (n == 1) break block4;
                throwable.printStackTrace();
                System.exit(1);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                Main.applyUserPreferences();
                if (Gate.isSlugGui()) {
                    frame = new ShellSlacFrame();
                } else {
                    frame = new MainFrame(graphicsConfiguration);
                }
                frame.setTitleChangable(true);
                if (Gate.isSlugGui()) {
                    frame.setTitle("SLUG application");
                } else {
                    frame.setTitle(name + " " + version + " build " + build);
                }
                String string = System.getProperty("gate.slug.title");
                if (string != null) {
                    frame.setTitle(string);
                }
                frame.setTitleChangable(false);
                String string2 = System.getProperty("gate.slug.icon");
                if (string2 != null) {
                    try {
                        frame.setIconImage(Toolkit.getDefaultToolkit().getImage(new URL(string2)));
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace(Err.getPrintWriter());
                    }
                }
                frame.validate();
                Rectangle rectangle = graphicsConfiguration.getBounds();
                Dimension dimension = rectangle.getSize();
                Dimension dimension2 = frame.getSize();
                if (dimension2.height > dimension.height) {
                    dimension2.height = dimension.height;
                }
                if (dimension2.width > dimension.width) {
                    dimension2.width = dimension.width;
                }
                frame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
                frame.setVisible(true);
                if (splash != null) {
                    splash.setVisible(false);
                    splash.dispose();
                }
                if (!Gate.isSlugGui()) {
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                File file = Gate.getUserSessionFile();
                                if (file.exists()) {
                                    MainFrame.lockGUI("Loading saved session...");
                                    PersistenceManager.loadObjectFromFile(file);
                                }
                            }
                            catch (Exception exception) {
                                Err.prln("Failed to load session data:");
                                exception.printStackTrace(Err.getPrintWriter());
                            }
                            finally {
                                MainFrame.unlockGUI();
                            }
                        }
                    };
                    Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Session loader");
                    thread.setPriority(1);
                    thread.start();
                }
            }
        });
        Main.registerCreoleUrls();
    }

    private static void dbAdmin() throws GateException {
        try {
            UserGroupEditor.main(null);
        }
        catch (Exception exception) {
            throw new GateException(exception);
        }
    }

    public static void applyUserPreferences() {
        String string;
        String string2 = Gate.getUserConfig().getString("Look_and_Feel");
        if (string2 == null) {
            string2 = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1 ? UIManager.getCrossPlatformLookAndFeelClassName() : UIManager.getSystemLookAndFeelClassName();
            Gate.getUserConfig().put((Object)"Look_and_Feel", string2);
        }
        try {
            UIManager.setLookAndFeel(string2);
        }
        catch (Exception exception) {
            System.err.print("Could not set your preferred Look and Feel. The error was:\n" + exception.toString() + "\nReverting to using Java Look and Feel");
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exception2) {
                System.err.print("Could not set the cross-platform Look and Feel either. The error was:\n" + exception2.toString() + "\nGiving up on Look and Feel.");
            }
        }
        OptionsMap optionsMap = Gate.getUserConfig();
        Font font = optionsMap.getFont("Text_components_font");
        if (font == null) {
            string = Gate.guessUnicodeFont();
            font = string != null ? new Font(string, 0, 12) : UIManager.getFont("TextPane.font");
        }
        if (font != null) {
            OptionsDialog.setTextComponentsFont(font);
        }
        if ((font = optionsMap.getFont("Menus_font")) == null) {
            string = Gate.guessUnicodeFont();
            font = string != null ? new Font(string, 0, 12) : UIManager.getFont("Menu.font");
        }
        if (font != null) {
            OptionsDialog.setMenuComponentsFont(font);
        }
        if ((font = optionsMap.getFont("Other_components_font")) == null) {
            string = Gate.guessUnicodeFont();
            font = string != null ? new Font(string, 0, 12) : UIManager.getFont("Button.font");
        }
        if (font != null) {
            OptionsDialog.setComponentsFont(font);
        }
    }

    public static void processArgs(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("GATE main", stringArray, "hd:ei:asj");
        block15: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 97: {
                    dbAdminMode = true;
                    continue block15;
                }
                case 104: {
                    Main.help();
                    Main.usage();
                    System.exit(0);
                    continue block15;
                }
                case 100: {
                    String string = getopt.getOptarg();
                    URL uRL = null;
                    try {
                        uRL = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Err.prln("Bad URL: " + string);
                        Err.prln(malformedURLException);
                        System.exit(1);
                    }
                    pendingCreoleUrls.add(uRL);
                    Out.prln("CREOLE Directory " + string + " queued for registration");
                    continue block15;
                }
                case 105: {
                    String string = getopt.getOptarg();
                    URL uRL = null;
                    File file = new File(string);
                    try {
                        uRL = file.toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        Err.prln("Bad initialisation file: " + string);
                        Err.prln(malformedURLException);
                        System.exit(1);
                    }
                    Gate.setSiteConfigFile(file);
                    continue block15;
                }
                case 101: {
                    try {
                        CorpusBenchmarkTool.main(stringArray);
                    }
                    catch (GateException gateException) {
                        Out.prln("Error running the evaluation tool: " + gateException.getMessage());
                        System.exit(-1);
                    }
                    continue block15;
                }
                case 115: {
                    Gate.setSlugGui(true);
                    continue block15;
                }
                case 63: {
                    System.exit(1);
                    continue block15;
                }
            }
            Err.prln("getopt() returned " + n + "\n");
            System.exit(1);
        }
    }

    private static void batchProcess() throws GateException {
        Gate.init();
        Main.registerCreoleUrls();
    }

    public static void usage() {
        Out.prln("Usage: java gate.Main [ -h [-d CREOLE-URL]");
    }

    public static void help() {
        String string = Strings.getNl();
        Out.prln("For help on command-line options and other information " + string + "see the user manual in your GATE distribution or at " + string + "http://gate.ac.uk/userguide/");
    }

    static {
        BomStrippingInputStreamReader bomStrippingInputStreamReader;
        InputStream inputStream;
        try {
            inputStream = Files.getGateResourceAsStream("version.txt");
            if (inputStream == null) {
                throw new IOException();
            }
            bomStrippingInputStreamReader = new BomStrippingInputStreamReader(inputStream, "UTF-8");
            version = ((BufferedReader)bomStrippingInputStreamReader).readLine();
        }
        catch (IOException iOException) {
            version = "5.0";
        }
        try {
            inputStream = Files.getGateResourceAsStream("build.txt");
            if (inputStream == null) {
                throw new IOException();
            }
            bomStrippingInputStreamReader = new BomStrippingInputStreamReader(inputStream, "UTF-8");
            build = ((BufferedReader)bomStrippingInputStreamReader).readLine();
        }
        catch (IOException iOException) {
            build = "0000";
        }
        fileNames = new ArrayList();
        annotatorNames = new ArrayList();
        annotatorArgsMap = new HashMap();
        debugNames = new ArrayList();
        batchMode = false;
        dbAdminMode = false;
        destroyColl = false;
        verbose = false;
        runCorpusBenchmarkTool = false;
        name = "GATE Developer";
        pendingCreoleUrls = new ArrayList<URL>();
    }
}

