/*
 * Decompiled with CFR 0.152.
 */
package gate.wordnet;

import gate.wordnet.LexicalRelation;
import gate.wordnet.LexicalRelationImpl;
import gate.wordnet.Synset;
import gate.wordnet.SynsetImpl;
import gate.wordnet.WNHelper;
import gate.wordnet.Word;
import gate.wordnet.WordImpl;
import gate.wordnet.WordNetException;
import gate.wordnet.WordSense;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.dictionary.Dictionary;

public class WordSenseImpl
implements WordSense {
    private Word word;
    private Synset synset;
    private int senseNumber;
    private int orderInSynset;
    private boolean isSemcor;
    private List lexRelations;
    private Dictionary wnDictionary;

    public WordSenseImpl(Word word, Synset synset, int n, int n2, boolean bl, Dictionary dictionary) {
        Assert.assertNotNull((Object)word);
        Assert.assertNotNull((Object)synset);
        Assert.assertNotNull((Object)dictionary);
        this.word = word;
        this.synset = synset;
        this.senseNumber = n;
        this.orderInSynset = n2;
        this.isSemcor = bl;
        this.wnDictionary = dictionary;
    }

    public Word getWord() {
        return this.word;
    }

    public int getPOS() {
        return this.synset.getPOS();
    }

    public Synset getSynset() {
        return this.synset;
    }

    public int getSenseNumber() {
        return this.senseNumber;
    }

    public int getOrderInSynset() {
        return this.orderInSynset;
    }

    public boolean isSemcor() {
        return this.isSemcor;
    }

    public List getLexicalRelations() throws WordNetException {
        if (null == this.lexRelations) {
            this._loadLexicalRelations();
        }
        return this.lexRelations;
    }

    public List getLexicalRelations(int n) throws WordNetException {
        ArrayList<LexicalRelation> arrayList = new ArrayList<LexicalRelation>(1);
        if (null == this.lexRelations) {
            this._loadLexicalRelations();
        }
        for (LexicalRelation lexicalRelation : this.lexRelations) {
            Assert.assertNotNull((Object)lexicalRelation);
            if (n != lexicalRelation.getType()) continue;
            arrayList.add(lexicalRelation);
        }
        return arrayList;
    }

    private void _loadLexicalRelations() throws WordNetException {
        POS pOS = null;
        pOS = WNHelper.int2POS(this.getPOS());
        try {
            net.didion.jwnl.data.Word word;
            int n;
            net.didion.jwnl.data.Synset synset = this.wnDictionary.getSynsetAt(pOS, this.synset.getOffset());
            Assert.assertNotNull((Object)synset);
            Pointer[] pointerArray = null;
            net.didion.jwnl.data.Word[] wordArray = synset.getWords();
            for (n = 0; n < wordArray.length; ++n) {
                word = wordArray[n];
                if (!word.getLemma().equalsIgnoreCase(this.getWord().getLemma())) continue;
                pointerArray = word.getPointers();
                break;
            }
            this.lexRelations = new ArrayList(pointerArray.length);
            for (n = 0; n < pointerArray.length; ++n) {
                word = pointerArray[n];
                if (!word.isLexical()) continue;
                PointerType pointerType = word.getType();
                PointerTarget pointerTarget = word.getTarget();
                Assert.assertTrue((boolean)(pointerTarget instanceof net.didion.jwnl.data.Word));
                net.didion.jwnl.data.Word word2 = (net.didion.jwnl.data.Word)pointerTarget;
                net.didion.jwnl.data.Synset synset2 = word2.getSynset();
                IndexWord indexWord = this.wnDictionary.lookupIndexWord(word2.getPOS(), word2.getLemma());
                SynsetImpl synsetImpl = new SynsetImpl(synset2, this.wnDictionary);
                WordImpl wordImpl = new WordImpl(word2.getLemma(), indexWord.getSenseCount(), this.wnDictionary);
                WordSenseImpl wordSenseImpl = new WordSenseImpl(wordImpl, synsetImpl, 0, word2.getIndex(), false, this.wnDictionary);
                LexicalRelationImpl lexicalRelationImpl = new LexicalRelationImpl(WNHelper.PointerType2int(pointerType), this, wordSenseImpl);
                this.lexRelations.add(lexicalRelationImpl);
            }
        }
        catch (JWNLException jWNLException) {
            throw new WordNetException(jWNLException);
        }
    }
}

