/*
 * Decompiled with CFR 0.152.
 */
package gate.util.spring;

import gate.Factory;
import gate.Resource;
import gate.creole.ResourceInstantiationException;
import gate.util.GateException;
import gate.util.persistence.PersistenceManager;
import gate.util.spring.GateAwareObject;
import gate.util.spring.ResourceCustomiser;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavedApplicationFactoryBean
extends GateAwareObject
implements FactoryBean,
DisposableBean {
    private org.springframework.core.io.Resource location;
    private List<ResourceCustomiser> customisers;
    private Object object = null;

    public void setLocation(org.springframework.core.io.Resource resource) {
        this.location = resource;
    }

    public void setCustomisers(List<ResourceCustomiser> list) {
        this.customisers = list;
    }

    public Object getObject() throws GateException, IOException {
        if (this.object == null) {
            this.ensureGateInit();
            File file = null;
            try {
                file = this.location.getFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.object = file == null ? PersistenceManager.loadObjectFromUrl(this.location.getURL()) : PersistenceManager.loadObjectFromFile(file);
            if (this.customisers != null) {
                for (ResourceCustomiser resourceCustomiser : this.customisers) {
                    try {
                        resourceCustomiser.customiseResource((Resource)this.object);
                    }
                    catch (GateException gateException) {
                        throw gateException;
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new ResourceInstantiationException("Exception in resource customiser", exception);
                    }
                }
            }
        }
        return this.object;
    }

    public Class getObjectType() {
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.object != null && this.object instanceof Resource) {
            Factory.deleteResource((Resource)this.object);
        }
    }
}

