/*
 * Decompiled with CFR 0.152.
 */
package gate.util.spring;

import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.util.spring.GateAwareObject;
import gate.util.spring.ResourceCustomiser;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateResourceFactoryBean
extends GateAwareObject
implements FactoryBean,
DisposableBean {
    private String resourceClass;
    private String resourceName;
    private FeatureMap parameters;
    private FeatureMap features;
    private List<ResourceCustomiser> customisers;
    private Resource object;

    public Object getObject() throws Exception {
        if (this.object == null) {
            this.ensureGateInit();
            if (this.parameters == null) {
                this.parameters = Factory.newFeatureMap();
            }
            if (this.features == null) {
                this.features = Factory.newFeatureMap();
            }
            this.object = this.resourceName == null ? Factory.createResource(this.resourceClass, this.parameters, this.features) : Factory.createResource(this.resourceClass, this.parameters, this.features, this.resourceName);
            if (this.customisers != null) {
                for (ResourceCustomiser resourceCustomiser : this.customisers) {
                    resourceCustomiser.customiseResource(this.object);
                }
            }
        }
        return this.object;
    }

    public Class getObjectType() {
        if (this.object != null) {
            return this.object.getClass();
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.object != null) {
            Factory.deleteResource(this.object);
        }
    }

    public void setResourceClass(String string) {
        this.resourceClass = string;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
    }

    public void setParameters(FeatureMap featureMap) {
        this.parameters = featureMap;
    }

    public void setFeatures(FeatureMap featureMap) {
        this.features = featureMap;
    }

    public void setCustomisers(List<ResourceCustomiser> list) {
        this.customisers = list;
    }
}

