/*
 * Decompiled with CFR 0.152.
 */
package gate.util.spring;

import gate.Factory;
import gate.FeatureMap;
import gate.util.spring.GateAwareObject;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureMapFactoryBean
extends GateAwareObject
implements FactoryBean {
    private Map<Object, Object> sourceMap;

    public void setSourceMap(Map<Object, Object> map) {
        this.sourceMap = map;
    }

    public Object getObject() throws IOException {
        this.ensureGateInit();
        FeatureMap featureMap = Factory.newFeatureMap();
        if (this.sourceMap != null) {
            for (Map.Entry<Object, Object> entry : this.sourceMap.entrySet()) {
                Object object = entry.getKey();
                Object object2 = entry.getValue();
                if (object2 instanceof Resource) {
                    File file = null;
                    try {
                        file = ((Resource)object2).getFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    object2 = file == null ? ((Resource)object2).getURL() : file.toURI().toURL();
                }
                featureMap.put(object, object2);
            }
        }
        return featureMap;
    }

    public Class getObjectType() {
        return FeatureMap.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

