/*
 * Decompiled with CFR 0.152.
 */
package gate.util.reporting;

import gate.util.reporting.BenchmarkReportable;
import gate.util.reporting.FileWatcher;
import gate.util.reporting.ValueComparator;
import gate.util.reporting.exceptions.BenchmarkReportExecutionException;
import gate.util.reporting.exceptions.BenchmarkReportInputFileFormatException;
import gnu.getopt.Getopt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PRTimeReporter
implements BenchmarkReportable {
    public static final String MEDIA_TEXT = "text";
    public static final String MEDIA_HTML = "html";
    public static final String SORT_EXEC_ORDER = "exec_order";
    public static final String SORT_TIME_TAKEN = "time_taken";
    private Hashtable<String, String> globalTotal = new Hashtable();
    private ArrayList<String> printLines = new ArrayList();
    private static final String NL = System.getProperty("line.separator");
    private String htmlElementTree = "<td rowspan=\"112\" width=\"550\">" + NL + "<div id=\"treemenu\" style=\"margin: 0;\">" + NL + "<ul id=\"tree\" style=\"margin-left: 0;\">" + NL;
    private String htmlTimeTree = "<td rowspan=\"112\" width=\"100\">" + NL + "<div style=\"margin-top: 0;\"><div>" + NL;
    private String htmlTimeInPercentTree = "<td rowspan=\"112\" width=\"100\">" + NL + "<div style=\"margin-top: 0;\"><div>" + NL;
    private int level = 1;
    private double globalValue = 0.0;
    private static final int STATUS_NORMAL = 0;
    private static final int STATUS_ERROR = 1;
    public int validEntries = 0;
    private static final int FILE_CHUNK_SIZE = 2000;
    public HashSet<String> pipelineNames = new HashSet();
    private File benchmarkFile = new File("benchmark.txt");
    private boolean suppressZeroTimeEntries = true;
    private String printMedia = "html";
    private String sortOrder = "exec_order";
    private File reportFile;
    private String logicalStart = null;

    public PRTimeReporter() {
    }

    PRTimeReporter(String[] stringArray) {
        this.parseArguments(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object store(File file) throws BenchmarkReportInputFileFormatException {
        LinkedHashMap<String, Object> linkedHashMap;
        block19: {
            String string;
            linkedHashMap = new LinkedHashMap<String, Object>();
            long l = 0L;
            RandomAccessFile randomAccessFile = null;
            if (this.getLogicalStart() != null) {
                l = this.tail(file, 2000);
            }
            randomAccessFile = new RandomAccessFile(file, "r");
            if (this.getLogicalStart() != null) {
                randomAccessFile.seek(l);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = null;
            Pattern pattern = Pattern.compile("(\\d+) (\\d+) (.*) (.*) \\{(.*)\\}");
            while ((string = randomAccessFile.readLine()) != null) {
                String[] stringArray;
                Matcher matcher = pattern.matcher(string);
                if (string.matches(".*documentLoaded.*")) continue;
                if (string.matches(".*START.*")) {
                    String string3;
                    stringArray = string.split("\\s");
                    String string4 = string3 = stringArray.length > 2 ? stringArray[2] : null;
                    if (string3 == null) {
                        throw new BenchmarkReportInputFileFormatException(this.getBenchmarkFile().getAbsolutePath() + " is invalid.");
                    }
                    arrayList.add(string3);
                    if (string3.endsWith("Start")) continue;
                    this.organizeEntries(linkedHashMap, string3.split("\\."), "0");
                }
                if (matcher == null || !matcher.matches() || !this.validateLogEntry(matcher.group(3), arrayList)) continue;
                stringArray = matcher.group(3).split("\\.");
                if (stringArray.length > 1) {
                    string2 = stringArray[1];
                    this.pipelineNames.add(stringArray[0]);
                }
                this.organizeEntries(linkedHashMap, matcher.group(3).replaceFirst(string2 + ".", "").split("\\."), matcher.group(2));
            }
            Object var14_13 = null;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                break block19;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                linkedHashMap = null;
            }
            break block19;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    linkedHashMap = null;
                    Object var14_14 = null;
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                        linkedHashMap = null;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    linkedHashMap = null;
                }
                throw throwable;
            }
        }
        if (this.validEntries == 0) {
            if (this.logicalStart != null) {
                throw new BenchmarkReportInputFileFormatException("No valid log entries present in " + this.getBenchmarkFile().getAbsolutePath() + " does not contain a marker named " + this.logicalStart + ".");
            }
            throw new BenchmarkReportInputFileFormatException("No valid log entries present in " + this.getBenchmarkFile().getAbsolutePath());
        }
        return linkedHashMap;
    }

    private void organizeEntries(LinkedHashMap<String, Object> linkedHashMap, String[] stringArray, String string) {
        if (stringArray.length > 0 && linkedHashMap.containsKey(stringArray[0])) {
            if (stringArray.length > 1) {
                String[] stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
                if (linkedHashMap.get(stringArray[0]) instanceof LinkedHashMap) {
                    this.organizeEntries((LinkedHashMap)linkedHashMap.get(stringArray[0]), stringArray2, string);
                } else if (linkedHashMap.get(stringArray[0]) != null) {
                    linkedHashMap.put(stringArray[0], new LinkedHashMap());
                } else {
                    linkedHashMap.put(stringArray[0], string);
                }
            } else if (linkedHashMap.get(stringArray[0]) != null) {
                if (!(linkedHashMap.get(stringArray[0]) instanceof LinkedHashMap)) {
                    int n = Integer.parseInt((String)linkedHashMap.get(stringArray[0])) + Integer.parseInt(string);
                    linkedHashMap.put(stringArray[0], Integer.toString(n));
                } else {
                    int n = Integer.parseInt(string);
                    if (((LinkedHashMap)linkedHashMap.get(stringArray[0])).get("systotal") != null) {
                        n += Integer.parseInt((String)((LinkedHashMap)linkedHashMap.get(stringArray[0])).get("systotal"));
                    }
                    ((LinkedHashMap)linkedHashMap.get(stringArray[0])).put("systotal", Integer.toString(n));
                }
            }
        } else if (stringArray.length - 1 == 0) {
            linkedHashMap.put(stringArray[0], string);
        } else {
            linkedHashMap.put(stringArray[0], new LinkedHashMap());
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray.length - 1);
            this.organizeEntries((LinkedHashMap)linkedHashMap.get(stringArray[0]), stringArray3, string);
        }
    }

    private LinkedHashMap<String, Object> sortReport(LinkedHashMap<String, Object> linkedHashMap) {
        Object object;
        Iterator<String> iterator = linkedHashMap.keySet().iterator();
        LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, LinkedHashMap<String, Object>> linkedHashMap3 = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        LinkedHashMap<String, String> linkedHashMap4 = new LinkedHashMap<String, String>();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (linkedHashMap.get(object) instanceof LinkedHashMap) {
                int n = 0;
                if (((LinkedHashMap)linkedHashMap.get(object)).get("systotal") != null) {
                    n = Integer.parseInt((String)((LinkedHashMap)linkedHashMap.get(object)).get("systotal"));
                }
                if (n >= 0) {
                    linkedHashMap4.put((String)object, Integer.toString(n));
                }
                linkedHashMap3.put((String)object, this.sortReport((LinkedHashMap)linkedHashMap.get(object)));
                continue;
            }
            if (object.equals("total") || object.equals("systotal") || Integer.parseInt((String)linkedHashMap.get(object)) < 0) continue;
            linkedHashMap4.put((String)object, new Integer((String)linkedHashMap.get(object)).toString());
        }
        object = this.sortHashMapByValues(linkedHashMap4);
        for (Object k : ((LinkedHashMap)object).keySet()) {
            linkedHashMap2.put((String)k, ((LinkedHashMap)object).get(k));
            if (!linkedHashMap3.containsKey(k)) continue;
            linkedHashMap2.put((String)k, linkedHashMap3.get((String)k));
        }
        linkedHashMap2.put("total", linkedHashMap.get("total"));
        if (linkedHashMap.get("systotal") != null) {
            linkedHashMap2.put("systotal", linkedHashMap.get("systotal"));
        }
        return linkedHashMap2;
    }

    private LinkedHashMap sortHashMapByValues(LinkedHashMap linkedHashMap) {
        ArrayList arrayList = new ArrayList(linkedHashMap.keySet());
        ArrayList arrayList2 = new ArrayList(linkedHashMap.values());
        Collections.sort(arrayList2, new ValueComparator());
        Collections.sort(arrayList);
        Collections.reverse(arrayList2);
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        block0: for (Object e : arrayList2) {
            for (Object e2 : arrayList) {
                String string;
                String string2 = linkedHashMap.get(e2).toString();
                if (!string2.equals(string = e.toString())) continue;
                linkedHashMap.remove(e2);
                arrayList.remove(e2);
                linkedHashMap2.put(e2, e);
                continue block0;
            }
        }
        return linkedHashMap2;
    }

    @Override
    public Object calculate(Object object) {
        LinkedHashMap linkedHashMap = (LinkedHashMap)object;
        Iterator iterator = linkedHashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            n = this.getTotal((LinkedHashMap)linkedHashMap.get(string));
            this.globalTotal.put(string, Integer.toString(n));
        }
        return linkedHashMap;
    }

    private int getTotal(LinkedHashMap<String, Object> linkedHashMap) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (String string : linkedHashMap.keySet()) {
            if (linkedHashMap.get(string) instanceof LinkedHashMap) {
                n4 = this.getTotal((LinkedHashMap)linkedHashMap.get(string));
                n += n4;
                continue;
            }
            if (string.equals("systotal")) continue;
            n += Integer.parseInt((String)linkedHashMap.get(string));
        }
        if (linkedHashMap.get("systotal") != null) {
            n3 = Integer.parseInt((String)linkedHashMap.get("systotal"));
        }
        n2 = n3 - n;
        linkedHashMap.put("total", Integer.toString(n));
        linkedHashMap.put("All others", Integer.toString(n2));
        return n += n2;
    }

    @Override
    public void printReport(Object object, File file) {
        if (this.printMedia.equalsIgnoreCase(MEDIA_TEXT)) {
            this.printToText(object, file, this.suppressZeroTimeEntries);
        } else if (this.printMedia.equalsIgnoreCase(MEDIA_HTML)) {
            this.printToHTML((LinkedHashMap)object, file, this.suppressZeroTimeEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void printToText(Object object, File file, boolean bl) {
        block12: {
            LinkedHashMap linkedHashMap = (LinkedHashMap)object;
            this.prettyPrint(linkedHashMap, "\t", bl);
            BufferedWriter bufferedWriter = null;
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (String string : this.printLines) {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            Object var9_9 = null;
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                break block12;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block12;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var9_10 = null;
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        break block12;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private void prettyPrint(LinkedHashMap<String, Object> linkedHashMap, String string, boolean bl) {
        for (String string2 : linkedHashMap.keySet()) {
            if (this.globalTotal.containsKey(string2)) {
                this.globalValue = Integer.parseInt(this.globalTotal.get(string2));
            }
            if (linkedHashMap.get(string2) instanceof LinkedHashMap) {
                int n = 0;
                if (((LinkedHashMap)linkedHashMap.get(string2)).containsKey("systotal")) {
                    n = Integer.parseInt((String)((LinkedHashMap)linkedHashMap.get(string2)).get("systotal"));
                }
                if (bl) {
                    if (n > 0) {
                        this.printLines.add(string + string2 + " (" + (double)n / 1000.0 + ") [" + (double)Math.round((double)n / this.globalValue * 100.0 * 10.0) / 10.0 + "%]");
                    }
                } else {
                    this.printLines.add(string + string2 + " (" + (double)n / 1000.0 + ") [" + (double)Math.round((double)n / this.globalValue * 100.0 * 10.0) / 10.0 + "%]");
                }
                this.prettyPrint((LinkedHashMap)linkedHashMap.get(string2), string + "\t", bl);
                continue;
            }
            if (string2.equals("total") || string2.equals("systotal")) continue;
            if (bl) {
                if (Integer.parseInt((String)linkedHashMap.get(string2)) == 0) continue;
                this.printLines.add(string + string2 + " (" + (double)Integer.parseInt((String)linkedHashMap.get(string2)) / 1000.0 + ") [" + (double)Math.round((double)Integer.parseInt((String)linkedHashMap.get(string2)) / this.globalValue * 100.0 * 10.0) / 10.0 + "%]");
                continue;
            }
            this.printLines.add(string + string2 + " (" + (double)Integer.parseInt((String)linkedHashMap.get(string2)) / 1000.0 + ") [" + (double)Math.round((double)Integer.parseInt((String)linkedHashMap.get(string2)) / this.globalValue * 100.0 * 10.0) / 10.0 + "%]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void printToHTML(LinkedHashMap<String, Object> linkedHashMap, File file, boolean bl) {
        block12: {
            Object object2;
            String string = "<ul>";
            for (Object object2 : this.pipelineNames) {
                string = string + "<li><b>" + (String)object2 + "</b></li>" + NL;
            }
            string = string + "</ul>" + NL;
            Object object3 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"" + NL + "\"http://www.w3.org/TR/html4/loose.dtd\">" + NL + "<html><head><title>Benchmarking Report</title>" + NL + "<meta http-equiv=\"Content-Type\"" + " content=\"text/html; charset=utf-8\">" + NL + "<style type=\"text/css\">" + NL + "#treemenu li { list-style: none; }" + NL + "#treemenu li A { font-family: monospace; text-decoration: none; }" + NL + "</style>" + NL + "<script type=\"text/javascript\" language=\"javascript\">" + NL + "function expandCollapseTree(obj){" + NL + "  var li = obj.parentNode;" + NL + "  var uls = li.getElementsByTagName('ul');" + NL + "  var id = li.id;" + NL + "  var ul = uls[0];" + NL + "  var objTimeBranch = document.getElementById(id + '.1');" + NL + "  var divs = objTimeBranch.getElementsByTagName('div');" + NL + "  var div = divs[0];" + NL + "  var objperBranch = document.getElementById(id + '.2');" + NL + "  var perdivs = objperBranch.getElementsByTagName('div');" + NL + "  var perdiv = perdivs[0];" + NL + NL + "  if (ul.style.display == 'none' || ul.style.display == '') {" + NL + "    ul.style.display = 'block';" + NL + "    obj.innerHTML = '[&mdash;]';" + NL + "  } else {" + NL + "    ul.style.display = 'none';" + NL + "    obj.innerHTML = '[+]';" + NL + "  }" + NL + "  if (div.style.display == 'block') {" + NL + "    div.style.display = 'none';" + NL + "  } else {" + NL + "    div.style.display = 'block';" + NL + "  }" + NL + "  if (perdiv.style.display == 'block') {" + NL + "    perdiv.style.display = 'none';" + NL + "  } else {" + NL + "    perdiv.style.display = 'block';" + NL + "  }" + NL + "}" + NL + NL + "</script>" + NL + "</head>" + NL + "<body style=\"font-family:Verdana; color:navy;\">" + NL + "<table><tr bgcolor=\"#eeeeff\">" + NL + "<td><b>Processing elements of following pipelines</b>" + NL + string + NL + "</td>" + NL + "<td><b>Time in seconds</b></td>" + NL + "<td><b>% time taken</b></td></tr><tr>";
            this.generateCollapsibleHTMLTree(linkedHashMap, bl);
            this.htmlElementTree = this.htmlElementTree + "</ul></div></td>" + NL;
            this.htmlTimeTree = this.htmlTimeTree + "</div></div></td>" + NL;
            this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "</div></div></td>" + NL;
            object3 = (String)object3 + this.htmlElementTree + this.htmlTimeTree + this.htmlTimeInPercentTree + "</tr></table>" + NL + "</body></html>";
            Object object2 = null;
            object2 = new BufferedWriter(new FileWriter(file));
            ((Writer)object2).write((String)object3);
            Object var9_7 = null;
            try {
                if (object2 != null) {
                    ((BufferedWriter)object2).close();
                }
                break block12;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block12;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var9_8 = null;
                    try {
                        if (object2 != null) {
                            ((BufferedWriter)object2).close();
                        }
                        break block12;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (object2 != null) {
                        ((BufferedWriter)object2).close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private void generateCollapsibleHTMLTree(LinkedHashMap<String, Object> linkedHashMap, boolean bl) {
        for (String string : linkedHashMap.keySet()) {
            if (this.globalTotal.containsKey(string)) {
                this.globalValue = Integer.parseInt(this.globalTotal.get(string));
            }
            if (linkedHashMap.get(string) instanceof LinkedHashMap) {
                int n = 0;
                if (((LinkedHashMap)linkedHashMap.get(string)).containsKey("systotal")) {
                    n = Integer.parseInt((String)((LinkedHashMap)linkedHashMap.get(string)).get("systotal"));
                }
                if (bl) {
                    if (n <= 0) continue;
                    this.htmlElementTree = this.htmlElementTree + "<li id=\"level" + this.level + "\">" + "<a href=\"#\"  onclick=\"expandCollapseTree(this)\">[+]</a>" + "&nbsp;" + string + "<ul style=\"display:none\">" + NL;
                    this.htmlTimeTree = this.htmlTimeTree + "<div id=level" + this.level + ".1>" + NL + (double)n / 1000.0 + NL + "<div style=\"display:none\">" + NL;
                    this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "<div id=level" + this.level + ".2>" + NL + (double)Math.round((double)n / this.globalValue * 100.0 * 10.0) / 10.0 + "<div style=\"display:none\">" + NL;
                    ++this.level;
                    this.generateCollapsibleHTMLTree((LinkedHashMap)linkedHashMap.get(string), bl);
                    this.htmlElementTree = this.htmlElementTree + "</ul></li>" + NL;
                    this.htmlTimeTree = this.htmlTimeTree + "</div></div>" + NL;
                    this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "</div></div>" + NL;
                    continue;
                }
                this.htmlElementTree = this.htmlElementTree + "<li id=level" + this.level + ">" + "<a href=\"#\" onclick=\"expandCollapseTree(this)\">[+]</a>" + "&nbsp;" + string + "<ul style=\"display:none\">" + NL;
                this.htmlTimeTree = this.htmlTimeTree + "<div id=level" + this.level + ".1>" + NL + (double)n / 1000.0 + "<div style=\"display:none\">" + NL;
                this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "<div id=level" + this.level + ".2>" + NL + (double)Math.round((double)n / this.globalValue * 100.0 * 10.0) / 10.0 + "<div style=\"display:none\">" + NL;
                ++this.level;
                this.generateCollapsibleHTMLTree((LinkedHashMap)linkedHashMap.get(string), bl);
                this.htmlElementTree = this.htmlElementTree + "</ul></li>" + NL;
                this.htmlTimeTree = this.htmlTimeTree + "</div></div>" + NL;
                this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "</div></div>" + NL;
                continue;
            }
            if (string.equals("total") || string.equals("systotal")) continue;
            if (bl) {
                if (Integer.parseInt((String)linkedHashMap.get(string)) == 0) continue;
                this.htmlElementTree = this.htmlElementTree + "<li>&nbsp;&nbsp;&nbsp;" + string + "</li>" + NL;
                this.htmlTimeTree = this.htmlTimeTree + "<div>" + NL + (double)Integer.parseInt((String)linkedHashMap.get(string)) / 1000.0 + "</div>" + NL;
                this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "<div>" + NL + (double)Math.round((double)Integer.parseInt((String)linkedHashMap.get(string)) / this.globalValue * 100.0 * 10.0) / 10.0 + "</div>" + NL;
                continue;
            }
            this.htmlElementTree = this.htmlElementTree + "<li>&nbsp;&nbsp;&nbsp;" + string + "</li>" + NL;
            this.htmlTimeTree = this.htmlTimeTree + "<div>" + NL + (double)Integer.parseInt((String)linkedHashMap.get(string)) / 1000.0 + "</div>" + NL;
            this.htmlTimeInPercentTree = this.htmlTimeInPercentTree + "<div>" + NL + (double)Math.round((double)Integer.parseInt((String)linkedHashMap.get(string)) / this.globalValue * 100.0 * 10.0) / 10.0 + "</div>" + NL;
        }
    }

    private boolean parseLinesFromLast(byte[] byArray, Vector<String> vector) {
        String string = new String(byArray);
        StringBuffer stringBuffer = new StringBuffer(string);
        string = stringBuffer.reverse().toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, NL);
        while (stringTokenizer.hasMoreTokens()) {
            StringBuffer stringBuffer2 = new StringBuffer(stringTokenizer.nextToken());
            vector.add(stringBuffer2.reverse().toString());
            if (!vector.get(vector.size() - 1).trim().endsWith(this.getLogicalStart())) continue;
            return true;
        }
        return false;
    }

    private long tail(File file, int n) throws BenchmarkReportInputFileFormatException {
        try {
            long l;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            long l2 = randomAccessFile.length() - 1L;
            while (true) {
                byte[] byArray;
                if ((l = l2 - (long)n) <= 0L) {
                    randomAccessFile.seek(0L);
                    byArray = new byte[(int)l2];
                    randomAccessFile.readFully(byArray);
                    if (!this.parseLinesFromLast(byArray, vector) || l >= 0L) break;
                    l = 0L;
                    break;
                }
                randomAccessFile.seek(l);
                byArray = new byte[n];
                randomAccessFile.readFully(byArray);
                if (this.parseLinesFromLast(byArray, vector)) break;
                n2 = vector.get(vector.size() - 1).length();
                vector.remove(vector.size() - 1);
                l2 = l + (long)n2;
            }
            if (l < 0L) {
                throw new BenchmarkReportInputFileFormatException(this.getBenchmarkFile().getAbsolutePath() + " does not contain a marker named " + this.getLogicalStart() + " indicating logical start of a run.");
            }
            return l;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1L;
        }
    }

    private boolean validateLogEntry(String string, ArrayList<String> arrayList) {
        String string2 = "(";
        for (int i = 0; i < arrayList.size(); ++i) {
            if (string.split("\\.").length == 1 && string.equals(arrayList.get(i))) {
                arrayList.remove(i);
                ++this.validEntries;
                return true;
            }
            string2 = string2 + arrayList.get(i) + "|";
        }
        if (string2.length() > 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string.matches((string2 = string2 + ")") + "\\.doc_.*?\\.pr_.*")) {
            ++this.validEntries;
            return true;
        }
        return false;
    }

    @Override
    public void parseArguments(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("gate.util.reporting.PRTimeReporter", stringArray, "i:m:z:s:o:l:h");
        String string = null;
        block9: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 105: {
                    String string2 = getopt.getOptarg();
                    if (string2 == null) continue block9;
                    this.setBenchmarkFile(new File(string2));
                    continue block9;
                }
                case 109: {
                    String string3 = getopt.getOptarg();
                    if (string3 != null) {
                        this.setPrintMedia(string3);
                        continue block9;
                    }
                    this.setPrintMedia(this.printMedia);
                    continue block9;
                }
                case 122: {
                    string = getopt.getOptarg();
                    if (string != null) continue block9;
                    this.setSuppressZeroTimeEntries(this.suppressZeroTimeEntries);
                    continue block9;
                }
                case 115: {
                    String string4 = getopt.getOptarg();
                    if (string4 != null) {
                        this.setSortOrder(string4);
                        continue block9;
                    }
                    this.setSortOrder(this.sortOrder);
                    continue block9;
                }
                case 111: {
                    String string5 = getopt.getOptarg();
                    if (string5 == null) continue block9;
                    this.setReportFile(new File(string5));
                    continue block9;
                }
                case 108: {
                    String string6 = getopt.getOptarg();
                    if (string6 == null) continue block9;
                    this.setLogicalStart(string6);
                    continue block9;
                }
                case 63: 
                case 104: {
                    PRTimeReporter.usage();
                    System.exit(0);
                    continue block9;
                }
            }
            PRTimeReporter.usage();
            System.exit(1);
        }
        if (string != null) {
            if (string.trim().equalsIgnoreCase("true")) {
                this.setSuppressZeroTimeEntries(true);
            } else if (string.trim().equalsIgnoreCase("false")) {
                this.setSuppressZeroTimeEntries(false);
            } else {
                System.err.println("Suppress Zero Time Entries: parameter value" + NL + " passed is invalid. Please provide true or false as value.");
                PRTimeReporter.usage();
                System.exit(1);
            }
        }
    }

    public static void usage() {
        System.out.println("Usage: java gate.util.reporting.PRTimeReporter [Options]" + NL + "\t Options:" + NL + "\t -i input file path (default: benchmark.txt in the execution directory)" + NL + "\t -m print media - html/text (default: html)" + NL + "\t -z suppressZeroTimeEntries - true/false (default: true)" + NL + "\t -s sorting order - exec_order/time_taken (default: exec_order)" + NL + "\t -o output file path (default: report.html/txt in the system temporary directory)" + NL + "\t -l logical start (not set by default)" + NL + "\t -h show help" + NL);
    }

    public static void main(String[] stringArray) throws BenchmarkReportInputFileFormatException {
        PRTimeReporter pRTimeReporter = new PRTimeReporter(stringArray);
        pRTimeReporter.generateReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReport() throws BenchmarkReportInputFileFormatException {
        Timer timer = null;
        try {
            FileWatcher fileWatcher = new FileWatcher(this.getBenchmarkFile()){

                protected void onChange(File file) throws BenchmarkReportExecutionException {
                    throw new BenchmarkReportExecutionException(PRTimeReporter.this.getBenchmarkFile() + " file has been modified while generating the report.");
                }
            };
            timer = new Timer();
            timer.schedule((TimerTask)fileWatcher, new Date(), 1000L);
            Object object = this.store(this.getBenchmarkFile());
            LinkedHashMap<String, Object> linkedHashMap = this.calculate(object);
            if (this.getSortOrder().equalsIgnoreCase(SORT_TIME_TAKEN)) {
                linkedHashMap = this.sortReport(linkedHashMap);
            }
            if (this.reportFile == null) {
                this.reportFile = new File(System.getProperty("java.io.tmpdir"), "report." + (this.printMedia.equals(MEDIA_HTML) ? MEDIA_HTML : "txt"));
            }
            this.printReport(linkedHashMap, this.reportFile);
            Object var6_5 = null;
            if (timer != null) {
                timer.cancel();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (timer != null) {
                timer.cancel();
            }
            throw throwable;
        }
    }

    @Override
    public void executeReport() throws BenchmarkReportInputFileFormatException {
        this.generateReport();
    }

    public boolean isSuppressZeroTimeEntries() {
        return this.suppressZeroTimeEntries;
    }

    public void setSuppressZeroTimeEntries(boolean bl) {
        this.suppressZeroTimeEntries = bl;
    }

    public String getPrintMedia() {
        return this.printMedia;
    }

    public void setPrintMedia(String string) {
        if (!string.equals(MEDIA_HTML) && !string.equals(MEDIA_TEXT)) {
            throw new IllegalArgumentException("Illegal argument: " + string);
        }
        this.printMedia = string.trim();
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String string) {
        if (!string.equals(SORT_EXEC_ORDER) && !string.equals(SORT_TIME_TAKEN)) {
            throw new IllegalArgumentException("Illegal argument: " + this.printMedia);
        }
        this.sortOrder = string.trim();
    }

    public String getLogicalStart() {
        return this.logicalStart;
    }

    public void setLogicalStart(String string) {
        this.logicalStart = string.trim();
    }

    public File getBenchmarkFile() {
        return this.benchmarkFile;
    }

    public void setBenchmarkFile(File file) {
        this.benchmarkFile = file;
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(File file) {
        this.reportFile = file;
    }
}

